"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFunctionExpression = exports.isReturnStatement = exports.isProperty = exports.isObjectPattern = exports.isObjectExpression = exports.isNewExpression = exports.isMemberExpression = exports.isLiteral = exports.isJSXAttribute = exports.isImportSpecifier = exports.isImportNamespaceSpecifier = exports.isImportDefaultSpecifier = exports.isImportDeclaration = exports.isSequenceExpression = exports.isAssignmentExpression = exports.isVariableDeclaration = exports.isExpressionStatement = exports.isCallExpression = exports.isBlockStatement = exports.isArrowFunctionExpression = exports.isArrayExpression = void 0;
const utils_1 = require("@typescript-eslint/utils");
const isNodeOfType = (nodeType) => (node) => (node === null || node === void 0 ? void 0 : node.type) === nodeType;
exports.isArrayExpression = isNodeOfType(utils_1.AST_NODE_TYPES.ArrayExpression);
exports.isArrowFunctionExpression = isNodeOfType(utils_1.AST_NODE_TYPES.ArrowFunctionExpression);
exports.isBlockStatement = isNodeOfType(utils_1.AST_NODE_TYPES.BlockStatement);
exports.isCallExpression = isNodeOfType(utils_1.AST_NODE_TYPES.CallExpression);
exports.isExpressionStatement = isNodeOfType(utils_1.AST_NODE_TYPES.ExpressionStatement);
exports.isVariableDeclaration = isNodeOfType(utils_1.AST_NODE_TYPES.VariableDeclaration);
exports.isAssignmentExpression = isNodeOfType(utils_1.AST_NODE_TYPES.AssignmentExpression);
exports.isSequenceExpression = isNodeOfType(utils_1.AST_NODE_TYPES.SequenceExpression);
exports.isImportDeclaration = isNodeOfType(utils_1.AST_NODE_TYPES.ImportDeclaration);
exports.isImportDefaultSpecifier = isNodeOfType(utils_1.AST_NODE_TYPES.ImportDefaultSpecifier);
exports.isImportNamespaceSpecifier = isNodeOfType(utils_1.AST_NODE_TYPES.ImportNamespaceSpecifier);
exports.isImportSpecifier = isNodeOfType(utils_1.AST_NODE_TYPES.ImportSpecifier);
exports.isJSXAttribute = isNodeOfType(utils_1.AST_NODE_TYPES.JSXAttribute);
exports.isLiteral = isNodeOfType(utils_1.AST_NODE_TYPES.Literal);
exports.isMemberExpression = isNodeOfType(utils_1.AST_NODE_TYPES.MemberExpression);
exports.isNewExpression = isNodeOfType(utils_1.AST_NODE_TYPES.NewExpression);
exports.isObjectExpression = isNodeOfType(utils_1.AST_NODE_TYPES.ObjectExpression);
exports.isObjectPattern = isNodeOfType(utils_1.AST_NODE_TYPES.ObjectPattern);
exports.isProperty = isNodeOfType(utils_1.AST_NODE_TYPES.Property);
exports.isReturnStatement = isNodeOfType(utils_1.AST_NODE_TYPES.ReturnStatement);
exports.isFunctionExpression = isNodeOfType(utils_1.AST_NODE_TYPES.FunctionExpression);
