"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = memoize;

function memoize(fn) {
  var cache = {};
  return function (arg) {
    if (cache[arg] === undefined) {
      cache[arg] = fn(arg);
    }

    return cache[arg];
  };
}