import { DerEncodedPublicKey, KeyPair, PublicKey, Signature, SignIdentity } from '@dfinity/agent';
export declare class Ed25519PublicKey implements PublicKey {
    static from(key: PublicKey): Ed25519PublicKey;
    static fromRaw(rawKey: ArrayBuffer): Ed25519PublicKey;
    static fromDer(derKey: DerEncodedPublicKey): Ed25519PublicKey;
    private static RAW_KEY_LENGTH;
    private static derEncode;
    private static derDecode;
    private readonly rawKey;
    private readonly derKey;
    private constructor();
    toDer(): DerEncodedPublicKey;
    toRaw(): ArrayBuffer;
}
export declare class Ed25519KeyIdentity extends SignIdentity {
    protected _privateKey: ArrayBuffer;
    static generate(seed?: Uint8Array): Ed25519KeyIdentity;
    static fromParsedJson(obj: JsonnableEd25519KeyIdentity): Ed25519KeyIdentity;
    static fromJSON(json: string): Ed25519KeyIdentity;
    static fromKeyPair(publicKey: ArrayBuffer, privateKey: ArrayBuffer): Ed25519KeyIdentity;
    static fromSecretKey(secretKey: ArrayBuffer): Ed25519KeyIdentity;
    protected _publicKey: Ed25519PublicKey;
    protected constructor(publicKey: PublicKey, _privateKey: ArrayBuffer);
    /**
     * Serialize this key to JSON.
     */
    toJSON(): JsonnableEd25519KeyIdentity;
    /**
     * Return a copy of the key pair.
     */
    getKeyPair(): KeyPair;
    /**
     * Return the public key.
     */
    getPublicKey(): PublicKey;
    /**
     * Signs a blob of data, with this identity's private key.
     * @param challenge - challenge to sign with this identity's secretKey, producing a signature
     */
    sign(challenge: ArrayBuffer): Promise<Signature>;
}
declare type PublicKeyHex = string;
declare type SecretKeyHex = string;
export declare type JsonnableEd25519KeyIdentity = [PublicKeyHex, SecretKeyHex];
export {};
