/** @license Material-UI v4.6.1
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('react-dom')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react', 'react-dom'], factory) :
  (global = global || self, factory(global.MaterialUI = {}, global.React, global.ReactDOM));
}(this, (function (exports, React, ReactDOM) { 'use strict';

  var React__default = 'default' in React ? React['default'] : React;
  ReactDOM = ReactDOM && ReactDOM.hasOwnProperty('default') ? ReactDOM['default'] : ReactDOM;

  var common = {
    black: '#000',
    white: '#fff'
  };

  var red = {
    50: '#ffebee',
    100: '#ffcdd2',
    200: '#ef9a9a',
    300: '#e57373',
    400: '#ef5350',
    500: '#f44336',
    600: '#e53935',
    700: '#d32f2f',
    800: '#c62828',
    900: '#b71c1c',
    A100: '#ff8a80',
    A200: '#ff5252',
    A400: '#ff1744',
    A700: '#d50000'
  };

  var pink = {
    50: '#fce4ec',
    100: '#f8bbd0',
    200: '#f48fb1',
    300: '#f06292',
    400: '#ec407a',
    500: '#e91e63',
    600: '#d81b60',
    700: '#c2185b',
    800: '#ad1457',
    900: '#880e4f',
    A100: '#ff80ab',
    A200: '#ff4081',
    A400: '#f50057',
    A700: '#c51162'
  };

  var purple = {
    50: '#f3e5f5',
    100: '#e1bee7',
    200: '#ce93d8',
    300: '#ba68c8',
    400: '#ab47bc',
    500: '#9c27b0',
    600: '#8e24aa',
    700: '#7b1fa2',
    800: '#6a1b9a',
    900: '#4a148c',
    A100: '#ea80fc',
    A200: '#e040fb',
    A400: '#d500f9',
    A700: '#aa00ff'
  };

  var deepPurple = {
    50: '#ede7f6',
    100: '#d1c4e9',
    200: '#b39ddb',
    300: '#9575cd',
    400: '#7e57c2',
    500: '#673ab7',
    600: '#5e35b1',
    700: '#512da8',
    800: '#4527a0',
    900: '#311b92',
    A100: '#b388ff',
    A200: '#7c4dff',
    A400: '#651fff',
    A700: '#6200ea'
  };

  var indigo = {
    50: '#e8eaf6',
    100: '#c5cae9',
    200: '#9fa8da',
    300: '#7986cb',
    400: '#5c6bc0',
    500: '#3f51b5',
    600: '#3949ab',
    700: '#303f9f',
    800: '#283593',
    900: '#1a237e',
    A100: '#8c9eff',
    A200: '#536dfe',
    A400: '#3d5afe',
    A700: '#304ffe'
  };

  var blue = {
    50: '#e3f2fd',
    100: '#bbdefb',
    200: '#90caf9',
    300: '#64b5f6',
    400: '#42a5f5',
    500: '#2196f3',
    600: '#1e88e5',
    700: '#1976d2',
    800: '#1565c0',
    900: '#0d47a1',
    A100: '#82b1ff',
    A200: '#448aff',
    A400: '#2979ff',
    A700: '#2962ff'
  };

  var lightBlue = {
    50: '#e1f5fe',
    100: '#b3e5fc',
    200: '#81d4fa',
    300: '#4fc3f7',
    400: '#29b6f6',
    500: '#03a9f4',
    600: '#039be5',
    700: '#0288d1',
    800: '#0277bd',
    900: '#01579b',
    A100: '#80d8ff',
    A200: '#40c4ff',
    A400: '#00b0ff',
    A700: '#0091ea'
  };

  var cyan = {
    50: '#e0f7fa',
    100: '#b2ebf2',
    200: '#80deea',
    300: '#4dd0e1',
    400: '#26c6da',
    500: '#00bcd4',
    600: '#00acc1',
    700: '#0097a7',
    800: '#00838f',
    900: '#006064',
    A100: '#84ffff',
    A200: '#18ffff',
    A400: '#00e5ff',
    A700: '#00b8d4'
  };

  var teal = {
    50: '#e0f2f1',
    100: '#b2dfdb',
    200: '#80cbc4',
    300: '#4db6ac',
    400: '#26a69a',
    500: '#009688',
    600: '#00897b',
    700: '#00796b',
    800: '#00695c',
    900: '#004d40',
    A100: '#a7ffeb',
    A200: '#64ffda',
    A400: '#1de9b6',
    A700: '#00bfa5'
  };

  var green = {
    50: '#e8f5e9',
    100: '#c8e6c9',
    200: '#a5d6a7',
    300: '#81c784',
    400: '#66bb6a',
    500: '#4caf50',
    600: '#43a047',
    700: '#388e3c',
    800: '#2e7d32',
    900: '#1b5e20',
    A100: '#b9f6ca',
    A200: '#69f0ae',
    A400: '#00e676',
    A700: '#00c853'
  };

  var lightGreen = {
    50: '#f1f8e9',
    100: '#dcedc8',
    200: '#c5e1a5',
    300: '#aed581',
    400: '#9ccc65',
    500: '#8bc34a',
    600: '#7cb342',
    700: '#689f38',
    800: '#558b2f',
    900: '#33691e',
    A100: '#ccff90',
    A200: '#b2ff59',
    A400: '#76ff03',
    A700: '#64dd17'
  };

  var lime = {
    50: '#f9fbe7',
    100: '#f0f4c3',
    200: '#e6ee9c',
    300: '#dce775',
    400: '#d4e157',
    500: '#cddc39',
    600: '#c0ca33',
    700: '#afb42b',
    800: '#9e9d24',
    900: '#827717',
    A100: '#f4ff81',
    A200: '#eeff41',
    A400: '#c6ff00',
    A700: '#aeea00'
  };

  var yellow = {
    50: '#fffde7',
    100: '#fff9c4',
    200: '#fff59d',
    300: '#fff176',
    400: '#ffee58',
    500: '#ffeb3b',
    600: '#fdd835',
    700: '#fbc02d',
    800: '#f9a825',
    900: '#f57f17',
    A100: '#ffff8d',
    A200: '#ffff00',
    A400: '#ffea00',
    A700: '#ffd600'
  };

  var amber = {
    50: '#fff8e1',
    100: '#ffecb3',
    200: '#ffe082',
    300: '#ffd54f',
    400: '#ffca28',
    500: '#ffc107',
    600: '#ffb300',
    700: '#ffa000',
    800: '#ff8f00',
    900: '#ff6f00',
    A100: '#ffe57f',
    A200: '#ffd740',
    A400: '#ffc400',
    A700: '#ffab00'
  };

  var orange = {
    50: '#fff3e0',
    100: '#ffe0b2',
    200: '#ffcc80',
    300: '#ffb74d',
    400: '#ffa726',
    500: '#ff9800',
    600: '#fb8c00',
    700: '#f57c00',
    800: '#ef6c00',
    900: '#e65100',
    A100: '#ffd180',
    A200: '#ffab40',
    A400: '#ff9100',
    A700: '#ff6d00'
  };

  var deepOrange = {
    50: '#fbe9e7',
    100: '#ffccbc',
    200: '#ffab91',
    300: '#ff8a65',
    400: '#ff7043',
    500: '#ff5722',
    600: '#f4511e',
    700: '#e64a19',
    800: '#d84315',
    900: '#bf360c',
    A100: '#ff9e80',
    A200: '#ff6e40',
    A400: '#ff3d00',
    A700: '#dd2c00'
  };

  var brown = {
    50: '#efebe9',
    100: '#d7ccc8',
    200: '#bcaaa4',
    300: '#a1887f',
    400: '#8d6e63',
    500: '#795548',
    600: '#6d4c41',
    700: '#5d4037',
    800: '#4e342e',
    900: '#3e2723',
    A100: '#d7ccc8',
    A200: '#bcaaa4',
    A400: '#8d6e63',
    A700: '#5d4037'
  };

  var grey = {
    50: '#fafafa',
    100: '#f5f5f5',
    200: '#eeeeee',
    300: '#e0e0e0',
    400: '#bdbdbd',
    500: '#9e9e9e',
    600: '#757575',
    700: '#616161',
    800: '#424242',
    900: '#212121',
    A100: '#d5d5d5',
    A200: '#aaaaaa',
    A400: '#303030',
    A700: '#616161'
  };

  var blueGrey = {
    50: '#eceff1',
    100: '#cfd8dc',
    200: '#b0bec5',
    300: '#90a4ae',
    400: '#78909c',
    500: '#607d8b',
    600: '#546e7a',
    700: '#455a64',
    800: '#37474f',
    900: '#263238',
    A100: '#cfd8dc',
    A200: '#b0bec5',
    A400: '#78909c',
    A700: '#455a64'
  };



  var index = /*#__PURE__*/Object.freeze({
    __proto__: null,
    common: common,
    red: red,
    pink: pink,
    purple: purple,
    deepPurple: deepPurple,
    indigo: indigo,
    blue: blue,
    lightBlue: lightBlue,
    cyan: cyan,
    teal: teal,
    green: green,
    lightGreen: lightGreen,
    lime: lime,
    yellow: yellow,
    amber: amber,
    orange: orange,
    deepOrange: deepOrange,
    brown: brown,
    grey: grey,
    blueGrey: blueGrey
  });

  var global$1 = (typeof global !== "undefined" ? global :
              typeof self !== "undefined" ? self :
              typeof window !== "undefined" ? window : {});

  // from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
  var performance$1 = global$1.performance || {};
  var performanceNow =
    performance$1.now        ||
    performance$1.mozNow     ||
    performance$1.msNow      ||
    performance$1.oNow       ||
    performance$1.webkitNow  ||
    function(){ return (new Date()).getTime() };

  /* eslint-disable no-use-before-define */

  /**
   * Returns a number whose value is limited to the given range.
   *
   * @param {number} value The value to be clamped
   * @param {number} min The lower boundary of the output range
   * @param {number} max The upper boundary of the output range
   * @returns {number} A number in the range [min, max]
   */
  function clamp(value) {
    var min = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var max = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;

    {
      if (value < min || value > max) {
        console.error("Material-UI: the value provided ".concat(value, " is out of range [").concat(min, ", ").concat(max, "]."));
      }
    }

    if (value < min) {
      return min;
    }

    if (value > max) {
      return max;
    }

    return value;
  }
  /**
   * Converts a color from CSS hex format to CSS rgb format.
   *
   * @param {string} color - Hex color, i.e. #nnn or #nnnnnn
   * @returns {string} A CSS rgb color string
   */


  function hexToRgb(color) {
    color = color.substr(1);
    var re = new RegExp(".{1,".concat(color.length / 3, "}"), 'g');
    var colors = color.match(re);

    if (colors && colors[0].length === 1) {
      colors = colors.map(function (n) {
        return n + n;
      });
    }

    return colors ? "rgb(".concat(colors.map(function (n) {
      return parseInt(n, 16);
    }).join(', '), ")") : '';
  }
  /**
   * Converts a color from hsl format to rgb format.
   *
   * @param {string} color - HSL color values
   * @returns {string} rgb color values
   */

  function hslToRgb(color) {
    color = decomposeColor(color);
    var _color = color,
        values = _color.values;
    var h = values[0];
    var s = values[1] / 100;
    var l = values[2] / 100;
    var a = s * Math.min(l, 1 - l);

    var f = function f(n) {
      var k = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (n + h / 30) % 12;
      return l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);
    };

    var type = 'rgb';
    var rgb = [Math.round(f(0) * 255), Math.round(f(8) * 255), Math.round(f(4) * 255)];

    if (color.type === 'hsla') {
      type += 'a';
      rgb.push(values[3]);
    }

    return recomposeColor({
      type: type,
      values: rgb
    });
  }
  /**
   * Returns an object with the type and values of a color.
   *
   * Note: Does not support rgb % values.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @returns {object} - A MUI color object: {type: string, values: number[]}
   */

  function decomposeColor(color) {
    // Idempotent
    if (color.type) {
      return color;
    }

    if (color.charAt(0) === '#') {
      return decomposeColor(hexToRgb(color));
    }

    var marker = color.indexOf('(');
    var type = color.substring(0, marker);

    if (['rgb', 'rgba', 'hsl', 'hsla'].indexOf(type) === -1) {
      throw new Error(["Material-UI: unsupported `".concat(color, "` color."), 'We support the following formats: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla().'].join('\n'));
    }

    var values = color.substring(marker + 1, color.length - 1).split(',');
    values = values.map(function (value) {
      return parseFloat(value);
    });
    return {
      type: type,
      values: values
    };
  }
  /**
   * Converts a color object with type and values to a string.
   *
   * @param {object} color - Decomposed color
   * @param {string} color.type - One of: 'rgb', 'rgba', 'hsl', 'hsla'
   * @param {array} color.values - [n,n,n] or [n,n,n,n]
   * @returns {string} A CSS color string
   */

  function recomposeColor(color) {
    var type = color.type;
    var values = color.values;

    if (type.indexOf('rgb') !== -1) {
      // Only convert the first 3 values to int (i.e. not alpha)
      values = values.map(function (n, i) {
        return i < 3 ? parseInt(n, 10) : n;
      });
    } else if (type.indexOf('hsl') !== -1) {
      values[1] = "".concat(values[1], "%");
      values[2] = "".concat(values[2], "%");
    }

    return "".concat(type, "(").concat(values.join(', '), ")");
  }
  /**
   * Calculates the contrast ratio between two colors.
   *
   * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
   *
   * @param {string} foreground - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {string} background - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @returns {number} A contrast ratio value in the range 0 - 21.
   */

  function getContrastRatio(foreground, background) {
    var lumA = getLuminance(foreground);
    var lumB = getLuminance(background);
    return (Math.max(lumA, lumB) + 0.05) / (Math.min(lumA, lumB) + 0.05);
  }
  /**
   * The relative brightness of any point in a color space,
   * normalized to 0 for darkest black and 1 for lightest white.
   *
   * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @returns {number} The relative brightness of the color in the range 0 - 1
   */

  function getLuminance(color) {
    color = decomposeColor(color);
    var rgb = color.type === 'hsl' ? decomposeColor(hslToRgb(color)).values : color.values;
    rgb = rgb.map(function (val) {
      val /= 255; // normalized

      return val <= 0.03928 ? val / 12.92 : Math.pow((val + 0.055) / 1.055, 2.4);
    }); // Truncate at 3 digits

    return Number((0.2126 * rgb[0] + 0.7152 * rgb[1] + 0.0722 * rgb[2]).toFixed(3));
  }
  /**
   * Darken or lighten a color, depending on its luminance.
   * Light colors are darkened, dark colors are lightened.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {number} coefficient=0.15 - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function emphasize(color) {
    var coefficient = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.15;
    return getLuminance(color) > 0.5 ? darken(color, coefficient) : lighten(color, coefficient);
  }
  /**
   * Set the absolute transparency of a color.
   * Any existing alpha values are overwritten.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {number} value - value to set the alpha channel to in the range 0 -1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function fade(color, value) {
    color = decomposeColor(color);
    value = clamp(value);

    if (color.type === 'rgb' || color.type === 'hsl') {
      color.type += 'a';
    }

    color.values[3] = value;
    return recomposeColor(color);
  }
  /**
   * Darkens a color.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {number} coefficient - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function darken(color, coefficient) {
    color = decomposeColor(color);
    coefficient = clamp(coefficient);

    if (color.type.indexOf('hsl') !== -1) {
      color.values[2] *= 1 - coefficient;
    } else if (color.type.indexOf('rgb') !== -1) {
      for (var i = 0; i < 3; i += 1) {
        color.values[i] *= 1 - coefficient;
      }
    }

    return recomposeColor(color);
  }
  /**
   * Lightens a color.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {number} coefficient - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function lighten(color, coefficient) {
    color = decomposeColor(color);
    coefficient = clamp(coefficient);

    if (color.type.indexOf('hsl') !== -1) {
      color.values[2] += (100 - color.values[2]) * coefficient;
    } else if (color.type.indexOf('rgb') !== -1) {
      for (var i = 0; i < 3; i += 1) {
        color.values[i] += (255 - color.values[i]) * coefficient;
      }
    }

    return recomposeColor(color);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};
    var target = _objectWithoutPropertiesLoose(source, excluded);
    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function chainPropTypes(propType1, propType2) {

    return function validate() {
      return propType1.apply(void 0, arguments) || propType2.apply(void 0, arguments);
    };
  }

  function _typeof2(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof2 = function _typeof2(obj) { return typeof obj; }; } else { _typeof2 = function _typeof2(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof2(obj); }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  function isObject(item) {
    return item && _typeof(item) === 'object' && !Array.isArray(item);
  }
  function deepmerge(target, source) {
    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
      clone: true
    };
    var output = options.clone ? _extends({}, target) : target;

    if (isObject(target) && isObject(source)) {
      Object.keys(source).forEach(function (key) {
        // Avoid prototype pollution
        if (key === '__proto__') {
          return;
        }

        if (isObject(source[key]) && key in target) {
          output[key] = deepmerge(target[key], source[key], options);
        } else {
          output[key] = source[key];
        }
      });
    }

    return output;
  }

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var reactIs_production_min = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports,"__esModule",{value:!0});
  var b="function"===typeof Symbol&&Symbol.for,c=b?Symbol.for("react.element"):60103,d=b?Symbol.for("react.portal"):60106,e=b?Symbol.for("react.fragment"):60107,f=b?Symbol.for("react.strict_mode"):60108,g=b?Symbol.for("react.profiler"):60114,h=b?Symbol.for("react.provider"):60109,k=b?Symbol.for("react.context"):60110,l=b?Symbol.for("react.async_mode"):60111,m=b?Symbol.for("react.concurrent_mode"):60111,n=b?Symbol.for("react.forward_ref"):60112,p=b?Symbol.for("react.suspense"):60113,q=b?Symbol.for("react.suspense_list"):
  60120,r=b?Symbol.for("react.memo"):60115,t=b?Symbol.for("react.lazy"):60116,v=b?Symbol.for("react.fundamental"):60117,w=b?Symbol.for("react.responder"):60118,x=b?Symbol.for("react.scope"):60119;function y(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k:case n:case h:return a;default:return u}}case t:case r:case d:return u}}}function z(a){return y(a)===m}
  exports.typeOf=y;exports.AsyncMode=l;exports.ConcurrentMode=m;exports.ContextConsumer=k;exports.ContextProvider=h;exports.Element=c;exports.ForwardRef=n;exports.Fragment=e;exports.Lazy=t;exports.Memo=r;exports.Portal=d;exports.Profiler=g;exports.StrictMode=f;exports.Suspense=p;
  exports.isValidElementType=function(a){return "string"===typeof a||"function"===typeof a||a===e||a===m||a===g||a===f||a===p||a===q||"object"===typeof a&&null!==a&&(a.$$typeof===t||a.$$typeof===r||a.$$typeof===h||a.$$typeof===k||a.$$typeof===n||a.$$typeof===v||a.$$typeof===w||a.$$typeof===x)};exports.isAsyncMode=function(a){return z(a)||y(a)===l};exports.isConcurrentMode=z;exports.isContextConsumer=function(a){return y(a)===k};exports.isContextProvider=function(a){return y(a)===h};
  exports.isElement=function(a){return "object"===typeof a&&null!==a&&a.$$typeof===c};exports.isForwardRef=function(a){return y(a)===n};exports.isFragment=function(a){return y(a)===e};exports.isLazy=function(a){return y(a)===t};exports.isMemo=function(a){return y(a)===r};exports.isPortal=function(a){return y(a)===d};exports.isProfiler=function(a){return y(a)===g};exports.isStrictMode=function(a){return y(a)===f};exports.isSuspense=function(a){return y(a)===p};
  });

  unwrapExports(reactIs_production_min);
  var reactIs_production_min_1 = reactIs_production_min.typeOf;
  var reactIs_production_min_2 = reactIs_production_min.AsyncMode;
  var reactIs_production_min_3 = reactIs_production_min.ConcurrentMode;
  var reactIs_production_min_4 = reactIs_production_min.ContextConsumer;
  var reactIs_production_min_5 = reactIs_production_min.ContextProvider;
  var reactIs_production_min_6 = reactIs_production_min.Element;
  var reactIs_production_min_7 = reactIs_production_min.ForwardRef;
  var reactIs_production_min_8 = reactIs_production_min.Fragment;
  var reactIs_production_min_9 = reactIs_production_min.Lazy;
  var reactIs_production_min_10 = reactIs_production_min.Memo;
  var reactIs_production_min_11 = reactIs_production_min.Portal;
  var reactIs_production_min_12 = reactIs_production_min.Profiler;
  var reactIs_production_min_13 = reactIs_production_min.StrictMode;
  var reactIs_production_min_14 = reactIs_production_min.Suspense;
  var reactIs_production_min_15 = reactIs_production_min.isValidElementType;
  var reactIs_production_min_16 = reactIs_production_min.isAsyncMode;
  var reactIs_production_min_17 = reactIs_production_min.isConcurrentMode;
  var reactIs_production_min_18 = reactIs_production_min.isContextConsumer;
  var reactIs_production_min_19 = reactIs_production_min.isContextProvider;
  var reactIs_production_min_20 = reactIs_production_min.isElement;
  var reactIs_production_min_21 = reactIs_production_min.isForwardRef;
  var reactIs_production_min_22 = reactIs_production_min.isFragment;
  var reactIs_production_min_23 = reactIs_production_min.isLazy;
  var reactIs_production_min_24 = reactIs_production_min.isMemo;
  var reactIs_production_min_25 = reactIs_production_min.isPortal;
  var reactIs_production_min_26 = reactIs_production_min.isProfiler;
  var reactIs_production_min_27 = reactIs_production_min.isStrictMode;
  var reactIs_production_min_28 = reactIs_production_min.isSuspense;

  var reactIs_development = createCommonjsModule(function (module, exports) {



  {
    (function() {

  Object.defineProperty(exports, '__esModule', { value: true });

  // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
  // nor polyfill, then a plain number is used for performance.
  var hasSymbol = typeof Symbol === 'function' && Symbol.for;
  var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
  var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
  var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
  var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
  var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
  var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
  var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
  // (unstable) APIs that have been removed. Can we remove the symbols?

  var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
  var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
  var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
  var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
  var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
  var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
  var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
  var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
  var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
  var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

  function isValidElementType(type) {
    return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
    type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE);
  }

  /**
   * Forked from fbjs/warning:
   * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
   *
   * Only change is we use console.warn instead of console.error,
   * and do nothing when 'console' is not supported.
   * This really simplifies the code.
   * ---
   * Similar to invariant but only logs a warning if the condition is not met.
   * This can be used to log issues in development environments in critical
   * paths. Removing the logging code for production environments will keep the
   * same logic and follow the same code paths.
   */
  var lowPriorityWarningWithoutStack = function () {};

  {
    var printWarning = function (format) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var argIndex = 0;
      var message = 'Warning: ' + format.replace(/%s/g, function () {
        return args[argIndex++];
      });

      if (typeof console !== 'undefined') {
        console.warn(message);
      }

      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };

    lowPriorityWarningWithoutStack = function (condition, format) {
      if (format === undefined) {
        throw new Error('`lowPriorityWarningWithoutStack(condition, format, ...args)` requires a warning ' + 'message argument');
      }

      if (!condition) {
        for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
          args[_key2 - 2] = arguments[_key2];
        }

        printWarning.apply(void 0, [format].concat(args));
      }
    };
  }

  var lowPriorityWarningWithoutStack$1 = lowPriorityWarningWithoutStack;

  function typeOf(object) {
    if (typeof object === 'object' && object !== null) {
      var $$typeof = object.$$typeof;

      switch ($$typeof) {
        case REACT_ELEMENT_TYPE:
          var type = object.type;

          switch (type) {
            case REACT_ASYNC_MODE_TYPE:
            case REACT_CONCURRENT_MODE_TYPE:
            case REACT_FRAGMENT_TYPE:
            case REACT_PROFILER_TYPE:
            case REACT_STRICT_MODE_TYPE:
            case REACT_SUSPENSE_TYPE:
              return type;

            default:
              var $$typeofType = type && type.$$typeof;

              switch ($$typeofType) {
                case REACT_CONTEXT_TYPE:
                case REACT_FORWARD_REF_TYPE:
                case REACT_PROVIDER_TYPE:
                  return $$typeofType;

                default:
                  return $$typeof;
              }

          }

        case REACT_LAZY_TYPE:
        case REACT_MEMO_TYPE:
        case REACT_PORTAL_TYPE:
          return $$typeof;
      }
    }

    return undefined;
  } // AsyncMode is deprecated along with isAsyncMode

  var AsyncMode = REACT_ASYNC_MODE_TYPE;
  var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
  var ContextConsumer = REACT_CONTEXT_TYPE;
  var ContextProvider = REACT_PROVIDER_TYPE;
  var Element = REACT_ELEMENT_TYPE;
  var ForwardRef = REACT_FORWARD_REF_TYPE;
  var Fragment = REACT_FRAGMENT_TYPE;
  var Lazy = REACT_LAZY_TYPE;
  var Memo = REACT_MEMO_TYPE;
  var Portal = REACT_PORTAL_TYPE;
  var Profiler = REACT_PROFILER_TYPE;
  var StrictMode = REACT_STRICT_MODE_TYPE;
  var Suspense = REACT_SUSPENSE_TYPE;
  var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

  function isAsyncMode(object) {
    {
      if (!hasWarnedAboutDeprecatedIsAsyncMode) {
        hasWarnedAboutDeprecatedIsAsyncMode = true;
        lowPriorityWarningWithoutStack$1(false, 'The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
      }
    }

    return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
  }
  function isConcurrentMode(object) {
    return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
  }
  function isContextConsumer(object) {
    return typeOf(object) === REACT_CONTEXT_TYPE;
  }
  function isContextProvider(object) {
    return typeOf(object) === REACT_PROVIDER_TYPE;
  }
  function isElement(object) {
    return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
  }
  function isForwardRef(object) {
    return typeOf(object) === REACT_FORWARD_REF_TYPE;
  }
  function isFragment(object) {
    return typeOf(object) === REACT_FRAGMENT_TYPE;
  }
  function isLazy(object) {
    return typeOf(object) === REACT_LAZY_TYPE;
  }
  function isMemo(object) {
    return typeOf(object) === REACT_MEMO_TYPE;
  }
  function isPortal(object) {
    return typeOf(object) === REACT_PORTAL_TYPE;
  }
  function isProfiler(object) {
    return typeOf(object) === REACT_PROFILER_TYPE;
  }
  function isStrictMode(object) {
    return typeOf(object) === REACT_STRICT_MODE_TYPE;
  }
  function isSuspense(object) {
    return typeOf(object) === REACT_SUSPENSE_TYPE;
  }

  exports.typeOf = typeOf;
  exports.AsyncMode = AsyncMode;
  exports.ConcurrentMode = ConcurrentMode;
  exports.ContextConsumer = ContextConsumer;
  exports.ContextProvider = ContextProvider;
  exports.Element = Element;
  exports.ForwardRef = ForwardRef;
  exports.Fragment = Fragment;
  exports.Lazy = Lazy;
  exports.Memo = Memo;
  exports.Portal = Portal;
  exports.Profiler = Profiler;
  exports.StrictMode = StrictMode;
  exports.Suspense = Suspense;
  exports.isValidElementType = isValidElementType;
  exports.isAsyncMode = isAsyncMode;
  exports.isConcurrentMode = isConcurrentMode;
  exports.isContextConsumer = isContextConsumer;
  exports.isContextProvider = isContextProvider;
  exports.isElement = isElement;
  exports.isForwardRef = isForwardRef;
  exports.isFragment = isFragment;
  exports.isLazy = isLazy;
  exports.isMemo = isMemo;
  exports.isPortal = isPortal;
  exports.isProfiler = isProfiler;
  exports.isStrictMode = isStrictMode;
  exports.isSuspense = isSuspense;
    })();
  }
  });

  unwrapExports(reactIs_development);
  var reactIs_development_1 = reactIs_development.typeOf;
  var reactIs_development_2 = reactIs_development.AsyncMode;
  var reactIs_development_3 = reactIs_development.ConcurrentMode;
  var reactIs_development_4 = reactIs_development.ContextConsumer;
  var reactIs_development_5 = reactIs_development.ContextProvider;
  var reactIs_development_6 = reactIs_development.Element;
  var reactIs_development_7 = reactIs_development.ForwardRef;
  var reactIs_development_8 = reactIs_development.Fragment;
  var reactIs_development_9 = reactIs_development.Lazy;
  var reactIs_development_10 = reactIs_development.Memo;
  var reactIs_development_11 = reactIs_development.Portal;
  var reactIs_development_12 = reactIs_development.Profiler;
  var reactIs_development_13 = reactIs_development.StrictMode;
  var reactIs_development_14 = reactIs_development.Suspense;
  var reactIs_development_15 = reactIs_development.isValidElementType;
  var reactIs_development_16 = reactIs_development.isAsyncMode;
  var reactIs_development_17 = reactIs_development.isConcurrentMode;
  var reactIs_development_18 = reactIs_development.isContextConsumer;
  var reactIs_development_19 = reactIs_development.isContextProvider;
  var reactIs_development_20 = reactIs_development.isElement;
  var reactIs_development_21 = reactIs_development.isForwardRef;
  var reactIs_development_22 = reactIs_development.isFragment;
  var reactIs_development_23 = reactIs_development.isLazy;
  var reactIs_development_24 = reactIs_development.isMemo;
  var reactIs_development_25 = reactIs_development.isPortal;
  var reactIs_development_26 = reactIs_development.isProfiler;
  var reactIs_development_27 = reactIs_development.isStrictMode;
  var reactIs_development_28 = reactIs_development.isSuspense;

  var reactIs = createCommonjsModule(function (module) {

  {
    module.exports = reactIs_development;
  }
  });
  var reactIs_1 = reactIs.ForwardRef;
  var reactIs_2 = reactIs.isLazy;
  var reactIs_3 = reactIs.isMemo;
  var reactIs_4 = reactIs.isValidElementType;

  /*
  object-assign
  (c) Sindre Sorhus
  @license MIT
  */
  /* eslint-disable no-unused-vars */
  var getOwnPropertySymbols = Object.getOwnPropertySymbols;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var propIsEnumerable = Object.prototype.propertyIsEnumerable;

  function toObject(val) {
  	if (val === null || val === undefined) {
  		throw new TypeError('Object.assign cannot be called with null or undefined');
  	}

  	return Object(val);
  }

  function shouldUseNative() {
  	try {
  		if (!Object.assign) {
  			return false;
  		}

  		// Detect buggy property enumeration order in older V8 versions.

  		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
  		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
  		test1[5] = 'de';
  		if (Object.getOwnPropertyNames(test1)[0] === '5') {
  			return false;
  		}

  		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
  		var test2 = {};
  		for (var i = 0; i < 10; i++) {
  			test2['_' + String.fromCharCode(i)] = i;
  		}
  		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
  			return test2[n];
  		});
  		if (order2.join('') !== '0123456789') {
  			return false;
  		}

  		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
  		var test3 = {};
  		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
  			test3[letter] = letter;
  		});
  		if (Object.keys(Object.assign({}, test3)).join('') !==
  				'abcdefghijklmnopqrst') {
  			return false;
  		}

  		return true;
  	} catch (err) {
  		// We don't expect any of the above to throw, but better to be safe.
  		return false;
  	}
  }

  var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
  	var from;
  	var to = toObject(target);
  	var symbols;

  	for (var s = 1; s < arguments.length; s++) {
  		from = Object(arguments[s]);

  		for (var key in from) {
  			if (hasOwnProperty.call(from, key)) {
  				to[key] = from[key];
  			}
  		}

  		if (getOwnPropertySymbols) {
  			symbols = getOwnPropertySymbols(from);
  			for (var i = 0; i < symbols.length; i++) {
  				if (propIsEnumerable.call(from, symbols[i])) {
  					to[symbols[i]] = from[symbols[i]];
  				}
  			}
  		}
  	}

  	return to;
  };

  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

  var ReactPropTypesSecret_1 = ReactPropTypesSecret;

  var printWarning = function() {};

  {
    var ReactPropTypesSecret$1 = ReactPropTypesSecret_1;
    var loggedTypeFailures = {};
    var has = Function.call.bind(Object.prototype.hasOwnProperty);

    printWarning = function(text) {
      var message = 'Warning: ' + text;
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };
  }

  /**
   * Assert that the values match with the type specs.
   * Error messages are memorized and will only be shown once.
   *
   * @param {object} typeSpecs Map of name to a ReactPropType
   * @param {object} values Runtime values that need to be type-checked
   * @param {string} location e.g. "prop", "context", "child context"
   * @param {string} componentName Name of the component for error messages.
   * @param {?Function} getStack Returns the component stack.
   * @private
   */
  function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
    {
      for (var typeSpecName in typeSpecs) {
        if (has(typeSpecs, typeSpecName)) {
          var error;
          // Prop type validation may throw. In case they do, we don't want to
          // fail the render phase where it didn't fail before. So we log it.
          // After these have been cleaned up, we'll let them throw.
          try {
            // This is intentionally an invariant that gets caught. It's the same
            // behavior as without this statement except with a better message.
            if (typeof typeSpecs[typeSpecName] !== 'function') {
              var err = Error(
                (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
                'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.'
              );
              err.name = 'Invariant Violation';
              throw err;
            }
            error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret$1);
          } catch (ex) {
            error = ex;
          }
          if (error && !(error instanceof Error)) {
            printWarning(
              (componentName || 'React class') + ': type specification of ' +
              location + ' `' + typeSpecName + '` is invalid; the type checker ' +
              'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
              'You may have forgotten to pass an argument to the type checker ' +
              'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
              'shape all require an argument).'
            );
          }
          if (error instanceof Error && !(error.message in loggedTypeFailures)) {
            // Only monitor this failure once because there tends to be a lot of the
            // same error.
            loggedTypeFailures[error.message] = true;

            var stack = getStack ? getStack() : '';

            printWarning(
              'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
            );
          }
        }
      }
    }
  }

  /**
   * Resets warning cache when testing.
   *
   * @private
   */
  checkPropTypes.resetWarningCache = function() {
    {
      loggedTypeFailures = {};
    }
  };

  var checkPropTypes_1 = checkPropTypes;

  var has$1 = Function.call.bind(Object.prototype.hasOwnProperty);
  var printWarning$1 = function() {};

  {
    printWarning$1 = function(text) {
      var message = 'Warning: ' + text;
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };
  }

  function emptyFunctionThatReturnsNull() {
    return null;
  }

  var factoryWithTypeCheckers = function(isValidElement, throwOnDirectAccess) {
    /* global Symbol */
    var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
    var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

    /**
     * Returns the iterator method function contained on the iterable object.
     *
     * Be sure to invoke the function with the iterable as context:
     *
     *     var iteratorFn = getIteratorFn(myIterable);
     *     if (iteratorFn) {
     *       var iterator = iteratorFn.call(myIterable);
     *       ...
     *     }
     *
     * @param {?object} maybeIterable
     * @return {?function}
     */
    function getIteratorFn(maybeIterable) {
      var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
      if (typeof iteratorFn === 'function') {
        return iteratorFn;
      }
    }

    /**
     * Collection of methods that allow declaration and validation of props that are
     * supplied to React components. Example usage:
     *
     *   var Props = require('ReactPropTypes');
     *   var MyArticle = React.createClass({
     *     propTypes: {
     *       // An optional string prop named "description".
     *       description: Props.string,
     *
     *       // A required enum prop named "category".
     *       category: Props.oneOf(['News','Photos']).isRequired,
     *
     *       // A prop named "dialog" that requires an instance of Dialog.
     *       dialog: Props.instanceOf(Dialog).isRequired
     *     },
     *     render: function() { ... }
     *   });
     *
     * A more formal specification of how these methods are used:
     *
     *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
     *   decl := ReactPropTypes.{type}(.isRequired)?
     *
     * Each and every declaration produces a function with the same signature. This
     * allows the creation of custom validation functions. For example:
     *
     *  var MyLink = React.createClass({
     *    propTypes: {
     *      // An optional string or URI prop named "href".
     *      href: function(props, propName, componentName) {
     *        var propValue = props[propName];
     *        if (propValue != null && typeof propValue !== 'string' &&
     *            !(propValue instanceof URI)) {
     *          return new Error(
     *            'Expected a string or an URI for ' + propName + ' in ' +
     *            componentName
     *          );
     *        }
     *      }
     *    },
     *    render: function() {...}
     *  });
     *
     * @internal
     */

    var ANONYMOUS = '<<anonymous>>';

    // Important!
    // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
    var ReactPropTypes = {
      array: createPrimitiveTypeChecker('array'),
      bool: createPrimitiveTypeChecker('boolean'),
      func: createPrimitiveTypeChecker('function'),
      number: createPrimitiveTypeChecker('number'),
      object: createPrimitiveTypeChecker('object'),
      string: createPrimitiveTypeChecker('string'),
      symbol: createPrimitiveTypeChecker('symbol'),

      any: createAnyTypeChecker(),
      arrayOf: createArrayOfTypeChecker,
      element: createElementTypeChecker(),
      elementType: createElementTypeTypeChecker(),
      instanceOf: createInstanceTypeChecker,
      node: createNodeChecker(),
      objectOf: createObjectOfTypeChecker,
      oneOf: createEnumTypeChecker,
      oneOfType: createUnionTypeChecker,
      shape: createShapeTypeChecker,
      exact: createStrictShapeTypeChecker,
    };

    /**
     * inlined Object.is polyfill to avoid requiring consumers ship their own
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
     */
    /*eslint-disable no-self-compare*/
    function is(x, y) {
      // SameValue algorithm
      if (x === y) {
        // Steps 1-5, 7-10
        // Steps 6.b-6.e: +0 != -0
        return x !== 0 || 1 / x === 1 / y;
      } else {
        // Step 6.a: NaN == NaN
        return x !== x && y !== y;
      }
    }
    /*eslint-enable no-self-compare*/

    /**
     * We use an Error-like object for backward compatibility as people may call
     * PropTypes directly and inspect their output. However, we don't use real
     * Errors anymore. We don't inspect their stack anyway, and creating them
     * is prohibitively expensive if they are created too often, such as what
     * happens in oneOfType() for any type before the one that matched.
     */
    function PropTypeError(message) {
      this.message = message;
      this.stack = '';
    }
    // Make `instanceof Error` still work for returned errors.
    PropTypeError.prototype = Error.prototype;

    function createChainableTypeChecker(validate) {
      {
        var manualPropTypeCallCache = {};
        var manualPropTypeWarningCount = 0;
      }
      function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
        componentName = componentName || ANONYMOUS;
        propFullName = propFullName || propName;

        if (secret !== ReactPropTypesSecret_1) {
          if (throwOnDirectAccess) {
            // New behavior only for users of `prop-types` package
            var err = new Error(
              'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
              'Use `PropTypes.checkPropTypes()` to call them. ' +
              'Read more at http://fb.me/use-check-prop-types'
            );
            err.name = 'Invariant Violation';
            throw err;
          } else if ( typeof console !== 'undefined') {
            // Old behavior for people using React.PropTypes
            var cacheKey = componentName + ':' + propName;
            if (
              !manualPropTypeCallCache[cacheKey] &&
              // Avoid spamming the console because they are often not actionable except for lib authors
              manualPropTypeWarningCount < 3
            ) {
              printWarning$1(
                'You are manually calling a React.PropTypes validation ' +
                'function for the `' + propFullName + '` prop on `' + componentName  + '`. This is deprecated ' +
                'and will throw in the standalone `prop-types` package. ' +
                'You may be seeing this warning due to a third-party PropTypes ' +
                'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
              );
              manualPropTypeCallCache[cacheKey] = true;
              manualPropTypeWarningCount++;
            }
          }
        }
        if (props[propName] == null) {
          if (isRequired) {
            if (props[propName] === null) {
              return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
            }
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
          }
          return null;
        } else {
          return validate(props, propName, componentName, location, propFullName);
        }
      }

      var chainedCheckType = checkType.bind(null, false);
      chainedCheckType.isRequired = checkType.bind(null, true);

      return chainedCheckType;
    }

    function createPrimitiveTypeChecker(expectedType) {
      function validate(props, propName, componentName, location, propFullName, secret) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== expectedType) {
          // `propValue` being instance of, say, date/regexp, pass the 'object'
          // check, but we can offer a more precise error message here rather than
          // 'of type `object`'.
          var preciseType = getPreciseType(propValue);

          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createAnyTypeChecker() {
      return createChainableTypeChecker(emptyFunctionThatReturnsNull);
    }

    function createArrayOfTypeChecker(typeChecker) {
      function validate(props, propName, componentName, location, propFullName) {
        if (typeof typeChecker !== 'function') {
          return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
        }
        var propValue = props[propName];
        if (!Array.isArray(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
        }
        for (var i = 0; i < propValue.length; i++) {
          var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1);
          if (error instanceof Error) {
            return error;
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createElementTypeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        if (!isValidElement(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createElementTypeTypeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        if (!reactIs.isValidElementType(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createInstanceTypeChecker(expectedClass) {
      function validate(props, propName, componentName, location, propFullName) {
        if (!(props[propName] instanceof expectedClass)) {
          var expectedClassName = expectedClass.name || ANONYMOUS;
          var actualClassName = getClassName(props[propName]);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createEnumTypeChecker(expectedValues) {
      if (!Array.isArray(expectedValues)) {
        {
          if (arguments.length > 1) {
            printWarning$1(
              'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +
              'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'
            );
          } else {
            printWarning$1('Invalid argument supplied to oneOf, expected an array.');
          }
        }
        return emptyFunctionThatReturnsNull;
      }

      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        for (var i = 0; i < expectedValues.length; i++) {
          if (is(propValue, expectedValues[i])) {
            return null;
          }
        }

        var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
          var type = getPreciseType(value);
          if (type === 'symbol') {
            return String(value);
          }
          return value;
        });
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
      }
      return createChainableTypeChecker(validate);
    }

    function createObjectOfTypeChecker(typeChecker) {
      function validate(props, propName, componentName, location, propFullName) {
        if (typeof typeChecker !== 'function') {
          return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
        }
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
        }
        for (var key in propValue) {
          if (has$1(propValue, key)) {
            var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
            if (error instanceof Error) {
              return error;
            }
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createUnionTypeChecker(arrayOfTypeCheckers) {
      if (!Array.isArray(arrayOfTypeCheckers)) {
         printWarning$1('Invalid argument supplied to oneOfType, expected an instance of array.') ;
        return emptyFunctionThatReturnsNull;
      }

      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (typeof checker !== 'function') {
          printWarning$1(
            'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
            'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
          );
          return emptyFunctionThatReturnsNull;
        }
      }

      function validate(props, propName, componentName, location, propFullName) {
        for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
          var checker = arrayOfTypeCheckers[i];
          if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1) == null) {
            return null;
          }
        }

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
      }
      return createChainableTypeChecker(validate);
    }

    function createNodeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        if (!isNode(props[propName])) {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createShapeTypeChecker(shapeTypes) {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
        }
        for (var key in shapeTypes) {
          var checker = shapeTypes[key];
          if (!checker) {
            continue;
          }
          var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error) {
            return error;
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createStrictShapeTypeChecker(shapeTypes) {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
        }
        // We need to check all keys in case some are required but missing from
        // props.
        var allKeys = objectAssign({}, props[propName], shapeTypes);
        for (var key in allKeys) {
          var checker = shapeTypes[key];
          if (!checker) {
            return new PropTypeError(
              'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
              '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
              '\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')
            );
          }
          var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error) {
            return error;
          }
        }
        return null;
      }

      return createChainableTypeChecker(validate);
    }

    function isNode(propValue) {
      switch (typeof propValue) {
        case 'number':
        case 'string':
        case 'undefined':
          return true;
        case 'boolean':
          return !propValue;
        case 'object':
          if (Array.isArray(propValue)) {
            return propValue.every(isNode);
          }
          if (propValue === null || isValidElement(propValue)) {
            return true;
          }

          var iteratorFn = getIteratorFn(propValue);
          if (iteratorFn) {
            var iterator = iteratorFn.call(propValue);
            var step;
            if (iteratorFn !== propValue.entries) {
              while (!(step = iterator.next()).done) {
                if (!isNode(step.value)) {
                  return false;
                }
              }
            } else {
              // Iterator will provide entry [k,v] tuples rather than values.
              while (!(step = iterator.next()).done) {
                var entry = step.value;
                if (entry) {
                  if (!isNode(entry[1])) {
                    return false;
                  }
                }
              }
            }
          } else {
            return false;
          }

          return true;
        default:
          return false;
      }
    }

    function isSymbol(propType, propValue) {
      // Native Symbol.
      if (propType === 'symbol') {
        return true;
      }

      // falsy value can't be a Symbol
      if (!propValue) {
        return false;
      }

      // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
      if (propValue['@@toStringTag'] === 'Symbol') {
        return true;
      }

      // Fallback for non-spec compliant Symbols which are polyfilled.
      if (typeof Symbol === 'function' && propValue instanceof Symbol) {
        return true;
      }

      return false;
    }

    // Equivalent of `typeof` but with special handling for array and regexp.
    function getPropType(propValue) {
      var propType = typeof propValue;
      if (Array.isArray(propValue)) {
        return 'array';
      }
      if (propValue instanceof RegExp) {
        // Old webkits (at least until Android 4.0) return 'function' rather than
        // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
        // passes PropTypes.object.
        return 'object';
      }
      if (isSymbol(propType, propValue)) {
        return 'symbol';
      }
      return propType;
    }

    // This handles more types than `getPropType`. Only used for error messages.
    // See `createPrimitiveTypeChecker`.
    function getPreciseType(propValue) {
      if (typeof propValue === 'undefined' || propValue === null) {
        return '' + propValue;
      }
      var propType = getPropType(propValue);
      if (propType === 'object') {
        if (propValue instanceof Date) {
          return 'date';
        } else if (propValue instanceof RegExp) {
          return 'regexp';
        }
      }
      return propType;
    }

    // Returns a string that is postfixed to a warning about an invalid type.
    // For example, "undefined" or "of type array"
    function getPostfixForTypeWarning(value) {
      var type = getPreciseType(value);
      switch (type) {
        case 'array':
        case 'object':
          return 'an ' + type;
        case 'boolean':
        case 'date':
        case 'regexp':
          return 'a ' + type;
        default:
          return type;
      }
    }

    // Returns class name of the object, if any.
    function getClassName(propValue) {
      if (!propValue.constructor || !propValue.constructor.name) {
        return ANONYMOUS;
      }
      return propValue.constructor.name;
    }

    ReactPropTypes.checkPropTypes = checkPropTypes_1;
    ReactPropTypes.resetWarningCache = checkPropTypes_1.resetWarningCache;
    ReactPropTypes.PropTypes = ReactPropTypes;

    return ReactPropTypes;
  };

  var propTypes = createCommonjsModule(function (module) {
  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  {
    var ReactIs = reactIs;

    // By explicitly using `prop-types` you are opting into new development behavior.
    // http://fb.me/prop-types-in-prod
    var throwOnDirectAccess = true;
    module.exports = factoryWithTypeCheckers(ReactIs.isElement, throwOnDirectAccess);
  }
  });
  var propTypes_1 = propTypes.elementType;
  var propTypes_2 = propTypes.bool;
  var propTypes_3 = propTypes.func;
  var propTypes_4 = propTypes.object;
  var propTypes_5 = propTypes.oneOfType;
  var propTypes_6 = propTypes.element;

  function isClassComponent(elementType) {
    // elementType.prototype?.isReactComponent
    var _elementType$prototyp = elementType.prototype,
        prototype = _elementType$prototyp === void 0 ? {} : _elementType$prototyp;
    return Boolean(prototype.isReactComponent);
  }

  function acceptingRef(props, propName, componentName, location, propFullName) {
    var element = props[propName];
    var safePropName = propFullName || propName;

    if (element == null) {
      return null;
    }

    var warningHint;
    var elementType = element.type;
    /**
     * Blacklisting instead of whitelisting
     *
     * Blacklisting will miss some components, such as React.Fragment. Those will at least
     * trigger a warning in React.
     * We can't whitelist because there is no safe way to detect React.forwardRef
     * or class components. "Safe" means there's no public API.
     *
     */

    if (typeof elementType === 'function' && !isClassComponent(elementType)) {
      warningHint = 'Did you accidentally use a plain function component for an element instead?';
    }

    if (warningHint !== undefined) {
      return new Error("Invalid ".concat(location, " `").concat(safePropName, "` supplied to `").concat(componentName, "`. ") + "Expected an element that can hold a ref. ".concat(warningHint, " ") + 'For more information see https://material-ui.com/r/caveat-with-refs-guide');
    }

    return null;
  }

  var elementAcceptingRef = chainPropTypes(propTypes.element, acceptingRef);
  elementAcceptingRef.isRequired = chainPropTypes(propTypes.element.isRequired, acceptingRef);

  function isClassComponent$1(elementType) {
    // elementType.prototype?.isReactComponent
    var _elementType$prototyp = elementType.prototype,
        prototype = _elementType$prototyp === void 0 ? {} : _elementType$prototyp;
    return Boolean(prototype.isReactComponent);
  }

  function elementTypeAcceptingRef(props, propName, componentName, location, propFullName) {
    var propValue = props[propName];
    var safePropName = propFullName || propName;

    if (propValue == null) {
      return null;
    }

    var warningHint;
    /**
     * Blacklisting instead of whitelisting
     *
     * Blacklisting will miss some components, such as React.Fragment. Those will at least
     * trigger a warning in React.
     * We can't whitelist because there is no safe way to detect React.forwardRef
     * or class components. "Safe" means there's no public API.
     *
     */

    if (typeof propValue === 'function' && !isClassComponent$1(propValue)) {
      warningHint = 'Did you accidentally provide a plain function component instead?';
    }

    if (warningHint !== undefined) {
      return new Error("Invalid ".concat(location, " `").concat(safePropName, "` supplied to `").concat(componentName, "`. ") + "Expected an element type that can hold a ref. ".concat(warningHint, " ") + 'For more information see https://material-ui.com/r/caveat-with-refs-guide');
    }

    return null;
  }

  var elementTypeAcceptingRef$1 = chainPropTypes(propTypes_1, elementTypeAcceptingRef);

  // This module is based on https://github.com/airbnb/prop-types-exact repository.
  // However, in order to reduce the number of dependencies and to remove some extra safe checks
  // the module was forked.
  // Only exported for test purposes.
  var specialProperty = "exact-prop: \u200B";
  function exactProp(propTypes) {

    return _extends({}, propTypes, _defineProperty({}, specialProperty, function (props) {
      var unsupportedProps = Object.keys(props).filter(function (prop) {
        return !propTypes.hasOwnProperty(prop);
      });

      if (unsupportedProps.length > 0) {
        return new Error("The following props are not supported: ".concat(unsupportedProps.map(function (prop) {
          return "`".concat(prop, "`");
        }).join(', '), ". Please remove them."));
      }

      return null;
    }));
  }

  // https://github.com/JamesMGreene/Function.name/blob/58b314d4a983110c3682f1228f845d39ccca1817/Function.name.js#L3

  var fnNameMatchRegex = /^\s*function(?:\s|\s*\/\*.*\*\/\s*)+([^(\s/]*)\s*/;
  function getFunctionName(fn) {
    var match = "".concat(fn).match(fnNameMatchRegex);
    var name = match && match[1];
    return name || '';
  }
  /**
   * @param {function} Component
   * @param {string} fallback
   * @returns {string | undefined}
   */

  function getFunctionComponentName(Component) {
    var fallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    return Component.displayName || Component.name || getFunctionName(Component) || fallback;
  }

  function getWrappedName(outerType, innerType, wrapperName) {
    var functionName = getFunctionComponentName(innerType);
    return outerType.displayName || (functionName !== '' ? "".concat(wrapperName, "(").concat(functionName, ")") : wrapperName);
  }
  /**
   * cherry-pick from
   * https://github.com/facebook/react/blob/769b1f270e1251d9dbdce0fcbd9e92e502d059b8/packages/shared/getComponentName.js
   * originally forked from recompose/getDisplayName with added IE 11 support
   *
   * @param {React.ReactType} Component
   * @returns {string | undefined}
   */


  function getDisplayName(Component) {
    if (Component == null) {
      return undefined;
    }

    if (typeof Component === 'string') {
      return Component;
    }

    if (typeof Component === 'function') {
      return getFunctionComponentName(Component, 'Component');
    }

    if (_typeof(Component) === 'object') {
      switch (Component.$$typeof) {
        case reactIs_1:
          return getWrappedName(Component, Component.render, 'ForwardRef');

        default:
          return undefined;
      }
    }

    return undefined;
  }

  var refType = propTypes.oneOfType([propTypes.func, propTypes.PropTypes.object]);

  // Sorted ASC by size. That's important.
  // It can't be configured as it's used statically for propTypes.
  var keys = ['xs', 'sm', 'md', 'lg', 'xl']; // Keep in mind that @media is inclusive by the CSS specification.

  function createBreakpoints(breakpoints) {
    var _breakpoints$values = breakpoints.values,
        values = _breakpoints$values === void 0 ? {
      xs: 0,
      sm: 600,
      md: 960,
      lg: 1280,
      xl: 1920
    } : _breakpoints$values,
        _breakpoints$unit = breakpoints.unit,
        unit = _breakpoints$unit === void 0 ? 'px' : _breakpoints$unit,
        _breakpoints$step = breakpoints.step,
        step = _breakpoints$step === void 0 ? 5 : _breakpoints$step,
        other = _objectWithoutProperties(breakpoints, ["values", "unit", "step"]);

    function up(key) {
      var value = typeof values[key] === 'number' ? values[key] : key;
      return "@media (min-width:".concat(value).concat(unit, ")");
    }

    function down(key) {
      var endIndex = keys.indexOf(key) + 1;
      var upperbound = values[keys[endIndex]];

      if (endIndex === keys.length) {
        // xl down applies to all sizes
        return up('xs');
      }

      var value = typeof upperbound === 'number' && endIndex > 0 ? upperbound : key;
      return "@media (max-width:".concat(value - step / 100).concat(unit, ")");
    }

    function between(start, end) {
      var endIndex = keys.indexOf(end) + 1;

      if (endIndex === keys.length) {
        return up(start);
      }

      return "@media (min-width:".concat(values[start]).concat(unit, ") and ") + "(max-width:".concat(values[keys[endIndex]] - step / 100).concat(unit, ")");
    }

    function only(key) {
      return between(key, key);
    }

    function width(key) {
      return values[key];
    }

    return _extends({
      keys: keys,
      values: values,
      up: up,
      down: down,
      between: between,
      only: only,
      width: width
    }, other);
  }

  function createMixins(breakpoints, spacing, mixins) {
    var _toolbar;

    return _extends({
      gutters: function gutters() {
        var styles = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        // To deprecate in v4.1
        //       warning(
        //         false,
        //         [
        //           'Material-UI: theme.mixins.gutters() is deprecated.',
        //           'You can use the source of the mixin directly:',
        //           `
        // paddingLeft: theme.spacing(2),
        // paddingRight: theme.spacing(2),
        // [theme.breakpoints.up('sm')]: {
        //   paddingLeft: theme.spacing(3),
        //   paddingRight: theme.spacing(3),
        // },
        // `,
        //         ].join('\n'),
        //       );
        return _extends({
          paddingLeft: spacing(2),
          paddingRight: spacing(2)
        }, styles, _defineProperty({}, breakpoints.up('sm'), _extends({
          paddingLeft: spacing(3),
          paddingRight: spacing(3)
        }, styles[breakpoints.up('sm')])));
      },
      toolbar: (_toolbar = {
        minHeight: 56
      }, _defineProperty(_toolbar, "".concat(breakpoints.up('xs'), " and (orientation: landscape)"), {
        minHeight: 48
      }), _defineProperty(_toolbar, breakpoints.up('sm'), {
        minHeight: 64
      }), _toolbar)
    }, mixins);
  }

  var light = {
    // The colors used to style the text.
    text: {
      // The most important text.
      primary: 'rgba(0, 0, 0, 0.87)',
      // Secondary text.
      secondary: 'rgba(0, 0, 0, 0.54)',
      // Disabled text have even lower visual prominence.
      disabled: 'rgba(0, 0, 0, 0.38)',
      // Text hints.
      hint: 'rgba(0, 0, 0, 0.38)'
    },
    // The color used to divide different elements.
    divider: 'rgba(0, 0, 0, 0.12)',
    // The background colors used to style the surfaces.
    // Consistency between these values is important.
    background: {
      paper: common.white,
      default: grey[50]
    },
    // The colors used to style the action elements.
    action: {
      // The color of an active action like an icon button.
      active: 'rgba(0, 0, 0, 0.54)',
      // The color of an hovered action.
      hover: 'rgba(0, 0, 0, 0.08)',
      hoverOpacity: 0.08,
      // The color of a selected action.
      selected: 'rgba(0, 0, 0, 0.14)',
      // The color of a disabled action.
      disabled: 'rgba(0, 0, 0, 0.26)',
      // The background color of a disabled action.
      disabledBackground: 'rgba(0, 0, 0, 0.12)'
    }
  };
  var dark = {
    text: {
      primary: common.white,
      secondary: 'rgba(255, 255, 255, 0.7)',
      disabled: 'rgba(255, 255, 255, 0.5)',
      hint: 'rgba(255, 255, 255, 0.5)',
      icon: 'rgba(255, 255, 255, 0.5)'
    },
    divider: 'rgba(255, 255, 255, 0.12)',
    background: {
      paper: grey[800],
      default: '#303030'
    },
    action: {
      active: common.white,
      hover: 'rgba(255, 255, 255, 0.1)',
      hoverOpacity: 0.1,
      selected: 'rgba(255, 255, 255, 0.2)',
      disabled: 'rgba(255, 255, 255, 0.3)',
      disabledBackground: 'rgba(255, 255, 255, 0.12)'
    }
  };

  function addLightOrDark(intent, direction, shade, tonalOffset) {
    if (!intent[direction]) {
      if (intent.hasOwnProperty(shade)) {
        intent[direction] = intent[shade];
      } else if (direction === 'light') {
        intent.light = lighten(intent.main, tonalOffset);
      } else if (direction === 'dark') {
        intent.dark = darken(intent.main, tonalOffset * 1.5);
      }
    }
  }

  function createPalette(palette) {
    var _palette$primary = palette.primary,
        primary = _palette$primary === void 0 ? {
      light: indigo[300],
      main: indigo[500],
      dark: indigo[700]
    } : _palette$primary,
        _palette$secondary = palette.secondary,
        secondary = _palette$secondary === void 0 ? {
      light: pink.A200,
      main: pink.A400,
      dark: pink.A700
    } : _palette$secondary,
        _palette$error = palette.error,
        error = _palette$error === void 0 ? {
      light: red[300],
      main: red[500],
      dark: red[700]
    } : _palette$error,
        _palette$type = palette.type,
        type = _palette$type === void 0 ? 'light' : _palette$type,
        _palette$contrastThre = palette.contrastThreshold,
        contrastThreshold = _palette$contrastThre === void 0 ? 3 : _palette$contrastThre,
        _palette$tonalOffset = palette.tonalOffset,
        tonalOffset = _palette$tonalOffset === void 0 ? 0.2 : _palette$tonalOffset,
        other = _objectWithoutProperties(palette, ["primary", "secondary", "error", "type", "contrastThreshold", "tonalOffset"]); // Use the same logic as
    // Bootstrap: https://github.com/twbs/bootstrap/blob/1d6e3710dd447de1a200f29e8fa521f8a0908f70/scss/_functions.scss#L59
    // and material-components-web https://github.com/material-components/material-components-web/blob/ac46b8863c4dab9fc22c4c662dc6bd1b65dd652f/packages/mdc-theme/_functions.scss#L54


    function getContrastText(background) {
      {
        if (!background) {
          console.error("Material-UI: missing background argument in getContrastText(".concat(background, ")."));
        }
      }

      var contrastText = getContrastRatio(background, dark.text.primary) >= contrastThreshold ? dark.text.primary : light.text.primary;

      {
        var contrast = getContrastRatio(background, contrastText);

        if (contrast < 3) {
          console.error(["Material-UI: the contrast ratio of ".concat(contrast, ":1 for ").concat(contrastText, " on ").concat(background), 'falls below the WACG recommended absolute minimum contrast ratio of 3:1.', 'https://www.w3.org/TR/2008/REC-WCAG20-20081211/#visual-audio-contrast-contrast'].join('\n'));
        }
      }

      return contrastText;
    }

    function augmentColor(color) {
      var mainShade = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 500;
      var lightShade = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 300;
      var darkShade = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 700;
      color = _extends({}, color);

      if (!color.main && color[mainShade]) {
        color.main = color[mainShade];
      }

      {
        if (!color.main) {
          throw new Error(['Material-UI: the color provided to augmentColor(color) is invalid.', "The color object needs to have a `main` property or a `".concat(mainShade, "` property.")].join('\n'));
        }
      }

      addLightOrDark(color, 'light', lightShade, tonalOffset);
      addLightOrDark(color, 'dark', darkShade, tonalOffset);

      if (!color.contrastText) {
        color.contrastText = getContrastText(color.main);
      }

      return color;
    }

    var types = {
      dark: dark,
      light: light
    };

    {
      if (!types[type]) {
        console.error("Material-UI: the palette type `".concat(type, "` is not supported."));
      }
    }

    var paletteOutput = deepmerge(_extends({
      // A collection of common colors.
      common: common,
      // The palette type, can be light or dark.
      type: type,
      // The colors used to represent primary interface elements for a user.
      primary: augmentColor(primary),
      // The colors used to represent secondary interface elements for a user.
      secondary: augmentColor(secondary, 'A400', 'A200', 'A700'),
      // The colors used to represent interface elements that the user should be made aware of.
      error: augmentColor(error),
      // The grey colors.
      grey: grey,
      // Used by `getContrastText()` to maximize the contrast between the background and
      // the text.
      contrastThreshold: contrastThreshold,
      // Take a background color and return the color of the text to maximize the contrast.
      getContrastText: getContrastText,
      // Generate a rich color object.
      augmentColor: augmentColor,
      // Used by the functions below to shift a color's luminance by approximately
      // two indexes within its tonal palette.
      // E.g., shift from Red 500 to Red 300 or Red 700.
      tonalOffset: tonalOffset
    }, types[type]), other);
    return paletteOutput;
  }

  function round(value) {
    return Math.round(value * 1e5) / 1e5;
  }

  var caseAllCaps = {
    textTransform: 'uppercase'
  };
  var defaultFontFamily = '"Roboto", "Helvetica", "Arial", sans-serif';
  /**
   * @see @link{https://material.io/design/typography/the-type-system.html}
   * @see @link{https://material.io/design/typography/understanding-typography.html}
   */

  function createTypography(palette, typography) {
    var _ref = typeof typography === 'function' ? typography(palette) : typography,
        _ref$fontFamily = _ref.fontFamily,
        fontFamily = _ref$fontFamily === void 0 ? defaultFontFamily : _ref$fontFamily,
        _ref$fontSize = _ref.fontSize,
        fontSize = _ref$fontSize === void 0 ? 14 : _ref$fontSize,
        _ref$fontWeightLight = _ref.fontWeightLight,
        fontWeightLight = _ref$fontWeightLight === void 0 ? 300 : _ref$fontWeightLight,
        _ref$fontWeightRegula = _ref.fontWeightRegular,
        fontWeightRegular = _ref$fontWeightRegula === void 0 ? 400 : _ref$fontWeightRegula,
        _ref$fontWeightMedium = _ref.fontWeightMedium,
        fontWeightMedium = _ref$fontWeightMedium === void 0 ? 500 : _ref$fontWeightMedium,
        _ref$fontWeightBold = _ref.fontWeightBold,
        fontWeightBold = _ref$fontWeightBold === void 0 ? 700 : _ref$fontWeightBold,
        _ref$htmlFontSize = _ref.htmlFontSize,
        htmlFontSize = _ref$htmlFontSize === void 0 ? 16 : _ref$htmlFontSize,
        allVariants = _ref.allVariants,
        pxToRem2 = _ref.pxToRem,
        other = _objectWithoutProperties(_ref, ["fontFamily", "fontSize", "fontWeightLight", "fontWeightRegular", "fontWeightMedium", "fontWeightBold", "htmlFontSize", "allVariants", "pxToRem"]);

    {
      if (typeof fontSize !== 'number') {
        console.error("Material-UI: 'fontSize' is required to be a number.");
      }

      if (typeof htmlFontSize !== 'number') {
        console.error("Material-UI: 'htmlFontSize' is required to be a number.");
      }
    }

    var coef = fontSize / 14;

    var pxToRem = pxToRem2 || function (size) {
      return "".concat(size / htmlFontSize * coef, "rem");
    };

    var buildVariant = function buildVariant(fontWeight, size, lineHeight, letterSpacing, casing) {
      return _extends({
        fontFamily: fontFamily,
        fontWeight: fontWeight,
        fontSize: pxToRem(size),
        // Unitless following https://meyerweb.com/eric/thoughts/2006/02/08/unitless-line-heights/
        lineHeight: lineHeight
      }, fontFamily === defaultFontFamily ? {
        letterSpacing: "".concat(round(letterSpacing / size), "em")
      } : {}, {}, casing, {}, allVariants);
    };

    var variants = {
      h1: buildVariant(fontWeightLight, 96, 1, -1.5),
      h2: buildVariant(fontWeightLight, 60, 1, -0.5),
      h3: buildVariant(fontWeightRegular, 48, 1.04, 0),
      h4: buildVariant(fontWeightRegular, 34, 1.17, 0.25),
      h5: buildVariant(fontWeightRegular, 24, 1.33, 0),
      h6: buildVariant(fontWeightMedium, 20, 1.6, 0.15),
      subtitle1: buildVariant(fontWeightRegular, 16, 1.75, 0.15),
      subtitle2: buildVariant(fontWeightMedium, 14, 1.57, 0.1),
      body1: buildVariant(fontWeightRegular, 16, 1.5, 0.15),
      body2: buildVariant(fontWeightRegular, 14, 1.43, 0.15),
      button: buildVariant(fontWeightMedium, 14, 1.75, 0.4, caseAllCaps),
      caption: buildVariant(fontWeightRegular, 12, 1.66, 0.4),
      overline: buildVariant(fontWeightRegular, 12, 2.66, 1, caseAllCaps)
    };
    return deepmerge(_extends({
      htmlFontSize: htmlFontSize,
      pxToRem: pxToRem,
      round: round,
      // TODO To remove in v5?
      fontFamily: fontFamily,
      fontSize: fontSize,
      fontWeightLight: fontWeightLight,
      fontWeightRegular: fontWeightRegular,
      fontWeightMedium: fontWeightMedium,
      fontWeightBold: fontWeightBold
    }, variants), other, {
      clone: false // No need to clone deep

    });
  }

  var shadowKeyUmbraOpacity = 0.2;
  var shadowKeyPenumbraOpacity = 0.14;
  var shadowAmbientShadowOpacity = 0.12;

  function createShadow() {
    return ["".concat(arguments.length <= 0 ? undefined : arguments[0], "px ").concat(arguments.length <= 1 ? undefined : arguments[1], "px ").concat(arguments.length <= 2 ? undefined : arguments[2], "px ").concat(arguments.length <= 3 ? undefined : arguments[3], "px rgba(0,0,0,").concat(shadowKeyUmbraOpacity, ")"), "".concat(arguments.length <= 4 ? undefined : arguments[4], "px ").concat(arguments.length <= 5 ? undefined : arguments[5], "px ").concat(arguments.length <= 6 ? undefined : arguments[6], "px ").concat(arguments.length <= 7 ? undefined : arguments[7], "px rgba(0,0,0,").concat(shadowKeyPenumbraOpacity, ")"), "".concat(arguments.length <= 8 ? undefined : arguments[8], "px ").concat(arguments.length <= 9 ? undefined : arguments[9], "px ").concat(arguments.length <= 10 ? undefined : arguments[10], "px ").concat(arguments.length <= 11 ? undefined : arguments[11], "px rgba(0,0,0,").concat(shadowAmbientShadowOpacity, ")")].join(',');
  } // Values from https://github.com/material-components/material-components-web/blob/be8747f94574669cb5e7add1a7c54fa41a89cec7/packages/mdc-elevation/_variables.scss


  var shadows = ['none', createShadow(0, 2, 1, -1, 0, 1, 1, 0, 0, 1, 3, 0), createShadow(0, 3, 1, -2, 0, 2, 2, 0, 0, 1, 5, 0), createShadow(0, 3, 3, -2, 0, 3, 4, 0, 0, 1, 8, 0), createShadow(0, 2, 4, -1, 0, 4, 5, 0, 0, 1, 10, 0), createShadow(0, 3, 5, -1, 0, 5, 8, 0, 0, 1, 14, 0), createShadow(0, 3, 5, -1, 0, 6, 10, 0, 0, 1, 18, 0), createShadow(0, 4, 5, -2, 0, 7, 10, 1, 0, 2, 16, 1), createShadow(0, 5, 5, -3, 0, 8, 10, 1, 0, 3, 14, 2), createShadow(0, 5, 6, -3, 0, 9, 12, 1, 0, 3, 16, 2), createShadow(0, 6, 6, -3, 0, 10, 14, 1, 0, 4, 18, 3), createShadow(0, 6, 7, -4, 0, 11, 15, 1, 0, 4, 20, 3), createShadow(0, 7, 8, -4, 0, 12, 17, 2, 0, 5, 22, 4), createShadow(0, 7, 8, -4, 0, 13, 19, 2, 0, 5, 24, 4), createShadow(0, 7, 9, -4, 0, 14, 21, 2, 0, 5, 26, 4), createShadow(0, 8, 9, -5, 0, 15, 22, 2, 0, 6, 28, 5), createShadow(0, 8, 10, -5, 0, 16, 24, 2, 0, 6, 30, 5), createShadow(0, 8, 11, -5, 0, 17, 26, 2, 0, 6, 32, 5), createShadow(0, 9, 11, -5, 0, 18, 28, 2, 0, 7, 34, 6), createShadow(0, 9, 12, -6, 0, 19, 29, 2, 0, 7, 36, 6), createShadow(0, 10, 13, -6, 0, 20, 31, 3, 0, 8, 38, 7), createShadow(0, 10, 13, -6, 0, 21, 33, 3, 0, 8, 40, 7), createShadow(0, 10, 14, -6, 0, 22, 35, 3, 0, 8, 42, 7), createShadow(0, 11, 14, -7, 0, 23, 36, 3, 0, 9, 44, 8), createShadow(0, 11, 15, -7, 0, 24, 38, 3, 0, 9, 46, 8)];

  var shape = {
    borderRadius: 4
  };

  var warnOnce;
  function createSpacing() {
    var spacingInput = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 8;

    // Already transformed.
    if (spacingInput.mui) {
      return spacingInput;
    } // All components align to an 8dp square baseline grid for mobile, tablet, and desktop.
    // https://material.io/design/layout/understanding-layout.html#pixel-density


    var transform;

    if (typeof spacingInput === 'function') {
      transform = spacingInput;
    } else {
      {
        if (typeof spacingInput !== 'number') {
          console.error(["Material-UI: the `theme.spacing` value (".concat(spacingInput, ") is invalid."), 'It should be a number or a function.'].join('\n'));
        }
      }

      transform = function transform(factor) {
        {
          if (typeof factor !== 'number') {
            console.error("Expected spacing argument to be a number, got ".concat(factor));
          }
        }

        return spacingInput * factor;
      };
    }

    var spacing = function spacing() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      {
        if (!(args.length <= 4)) {
          console.error("Material-UI: Too many arguments provided, expected between 0 and 4, got ".concat(args.length));
        }
      }

      if (args.length === 0) {
        return transform(1);
      }

      if (args.length === 1) {
        return transform(args[0]);
      }

      return args.map(function (factor) {
        var output = transform(factor);
        return typeof output === 'number' ? "".concat(output, "px") : output;
      }).join(' ');
    }; // Backward compatibility, to remove in v5.


    Object.defineProperty(spacing, 'unit', {
      get: function get() {
        {
          if (!warnOnce || "development" === 'test') {
            console.error(['Material-UI: theme.spacing.unit usage has been deprecated.', 'It will be removed in v5.', 'You can replace `theme.spacing.unit * y` with `theme.spacing(y)`.', '', 'You can use the `https://github.com/mui-org/material-ui/tree/master/packages/material-ui-codemod/README.md#theme-spacing-api` migration helper to make the process smoother.'].join('\n'));
          }

          warnOnce = true;
        }

        return spacingInput;
      }
    });
    spacing.mui = true;
    return spacing;
  }

  // Follow https://material.google.com/motion/duration-easing.html#duration-easing-natural-easing-curves
  // to learn the context in which each easing should be used.
  var easing = {
    // This is the most common easing curve.
    easeInOut: 'cubic-bezier(0.4, 0, 0.2, 1)',
    // Objects enter the screen at full velocity from off-screen and
    // slowly decelerate to a resting point.
    easeOut: 'cubic-bezier(0.0, 0, 0.2, 1)',
    // Objects leave the screen at full velocity. They do not decelerate when off-screen.
    easeIn: 'cubic-bezier(0.4, 0, 1, 1)',
    // The sharp curve is used by objects that may return to the screen at any time.
    sharp: 'cubic-bezier(0.4, 0, 0.6, 1)'
  }; // Follow https://material.io/guidelines/motion/duration-easing.html#duration-easing-common-durations
  // to learn when use what timing

  var duration = {
    shortest: 150,
    shorter: 200,
    short: 250,
    // most basic recommended timing
    standard: 300,
    // this is to be used in complex animations
    complex: 375,
    // recommended when something is entering screen
    enteringScreen: 225,
    // recommended when something is leaving screen
    leavingScreen: 195
  };
  var formatMs = function formatMs(milliseconds) {
    return "".concat(Math.round(milliseconds), "ms");
  };
  var isString = function isString(value) {
    return typeof value === 'string';
  };
  var isNumber = function isNumber(value) {
    return !isNaN(parseFloat(value));
  };
  /**
   * @param {string|Array} props
   * @param {object} param
   * @param {string} param.prop
   * @param {number} param.duration
   * @param {string} param.easing
   * @param {number} param.delay
   */

  var transitions = {
    easing: easing,
    duration: duration,
    create: function create() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : ['all'];
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var _options$duration = options.duration,
          durationOption = _options$duration === void 0 ? duration.standard : _options$duration,
          _options$easing = options.easing,
          easingOption = _options$easing === void 0 ? easing.easeInOut : _options$easing,
          _options$delay = options.delay,
          delay = _options$delay === void 0 ? 0 : _options$delay,
          other = _objectWithoutProperties(options, ["duration", "easing", "delay"]);

      {
        if (!isString(props) && !Array.isArray(props)) {
          console.error('Material-UI: argument "props" must be a string or Array.');
        }

        if (!isNumber(durationOption) && !isString(durationOption)) {
          console.error("Material-UI: argument \"duration\" must be a number or a string but found ".concat(durationOption, "."));
        }

        if (!isString(easingOption)) {
          console.error('Material-UI: argument "easing" must be a string.');
        }

        if (!isNumber(delay) && !isString(delay)) {
          console.error('Material-UI: argument "delay" must be a number or a string.');
        }

        if (Object.keys(other).length !== 0) {
          console.error("Material-UI: unrecognized argument(s) [".concat(Object.keys(other).join(','), "]"));
        }
      }

      return (Array.isArray(props) ? props : [props]).map(function (animatedProp) {
        return "".concat(animatedProp, " ").concat(typeof durationOption === 'string' ? durationOption : formatMs(durationOption), " ").concat(easingOption, " ").concat(typeof delay === 'string' ? delay : formatMs(delay));
      }).join(',');
    },
    getAutoHeightDuration: function getAutoHeightDuration(height) {
      if (!height) {
        return 0;
      }

      var constant = height / 36; // https://www.wolframalpha.com/input/?i=(4+%2B+15+*+(x+%2F+36+)+**+0.25+%2B+(x+%2F+36)+%2F+5)+*+10

      return Math.round((4 + 15 * Math.pow(constant, 0.25) + constant / 5) * 10);
    }
  };

  // We need to centralize the zIndex definitions as they work
  // like global values in the browser.
  var zIndex = {
    mobileStepper: 1000,
    speedDial: 1050,
    appBar: 1100,
    drawer: 1200,
    modal: 1300,
    snackbar: 1400,
    tooltip: 1500
  };

  function createMuiTheme() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var _options$breakpoints = options.breakpoints,
        breakpointsInput = _options$breakpoints === void 0 ? {} : _options$breakpoints,
        _options$mixins = options.mixins,
        mixinsInput = _options$mixins === void 0 ? {} : _options$mixins,
        _options$palette = options.palette,
        paletteInput = _options$palette === void 0 ? {} : _options$palette,
        shadowsInput = options.shadows,
        spacingInput = options.spacing,
        _options$typography = options.typography,
        typographyInput = _options$typography === void 0 ? {} : _options$typography,
        other = _objectWithoutProperties(options, ["breakpoints", "mixins", "palette", "shadows", "spacing", "typography"]);

    var palette = createPalette(paletteInput);
    var breakpoints = createBreakpoints(breakpointsInput);
    var spacing = createSpacing(spacingInput);

    var muiTheme = _extends({
      breakpoints: breakpoints,
      direction: 'ltr',
      mixins: createMixins(breakpoints, spacing, mixinsInput),
      overrides: {},
      // Inject custom styles
      palette: palette,
      props: {},
      // Inject custom props
      shadows: shadowsInput || shadows,
      typography: createTypography(palette, typographyInput),
      spacing: spacing
    }, deepmerge({
      shape: shape,
      transitions: transitions,
      zIndex: zIndex
    }, other));

    {
      var pseudoClasses = ['checked', 'disabled', 'error', 'focused', 'focusVisible', 'required', 'expanded', 'selected'];

      var traverse = function traverse(node, parentKey) {
        var depth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
        var key; // eslint-disable-next-line guard-for-in, no-restricted-syntax

        for (key in node) {
          var child = node[key];

          if (depth === 1) {
            if (key.indexOf('Mui') === 0 && child) {
              traverse(child, key, depth + 1);
            }
          } else if (pseudoClasses.indexOf(key) !== -1 && Object.keys(child).length > 0) {
            {
              console.error(["Material-UI: the `".concat(parentKey, "` component increases ") + "the CSS specificity of the `".concat(key, "` internal state."), 'You can not override it like this: ', JSON.stringify(node, null, 2), '', 'Instead, you need to use the $ruleName syntax:', JSON.stringify({
                root: _defineProperty({}, "&$".concat(key), child)
              }, null, 2), '', 'https://material-ui.com/r/pseudo-classes-guide'].join('\n'));
            } // Remove the style to prevent global conflicts.


            node[key] = {};
          }
        }
      };

      traverse(muiTheme.overrides);
    }

    return muiTheme;
  }

  var hasSymbol = typeof Symbol === 'function' && Symbol.for;
  var nested = hasSymbol ? Symbol.for('mui.nested') : '__THEME_NESTED__';

  /**
   * This is the list of the style rule name we use as drop in replacement for the built-in
   * pseudo classes (:checked, :disabled, :focused, etc.).
   *
   * Why do they exist in the first place?
   * These classes are used at a specificity of 2.
   * It allows them to override previously definied styles as well as
   * being untouched by simple user overrides.
   */

  var pseudoClasses = ['checked', 'disabled', 'error', 'focused', 'focusVisible', 'required', 'expanded', 'selected']; // Returns a function which generates unique class names based on counters.
  // When new generator function is created, rule counter is reset.
  // We need to reset the rule counter for SSR for each request.
  //
  // It's inspired by
  // https://github.com/cssinjs/jss/blob/4e6a05dd3f7b6572fdd3ab216861d9e446c20331/src/utils/createGenerateClassName.js

  function createGenerateClassName() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _options$disableGloba = options.disableGlobal,
        disableGlobal = _options$disableGloba === void 0 ? false : _options$disableGloba,
        _options$productionPr = options.productionPrefix,
        _options$seed = options.seed,
        seed = _options$seed === void 0 ? '' : _options$seed;
    var seedPrefix = seed === '' ? '' : "".concat(seed, "-");
    var ruleCounter = 0;
    return function (rule, styleSheet) {
      ruleCounter += 1;

      {
        if (ruleCounter >= 1e10) {
          console.warn(['Material-UI: you might have a memory leak.', 'The ruleCounter is not supposed to grow that much.'].join(''));
        }
      }

      var name = styleSheet.options.name; // Is a global static MUI style?

      if (name && name.indexOf('Mui') === 0 && !styleSheet.options.link && !disableGlobal) {
        // We can use a shorthand class name, we never use the keys to style the components.
        if (pseudoClasses.indexOf(rule.key) !== -1) {
          return "Mui-".concat(rule.key);
        }

        var prefix = "".concat(seedPrefix).concat(name, "-").concat(rule.key);

        if (!styleSheet.options.theme[nested] || seed !== '') {
          return prefix;
        }

        return "".concat(prefix, "-").concat(ruleCounter);
      }

      var suffix = "".concat(rule.key, "-").concat(ruleCounter); // Help with debuggability.

      if (styleSheet.options.classNamePrefix) {
        return "".concat(seedPrefix).concat(styleSheet.options.classNamePrefix, "-").concat(suffix);
      }

      return "".concat(seedPrefix).concat(suffix);
    };
  }

  function createStyles(styles) {
    return styles;
  }

  /* eslint-disable no-restricted-syntax */
  function getThemeProps(params) {
    var theme = params.theme,
        name = params.name,
        props = params.props;

    if (!theme || !theme.props || !theme.props[name]) {
      return props;
    } // Resolve default props, code borrow from React source.
    // https://github.com/facebook/react/blob/15a8f031838a553e41c0b66eb1bcf1da8448104d/packages/react/src/ReactElement.js#L221


    var defaultProps = theme.props[name];
    var propName;

    for (propName in defaultProps) {
      if (props[propName] === undefined) {
        props[propName] = defaultProps[propName];
      }
    }

    return props;
  }

  var _typeof$1 = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

  var isBrowser = (typeof window === "undefined" ? "undefined" : _typeof$1(window)) === "object" && (typeof document === "undefined" ? "undefined" : _typeof$1(document)) === 'object' && document.nodeType === 9;

  function warning(condition, message) {
    {
      if (condition) {
        return;
      }

      var text = "Warning: " + message;

      if (typeof console !== 'undefined') {
        console.warn(text);
      }

      try {
        throw Error(text);
      } catch (x) {}
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    subClass.__proto__ = superClass;
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  var plainObjectConstrurctor = {}.constructor;
  function cloneStyle(style) {
    if (style == null || typeof style !== 'object') return style;
    if (Array.isArray(style)) return style.map(cloneStyle);
    if (style.constructor !== plainObjectConstrurctor) return style;
    var newStyle = {};

    for (var name in style) {
      newStyle[name] = cloneStyle(style[name]);
    }

    return newStyle;
  }

  /**
   * Create a rule instance.
   */

  function createRule(name, decl, options) {
    if (name === void 0) {
      name = 'unnamed';
    }

    var jss = options.jss;
    var declCopy = cloneStyle(decl);
    var rule = jss.plugins.onCreateRule(name, declCopy, options);
    if (rule) return rule; // It is an at-rule and it has no instance.

    if (name[0] === '@') {
       warning(false, "[JSS] Unknown rule " + name) ;
    }

    return null;
  }

  var join = function join(value, by) {
    var result = '';

    for (var i = 0; i < value.length; i++) {
      // Remove !important from the value, it will be readded later.
      if (value[i] === '!important') break;
      if (result) result += by;
      result += value[i];
    }

    return result;
  };
  /**
   * Converts array values to string.
   *
   * `margin: [['5px', '10px']]` > `margin: 5px 10px;`
   * `border: ['1px', '2px']` > `border: 1px, 2px;`
   * `margin: [['5px', '10px'], '!important']` > `margin: 5px 10px !important;`
   * `color: ['red', !important]` > `color: red !important;`
   */


  function toCssValue(value, ignoreImportant) {
    if (ignoreImportant === void 0) {
      ignoreImportant = false;
    }

    if (!Array.isArray(value)) return value;
    var cssValue = ''; // Support space separated values via `[['5px', '10px']]`.

    if (Array.isArray(value[0])) {
      for (var i = 0; i < value.length; i++) {
        if (value[i] === '!important') break;
        if (cssValue) cssValue += ', ';
        cssValue += join(value[i], ' ');
      }
    } else cssValue = join(value, ', '); // Add !important, because it was ignored.


    if (!ignoreImportant && value[value.length - 1] === '!important') {
      cssValue += ' !important';
    }

    return cssValue;
  }

  /**
   * Indent a string.
   * http://jsperf.com/array-join-vs-for
   */
  function indentStr(str, indent) {
    var result = '';

    for (var index = 0; index < indent; index++) {
      result += '  ';
    }

    return result + str;
  }
  /**
   * Converts a Rule to CSS string.
   */


  function toCss(selector, style, options) {
    if (options === void 0) {
      options = {};
    }

    var result = '';
    if (!style) return result;
    var _options = options,
        _options$indent = _options.indent,
        indent = _options$indent === void 0 ? 0 : _options$indent;
    var fallbacks = style.fallbacks;
    if (selector) indent++; // Apply fallbacks first.

    if (fallbacks) {
      // Array syntax {fallbacks: [{prop: value}]}
      if (Array.isArray(fallbacks)) {
        for (var index = 0; index < fallbacks.length; index++) {
          var fallback = fallbacks[index];

          for (var prop in fallback) {
            var value = fallback[prop];

            if (value != null) {
              if (result) result += '\n';
              result += "" + indentStr(prop + ": " + toCssValue(value) + ";", indent);
            }
          }
        }
      } else {
        // Object syntax {fallbacks: {prop: value}}
        for (var _prop in fallbacks) {
          var _value = fallbacks[_prop];

          if (_value != null) {
            if (result) result += '\n';
            result += "" + indentStr(_prop + ": " + toCssValue(_value) + ";", indent);
          }
        }
      }
    }

    for (var _prop2 in style) {
      var _value2 = style[_prop2];

      if (_value2 != null && _prop2 !== 'fallbacks') {
        if (result) result += '\n';
        result += "" + indentStr(_prop2 + ": " + toCssValue(_value2) + ";", indent);
      }
    } // Allow empty style in this case, because properties will be added dynamically.


    if (!result && !options.allowEmpty) return result; // When rule is being stringified before selector was defined.

    if (!selector) return result;
    indent--;
    if (result) result = "\n" + result + "\n";
    return indentStr(selector + " {" + result, indent) + indentStr('}', indent);
  }

  var escapeRegex = /([[\].#*$><+~=|^:(),"'`\s])/g;
  var nativeEscape = typeof CSS !== 'undefined' && CSS.escape;
  var escape = (function (str) {
    return nativeEscape ? nativeEscape(str) : str.replace(escapeRegex, '\\$1');
  });

  var BaseStyleRule =
  /*#__PURE__*/
  function () {
    function BaseStyleRule(key, style, options) {
      this.type = 'style';
      this.key = void 0;
      this.isProcessed = false;
      this.style = void 0;
      this.renderer = void 0;
      this.renderable = void 0;
      this.options = void 0;
      var sheet = options.sheet,
          Renderer = options.Renderer;
      this.key = key;
      this.options = options;
      this.style = style;
      if (sheet) this.renderer = sheet.renderer;else if (Renderer) this.renderer = new Renderer();
    }
    /**
     * Get or set a style property.
     */


    var _proto = BaseStyleRule.prototype;

    _proto.prop = function prop(name, value, options) {
      // It's a getter.
      if (value === undefined) return this.style[name]; // Don't do anything if the value has not changed.

      var force = options ? options.force : false;
      if (!force && this.style[name] === value) return this;
      var newValue = value;

      if (!options || options.process !== false) {
        newValue = this.options.jss.plugins.onChangeValue(value, name, this);
      }

      var isEmpty = newValue == null || newValue === false;
      var isDefined = name in this.style; // Value is empty and wasn't defined before.

      if (isEmpty && !isDefined && !force) return this; // We are going to remove this value.

      var remove = isEmpty && isDefined;
      if (remove) delete this.style[name];else this.style[name] = newValue; // Renderable is defined if StyleSheet option `link` is true.

      if (this.renderable && this.renderer) {
        if (remove) this.renderer.removeProperty(this.renderable, name);else this.renderer.setProperty(this.renderable, name, newValue);
        return this;
      }

      var sheet = this.options.sheet;

      if (sheet && sheet.attached) {
         warning(false, '[JSS] Rule is not linked. Missing sheet option "link: true".') ;
      }

      return this;
    };

    return BaseStyleRule;
  }();
  var StyleRule =
  /*#__PURE__*/
  function (_BaseStyleRule) {
    _inheritsLoose(StyleRule, _BaseStyleRule);

    function StyleRule(key, style, options) {
      var _this;

      _this = _BaseStyleRule.call(this, key, style, options) || this;
      _this.selectorText = void 0;
      _this.id = void 0;
      _this.renderable = void 0;
      var selector = options.selector,
          scoped = options.scoped,
          sheet = options.sheet,
          generateId = options.generateId;

      if (selector) {
        _this.selectorText = selector;
      } else if (scoped !== false) {
        _this.id = generateId(_assertThisInitialized(_assertThisInitialized(_this)), sheet);
        _this.selectorText = "." + escape(_this.id);
      }

      return _this;
    }
    /**
     * Set selector string.
     * Attention: use this with caution. Most browsers didn't implement
     * selectorText setter, so this may result in rerendering of entire Style Sheet.
     */


    var _proto2 = StyleRule.prototype;

    /**
     * Apply rule to an element inline.
     */
    _proto2.applyTo = function applyTo(renderable) {
      var renderer = this.renderer;

      if (renderer) {
        var json = this.toJSON();

        for (var prop in json) {
          renderer.setProperty(renderable, prop, json[prop]);
        }
      }

      return this;
    }
    /**
     * Returns JSON representation of the rule.
     * Fallbacks are not supported.
     * Useful for inline styles.
     */
    ;

    _proto2.toJSON = function toJSON() {
      var json = {};

      for (var prop in this.style) {
        var value = this.style[prop];
        if (typeof value !== 'object') json[prop] = value;else if (Array.isArray(value)) json[prop] = toCssValue(value);
      }

      return json;
    }
    /**
     * Generates a CSS string.
     */
    ;

    _proto2.toString = function toString(options) {
      var sheet = this.options.sheet;
      var link = sheet ? sheet.options.link : false;
      var opts = link ? _extends({}, options, {
        allowEmpty: true
      }) : options;
      return toCss(this.selectorText, this.style, opts);
    };

    _createClass(StyleRule, [{
      key: "selector",
      set: function set(selector) {
        if (selector === this.selectorText) return;
        this.selectorText = selector;
        var renderer = this.renderer,
            renderable = this.renderable;
        if (!renderable || !renderer) return;
        var hasChanged = renderer.setSelector(renderable, selector); // If selector setter is not implemented, rerender the rule.

        if (!hasChanged) {
          renderer.replaceRule(renderable, this);
        }
      }
      /**
       * Get selector string.
       */
      ,
      get: function get() {
        return this.selectorText;
      }
    }]);

    return StyleRule;
  }(BaseStyleRule);
  var pluginStyleRule = {
    onCreateRule: function onCreateRule(name, style, options) {
      if (name[0] === '@' || options.parent && options.parent.type === 'keyframes') {
        return null;
      }

      return new StyleRule(name, style, options);
    }
  };

  var defaultToStringOptions = {
    indent: 1,
    children: true
  };
  var atRegExp = /@([\w-]+)/;
  /**
   * Conditional rule for @media, @supports
   */

  var ConditionalRule =
  /*#__PURE__*/
  function () {
    function ConditionalRule(key, styles, options) {
      this.type = 'conditional';
      this.at = void 0;
      this.key = void 0;
      this.rules = void 0;
      this.options = void 0;
      this.isProcessed = false;
      this.renderable = void 0;
      this.key = key;
      var atMatch = key.match(atRegExp);
      this.at = atMatch ? atMatch[1] : 'unknown';
      this.options = options;
      this.rules = new RuleList(_extends({}, options, {
        parent: this
      }));

      for (var name in styles) {
        this.rules.add(name, styles[name]);
      }

      this.rules.process();
    }
    /**
     * Get a rule.
     */


    var _proto = ConditionalRule.prototype;

    _proto.getRule = function getRule(name) {
      return this.rules.get(name);
    }
    /**
     * Get index of a rule.
     */
    ;

    _proto.indexOf = function indexOf(rule) {
      return this.rules.indexOf(rule);
    }
    /**
     * Create and register rule, run plugins.
     */
    ;

    _proto.addRule = function addRule(name, style, options) {
      var rule = this.rules.add(name, style, options);
      if (!rule) return null;
      this.options.jss.plugins.onProcessRule(rule);
      return rule;
    }
    /**
     * Generates a CSS string.
     */
    ;

    _proto.toString = function toString(options) {
      if (options === void 0) {
        options = defaultToStringOptions;
      }

      if (options.indent == null) options.indent = defaultToStringOptions.indent;
      if (options.children == null) options.children = defaultToStringOptions.children;

      if (options.children === false) {
        return this.key + " {}";
      }

      var children = this.rules.toString(options);
      return children ? this.key + " {\n" + children + "\n}" : '';
    };

    return ConditionalRule;
  }();
  var keyRegExp = /@media|@supports\s+/;
  var pluginConditionalRule = {
    onCreateRule: function onCreateRule(key, styles, options) {
      return keyRegExp.test(key) ? new ConditionalRule(key, styles, options) : null;
    }
  };

  var defaultToStringOptions$1 = {
    indent: 1,
    children: true
  };
  var nameRegExp = /@keyframes\s+([\w-]+)/;
  /**
   * Rule for @keyframes
   */

  var KeyframesRule =
  /*#__PURE__*/
  function () {
    function KeyframesRule(key, frames, options) {
      this.type = 'keyframes';
      this.at = '@keyframes';
      this.key = void 0;
      this.name = void 0;
      this.id = void 0;
      this.rules = void 0;
      this.options = void 0;
      this.isProcessed = false;
      this.renderable = void 0;
      var nameMatch = key.match(nameRegExp);

      if (nameMatch && nameMatch[1]) {
        this.name = nameMatch[1];
      } else {
        this.name = 'noname';
         warning(false, "[JSS] Bad keyframes name " + key) ;
      }

      this.key = this.type + "-" + this.name;
      this.options = options;
      var scoped = options.scoped,
          sheet = options.sheet,
          generateId = options.generateId;
      this.id = scoped === false ? this.name : escape(generateId(this, sheet));
      this.rules = new RuleList(_extends({}, options, {
        parent: this
      }));

      for (var name in frames) {
        this.rules.add(name, frames[name], _extends({}, options, {
          parent: this
        }));
      }

      this.rules.process();
    }
    /**
     * Generates a CSS string.
     */


    var _proto = KeyframesRule.prototype;

    _proto.toString = function toString(options) {
      if (options === void 0) {
        options = defaultToStringOptions$1;
      }

      if (options.indent == null) options.indent = defaultToStringOptions$1.indent;
      if (options.children == null) options.children = defaultToStringOptions$1.children;

      if (options.children === false) {
        return this.at + " " + this.id + " {}";
      }

      var children = this.rules.toString(options);
      if (children) children = "\n" + children + "\n";
      return this.at + " " + this.id + " {" + children + "}";
    };

    return KeyframesRule;
  }();
  var keyRegExp$1 = /@keyframes\s+/;
  var refRegExp = /\$([\w-]+)/g;

  var findReferencedKeyframe = function findReferencedKeyframe(val, keyframes) {
    if (typeof val === 'string') {
      return val.replace(refRegExp, function (match, name) {
        if (name in keyframes) {
          return keyframes[name];
        }

         warning(false, "[JSS] Referenced keyframes rule \"" + name + "\" is not defined.") ;
        return match;
      });
    }

    return val;
  };
  /**
   * Replace the reference for a animation name.
   */


  var replaceRef = function replaceRef(style, prop, keyframes) {
    var value = style[prop];
    var refKeyframe = findReferencedKeyframe(value, keyframes);

    if (refKeyframe !== value) {
      style[prop] = refKeyframe;
    }
  };

  var plugin = {
    onCreateRule: function onCreateRule(key, frames, options) {
      return typeof key === 'string' && keyRegExp$1.test(key) ? new KeyframesRule(key, frames, options) : null;
    },
    // Animation name ref replacer.
    onProcessStyle: function onProcessStyle(style, rule, sheet) {
      if (rule.type !== 'style' || !sheet) return style;
      if ('animation-name' in style) replaceRef(style, 'animation-name', sheet.keyframes);
      if ('animation' in style) replaceRef(style, 'animation', sheet.keyframes);
      return style;
    },
    onChangeValue: function onChangeValue(val, prop, rule) {
      var sheet = rule.options.sheet;

      if (!sheet) {
        return val;
      }

      switch (prop) {
        case 'animation':
          return findReferencedKeyframe(val, sheet.keyframes);

        case 'animation-name':
          return findReferencedKeyframe(val, sheet.keyframes);

        default:
          return val;
      }
    }
  };

  var KeyframeRule =
  /*#__PURE__*/
  function (_BaseStyleRule) {
    _inheritsLoose(KeyframeRule, _BaseStyleRule);

    function KeyframeRule() {
      var _this;

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _BaseStyleRule.call.apply(_BaseStyleRule, [this].concat(args)) || this;
      _this.renderable = void 0;
      return _this;
    }

    var _proto = KeyframeRule.prototype;

    /**
     * Generates a CSS string.
     */
    _proto.toString = function toString(options) {
      var sheet = this.options.sheet;
      var link = sheet ? sheet.options.link : false;
      var opts = link ? _extends({}, options, {
        allowEmpty: true
      }) : options;
      return toCss(this.key, this.style, opts);
    };

    return KeyframeRule;
  }(BaseStyleRule);
  var pluginKeyframeRule = {
    onCreateRule: function onCreateRule(key, style, options) {
      if (options.parent && options.parent.type === 'keyframes') {
        return new KeyframeRule(key, style, options);
      }

      return null;
    }
  };

  var FontFaceRule =
  /*#__PURE__*/
  function () {
    function FontFaceRule(key, style, options) {
      this.type = 'font-face';
      this.at = '@font-face';
      this.key = void 0;
      this.style = void 0;
      this.options = void 0;
      this.isProcessed = false;
      this.renderable = void 0;
      this.key = key;
      this.style = style;
      this.options = options;
    }
    /**
     * Generates a CSS string.
     */


    var _proto = FontFaceRule.prototype;

    _proto.toString = function toString(options) {
      if (Array.isArray(this.style)) {
        var str = '';

        for (var index = 0; index < this.style.length; index++) {
          str += toCss(this.key, this.style[index]);
          if (this.style[index + 1]) str += '\n';
        }

        return str;
      }

      return toCss(this.key, this.style, options);
    };

    return FontFaceRule;
  }();
  var pluginFontFaceRule = {
    onCreateRule: function onCreateRule(key, style, options) {
      return key === '@font-face' ? new FontFaceRule(key, style, options) : null;
    }
  };

  var ViewportRule =
  /*#__PURE__*/
  function () {
    function ViewportRule(key, style, options) {
      this.type = 'viewport';
      this.at = '@viewport';
      this.key = void 0;
      this.style = void 0;
      this.options = void 0;
      this.isProcessed = false;
      this.renderable = void 0;
      this.key = key;
      this.style = style;
      this.options = options;
    }
    /**
     * Generates a CSS string.
     */


    var _proto = ViewportRule.prototype;

    _proto.toString = function toString(options) {
      return toCss(this.key, this.style, options);
    };

    return ViewportRule;
  }();
  var pluginViewportRule = {
    onCreateRule: function onCreateRule(key, style, options) {
      return key === '@viewport' || key === '@-ms-viewport' ? new ViewportRule(key, style, options) : null;
    }
  };

  var SimpleRule =
  /*#__PURE__*/
  function () {
    function SimpleRule(key, value, options) {
      this.type = 'simple';
      this.key = void 0;
      this.value = void 0;
      this.options = void 0;
      this.isProcessed = false;
      this.renderable = void 0;
      this.key = key;
      this.value = value;
      this.options = options;
    }
    /**
     * Generates a CSS string.
     */
    // eslint-disable-next-line no-unused-vars


    var _proto = SimpleRule.prototype;

    _proto.toString = function toString(options) {
      if (Array.isArray(this.value)) {
        var str = '';

        for (var index = 0; index < this.value.length; index++) {
          str += this.key + " " + this.value[index] + ";";
          if (this.value[index + 1]) str += '\n';
        }

        return str;
      }

      return this.key + " " + this.value + ";";
    };

    return SimpleRule;
  }();
  var keysMap = {
    '@charset': true,
    '@import': true,
    '@namespace': true
  };
  var pluginSimpleRule = {
    onCreateRule: function onCreateRule(key, value, options) {
      return key in keysMap ? new SimpleRule(key, value, options) : null;
    }
  };

  var plugins = [pluginStyleRule, pluginConditionalRule, plugin, pluginKeyframeRule, pluginFontFaceRule, pluginViewportRule, pluginSimpleRule];

  var defaultUpdateOptions = {
    process: true
  };
  var forceUpdateOptions = {
    force: true,
    process: true
    /**
     * Contains rules objects and allows adding/removing etc.
     * Is used for e.g. by `StyleSheet` or `ConditionalRule`.
     */

  };

  var RuleList =
  /*#__PURE__*/
  function () {
    // Rules registry for access by .get() method.
    // It contains the same rule registered by name and by selector.
    // Original styles object.
    // Used to ensure correct rules order.
    function RuleList(options) {
      this.map = {};
      this.raw = {};
      this.index = [];
      this.options = void 0;
      this.classes = void 0;
      this.keyframes = void 0;
      this.options = options;
      this.classes = options.classes;
      this.keyframes = options.keyframes;
    }
    /**
     * Create and register rule.
     *
     * Will not render after Style Sheet was rendered the first time.
     */


    var _proto = RuleList.prototype;

    _proto.add = function add(key, decl, ruleOptions) {
      var _this$options = this.options,
          parent = _this$options.parent,
          sheet = _this$options.sheet,
          jss = _this$options.jss,
          Renderer = _this$options.Renderer,
          generateId = _this$options.generateId,
          scoped = _this$options.scoped;

      var options = _extends({
        classes: this.classes,
        parent: parent,
        sheet: sheet,
        jss: jss,
        Renderer: Renderer,
        generateId: generateId,
        scoped: scoped
      }, ruleOptions); // We need to save the original decl before creating the rule
      // because cache plugin needs to use it as a key to return a cached rule.


      this.raw[key] = decl;

      if (key in this.classes) {
        // For e.g. rules inside of @media container
        options.selector = "." + escape(this.classes[key]);
      }

      var rule = createRule(key, decl, options);
      if (!rule) return null;
      this.register(rule);
      var index = options.index === undefined ? this.index.length : options.index;
      this.index.splice(index, 0, rule);
      return rule;
    }
    /**
     * Get a rule.
     */
    ;

    _proto.get = function get(name) {
      return this.map[name];
    }
    /**
     * Delete a rule.
     */
    ;

    _proto.remove = function remove(rule) {
      this.unregister(rule);
      delete this.raw[rule.key];
      this.index.splice(this.indexOf(rule), 1);
    }
    /**
     * Get index of a rule.
     */
    ;

    _proto.indexOf = function indexOf(rule) {
      return this.index.indexOf(rule);
    }
    /**
     * Run `onProcessRule()` plugins on every rule.
     */
    ;

    _proto.process = function process() {
      var plugins$$1 = this.options.jss.plugins; // We need to clone array because if we modify the index somewhere else during a loop
      // we end up with very hard-to-track-down side effects.

      this.index.slice(0).forEach(plugins$$1.onProcessRule, plugins$$1);
    }
    /**
     * Register a rule in `.map` and `.classes` maps.
     */
    ;

    _proto.register = function register(rule) {
      this.map[rule.key] = rule;

      if (rule instanceof StyleRule) {
        this.map[rule.selector] = rule;
        if (rule.id) this.classes[rule.key] = rule.id;
      } else if (rule instanceof KeyframesRule && this.keyframes) {
        this.keyframes[rule.name] = rule.id;
      }
    }
    /**
     * Unregister a rule.
     */
    ;

    _proto.unregister = function unregister(rule) {
      delete this.map[rule.key];

      if (rule instanceof StyleRule) {
        delete this.map[rule.selector];
        delete this.classes[rule.key];
      } else if (rule instanceof KeyframesRule) {
        delete this.keyframes[rule.name];
      }
    }
    /**
     * Update the function values with a new data.
     */
    ;

    _proto.update = function update() {
      var name;
      var data;
      var options;

      if (typeof (arguments.length <= 0 ? undefined : arguments[0]) === 'string') {
        name = arguments.length <= 0 ? undefined : arguments[0]; // $FlowFixMe

        data = arguments.length <= 1 ? undefined : arguments[1]; // $FlowFixMe

        options = arguments.length <= 2 ? undefined : arguments[2];
      } else {
        data = arguments.length <= 0 ? undefined : arguments[0]; // $FlowFixMe

        options = arguments.length <= 1 ? undefined : arguments[1];
        name = null;
      }

      if (name) {
        this.onUpdate(data, this.get(name), options);
      } else {
        for (var index = 0; index < this.index.length; index++) {
          this.onUpdate(data, this.index[index], options);
        }
      }
    }
    /**
     * Execute plugins, update rule props.
     */
    ;

    _proto.onUpdate = function onUpdate(data, rule, options) {
      if (options === void 0) {
        options = defaultUpdateOptions;
      }

      var _this$options2 = this.options,
          plugins$$1 = _this$options2.jss.plugins,
          sheet = _this$options2.sheet; // It is a rules container like for e.g. ConditionalRule.

      if (rule.rules instanceof RuleList) {
        rule.rules.update(data, options);
        return;
      }

      var styleRule = rule;
      var style = styleRule.style;
      plugins$$1.onUpdate(data, rule, sheet, options); // We rely on a new `style` ref in case it was mutated during onUpdate hook.

      if (options.process && style && style !== styleRule.style) {
        // We need to run the plugins in case new `style` relies on syntax plugins.
        plugins$$1.onProcessStyle(styleRule.style, styleRule, sheet); // Update and add props.

        for (var prop in styleRule.style) {
          var nextValue = styleRule.style[prop];
          var prevValue = style[prop]; // We need to use `force: true` because `rule.style` has been updated during onUpdate hook, so `rule.prop()` will not update the CSSOM rule.
          // We do this comparison to avoid unneeded `rule.prop()` calls, since we have the old `style` object here.

          if (nextValue !== prevValue) {
            styleRule.prop(prop, nextValue, forceUpdateOptions);
          }
        } // Remove props.


        for (var _prop in style) {
          var _nextValue = styleRule.style[_prop];
          var _prevValue = style[_prop]; // We need to use `force: true` because `rule.style` has been updated during onUpdate hook, so `rule.prop()` will not update the CSSOM rule.
          // We do this comparison to avoid unneeded `rule.prop()` calls, since we have the old `style` object here.

          if (_nextValue == null && _nextValue !== _prevValue) {
            styleRule.prop(_prop, null, forceUpdateOptions);
          }
        }
      }
    }
    /**
     * Convert rules to a CSS string.
     */
    ;

    _proto.toString = function toString(options) {
      var str = '';
      var sheet = this.options.sheet;
      var link = sheet ? sheet.options.link : false;

      for (var index = 0; index < this.index.length; index++) {
        var rule = this.index[index];
        var css = rule.toString(options); // No need to render an empty rule.

        if (!css && !link) continue;
        if (str) str += '\n';
        str += css;
      }

      return str;
    };

    return RuleList;
  }();

  var StyleSheet =
  /*#__PURE__*/
  function () {
    function StyleSheet(styles, options) {
      this.options = void 0;
      this.deployed = void 0;
      this.attached = void 0;
      this.rules = void 0;
      this.renderer = void 0;
      this.classes = void 0;
      this.keyframes = void 0;
      this.queue = void 0;
      this.attached = false;
      this.deployed = false;
      this.classes = {};
      this.keyframes = {};
      this.options = _extends({}, options, {
        sheet: this,
        parent: this,
        classes: this.classes,
        keyframes: this.keyframes
      });

      if (options.Renderer) {
        this.renderer = new options.Renderer(this);
      }

      this.rules = new RuleList(this.options);

      for (var name in styles) {
        this.rules.add(name, styles[name]);
      }

      this.rules.process();
    }
    /**
     * Attach renderable to the render tree.
     */


    var _proto = StyleSheet.prototype;

    _proto.attach = function attach() {
      if (this.attached) return this;
      if (this.renderer) this.renderer.attach();
      this.attached = true; // Order is important, because we can't use insertRule API if style element is not attached.

      if (!this.deployed) this.deploy();
      return this;
    }
    /**
     * Remove renderable from render tree.
     */
    ;

    _proto.detach = function detach() {
      if (!this.attached) return this;
      if (this.renderer) this.renderer.detach();
      this.attached = false;
      return this;
    }
    /**
     * Add a rule to the current stylesheet.
     * Will insert a rule also after the stylesheet has been rendered first time.
     */
    ;

    _proto.addRule = function addRule(name, decl, options) {
      var queue = this.queue; // Plugins can create rules.
      // In order to preserve the right order, we need to queue all `.addRule` calls,
      // which happen after the first `rules.add()` call.

      if (this.attached && !queue) this.queue = [];
      var rule = this.rules.add(name, decl, options);
      if (!rule) return null;
      this.options.jss.plugins.onProcessRule(rule);

      if (this.attached) {
        if (!this.deployed) return rule; // Don't insert rule directly if there is no stringified version yet.
        // It will be inserted all together when .attach is called.

        if (queue) queue.push(rule);else {
          this.insertRule(rule);

          if (this.queue) {
            this.queue.forEach(this.insertRule, this);
            this.queue = undefined;
          }
        }
        return rule;
      } // We can't add rules to a detached style node.
      // We will redeploy the sheet once user will attach it.


      this.deployed = false;
      return rule;
    }
    /**
     * Insert rule into the StyleSheet
     */
    ;

    _proto.insertRule = function insertRule(rule) {
      if (this.renderer) {
        this.renderer.insertRule(rule);
      }
    }
    /**
     * Create and add rules.
     * Will render also after Style Sheet was rendered the first time.
     */
    ;

    _proto.addRules = function addRules(styles, options) {
      var added = [];

      for (var name in styles) {
        var rule = this.addRule(name, styles[name], options);
        if (rule) added.push(rule);
      }

      return added;
    }
    /**
     * Get a rule by name.
     */
    ;

    _proto.getRule = function getRule(name) {
      return this.rules.get(name);
    }
    /**
     * Delete a rule by name.
     * Returns `true`: if rule has been deleted from the DOM.
     */
    ;

    _proto.deleteRule = function deleteRule(name) {
      var rule = this.rules.get(name);
      if (!rule) return false;
      this.rules.remove(rule);

      if (this.attached && rule.renderable && this.renderer) {
        return this.renderer.deleteRule(rule.renderable);
      }

      return true;
    }
    /**
     * Get index of a rule.
     */
    ;

    _proto.indexOf = function indexOf(rule) {
      return this.rules.indexOf(rule);
    }
    /**
     * Deploy pure CSS string to a renderable.
     */
    ;

    _proto.deploy = function deploy() {
      if (this.renderer) this.renderer.deploy();
      this.deployed = true;
      return this;
    }
    /**
     * Update the function values with a new data.
     */
    ;

    _proto.update = function update() {
      var _this$rules;

      (_this$rules = this.rules).update.apply(_this$rules, arguments);

      return this;
    }
    /**
     * Convert rules to a CSS string.
     */
    ;

    _proto.toString = function toString(options) {
      return this.rules.toString(options);
    };

    return StyleSheet;
  }();

  var PluginsRegistry =
  /*#__PURE__*/
  function () {
    function PluginsRegistry() {
      this.plugins = {
        internal: [],
        external: []
      };
      this.registry = void 0;
    }

    var _proto = PluginsRegistry.prototype;

    /**
     * Call `onCreateRule` hooks and return an object if returned by a hook.
     */
    _proto.onCreateRule = function onCreateRule(name, decl, options) {
      for (var i = 0; i < this.registry.onCreateRule.length; i++) {
        var rule = this.registry.onCreateRule[i](name, decl, options);
        if (rule) return rule;
      }

      return null;
    }
    /**
     * Call `onProcessRule` hooks.
     */
    ;

    _proto.onProcessRule = function onProcessRule(rule) {
      if (rule.isProcessed) return;
      var sheet = rule.options.sheet;

      for (var i = 0; i < this.registry.onProcessRule.length; i++) {
        this.registry.onProcessRule[i](rule, sheet);
      }

      if (rule.style) this.onProcessStyle(rule.style, rule, sheet);
      rule.isProcessed = true;
    }
    /**
     * Call `onProcessStyle` hooks.
     */
    ;

    _proto.onProcessStyle = function onProcessStyle(style, rule, sheet) {
      for (var i = 0; i < this.registry.onProcessStyle.length; i++) {
        // $FlowFixMe
        rule.style = this.registry.onProcessStyle[i](rule.style, rule, sheet);
      }
    }
    /**
     * Call `onProcessSheet` hooks.
     */
    ;

    _proto.onProcessSheet = function onProcessSheet(sheet) {
      for (var i = 0; i < this.registry.onProcessSheet.length; i++) {
        this.registry.onProcessSheet[i](sheet);
      }
    }
    /**
     * Call `onUpdate` hooks.
     */
    ;

    _proto.onUpdate = function onUpdate(data, rule, sheet, options) {
      for (var i = 0; i < this.registry.onUpdate.length; i++) {
        this.registry.onUpdate[i](data, rule, sheet, options);
      }
    }
    /**
     * Call `onChangeValue` hooks.
     */
    ;

    _proto.onChangeValue = function onChangeValue(value, prop, rule) {
      var processedValue = value;

      for (var i = 0; i < this.registry.onChangeValue.length; i++) {
        processedValue = this.registry.onChangeValue[i](processedValue, prop, rule);
      }

      return processedValue;
    }
    /**
     * Register a plugin.
     */
    ;

    _proto.use = function use(newPlugin, options) {
      if (options === void 0) {
        options = {
          queue: 'external'
        };
      }

      var plugins = this.plugins[options.queue]; // Avoids applying same plugin twice, at least based on ref.

      if (plugins.indexOf(newPlugin) !== -1) {
        return;
      }

      plugins.push(newPlugin);
      this.registry = [].concat(this.plugins.external, this.plugins.internal).reduce(function (registry, plugin) {
        for (var name in plugin) {
          if (name in registry) {
            registry[name].push(plugin[name]);
          } else {
             warning(false, "[JSS] Unknown hook \"" + name + "\".") ;
          }
        }

        return registry;
      }, {
        onCreateRule: [],
        onProcessRule: [],
        onProcessStyle: [],
        onProcessSheet: [],
        onChangeValue: [],
        onUpdate: []
      });
    };

    return PluginsRegistry;
  }();

  /**
   * Sheets registry to access them all at one place.
   */
  var SheetsRegistry =
  /*#__PURE__*/
  function () {
    function SheetsRegistry() {
      this.registry = [];
    }

    var _proto = SheetsRegistry.prototype;

    /**
     * Register a Style Sheet.
     */
    _proto.add = function add(sheet) {
      var registry = this.registry;
      var index = sheet.options.index;
      if (registry.indexOf(sheet) !== -1) return;

      if (registry.length === 0 || index >= this.index) {
        registry.push(sheet);
        return;
      } // Find a position.


      for (var i = 0; i < registry.length; i++) {
        if (registry[i].options.index > index) {
          registry.splice(i, 0, sheet);
          return;
        }
      }
    }
    /**
     * Reset the registry.
     */
    ;

    _proto.reset = function reset() {
      this.registry = [];
    }
    /**
     * Remove a Style Sheet.
     */
    ;

    _proto.remove = function remove(sheet) {
      var index = this.registry.indexOf(sheet);
      this.registry.splice(index, 1);
    }
    /**
     * Convert all attached sheets to a CSS string.
     */
    ;

    _proto.toString = function toString(_temp) {
      var _ref = _temp === void 0 ? {} : _temp,
          attached = _ref.attached,
          options = _objectWithoutPropertiesLoose(_ref, ["attached"]);

      var css = '';

      for (var i = 0; i < this.registry.length; i++) {
        var sheet = this.registry[i];

        if (attached != null && sheet.attached !== attached) {
          continue;
        }

        if (css) css += '\n';
        css += sheet.toString(options);
      }

      return css;
    };

    _createClass(SheetsRegistry, [{
      key: "index",

      /**
       * Current highest index number.
       */
      get: function get() {
        return this.registry.length === 0 ? 0 : this.registry[this.registry.length - 1].options.index;
      }
    }]);

    return SheetsRegistry;
  }();

  /**
   * This is a global sheets registry. Only DomRenderer will add sheets to it.
   * On the server one should use an own SheetsRegistry instance and add the
   * sheets to it, because you need to make sure to create a new registry for
   * each request in order to not leak sheets across requests.
   */

  var sheets = new SheetsRegistry();

  /* eslint-disable */
  // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
  var globalThis = typeof window != 'undefined' && window.Math == Math ? window : typeof self != 'undefined' && self.Math == Math ? self : Function('return this')();

  var ns = '2f1acc6c3a606b082e5eef5e54414ffb';
  if (globalThis[ns] == null) globalThis[ns] = 0; // Bundle may contain multiple JSS versions at the same time. In order to identify
  // the current version with just one short number and use it for classes generation
  // we use a counter. Also it is more accurate, because user can manually reevaluate
  // the module.

  var moduleId = globalThis[ns]++;

  var maxRules = 1e10;

  /**
   * Returns a function which generates unique class names based on counters.
   * When new generator function is created, rule counter is reseted.
   * We need to reset the rule counter for SSR for each request.
   */
  var createGenerateId = function createGenerateId(options) {
    if (options === void 0) {
      options = {};
    }

    var ruleCounter = 0;
    return function (rule, sheet) {
      ruleCounter += 1;

      if (ruleCounter > maxRules) {
         warning(false, "[JSS] You might have a memory leak. Rule counter is at " + ruleCounter + ".") ;
      }

      var jssId = '';
      var prefix = '';

      if (sheet) {
        if (sheet.options.classNamePrefix) {
          prefix = sheet.options.classNamePrefix;
        }

        if (sheet.options.jss.id != null) {
          jssId = String(sheet.options.jss.id);
        }
      }

      if (options.minify) {
        // Using "c" because a number can't be the first char in a class name.
        return "" + (prefix || 'c') + moduleId + jssId + ruleCounter;
      }

      return prefix + rule.key + "-" + moduleId + (jssId ? "-" + jssId : '') + "-" + ruleCounter;
    };
  };

  /**
   * Cache the value from the first time a function is called.
   */
  var memoize = function memoize(fn) {
    var value;
    return function () {
      if (!value) value = fn();
      return value;
    };
  };
  /**
   * Get a style property value.
   */


  function getPropertyValue(cssRule, prop) {
    try {
      // Support CSSTOM.
      if (cssRule.attributeStyleMap) {
        return cssRule.attributeStyleMap.get(prop);
      }

      return cssRule.style.getPropertyValue(prop);
    } catch (err) {
      // IE may throw if property is unknown.
      return '';
    }
  }
  /**
   * Set a style property.
   */


  function setProperty(cssRule, prop, value) {
    try {
      var cssValue = value;

      if (Array.isArray(value)) {
        cssValue = toCssValue(value, true);

        if (value[value.length - 1] === '!important') {
          cssRule.style.setProperty(prop, cssValue, 'important');
          return true;
        }
      } // Support CSSTOM.


      if (cssRule.attributeStyleMap) {
        cssRule.attributeStyleMap.set(prop, cssValue);
      } else {
        cssRule.style.setProperty(prop, cssValue);
      }
    } catch (err) {
      // IE may throw if property is unknown.
      return false;
    }

    return true;
  }
  /**
   * Remove a style property.
   */


  function removeProperty(cssRule, prop) {
    try {
      // Support CSSTOM.
      if (cssRule.attributeStyleMap) {
        cssRule.attributeStyleMap.delete(prop);
      } else {
        cssRule.style.removeProperty(prop);
      }
    } catch (err) {
       warning(false, "[JSS] DOMException \"" + err.message + "\" was thrown. Tried to remove property \"" + prop + "\".") ;
    }
  }
  /**
   * Set the selector.
   */


  function setSelector(cssRule, selectorText) {
    cssRule.selectorText = selectorText; // Return false if setter was not successful.
    // Currently works in chrome only.

    return cssRule.selectorText === selectorText;
  }
  /**
   * Gets the `head` element upon the first call and caches it.
   * We assume it can't be null.
   */


  var getHead = memoize(function () {
    return document.querySelector('head');
  });
  /**
   * Find attached sheet with an index higher than the passed one.
   */

  function findHigherSheet(registry, options) {
    for (var i = 0; i < registry.length; i++) {
      var sheet = registry[i];

      if (sheet.attached && sheet.options.index > options.index && sheet.options.insertionPoint === options.insertionPoint) {
        return sheet;
      }
    }

    return null;
  }
  /**
   * Find attached sheet with the highest index.
   */


  function findHighestSheet(registry, options) {
    for (var i = registry.length - 1; i >= 0; i--) {
      var sheet = registry[i];

      if (sheet.attached && sheet.options.insertionPoint === options.insertionPoint) {
        return sheet;
      }
    }

    return null;
  }
  /**
   * Find a comment with "jss" inside.
   */


  function findCommentNode(text) {
    var head = getHead();

    for (var i = 0; i < head.childNodes.length; i++) {
      var node = head.childNodes[i];

      if (node.nodeType === 8 && node.nodeValue.trim() === text) {
        return node;
      }
    }

    return null;
  }

  /**
   * Find a node before which we can insert the sheet.
   */
  function findPrevNode(options) {
    var registry = sheets.registry;

    if (registry.length > 0) {
      // Try to insert before the next higher sheet.
      var sheet = findHigherSheet(registry, options);

      if (sheet && sheet.renderer) {
        return {
          parent: sheet.renderer.element.parentNode,
          node: sheet.renderer.element
        };
      } // Otherwise insert after the last attached.


      sheet = findHighestSheet(registry, options);

      if (sheet && sheet.renderer) {
        return {
          parent: sheet.renderer.element.parentNode,
          node: sheet.renderer.element.nextSibling
        };
      }
    } // Try to find a comment placeholder if registry is empty.


    var insertionPoint = options.insertionPoint;

    if (insertionPoint && typeof insertionPoint === 'string') {
      var comment = findCommentNode(insertionPoint);

      if (comment) {
        return {
          parent: comment.parentNode,
          node: comment.nextSibling
        };
      } // If user specifies an insertion point and it can't be found in the document -
      // bad specificity issues may appear.


       warning(false, "[JSS] Insertion point \"" + insertionPoint + "\" not found.") ;
    }

    return false;
  }
  /**
   * Insert style element into the DOM.
   */


  function insertStyle(style, options) {
    var insertionPoint = options.insertionPoint;
    var nextNode = findPrevNode(options);

    if (nextNode !== false && nextNode.parent) {
      nextNode.parent.insertBefore(style, nextNode.node);
      return;
    } // Works with iframes and any node types.


    if (insertionPoint && typeof insertionPoint.nodeType === 'number') {
      // https://stackoverflow.com/questions/41328728/force-casting-in-flow
      var insertionPointElement = insertionPoint;
      var parentNode = insertionPointElement.parentNode;
      if (parentNode) parentNode.insertBefore(style, insertionPointElement.nextSibling);else  warning(false, '[JSS] Insertion point is not in the DOM.') ;
      return;
    }

    getHead().appendChild(style);
  }
  /**
   * Read jss nonce setting from the page if the user has set it.
   */


  var getNonce = memoize(function () {
    var node = document.querySelector('meta[property="csp-nonce"]');
    return node ? node.getAttribute('content') : null;
  });

  var _insertRule = function insertRule(container, rule, index) {
    var maxIndex = container.cssRules.length; // In case previous insertion fails, passed index might be wrong

    if (index === undefined || index > maxIndex) {
      // eslint-disable-next-line no-param-reassign
      index = maxIndex;
    }

    try {
      if ('insertRule' in container) {
        var c = container;
        c.insertRule(rule, index);
      } // Keyframes rule.
      else if ('appendRule' in container) {
          var _c = container;

          _c.appendRule(rule);
        }
    } catch (err) {
       warning(false, "[JSS] " + err.message) ;
      return false;
    }

    return container.cssRules[index];
  };

  var createStyle = function createStyle() {
    var el = document.createElement('style'); // Without it, IE will have a broken source order specificity if we
    // insert rules after we insert the style tag.
    // It seems to kick-off the source order specificity algorithm.

    el.textContent = '\n';
    return el;
  };

  var DomRenderer =
  /*#__PURE__*/
  function () {
    // HTMLStyleElement needs fixing https://github.com/facebook/flow/issues/2696
    function DomRenderer(sheet) {
      this.getPropertyValue = getPropertyValue;
      this.setProperty = setProperty;
      this.removeProperty = removeProperty;
      this.setSelector = setSelector;
      this.element = void 0;
      this.sheet = void 0;
      this.hasInsertedRules = false;
      // There is no sheet when the renderer is used from a standalone StyleRule.
      if (sheet) sheets.add(sheet);
      this.sheet = sheet;

      var _ref = this.sheet ? this.sheet.options : {},
          media = _ref.media,
          meta = _ref.meta,
          element = _ref.element;

      this.element = element || createStyle();
      this.element.setAttribute('data-jss', '');
      if (media) this.element.setAttribute('media', media);
      if (meta) this.element.setAttribute('data-meta', meta);
      var nonce = getNonce();
      if (nonce) this.element.setAttribute('nonce', nonce);
    }
    /**
     * Insert style element into render tree.
     */


    var _proto = DomRenderer.prototype;

    _proto.attach = function attach() {
      // In the case the element node is external and it is already in the DOM.
      if (this.element.parentNode || !this.sheet) return;
      insertStyle(this.element, this.sheet.options); // When rules are inserted using `insertRule` API, after `sheet.detach().attach()`
      // most browsers create a new CSSStyleSheet, except of all IEs.

      var deployed = Boolean(this.sheet && this.sheet.deployed);

      if (this.hasInsertedRules && deployed) {
        this.hasInsertedRules = false;
        this.deploy();
      }
    }
    /**
     * Remove style element from render tree.
     */
    ;

    _proto.detach = function detach() {
      var parentNode = this.element.parentNode;
      if (parentNode) parentNode.removeChild(this.element);
    }
    /**
     * Inject CSS string into element.
     */
    ;

    _proto.deploy = function deploy() {
      var sheet = this.sheet;
      if (!sheet) return;

      if (sheet.options.link) {
        this.insertRules(sheet.rules);
        return;
      }

      this.element.textContent = "\n" + sheet.toString() + "\n";
    }
    /**
     * Insert RuleList into an element.
     */
    ;

    _proto.insertRules = function insertRules(rules, nativeParent) {
      for (var i = 0; i < rules.index.length; i++) {
        this.insertRule(rules.index[i], i, nativeParent);
      }
    }
    /**
     * Insert a rule into element.
     */
    ;

    _proto.insertRule = function insertRule(rule, index, nativeParent) {
      if (nativeParent === void 0) {
        nativeParent = this.element.sheet;
      }

      if (rule.rules) {
        var parent = rule;
        var latestNativeParent = nativeParent;

        if (rule.type === 'conditional' || rule.type === 'keyframes') {
          // We need to render the container without children first.
          latestNativeParent = _insertRule(nativeParent, parent.toString({
            children: false
          }), index);

          if (latestNativeParent === false) {
            return false;
          }
        }

        this.insertRules(parent.rules, latestNativeParent);
        return latestNativeParent;
      } // IE keeps the CSSStyleSheet after style node has been reattached,
      // so we need to check if the `renderable` reference the right style sheet and not
      // rerender those rules.


      if (rule.renderable && rule.renderable.parentStyleSheet === this.element.sheet) {
        return rule.renderable;
      }

      var ruleStr = rule.toString();
      if (!ruleStr) return false;

      var nativeRule = _insertRule(nativeParent, ruleStr, index);

      if (nativeRule === false) {
        return false;
      }

      this.hasInsertedRules = true;
      rule.renderable = nativeRule;
      return nativeRule;
    }
    /**
     * Delete a rule.
     */
    ;

    _proto.deleteRule = function deleteRule(cssRule) {
      var sheet = this.element.sheet;
      var index = this.indexOf(cssRule);
      if (index === -1) return false;
      sheet.deleteRule(index);
      return true;
    }
    /**
     * Get index of a CSS Rule.
     */
    ;

    _proto.indexOf = function indexOf(cssRule) {
      var cssRules = this.element.sheet.cssRules;

      for (var index = 0; index < cssRules.length; index++) {
        if (cssRule === cssRules[index]) return index;
      }

      return -1;
    }
    /**
     * Generate a new CSS rule and replace the existing one.
     *
     * Only used for some old browsers because they can't set a selector.
     */
    ;

    _proto.replaceRule = function replaceRule(cssRule, rule) {
      var index = this.indexOf(cssRule);
      if (index === -1) return false;
      this.element.sheet.deleteRule(index);
      return this.insertRule(rule, index);
    }
    /**
     * Get all rules elements.
     */
    ;

    _proto.getRules = function getRules() {
      return this.element.sheet.cssRules;
    };

    return DomRenderer;
  }();

  var instanceCounter = 0;

  var Jss =
  /*#__PURE__*/
  function () {
    function Jss(options) {
      this.id = instanceCounter++;
      this.version = "10.0.0";
      this.plugins = new PluginsRegistry();
      this.options = {
        id: {
          minify: false
        },
        createGenerateId: createGenerateId,
        Renderer: isBrowser ? DomRenderer : null,
        plugins: []
      };
      this.generateId = createGenerateId({
        minify: false
      });

      for (var i = 0; i < plugins.length; i++) {
        this.plugins.use(plugins[i], {
          queue: 'internal'
        });
      }

      this.setup(options);
    }
    /**
     * Prepares various options, applies plugins.
     * Should not be used twice on the same instance, because there is no plugins
     * deduplication logic.
     */


    var _proto = Jss.prototype;

    _proto.setup = function setup(options) {
      if (options === void 0) {
        options = {};
      }

      if (options.createGenerateId) {
        this.options.createGenerateId = options.createGenerateId;
      }

      if (options.id) {
        this.options.id = _extends({}, this.options.id, options.id);
      }

      if (options.createGenerateId || options.id) {
        this.generateId = this.options.createGenerateId(this.options.id);
      }

      if (options.insertionPoint != null) this.options.insertionPoint = options.insertionPoint;

      if ('Renderer' in options) {
        this.options.Renderer = options.Renderer;
      } // eslint-disable-next-line prefer-spread


      if (options.plugins) this.use.apply(this, options.plugins);
      return this;
    }
    /**
     * Create a Style Sheet.
     */
    ;

    _proto.createStyleSheet = function createStyleSheet(styles, options) {
      if (options === void 0) {
        options = {};
      }

      var _options = options,
          index = _options.index;

      if (typeof index !== 'number') {
        index = sheets.index === 0 ? 0 : sheets.index + 1;
      }

      var sheet = new StyleSheet(styles, _extends({}, options, {
        jss: this,
        generateId: options.generateId || this.generateId,
        insertionPoint: this.options.insertionPoint,
        Renderer: this.options.Renderer,
        index: index
      }));
      this.plugins.onProcessSheet(sheet);
      return sheet;
    }
    /**
     * Detach the Style Sheet and remove it from the registry.
     */
    ;

    _proto.removeStyleSheet = function removeStyleSheet(sheet) {
      sheet.detach();
      sheets.remove(sheet);
      return this;
    }
    /**
     * Create a rule without a Style Sheet.
     */
    ;

    _proto.createRule = function createRule$$1(name, style, options) {
      if (style === void 0) {
        style = {};
      }

      if (options === void 0) {
        options = {};
      }

      // Enable rule without name for inline styles.
      if (typeof name === 'object') {
        return this.createRule(undefined, name, style);
      }

      var ruleOptions = _extends({}, options, {
        jss: this,
        Renderer: this.options.Renderer
      });

      if (!ruleOptions.generateId) ruleOptions.generateId = this.generateId;
      if (!ruleOptions.classes) ruleOptions.classes = {};
      if (!ruleOptions.keyframes) ruleOptions.keyframes = {};

      var rule = createRule(name, style, ruleOptions);

      if (rule) this.plugins.onProcessRule(rule);
      return rule;
    }
    /**
     * Register plugin. Passed function will be invoked with a rule instance.
     */
    ;

    _proto.use = function use() {
      var _this = this;

      for (var _len = arguments.length, plugins$$1 = new Array(_len), _key = 0; _key < _len; _key++) {
        plugins$$1[_key] = arguments[_key];
      }

      plugins$$1.forEach(function (plugin) {
        _this.plugins.use(plugin);
      });
      return this;
    };

    return Jss;
  }();

  /**
   * Extracts a styles object with only props that contain function values.
   */
  function getDynamicStyles(styles) {
    var to = null;

    for (var key in styles) {
      var value = styles[key];
      var type = typeof value;

      if (type === 'function') {
        if (!to) to = {};
        to[key] = value;
      } else if (type === 'object' && value !== null && !Array.isArray(value)) {
        var extracted = getDynamicStyles(value);

        if (extracted) {
          if (!to) to = {};
          to[key] = extracted;
        }
      }
    }

    return to;
  }

  /**
   * A better abstraction over CSS.
   *
   * @copyright Oleg Isonen (Slobodskoi) / Isonen 2014-present
   * @website https://github.com/cssinjs/jss
   * @license MIT
   */

  /**
   * Export a constant indicating if this browser has CSSTOM support.
   * https://developers.google.com/web/updates/2018/03/cssom
   */
  var hasCSSTOMSupport = typeof CSS !== 'undefined' && CSS && 'number' in CSS;
  /**
   * Creates a new instance of Jss.
   */

  var create = function create(options) {
    return new Jss(options);
  };
  /**
   * A global Jss instance.
   */

  var index$1 = create();

  var now = Date.now();
  var fnValuesNs = "fnValues" + now;
  var fnRuleNs = "fnStyle" + ++now;
  function functionPlugin() {
    return {
      onCreateRule: function onCreateRule(name, decl, options) {
        if (typeof decl !== 'function') return null;
        var rule = createRule(name, {}, options);
        rule[fnRuleNs] = decl;
        return rule;
      },
      onProcessStyle: function onProcessStyle(style, rule) {
        // We need to extract function values from the declaration, so that we can keep core unaware of them.
        // We need to do that only once.
        // We don't need to extract functions on each style update, since this can happen only once.
        // We don't support function values inside of function rules.
        if (fnValuesNs in rule || fnRuleNs in rule) return style;
        var fnValues = {};

        for (var prop in style) {
          var value = style[prop];
          if (typeof value !== 'function') continue;
          delete style[prop];
          fnValues[prop] = value;
        } // $FlowFixMe


        rule[fnValuesNs] = fnValues;
        return style;
      },
      onUpdate: function onUpdate(data, rule, sheet, options) {
        var styleRule = rule;
        var fnRule = styleRule[fnRuleNs]; // If we have a style function, the entire rule is dynamic and style object
        // will be returned from that function.

        if (fnRule) {
          // Empty object will remove all currently defined props
          // in case function rule returns a falsy value.
          styleRule.style = fnRule(data) || {};
        }

        var fnValues = styleRule[fnValuesNs]; // If we have a fn values map, it is a rule with function values.

        if (fnValues) {
          for (var prop in fnValues) {
            styleRule.prop(prop, fnValues[prop](data), options);
          }
        }
      }
    };
  }

  var at = '@global';
  var atPrefix = '@global ';

  var GlobalContainerRule =
  /*#__PURE__*/
  function () {
    function GlobalContainerRule(key, styles, options) {
      this.type = 'global';
      this.at = at;
      this.rules = void 0;
      this.options = void 0;
      this.key = void 0;
      this.isProcessed = false;
      this.key = key;
      this.options = options;
      this.rules = new RuleList(_extends({}, options, {
        parent: this
      }));

      for (var selector in styles) {
        this.rules.add(selector, styles[selector]);
      }

      this.rules.process();
    }
    /**
     * Get a rule.
     */


    var _proto = GlobalContainerRule.prototype;

    _proto.getRule = function getRule(name) {
      return this.rules.get(name);
    }
    /**
     * Create and register rule, run plugins.
     */
    ;

    _proto.addRule = function addRule(name, style, options) {
      var rule = this.rules.add(name, style, options);
      this.options.jss.plugins.onProcessRule(rule);
      return rule;
    }
    /**
     * Get index of a rule.
     */
    ;

    _proto.indexOf = function indexOf(rule) {
      return this.rules.indexOf(rule);
    }
    /**
     * Generates a CSS string.
     */
    ;

    _proto.toString = function toString() {
      return this.rules.toString();
    };

    return GlobalContainerRule;
  }();

  var GlobalPrefixedRule =
  /*#__PURE__*/
  function () {
    function GlobalPrefixedRule(key, style, options) {
      this.type = 'global';
      this.at = at;
      this.options = void 0;
      this.rule = void 0;
      this.isProcessed = false;
      this.key = void 0;
      this.key = key;
      this.options = options;
      var selector = key.substr(atPrefix.length);
      this.rule = options.jss.createRule(selector, style, _extends({}, options, {
        parent: this
      }));
    }

    var _proto2 = GlobalPrefixedRule.prototype;

    _proto2.toString = function toString(options) {
      return this.rule ? this.rule.toString(options) : '';
    };

    return GlobalPrefixedRule;
  }();

  var separatorRegExp = /\s*,\s*/g;

  function addScope(selector, scope) {
    var parts = selector.split(separatorRegExp);
    var scoped = '';

    for (var i = 0; i < parts.length; i++) {
      scoped += scope + " " + parts[i].trim();
      if (parts[i + 1]) scoped += ', ';
    }

    return scoped;
  }

  function handleNestedGlobalContainerRule(rule) {
    var options = rule.options,
        style = rule.style;
    var rules = style ? style[at] : null;
    if (!rules) return;

    for (var name in rules) {
      options.sheet.addRule(name, rules[name], _extends({}, options, {
        selector: addScope(name, rule.selector)
      }));
    }

    delete style[at];
  }

  function handlePrefixedGlobalRule(rule) {
    var options = rule.options,
        style = rule.style;

    for (var prop in style) {
      if (prop[0] !== '@' || prop.substr(0, at.length) !== at) continue;
      var selector = addScope(prop.substr(at.length), rule.selector);
      options.sheet.addRule(selector, style[prop], _extends({}, options, {
        selector: selector
      }));
      delete style[prop];
    }
  }
  /**
   * Convert nested rules to separate, remove them from original styles.
   *
   * @param {Rule} rule
   * @api public
   */


  function jssGlobal() {
    function onCreateRule(name, styles, options) {
      if (!name) return null;

      if (name === at) {
        return new GlobalContainerRule(name, styles, options);
      }

      if (name[0] === '@' && name.substr(0, atPrefix.length) === atPrefix) {
        return new GlobalPrefixedRule(name, styles, options);
      }

      var parent = options.parent;

      if (parent) {
        if (parent.type === 'global' || parent.options.parent && parent.options.parent.type === 'global') {
          options.scoped = false;
        }
      }

      if (options.scoped === false) {
        options.selector = name;
      }

      return null;
    }

    function onProcessRule(rule) {
      if (rule.type !== 'style') return;
      handleNestedGlobalContainerRule(rule);
      handlePrefixedGlobalRule(rule);
    }

    return {
      onCreateRule: onCreateRule,
      onProcessRule: onProcessRule
    };
  }

  var separatorRegExp$1 = /\s*,\s*/g;
  var parentRegExp = /&/g;
  var refRegExp$1 = /\$([\w-]+)/g;
  /**
   * Convert nested rules to separate, remove them from original styles.
   *
   * @param {Rule} rule
   * @api public
   */

  function jssNested() {
    // Get a function to be used for $ref replacement.
    function getReplaceRef(container, sheet) {
      return function (match, key) {
        var rule = container.getRule(key) || sheet && sheet.getRule(key);

        if (rule) {
          rule = rule;
          return rule.selector;
        }

         warning(false, "[JSS] Could not find the referenced rule \"" + key + "\" in \"" + (container.options.meta || container.toString()) + "\".") ;
        return key;
      };
    }

    function replaceParentRefs(nestedProp, parentProp) {
      var parentSelectors = parentProp.split(separatorRegExp$1);
      var nestedSelectors = nestedProp.split(separatorRegExp$1);
      var result = '';

      for (var i = 0; i < parentSelectors.length; i++) {
        var parent = parentSelectors[i];

        for (var j = 0; j < nestedSelectors.length; j++) {
          var nested = nestedSelectors[j];
          if (result) result += ', '; // Replace all & by the parent or prefix & with the parent.

          result += nested.indexOf('&') !== -1 ? nested.replace(parentRegExp, parent) : parent + " " + nested;
        }
      }

      return result;
    }

    function getOptions(rule, container, options) {
      // Options has been already created, now we only increase index.
      if (options) return _extends({}, options, {
        index: options.index + 1
      });
      var nestingLevel = rule.options.nestingLevel;
      nestingLevel = nestingLevel === undefined ? 1 : nestingLevel + 1;
      return _extends({}, rule.options, {
        nestingLevel: nestingLevel,
        index: container.indexOf(rule) + 1
      });
    }

    function onProcessStyle(style, rule, sheet) {
      if (rule.type !== 'style') return style;
      var styleRule = rule;
      var container = styleRule.options.parent;
      var options;
      var replaceRef;

      for (var prop in style) {
        var isNested = prop.indexOf('&') !== -1;
        var isNestedConditional = prop[0] === '@';
        if (!isNested && !isNestedConditional) continue;
        options = getOptions(styleRule, container, options);

        if (isNested) {
          var selector = replaceParentRefs(prop, styleRule.selector); // Lazily create the ref replacer function just once for
          // all nested rules within the sheet.

          if (!replaceRef) replaceRef = getReplaceRef(container, sheet); // Replace all $refs.

          selector = selector.replace(refRegExp$1, replaceRef);
          container.addRule(selector, style[prop], _extends({}, options, {
            selector: selector
          }));
        } else if (isNestedConditional) {
          // Place conditional right after the parent rule to ensure right ordering.
          container.addRule(prop, {}, options) // Flow expects more options but they aren't required
          // And flow doesn't know this will always be a StyleRule which has the addRule method
          // $FlowFixMe
          .addRule(styleRule.key, style[prop], {
            selector: styleRule.selector
          });
        }

        delete style[prop];
      }

      return style;
    }

    return {
      onProcessStyle: onProcessStyle
    };
  }

  /* eslint-disable no-var, prefer-template */
  var uppercasePattern = /[A-Z]/g;
  var msPattern = /^ms-/;
  var cache = {};

  function toHyphenLower(match) {
    return '-' + match.toLowerCase()
  }

  function hyphenateStyleName(name) {
    if (cache.hasOwnProperty(name)) {
      return cache[name]
    }

    var hName = name.replace(uppercasePattern, toHyphenLower);
    return (cache[name] = msPattern.test(hName) ? '-' + hName : hName)
  }

  /**
   * Convert camel cased property names to dash separated.
   *
   * @param {Object} style
   * @return {Object}
   */

  function convertCase(style) {
    var converted = {};

    for (var prop in style) {
      var key = prop.indexOf('--') === 0 ? prop : hyphenateStyleName(prop);
      converted[key] = style[prop];
    }

    if (style.fallbacks) {
      if (Array.isArray(style.fallbacks)) converted.fallbacks = style.fallbacks.map(convertCase);else converted.fallbacks = convertCase(style.fallbacks);
    }

    return converted;
  }
  /**
   * Allow camel cased property names by converting them back to dasherized.
   *
   * @param {Rule} rule
   */


  function camelCase() {
    function onProcessStyle(style) {
      if (Array.isArray(style)) {
        // Handle rules like @font-face, which can have multiple styles in an array
        for (var index = 0; index < style.length; index++) {
          style[index] = convertCase(style[index]);
        }

        return style;
      }

      return convertCase(style);
    }

    function onChangeValue(value, prop, rule) {
      if (prop.indexOf('--') === 0) {
        return value;
      }

      var hyphenatedProp = hyphenateStyleName(prop); // There was no camel case in place

      if (prop === hyphenatedProp) return value;
      rule.prop(hyphenatedProp, value); // Core will ignore that property value we set the proper one above.

      return null;
    }

    return {
      onProcessStyle: onProcessStyle,
      onChangeValue: onChangeValue
    };
  }

  var px = hasCSSTOMSupport && CSS ? CSS.px : 'px';
  var ms = hasCSSTOMSupport && CSS ? CSS.ms : 'ms';
  var percent = hasCSSTOMSupport && CSS ? CSS.percent : '%';
  /**
   * Generated jss-plugin-default-unit CSS property units
   *
   * @type object
   */

  var defaultUnits = {
    // Animation properties
    'animation-delay': ms,
    'animation-duration': ms,
    // Background properties
    'background-position': px,
    'background-position-x': px,
    'background-position-y': px,
    'background-size': px,
    // Border Properties
    border: px,
    'border-bottom': px,
    'border-bottom-left-radius': px,
    'border-bottom-right-radius': px,
    'border-bottom-width': px,
    'border-left': px,
    'border-left-width': px,
    'border-radius': px,
    'border-right': px,
    'border-right-width': px,
    'border-top': px,
    'border-top-left-radius': px,
    'border-top-right-radius': px,
    'border-top-width': px,
    'border-width': px,
    // Margin properties
    margin: px,
    'margin-bottom': px,
    'margin-left': px,
    'margin-right': px,
    'margin-top': px,
    // Padding properties
    padding: px,
    'padding-bottom': px,
    'padding-left': px,
    'padding-right': px,
    'padding-top': px,
    // Mask properties
    'mask-position-x': px,
    'mask-position-y': px,
    'mask-size': px,
    // Width and height properties
    height: px,
    width: px,
    'min-height': px,
    'max-height': px,
    'min-width': px,
    'max-width': px,
    // Position properties
    bottom: px,
    left: px,
    top: px,
    right: px,
    // Shadow properties
    'box-shadow': px,
    'text-shadow': px,
    // Column properties
    'column-gap': px,
    'column-rule': px,
    'column-rule-width': px,
    'column-width': px,
    // Font and text properties
    'font-size': px,
    'font-size-delta': px,
    'letter-spacing': px,
    'text-indent': px,
    'text-stroke': px,
    'text-stroke-width': px,
    'word-spacing': px,
    // Motion properties
    motion: px,
    'motion-offset': px,
    // Outline properties
    outline: px,
    'outline-offset': px,
    'outline-width': px,
    // Perspective properties
    perspective: px,
    'perspective-origin-x': percent,
    'perspective-origin-y': percent,
    // Transform properties
    'transform-origin': percent,
    'transform-origin-x': percent,
    'transform-origin-y': percent,
    'transform-origin-z': percent,
    // Transition properties
    'transition-delay': ms,
    'transition-duration': ms,
    // Alignment properties
    'vertical-align': px,
    'flex-basis': px,
    // Some random properties
    'shape-margin': px,
    size: px,
    // Grid properties
    grid: px,
    'grid-gap': px,
    'grid-row-gap': px,
    'grid-column-gap': px,
    'grid-template-rows': px,
    'grid-template-columns': px,
    'grid-auto-rows': px,
    'grid-auto-columns': px,
    // Not existing properties.
    // Used to avoid issues with jss-plugin-expand integration.
    'box-shadow-x': px,
    'box-shadow-y': px,
    'box-shadow-blur': px,
    'box-shadow-spread': px,
    'font-line-height': px,
    'text-shadow-x': px,
    'text-shadow-y': px,
    'text-shadow-blur': px
  };

  /**
   * Clones the object and adds a camel cased property version.
   */
  function addCamelCasedVersion(obj) {
    var regExp = /(-[a-z])/g;

    var replace = function replace(str) {
      return str[1].toUpperCase();
    };

    var newObj = {};

    for (var _key in obj) {
      newObj[_key] = obj[_key];
      newObj[_key.replace(regExp, replace)] = obj[_key];
    }

    return newObj;
  }

  var units = addCamelCasedVersion(defaultUnits);
  /**
   * Recursive deep style passing function
   */

  function iterate(prop, value, options) {
    if (!value) return value;

    if (Array.isArray(value)) {
      for (var i = 0; i < value.length; i++) {
        value[i] = iterate(prop, value[i], options);
      }
    } else if (typeof value === 'object') {
      if (prop === 'fallbacks') {
        for (var innerProp in value) {
          value[innerProp] = iterate(innerProp, value[innerProp], options);
        }
      } else {
        for (var _innerProp in value) {
          value[_innerProp] = iterate(prop + "-" + _innerProp, value[_innerProp], options);
        }
      }
    } else if (typeof value === 'number') {
      if (options[prop]) {
        return "" + value + options[prop];
      }

      if (units[prop]) {
        return typeof units[prop] === 'function' ? units[prop](value).toString() : "" + value + units[prop];
      }

      return value.toString();
    }

    return value;
  }
  /**
   * Add unit to numeric values.
   */


  function defaultUnit(options) {
    if (options === void 0) {
      options = {};
    }

    var camelCasedOptions = addCamelCasedVersion(options);

    function onProcessStyle(style, rule) {
      if (rule.type !== 'style') return style;

      for (var prop in style) {
        style[prop] = iterate(prop, style[prop], camelCasedOptions);
      }

      return style;
    }

    function onChangeValue(value, prop) {
      return iterate(prop, value, camelCasedOptions);
    }

    return {
      onProcessStyle: onProcessStyle,
      onChangeValue: onChangeValue
    };
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  // Export javascript style and css style vendor prefixes.
  var js = '';
  var css = '';
  var vendor = '';
  var browser = '';
  var isTouch = isBrowser && 'ontouchstart' in document.documentElement; // We should not do anything if required serverside.

  if (isBrowser) {
    // Order matters. We need to check Webkit the last one because
    // other vendors use to add Webkit prefixes to some properties
    var jsCssMap = {
      Moz: '-moz-',
      ms: '-ms-',
      O: '-o-',
      Webkit: '-webkit-'
    };

    var _document$createEleme = document.createElement('p'),
        style = _document$createEleme.style;

    var testProp = 'Transform';

    for (var key in jsCssMap) {
      if (key + testProp in style) {
        js = key;
        css = jsCssMap[key];
        break;
      }
    } // Correctly detect the Edge browser.


    if (js === 'Webkit' && 'msHyphens' in style) {
      js = 'ms';
      css = jsCssMap.ms;
      browser = 'edge';
    } // Correctly detect the Safari browser.


    if (js === 'Webkit' && '-apple-trailing-word' in style) {
      vendor = 'apple';
    }
  }
  /**
   * Vendor prefix string for the current browser.
   *
   * @type {{js: String, css: String, vendor: String, browser: String}}
   * @api public
   */


  var prefix = {
    js: js,
    css: css,
    vendor: vendor,
    browser: browser,
    isTouch: isTouch
  };

  /**
   * Test if a keyframe at-rule should be prefixed or not
   *
   * @param {String} vendor prefix string for the current browser.
   * @return {String}
   * @api public
   */

  function supportedKeyframes(key) {
    // Keyframes is already prefixed. e.g. key = '@-webkit-keyframes a'
    if (key[1] === '-') return key; // No need to prefix IE/Edge. Older browsers will ignore unsupported rules.
    // https://caniuse.com/#search=keyframes

    if (prefix.js === 'ms') return key;
    return "@" + prefix.css + "keyframes" + key.substr(10);
  }

  // https://caniuse.com/#search=appearance

  var appearence = {
    noPrefill: ['appearance'],
    supportedProperty: function supportedProperty(prop) {
      if (prop !== 'appearance') return false;
      if (prefix.js === 'ms') return "-webkit-" + prop;
      return prefix.css + prop;
    }
  };

  var regExp = /[-\s]+(.)?/g;
  /**
   * Replaces the letter with the capital letter
   *
   * @param {String} match
   * @param {String} c
   * @return {String}
   * @api private
   */

  function toUpper(match, c) {
    return c ? c.toUpperCase() : '';
  }
  /**
   * Convert dash separated strings to camel-cased.
   *
   * @param {String} str
   * @return {String}
   * @api private
   */


  function camelize(str) {
    return str.replace(regExp, toUpper);
  }

  /**
   * Convert dash separated strings to pascal cased.
   *
   * @param {String} str
   * @return {String}
   * @api private
   */

  function pascalize(str) {
    return camelize("-" + str);
  }

  // https://caniuse.com/#search=multicolumn
  // https://github.com/postcss/autoprefixer/issues/491
  // https://github.com/postcss/autoprefixer/issues/177

  var breakPropsOld = {
    supportedProperty: function supportedProperty(prop, style) {
      if (!/^break-/.test(prop)) return false;

      if (prefix.js === 'Webkit') {
        var jsProp = "WebkitColumn" + pascalize(prop);
        return jsProp in style ? prefix.css + "column-" + prop : false;
      }

      if (prefix.js === 'Moz') {
        var _jsProp = "page" + pascalize(prop);

        return _jsProp in style ? "page-" + prop : false;
      }

      return false;
    }
  };

  // https://caniuse.com/#search=color-adjust

  var colorAdjust = {
    noPrefill: ['color-adjust'],
    supportedProperty: function supportedProperty(prop) {
      if (prop !== 'color-adjust') return false;
      if (prefix.js === 'Webkit') return prefix.css + "print-" + prop;
      return prop;
    }
  };

  var propMap = {
    flex: 'box-flex',
    'flex-grow': 'box-flex',
    'flex-direction': ['box-orient', 'box-direction'],
    order: 'box-ordinal-group',
    'align-items': 'box-align',
    'flex-flow': ['box-orient', 'box-direction'],
    'justify-content': 'box-pack'
  };
  var propKeys = Object.keys(propMap);

  var prefixCss = function prefixCss(p) {
    return prefix.css + p;
  }; // Support old flex spec from 2009.


  var flex2009 = {
    supportedProperty: function supportedProperty(prop, style, _ref) {
      var multiple = _ref.multiple;

      if (propKeys.indexOf(prop) > -1) {
        var newProp = propMap[prop];

        if (!Array.isArray(newProp)) {
          return prefix.js + pascalize(newProp) in style ? prefix.css + newProp : false;
        }

        if (!multiple) return false;

        for (var i = 0; i < newProp.length; i++) {
          if (!(prefix.js + pascalize(newProp[0]) in style)) {
            return false;
          }
        }

        return newProp.map(prefixCss);
      }

      return false;
    }
  };

  var propMap$1 = {
    'flex-grow': 'flex-positive',
    'flex-shrink': 'flex-negative',
    'flex-basis': 'flex-preferred-size',
    'justify-content': 'flex-pack',
    order: 'flex-order',
    'align-items': 'flex-align',
    'align-content': 'flex-line-pack' // 'align-self' is handled by 'align-self' plugin.
    // Support old flex spec from 2012.

  };
  var flex2012 = {
    supportedProperty: function supportedProperty(prop, style) {
      var newProp = propMap$1[prop];
      if (!newProp) return false;
      return prefix.js + pascalize(newProp) in style ? prefix.css + newProp : false;
    }
  };

  // See https://github.com/postcss/autoprefixer/issues/324.

  var inlineLogicalOld = {
    supportedProperty: function supportedProperty(prop, style) {
      if (!/^(border|margin|padding)-inline/.test(prop)) return false;
      if (prefix.js === 'Moz') return prop;
      var newProp = prop.replace('-inline', '');
      return prefix.js + pascalize(newProp) in style ? prefix.css + newProp : false;
    }
  };

  // but we can use a longhand property instead.
  // https://caniuse.com/#search=mask

  var mask = {
    noPrefill: ['mask'],
    supportedProperty: function supportedProperty(prop, style) {
      if (!/^mask/.test(prop)) return false;

      if (prefix.js === 'Webkit') {
        var longhand = 'mask-image';

        if (camelize(longhand) in style) {
          return prop;
        }

        if (prefix.js + pascalize(longhand) in style) {
          return prefix.css + prop;
        }
      }

      return prop;
    }
  };

  // https://caniuse.com/#search=overscroll-behavior

  var overscrollBehavior = {
    supportedProperty: function supportedProperty(prop) {
      if (prop !== 'overscroll-behavior') return false;

      if (prefix.js === 'ms') {
        return prefix.css + "scroll-chaining";
      }

      return prop;
    }
  };

  var prefixed = {
    supportedProperty: function supportedProperty(prop, style) {
      var pascalized = pascalize(prop); // Return custom CSS variable without prefixing.

      if (prop[0] === '-') return prop; // Return already prefixed value without prefixing.

      if (prop[0] === '-' && prop[1] === '-') return prop;
      if (prefix.js + pascalized in style) return prefix.css + prop; // Try webkit fallback.

      if (prefix.js !== 'Webkit' && "Webkit" + pascalized in style) return "-webkit-" + prop;
      return false;
    }
  };

  // https://caniuse.com/#search=scroll-snap

  var scrollSnap = {
    supportedProperty: function supportedProperty(prop) {
      if (prop.substring(0, 11) !== 'scroll-snap') return false;

      if (prefix.js === 'ms') {
        return "" + prefix.css + prop;
      }

      return prop;
    }
  };

  // https://caniuse.com/#search=text-orientation

  var textOrientation = {
    noPrefill: ['text-orientation'],
    supportedProperty: function supportedProperty(prop) {
      if (prop !== 'text-orientation') return false;

      if (prefix.vendor === 'apple' && !prefix.isTouch) {
        return prefix.css + prop;
      }

      return prop;
    }
  };

  // https://caniuse.com/#search=transform

  var transform = {
    noPrefill: ['transform'],
    supportedProperty: function supportedProperty(prop, style, options) {
      if (prop !== 'transform') return false;

      if (options.transform) {
        return prop;
      }

      return prefix.css + prop;
    }
  };

  // https://caniuse.com/#search=transition

  var transition = {
    noPrefill: ['transition'],
    supportedProperty: function supportedProperty(prop, style, options) {
      if (prop !== 'transition') return false;

      if (options.transition) {
        return prop;
      }

      return prefix.css + prop;
    }
  };

  // Camelization is required because we can't test using.
  // CSS syntax for e.g. in FF.

  var unprefixed = {
    supportedProperty: function supportedProperty(prop, style) {
      return camelize(prop) in style ? prop : false;
    }
  };

  // https://caniuse.com/#search=writing-mode

  var writingMode = {
    noPrefill: ['writing-mode'],
    supportedProperty: function supportedProperty(prop) {
      if (prop !== 'writing-mode') return false;

      if (prefix.js === 'Webkit' || prefix.js === 'ms') {
        return prefix.css + prop;
      }

      return prop;
    }
  };

  // plugins = [
  //   ...plugins,
  //    breakPropsOld,
  //    inlineLogicalOld,
  //    unprefixed,
  //    prefixed,
  //    scrollSnap,
  //    flex2012,
  //    flex2009
  // ]
  // Plugins without 'noPrefill' value, going last.
  // 'flex-*' plugins should be at the bottom.
  // 'flex2009' going after 'flex2012'.
  // 'prefixed' going after 'unprefixed'

  var plugins$1 = [appearence, colorAdjust, mask, textOrientation, transform, transition, writingMode, breakPropsOld, inlineLogicalOld, unprefixed, prefixed, scrollSnap, overscrollBehavior, flex2012, flex2009];
  var propertyDetectors = plugins$1.filter(function (p) {
    return p.supportedProperty;
  }).map(function (p) {
    return p.supportedProperty;
  });
  var noPrefill = plugins$1.filter(function (p) {
    return p.noPrefill;
  }).reduce(function (a, p) {
    a.push.apply(a, _toConsumableArray(p.noPrefill));
    return a;
  }, []);

  var el;
  var cache$1 = {};

  if (isBrowser) {
    el = document.createElement('p'); // We test every property on vendor prefix requirement.
    // Once tested, result is cached. It gives us up to 70% perf boost.
    // http://jsperf.com/element-style-object-access-vs-plain-object
    //
    // Prefill cache with known css properties to reduce amount of
    // properties we need to feature test at runtime.
    // http://davidwalsh.name/vendor-prefix

    var computed = window.getComputedStyle(document.documentElement, '');

    for (var key$1 in computed) {
      // eslint-disable-next-line no-restricted-globals
      if (!isNaN(key$1)) cache$1[computed[key$1]] = computed[key$1];
    } // Properties that cannot be correctly detected using the
    // cache prefill method.


    noPrefill.forEach(function (x) {
      return delete cache$1[x];
    });
  }
  /**
   * Test if a property is supported, returns supported property with vendor
   * prefix if required. Returns `false` if not supported.
   *
   * @param {String} prop dash separated
   * @param {Object} [options]
   * @return {String|Boolean}
   * @api public
   */


  function supportedProperty(prop, options) {
    if (options === void 0) {
      options = {};
    }

    // For server-side rendering.
    if (!el) return prop; // Remove cache for benchmark tests or return property from the cache.

    if ( cache$1[prop] != null) {
      return cache$1[prop];
    } // Check if 'transition' or 'transform' natively supported in browser.


    if (prop === 'transition' || prop === 'transform') {
      options[prop] = prop in el.style;
    } // Find a plugin for current prefix property.


    for (var i = 0; i < propertyDetectors.length; i++) {
      cache$1[prop] = propertyDetectors[i](prop, el.style, options); // Break loop, if value found.

      if (cache$1[prop]) break;
    } // Reset styles for current property.
    // Firefox can even throw an error for invalid properties, e.g., "0".


    try {
      el.style[prop] = '';
    } catch (err) {
      return false;
    }

    return cache$1[prop];
  }

  var cache$1$1 = {};
  var transitionProperties = {
    transition: 1,
    'transition-property': 1,
    '-webkit-transition': 1,
    '-webkit-transition-property': 1
  };
  var transPropsRegExp = /(^\s*[\w-]+)|, (\s*[\w-]+)(?![^()]*\))/g;
  var el$1;
  /**
   * Returns prefixed value transition/transform if needed.
   *
   * @param {String} match
   * @param {String} p1
   * @param {String} p2
   * @return {String}
   * @api private
   */

  function prefixTransitionCallback(match, p1, p2) {
    if (p1 === 'var') return 'var';
    if (p1 === 'all') return 'all';
    if (p2 === 'all') return ', all';
    return p1 ? supportedProperty(p1) : ", " + supportedProperty(p2);
  }

  if (isBrowser) el$1 = document.createElement('p');
  /**
   * Returns prefixed value if needed. Returns `false` if value is not supported.
   *
   * @param {String} property
   * @param {String} value
   * @return {String|Boolean}
   * @api public
   */

  function supportedValue(property, value) {
    // For server-side rendering.
    var prefixedValue = value;
    if (!el$1 || property === 'content') return value; // It is a string or a number as a string like '1'.
    // We want only prefixable values here.
    // eslint-disable-next-line no-restricted-globals

    if (typeof prefixedValue !== 'string' || !isNaN(parseInt(prefixedValue, 10))) {
      return prefixedValue;
    } // Create cache key for current value.


    var cacheKey = property + prefixedValue; // Remove cache for benchmark tests or return value from cache.

    if ( cache$1$1[cacheKey] != null) {
      return cache$1$1[cacheKey];
    } // IE can even throw an error in some cases, for e.g. style.content = 'bar'.


    try {
      // Test value as it is.
      el$1.style[property] = prefixedValue;
    } catch (err) {
      // Return false if value not supported.
      cache$1$1[cacheKey] = false;
      return false;
    } // If 'transition' or 'transition-property' property.


    if (transitionProperties[property]) {
      prefixedValue = prefixedValue.replace(transPropsRegExp, prefixTransitionCallback);
    } else if (el$1.style[property] === '') {
      // Value with a vendor prefix.
      prefixedValue = prefix.css + prefixedValue; // Hardcode test to convert "flex" to "-ms-flexbox" for IE10.

      if (prefixedValue === '-ms-flex') el$1.style[property] = '-ms-flexbox'; // Test prefixed value.

      el$1.style[property] = prefixedValue; // Return false if value not supported.

      if (el$1.style[property] === '') {
        cache$1$1[cacheKey] = false;
        return false;
      }
    } // Reset styles for current property.


    el$1.style[property] = ''; // Write current value to cache.

    cache$1$1[cacheKey] = prefixedValue;
    return cache$1$1[cacheKey];
  }

  /**
   * Add vendor prefix to a property name when needed.
   *
   * @api public
   */

  function jssVendorPrefixer() {
    function onProcessRule(rule) {
      if (rule.type === 'keyframes') {
        var atRule = rule;
        atRule.at = supportedKeyframes(atRule.at);
      }
    }

    function prefixStyle(style) {
      for (var prop in style) {
        var value = style[prop];

        if (prop === 'fallbacks' && Array.isArray(value)) {
          style[prop] = value.map(prefixStyle);
          continue;
        }

        var changeProp = false;
        var supportedProp = supportedProperty(prop);
        if (supportedProp && supportedProp !== prop) changeProp = true;
        var changeValue = false;
        var supportedValue$$1 = supportedValue(supportedProp, toCssValue(value));
        if (supportedValue$$1 && supportedValue$$1 !== value) changeValue = true;

        if (changeProp || changeValue) {
          if (changeProp) delete style[prop];
          style[supportedProp || prop] = supportedValue$$1 || value;
        }
      }

      return style;
    }

    function onProcessStyle(style, rule) {
      if (rule.type !== 'style') return style;
      return prefixStyle(style);
    }

    function onChangeValue(value, prop) {
      return supportedValue(prop, toCssValue(value)) || value;
    }

    return {
      onProcessRule: onProcessRule,
      onProcessStyle: onProcessStyle,
      onChangeValue: onChangeValue
    };
  }

  /**
   * Sort props by length.
   */
  function jssPropsSort() {
    var sort = function sort(prop0, prop1) {
      if (prop0.length === prop1.length) {
        return prop0 > prop1 ? 1 : -1;
      }

      return prop0.length - prop1.length;
    };

    return {
      onProcessStyle: function onProcessStyle(style, rule) {
        if (rule.type !== 'style') return style;
        var newStyle = {};
        var props = Object.keys(style).sort(sort);

        for (var i = 0; i < props.length; i++) {
          newStyle[props[i]] = style[props[i]];
        }

        return newStyle;
      }
    };
  }

  function jssPreset() {
    return {
      plugins: [functionPlugin(), jssGlobal(), jssNested(), camelCase(), defaultUnit(), // Disable the vendor prefixer server-side, it does nothing.
      // This way, we can get a performance boost.
      // In the documentation, we are using `autoprefixer` to solve this problem.
      typeof window === 'undefined' ? null : jssVendorPrefixer(), jssPropsSort()]
    };
  }

  function mergeClasses() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var baseClasses = options.baseClasses,
        newClasses = options.newClasses,
        Component = options.Component;

    if (!newClasses) {
      return baseClasses;
    }

    var nextClasses = _extends({}, baseClasses);

    {
      if (typeof newClasses === 'string') {
        console.error(["Material-UI: the value `".concat(newClasses, "` ") + "provided to the classes prop of ".concat(getDisplayName(Component), " is incorrect."), 'You might want to use the className prop instead.'].join('\n'));
        return baseClasses;
      }
    }

    Object.keys(newClasses).forEach(function (key) {
      {
        if (!baseClasses[key] && newClasses[key]) {
          console.error(["Material-UI: the key `".concat(key, "` ") + "provided to the classes prop is not implemented in ".concat(getDisplayName(Component), "."), "You can only override one of the following: ".concat(Object.keys(baseClasses).join(','), ".")].join('\n'));
        }

        if (newClasses[key] && typeof newClasses[key] !== 'string') {
          console.error(["Material-UI: the key `".concat(key, "` ") + "provided to the classes prop is not valid for ".concat(getDisplayName(Component), "."), "You need to provide a non empty string instead of: ".concat(newClasses[key], ".")].join('\n'));
        }
      }

      if (newClasses[key]) {
        nextClasses[key] = "".concat(baseClasses[key], " ").concat(newClasses[key]);
      }
    });
    return nextClasses;
  }

  // Used https://github.com/thinkloop/multi-key-cache as inspiration
  var multiKeyStore = {
    set: function set(cache, key1, key2, value) {
      var subCache = cache.get(key1);

      if (!subCache) {
        subCache = new Map();
        cache.set(key1, subCache);
      }

      subCache.set(key2, value);
    },
    get: function get(cache, key1, key2) {
      var subCache = cache.get(key1);
      return subCache ? subCache.get(key2) : undefined;
    },
    delete: function _delete(cache, key1, key2) {
      var subCache = cache.get(key1);
      subCache.delete(key2);
    }
  };

  var ThemeContext = React__default.createContext(null);

  function useTheme() {
    return React__default.useContext(ThemeContext);
  }

  var jss = create(jssPreset()); // Use a singleton or the provided one by the context.
  //
  // The counter-based approach doesn't tolerate any mistake.
  // It's much safer to use the same counter everywhere.

  var generateClassName = createGenerateClassName(); // Exported for test purposes

  var sheetsManager = new Map();
  var defaultOptions = {
    disableGeneration: false,
    generateClassName: generateClassName,
    jss: jss,
    sheetsCache: null,
    sheetsManager: sheetsManager,
    sheetsRegistry: null
  };
  var StylesContext = React__default.createContext(defaultOptions);
  var injectFirstNode;

  function StylesProvider(props) {
    var children = props.children,
        _props$injectFirst = props.injectFirst,
        injectFirst = _props$injectFirst === void 0 ? false : _props$injectFirst,
        _props$disableGenerat = props.disableGeneration,
        disableGeneration = _props$disableGenerat === void 0 ? false : _props$disableGenerat,
        localOptions = _objectWithoutProperties(props, ["children", "injectFirst", "disableGeneration"]);

    var outerOptions = React__default.useContext(StylesContext);

    var context = _extends({}, outerOptions, {
      disableGeneration: disableGeneration
    }, localOptions);

    {
      if (typeof window === 'undefined' && !context.sheetsManager) {
        console.error('Material-UI: you need to use the ServerStyleSheets API when rendering on the server.');
      }
    }

    {
      if (context.jss.options.insertionPoint && injectFirst) {
        console.error('Material-UI: you cannot use a custom insertionPoint and <StylesContext injectFirst> at the same time.');
      }
    }

    {
      if (injectFirst && localOptions.jss) {
        console.error('Material-UI: you cannot use the jss and injectFirst props at the same time.');
      }
    }

    if (!context.jss.options.insertionPoint && injectFirst && typeof window !== 'undefined') {
      if (!injectFirstNode) {
        var head = document.head;
        injectFirstNode = document.createComment('mui-inject-first');
        head.insertBefore(injectFirstNode, head.firstChild);
      }

      context.jss = create({
        plugins: jssPreset().plugins,
        insertionPoint: injectFirstNode
      });
    }

    return React__default.createElement(StylesContext.Provider, {
      value: context
    }, children);
  }

   StylesProvider.propTypes = {
    /**
     * Your component tree.
     */
    children: propTypes.node.isRequired,

    /**
     * You can disable the generation of the styles with this option.
     * It can be useful when traversing the React tree outside of the HTML
     * rendering step on the server.
     * Let's say you are using react-apollo to extract all
     * the queries made by the interface server-side - you can significantly speed up the traversal with this prop.
     */
    disableGeneration: propTypes.bool,

    /**
     * JSS's class name generator.
     */
    generateClassName: propTypes.func,

    /**
     * By default, the styles are injected last in the <head> element of the page.
     * As a result, they gain more specificity than any other style sheet.
     * If you want to override Material-UI's styles, set this prop.
     */
    injectFirst: propTypes.bool,

    /**
     * JSS's instance.
     */
    jss: propTypes.object,

    /**
     * @ignore
     */
    serverGenerateClassName: propTypes.func,

    /**
     * @ignore
     *
     * Beta feature.
     *
     * Cache for the sheets.
     */
    sheetsCache: propTypes.object,

    /**
     * @ignore
     *
     * The sheetsManager is used to deduplicate style sheet injection in the page.
     * It's deduplicating using the (theme, styles) couple.
     * On the server, you should provide a new instance for each request.
     */
    sheetsManager: propTypes.object,

    /**
     * @ignore
     *
     * Collect the sheets.
     */
    sheetsRegistry: propTypes.object
  } ;

  {
     StylesProvider.propTypes = exactProp(StylesProvider.propTypes) ;
  }

  /* eslint-disable import/prefer-default-export */
  // Global index counter to preserve source order.
  // We create the style sheet during at the creation of the component,
  // children are handled after the parents, so the order of style elements would be parent->child.
  // It is a problem though when a parent passes a className
  // which needs to override any child's styles.
  // StyleSheet of the child has a higher specificity, because of the source order.
  // So our solution is to render sheets them in the reverse order child->sheet, so
  // that parent has a higher specificity.
  var indexCounter = -1e9;
  function increment() {
    indexCounter += 1;

    {
      if (indexCounter >= 0) {
        console.warn(['Material-UI: you might have a memory leak.', 'The indexCounter is not supposed to grow that much.'].join('\n'));
      }
    }

    return indexCounter;
  }

  // We use the same empty object to ref count the styles that don't need a theme object.
  var noopTheme = {};

  function getStylesCreator(stylesOrCreator) {
    var themingEnabled = typeof stylesOrCreator === 'function';

    {
      if (_typeof(stylesOrCreator) !== 'object' && !themingEnabled) {
        console.error(['Material-UI: the `styles` argument provided is invalid.', 'You need to provide a function generating the styles or a styles object.'].join('\n'));
      }
    }

    return {
      create: function create(theme, name) {
        var styles;

        try {
          styles = themingEnabled ? stylesOrCreator(theme) : stylesOrCreator;
        } catch (err) {
          {
            if (themingEnabled === true && theme === noopTheme) {
              // TODO: prepend error message/name instead
              console.error(['Material-UI: the `styles` argument provided is invalid.', 'You are providing a function without a theme in the context.', 'One of the parent elements needs to use a ThemeProvider.'].join('\n'));
            }
          }

          throw err;
        }

        if (!name || !theme.overrides || !theme.overrides[name]) {
          return styles;
        }

        var overrides = theme.overrides[name];

        var stylesWithOverrides = _extends({}, styles);

        Object.keys(overrides).forEach(function (key) {
          {
            if (!stylesWithOverrides[key]) {
              console.warn(['Material-UI: you are trying to override a style that does not exist.', "Fix the `".concat(key, "` key of `theme.overrides.").concat(name, "`.")].join('\n'));
            }
          }

          stylesWithOverrides[key] = deepmerge(stylesWithOverrides[key], overrides[key]);
        });
        return stylesWithOverrides;
      },
      options: {}
    };
  }

  function getClasses(_ref, classes, Component) {
    var state = _ref.state,
        stylesOptions = _ref.stylesOptions;

    if (stylesOptions.disableGeneration) {
      return classes || {};
    }

    if (!state.cacheClasses) {
      state.cacheClasses = {
        // Cache for the finalized classes value.
        value: null,
        // Cache for the last used classes prop pointer.
        lastProp: null,
        // Cache for the last used rendered classes pointer.
        lastJSS: {}
      };
    } // Tracks if either the rendered classes or classes prop has changed,
    // requiring the generation of a new finalized classes object.


    var generate = false;

    if (state.classes !== state.cacheClasses.lastJSS) {
      state.cacheClasses.lastJSS = state.classes;
      generate = true;
    }

    if (classes !== state.cacheClasses.lastProp) {
      state.cacheClasses.lastProp = classes;
      generate = true;
    }

    if (generate) {
      state.cacheClasses.value = mergeClasses({
        baseClasses: state.cacheClasses.lastJSS,
        newClasses: classes,
        Component: Component
      });
    }

    return state.cacheClasses.value;
  }

  function attach(_ref2, props) {
    var state = _ref2.state,
        theme = _ref2.theme,
        stylesOptions = _ref2.stylesOptions,
        stylesCreator = _ref2.stylesCreator,
        name = _ref2.name;

    if (stylesOptions.disableGeneration) {
      return;
    }

    var sheetManager = multiKeyStore.get(stylesOptions.sheetsManager, stylesCreator, theme);

    if (!sheetManager) {
      sheetManager = {
        refs: 0,
        staticSheet: null,
        dynamicStyles: null
      };
      multiKeyStore.set(stylesOptions.sheetsManager, stylesCreator, theme, sheetManager);
    }

    var options = _extends({}, stylesCreator.options, {}, stylesOptions, {
      theme: theme,
      flip: typeof stylesOptions.flip === 'boolean' ? stylesOptions.flip : theme.direction === 'rtl'
    });

    options.generateId = options.serverGenerateClassName || options.generateClassName;
    var sheetsRegistry = stylesOptions.sheetsRegistry;

    if (sheetManager.refs === 0) {
      var staticSheet;

      if (stylesOptions.sheetsCache) {
        staticSheet = multiKeyStore.get(stylesOptions.sheetsCache, stylesCreator, theme);
      }

      var styles = stylesCreator.create(theme, name);

      if (!staticSheet) {
        staticSheet = stylesOptions.jss.createStyleSheet(styles, _extends({
          link: false
        }, options));
        staticSheet.attach();

        if (stylesOptions.sheetsCache) {
          multiKeyStore.set(stylesOptions.sheetsCache, stylesCreator, theme, staticSheet);
        }
      }

      if (sheetsRegistry) {
        sheetsRegistry.add(staticSheet);
      }

      sheetManager.staticSheet = staticSheet;
      sheetManager.dynamicStyles = getDynamicStyles(styles);
    }

    if (sheetManager.dynamicStyles) {
      var dynamicSheet = stylesOptions.jss.createStyleSheet(sheetManager.dynamicStyles, _extends({
        link: true
      }, options));
      dynamicSheet.update(props).attach();
      state.dynamicSheet = dynamicSheet;
      state.classes = mergeClasses({
        baseClasses: sheetManager.staticSheet.classes,
        newClasses: dynamicSheet.classes
      });

      if (sheetsRegistry) {
        sheetsRegistry.add(dynamicSheet);
      }
    } else {
      state.classes = sheetManager.staticSheet.classes;
    }

    sheetManager.refs += 1;
  }

  function update(_ref3, props) {
    var state = _ref3.state;

    if (state.dynamicSheet) {
      state.dynamicSheet.update(props);
    }
  }

  function detach(_ref4) {
    var state = _ref4.state,
        theme = _ref4.theme,
        stylesOptions = _ref4.stylesOptions,
        stylesCreator = _ref4.stylesCreator;

    if (stylesOptions.disableGeneration) {
      return;
    }

    var sheetManager = multiKeyStore.get(stylesOptions.sheetsManager, stylesCreator, theme);
    sheetManager.refs -= 1;
    var sheetsRegistry = stylesOptions.sheetsRegistry;

    if (sheetManager.refs === 0) {
      multiKeyStore.delete(stylesOptions.sheetsManager, stylesCreator, theme);
      stylesOptions.jss.removeStyleSheet(sheetManager.staticSheet);

      if (sheetsRegistry) {
        sheetsRegistry.remove(sheetManager.staticSheet);
      }
    }

    if (state.dynamicSheet) {
      stylesOptions.jss.removeStyleSheet(state.dynamicSheet);

      if (sheetsRegistry) {
        sheetsRegistry.remove(state.dynamicSheet);
      }
    }
  }

  function useSynchronousEffect(func, values) {
    var key = React__default.useRef([]);
    var output; // Store "generation" key. Just returns a new object every time

    var currentKey = React__default.useMemo(function () {
      return {};
    }, values); // eslint-disable-line react-hooks/exhaustive-deps
    // "the first render", or "memo dropped the value"

    if (key.current !== currentKey) {
      key.current = currentKey;
      output = func();
    }

    React__default.useEffect(function () {
      return function () {
        if (output) {
          output();
        }
      };
    }, [currentKey] // eslint-disable-line react-hooks/exhaustive-deps
    );
  }

  function makeStyles(stylesOrCreator) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var name = options.name,
        classNamePrefixOption = options.classNamePrefix,
        Component = options.Component,
        _options$defaultTheme = options.defaultTheme,
        defaultTheme = _options$defaultTheme === void 0 ? noopTheme : _options$defaultTheme,
        stylesOptions2 = _objectWithoutProperties(options, ["name", "classNamePrefix", "Component", "defaultTheme"]);

    var stylesCreator = getStylesCreator(stylesOrCreator);
    var classNamePrefix = name || classNamePrefixOption || 'makeStyles';
    stylesCreator.options = {
      index: increment(),
      name: name,
      meta: classNamePrefix,
      classNamePrefix: classNamePrefix
    };
    return function () {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var theme = useTheme() || defaultTheme;

      var stylesOptions = _extends({}, React__default.useContext(StylesContext), {}, stylesOptions2);

      var instance = React__default.useRef();
      var shouldUpdate = React__default.useRef();
      useSynchronousEffect(function () {
        var current = {
          name: name,
          state: {},
          stylesCreator: stylesCreator,
          stylesOptions: stylesOptions,
          theme: theme
        };
        attach(current, props);
        shouldUpdate.current = false;
        instance.current = current;
        return function () {
          detach(current);
        };
      }, [theme, stylesCreator]);
      React__default.useEffect(function () {
        if (shouldUpdate.current) {
          update(instance.current, props);
        }

        shouldUpdate.current = true;
      });
      return getClasses(instance.current, props.classes, Component);
    };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  var ServerStyleSheets =
  /*#__PURE__*/
  function () {
    function ServerStyleSheets() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _classCallCheck(this, ServerStyleSheets);

      this.options = options;
    }

    _createClass(ServerStyleSheets, [{
      key: "collect",
      value: function collect(children) {
        // This is needed in order to deduplicate the injection of CSS in the page.
        var sheetsManager = new Map(); // This is needed in order to inject the critical CSS.

        this.sheetsRegistry = new SheetsRegistry(); // A new class name generator

        var generateClassName = createGenerateClassName();
        return React__default.createElement(StylesProvider, _extends({
          sheetsManager: sheetsManager,
          serverGenerateClassName: generateClassName,
          sheetsRegistry: this.sheetsRegistry
        }, this.options), children);
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.sheetsRegistry ? this.sheetsRegistry.toString() : '';
      }
    }, {
      key: "getStyleElement",
      value: function getStyleElement(props) {
        return React__default.createElement('style', _extends({
          id: 'jss-server-side',
          key: 'jss-server-side',
          dangerouslySetInnerHTML: {
            __html: this.toString()
          }
        }, props));
      }
    }]);

    return ServerStyleSheets;
  }();

  function toVal(mix) {
  	var k, y, str='';
  	if (mix) {
  		if (typeof mix === 'object') {
  			if (!!mix.push) {
  				for (k=0; k < mix.length; k++) {
  					if (mix[k] && (y = toVal(mix[k]))) {
  						str && (str += ' ');
  						str += y;
  					}
  				}
  			} else {
  				for (k in mix) {
  					if (mix[k] && (y = toVal(k))) {
  						str && (str += ' ');
  						str += y;
  					}
  				}
  			}
  		} else if (typeof mix !== 'boolean' && !mix.call) {
  			str && (str += ' ');
  			str += mix;
  		}
  	}
  	return str;
  }

  function clsx () {
  	var i=0, x, str='';
  	while (i < arguments.length) {
  		if (x = toVal(arguments[i++])) {
  			str && (str += ' ');
  			str += x;
  		}
  	}
  	return str;
  }

  /**
   * Copyright 2015, Yahoo! Inc.
   * Copyrights licensed under the New BSD License. See the accompanying LICENSE file for terms.
   */

  var REACT_STATICS = {
      childContextTypes: true,
      contextType: true,
      contextTypes: true,
      defaultProps: true,
      displayName: true,
      getDefaultProps: true,
      getDerivedStateFromError: true,
      getDerivedStateFromProps: true,
      mixins: true,
      propTypes: true,
      type: true
  };

  var KNOWN_STATICS = {
      name: true,
      length: true,
      prototype: true,
      caller: true,
      callee: true,
      arguments: true,
      arity: true
  };

  var FORWARD_REF_STATICS = {
      '$$typeof': true,
      render: true,
      defaultProps: true,
      displayName: true,
      propTypes: true
  };

  var MEMO_STATICS = {
      '$$typeof': true,
      compare: true,
      defaultProps: true,
      displayName: true,
      propTypes: true,
      type: true
  };

  var TYPE_STATICS = {};
  TYPE_STATICS[reactIs.ForwardRef] = FORWARD_REF_STATICS;

  function getStatics(component) {
      if (reactIs.isMemo(component)) {
          return MEMO_STATICS;
      }
      return TYPE_STATICS[component['$$typeof']] || REACT_STATICS;
  }

  var defineProperty = Object.defineProperty;
  var getOwnPropertyNames = Object.getOwnPropertyNames;
  var getOwnPropertySymbols$1 = Object.getOwnPropertySymbols;
  var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
  var getPrototypeOf = Object.getPrototypeOf;
  var objectPrototype = Object.prototype;

  function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
      if (typeof sourceComponent !== 'string') {
          // don't hoist over string (html) components

          if (objectPrototype) {
              var inheritedComponent = getPrototypeOf(sourceComponent);
              if (inheritedComponent && inheritedComponent !== objectPrototype) {
                  hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
              }
          }

          var keys = getOwnPropertyNames(sourceComponent);

          if (getOwnPropertySymbols$1) {
              keys = keys.concat(getOwnPropertySymbols$1(sourceComponent));
          }

          var targetStatics = getStatics(targetComponent);
          var sourceStatics = getStatics(sourceComponent);

          for (var i = 0; i < keys.length; ++i) {
              var key = keys[i];
              if (!KNOWN_STATICS[key] && !(blacklist && blacklist[key]) && !(sourceStatics && sourceStatics[key]) && !(targetStatics && targetStatics[key])) {
                  var descriptor = getOwnPropertyDescriptor(sourceComponent, key);
                  try {
                      // Avoid failures from read-only properties
                      defineProperty(targetComponent, key, descriptor);
                  } catch (e) {}
              }
          }

          return targetComponent;
      }

      return targetComponent;
  }

  var hoistNonReactStatics_cjs = hoistNonReactStatics;

  function omit(input, fields) {
    var output = {};
    Object.keys(input).forEach(function (prop) {
      if (fields.indexOf(prop) === -1) {
        output[prop] = input[prop];
      }
    });
    return output;
  } // styled-components's API removes the mapping between components and styles.
  // Using components as a low-level styling construct can be simpler.


  function styled(Component) {
    var componentCreator = function componentCreator(style) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var name = options.name,
          stylesOptions = _objectWithoutProperties(options, ["name"]);

      if ( Component === undefined) {
        throw new Error(['You are calling styled(Component)(style) with an undefined component.', 'You may have forgotten to import it.'].join('\n'));
      }

      var classNamePrefix = name;

      {
        if (!name) {
          // Provide a better DX outside production.
          var displayName = getDisplayName(Component);

          if (displayName !== undefined) {
            classNamePrefix = displayName;
          }
        }
      }

      var stylesOrCreator = typeof style === 'function' ? function (theme) {
        return {
          root: function root(props) {
            return style(_extends({
              theme: theme
            }, props));
          }
        };
      } : {
        root: style
      };
      var useStyles = makeStyles(stylesOrCreator, _extends({
        Component: Component,
        name: name || Component.displayName,
        classNamePrefix: classNamePrefix
      }, stylesOptions));
      var filterProps;
      var propTypes$1 = {};

      if (style.filterProps) {
        filterProps = style.filterProps;
        delete style.filterProps;
      }
      /* eslint-disable react/forbid-foreign-prop-types */


      if (style.propTypes) {
        propTypes$1 = style.propTypes;
        delete style.propTypes;
      }
      /* eslint-enable react/forbid-foreign-prop-types */


      var StyledComponent = React__default.forwardRef(function StyledComponent(props, ref) {
        var children = props.children,
            classNameProp = props.className,
            clone = props.clone,
            ComponentProp = props.component,
            other = _objectWithoutProperties(props, ["children", "className", "clone", "component"]);

        var classes = useStyles(props);
        var className = clsx(classes.root, classNameProp);
        var spread = other;

        if (filterProps) {
          spread = omit(spread, filterProps);
        }

        if (clone) {
          return React__default.cloneElement(children, _extends({
            className: clsx(children.props.className, className)
          }, spread));
        }

        if (typeof children === 'function') {
          return children(_extends({
            className: className
          }, spread));
        }

        var FinalComponent = ComponentProp || Component;
        return React__default.createElement(FinalComponent, _extends({
          ref: ref,
          className: className
        }, spread), children);
      });
       StyledComponent.propTypes = _extends({
        /**
         * A render function or node.
         */
        children: propTypes.oneOfType([propTypes.node, propTypes.func]),

        /**
         * @ignore
         */
        className: propTypes.string,

        /**
         * If `true`, the component will recycle it's children DOM element.
         * It's using `React.cloneElement` internally.
         *
         * This prop will be deprecated and removed in v5
         */
        clone: chainPropTypes(propTypes.bool, function (props) {
          if (props.clone && props.component) {
            return new Error('You can not use the clone and component prop at the same time.');
          }

          return null;
        }),

        /**
         * The component used for the root node.
         * Either a string to use a DOM element or a component.
         */
        component: propTypes.elementType
      }, propTypes$1) ;

      {
        StyledComponent.displayName = "Styled(".concat(classNamePrefix, ")");
      }

      hoistNonReactStatics_cjs(StyledComponent, Component);
      return StyledComponent;
    };

    return componentCreator;
  }

  function mergeOuterLocalTheme(outerTheme, localTheme) {
    if (typeof localTheme === 'function') {
      var mergedTheme = localTheme(outerTheme);

      {
        if (!mergedTheme) {
          console.error(['Material-UI: you should return an object from your theme function, i.e.', '<ThemeProvider theme={() => ({})} />'].join('\n'));
        }
      }

      return mergedTheme;
    }

    return _extends({}, outerTheme, {}, localTheme);
  }
  /**
   * This component takes a `theme` prop.
   * It makes the `theme` available down the React tree thanks to React context.
   * This component should preferably be used at **the root of your component tree**.
   */


  function ThemeProvider(props) {
    var children = props.children,
        localTheme = props.theme;
    var outerTheme = useTheme();

    {
      if (outerTheme === null && typeof localTheme === 'function') {
        console.error(['Material-UI: you are providing a theme function prop to the ThemeProvider component:', '<ThemeProvider theme={outerTheme => outerTheme} />', '', 'However, no outer theme is present.', 'Make sure a theme is already injected higher in the React tree ' + 'or provide a theme object.'].join('\n'));
      }
    }

    var theme = React__default.useMemo(function () {
      var output = outerTheme === null ? localTheme : mergeOuterLocalTheme(outerTheme, localTheme);

      if (output != null) {
        output[nested] = outerTheme !== null;
      }

      return output;
    }, [localTheme, outerTheme]);
    return React__default.createElement(ThemeContext.Provider, {
      value: theme
    }, children);
  }

   ThemeProvider.propTypes = {
    /**
     * Your component tree.
     */
    children: propTypes.node.isRequired,

    /**
     * A theme object. You can provide a function to extend the outer theme.
     */
    theme: propTypes.oneOfType([propTypes.object, propTypes.func]).isRequired
  } ;

  {
     ThemeProvider.propTypes = exactProp(ThemeProvider.propTypes) ;
  }

  // It does not modify the component passed to it;
  // instead, it returns a new component, with a `classes` property.

  var withStyles = function withStyles(stylesOrCreator) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    return function (Component) {
      var defaultTheme = options.defaultTheme,
          _options$withTheme = options.withTheme,
          withTheme = _options$withTheme === void 0 ? false : _options$withTheme,
          name = options.name,
          stylesOptions = _objectWithoutProperties(options, ["defaultTheme", "withTheme", "name"]);

      {
        if (Component === undefined) {
          throw new Error(['You are calling withStyles(styles)(Component) with an undefined component.', 'You may have forgotten to import it.'].join('\n'));
        }
      }

      var classNamePrefix = name;

      {
        if (!name) {
          // Provide a better DX outside production.
          var displayName = getDisplayName(Component);

          if (displayName !== undefined) {
            classNamePrefix = displayName;
          }
        }
      }

      var useStyles = makeStyles(stylesOrCreator, _extends({
        defaultTheme: defaultTheme,
        Component: Component,
        name: name || Component.displayName,
        classNamePrefix: classNamePrefix
      }, stylesOptions));
      var WithStyles = React__default.forwardRef(function WithStyles(props, ref) {
        var classesProp = props.classes,
            innerRef = props.innerRef,
            other = _objectWithoutProperties(props, ["classes", "innerRef"]);

        var classes = useStyles(props);
        var theme;
        var more = other;

        if (typeof name === 'string' || withTheme) {
          // name and withTheme are invariant in the outer scope
          // eslint-disable-next-line react-hooks/rules-of-hooks
          theme = useTheme() || defaultTheme;

          if (name) {
            more = getThemeProps({
              theme: theme,
              name: name,
              props: other
            });
          } // Provide the theme to the wrapped component.
          // So we don't have to use the `withTheme()` Higher-order Component.


          if (withTheme && !more.theme) {
            more.theme = theme;
          }
        }

        return React__default.createElement(Component, _extends({
          ref: innerRef || ref,
          classes: classes
        }, more));
      });
       WithStyles.propTypes = {
        /**
         * Override or extend the styles applied to the component.
         */
        classes: propTypes.object,

        /**
         * Use that prop to pass a ref to the decorated component.
         * @deprecated
         */
        innerRef: chainPropTypes(propTypes.oneOfType([propTypes.func, propTypes.object]), function (props) {
          if (props.innerRef == null) {
            return null;
          }

          return null; // return new Error(
          //   'Material-UI: the `innerRef` prop is deprecated and will be removed in v5. ' +
          //     'Refs are now automatically forwarded to the inner component.',
          // );
        })
      } ; // The wrapper receives only user supplied props, which could be a subset of
      // the actual props Component might receive due to merging with defaultProps.
      // So copying it here would give us the same result in the wrapper as well.

      WithStyles.defaultProps = Component.defaultProps;

      {
        WithStyles.displayName = "WithStyles(".concat(getDisplayName(Component), ")");
      }

      hoistNonReactStatics_cjs(WithStyles, Component);

      {
        // Exposed for test purposes.
        WithStyles.Naked = Component;
        WithStyles.options = options;
        WithStyles.useStyles = useStyles;
      }

      return WithStyles;
    };
  };

  function withThemeCreator() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var defaultTheme = options.defaultTheme;

    var withTheme = function withTheme(Component) {
      {
        if (Component === undefined) {
          throw new Error(['You are calling withTheme(Component) with an undefined component.', 'You may have forgotten to import it.'].join('\n'));
        }
      }

      var WithTheme = React__default.forwardRef(function WithTheme(props, ref) {
        var innerRef = props.innerRef,
            other = _objectWithoutProperties(props, ["innerRef"]);

        var theme = useTheme() || defaultTheme;
        return React__default.createElement(Component, _extends({
          theme: theme,
          ref: innerRef || ref
        }, other));
      });
       WithTheme.propTypes = {
        /**
         * Use that prop to pass a ref to the decorated component.
         * @deprecated
         */
        innerRef: chainPropTypes(propTypes.oneOfType([propTypes.func, propTypes.object]), function (props) {
          if (props.innerRef == null) {
            return null;
          }

          return new Error('Material-UI: the `innerRef` prop is deprecated and will be removed in v5. ' + 'Refs are now automatically forwarded to the inner component.');
        })
      } ;

      {
        WithTheme.displayName = "WithTheme(".concat(getDisplayName(Component), ")");
      }

      hoistNonReactStatics_cjs(WithTheme, Component);

      {
        // Exposed for test purposes.
        WithTheme.Naked = Component;
      }

      return WithTheme;
    };

    return withTheme;
  } // Provide the theme object as a prop to the input component.
  // It's an alternative API to useTheme().
  // We encourage the usage of useTheme() where possible.

  var withTheme = withThemeCreator();

  // To remove in v5

  function createStyles$1(styles) {
    // warning(
    //   warnOnce,
    //   [
    //     'Material-UI: createStyles from @material-ui/core/styles is deprecated.',
    //     'Please use @material-ui/styles/createStyles',
    //   ].join('\n'),
    // );
    // warnOnce = true;
    return createStyles(styles);
  }

  var defaultTheme = createMuiTheme();

  function makeStyles$1(stylesOrCreator) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    return makeStyles(stylesOrCreator, _extends({
      defaultTheme: defaultTheme
    }, options));
  }

  var e=function(e){return parseFloat(e)};function convertLength(r){return null==r&&(r=r),function(n,t,i,f){null==i&&(i=r),null==f&&(f=i);var l=String(n).match(/[\d.\-\+]*\s*(.*)/)[1]||"";if(l===t)return n;var u=e(n);if("px"!==l)if("em"===l)u=e(n)*e(i);else if("rem"===l)u=e(n)*e(r);else{if("ex"!==l)return n;u=e(n)*e(i)*2;}var a=u;if("px"!==t)if("em"===t)a=u/e(f);else if("rem"===t)a=u/e(r);else{if("ex"!==t)return n;a=u/e(f)/2;}return parseFloat(a.toFixed(5))+t}}

  function alignProperty(_ref) {
    var size = _ref.size,
        grid = _ref.grid;
    var sizeBelow = size - size % grid;
    var sizeAbove = sizeBelow + grid;
    return size - sizeBelow < sizeAbove - size ? sizeBelow : sizeAbove;
  } // fontGrid finds a minimal grid (in rem) for the fontSize values so that the
  // lineHeight falls under a x pixels grid, 4px in the case of Material Design,
  // without changing the relative line height

  function fontGrid(_ref2) {
    var lineHeight = _ref2.lineHeight,
        pixels = _ref2.pixels,
        htmlFontSize = _ref2.htmlFontSize;
    return pixels / (lineHeight * htmlFontSize);
  }
  /**
   * generate a responsive version of a given CSS property
   * @example
   * responsiveProperty({
   *   cssProperty: 'fontSize',
   *   min: 15,
   *   max: 20,
   *   unit: 'px',
   *   breakpoints: [300, 600],
   * })
   *
   * // this returns
   *
   * {
   *   fontSize: '15px',
   *   '@media (min-width:300px)': {
   *     fontSize: '17.5px',
   *   },
   *   '@media (min-width:600px)': {
   *     fontSize: '20px',
   *   },
   * }
   *
   * @param {Object} params
   * @param {string} params.cssProperty - The CSS property to be made responsive
   * @param {number} params.min - The smallest value of the CSS property
   * @param {number} params.max - The largest value of the CSS property
   * @param {string} [params.unit] - The unit to be used for the CSS property
   * @param {Array.number} [params.breakpoints]  - An array of breakpoints
   * @param {number} [params.alignStep] - Round scaled value to fall under this grid
   * @returns {Object} responsive styles for {params.cssProperty}
   */

  function responsiveProperty(_ref3) {
    var cssProperty = _ref3.cssProperty,
        min = _ref3.min,
        max = _ref3.max,
        _ref3$unit = _ref3.unit,
        unit = _ref3$unit === void 0 ? 'rem' : _ref3$unit,
        _ref3$breakpoints = _ref3.breakpoints,
        breakpoints = _ref3$breakpoints === void 0 ? [600, 960, 1280] : _ref3$breakpoints,
        _ref3$transform = _ref3.transform,
        transform = _ref3$transform === void 0 ? null : _ref3$transform;

    var output = _defineProperty({}, cssProperty, "".concat(min).concat(unit));

    var factor = (max - min) / breakpoints[breakpoints.length - 1];
    breakpoints.forEach(function (breakpoint) {
      var value = min + factor * breakpoint;

      if (transform !== null) {
        value = transform(value);
      }

      output["@media (min-width:".concat(breakpoint, "px)")] = _defineProperty({}, cssProperty, "".concat(Math.round(value * 10000) / 10000).concat(unit));
    });
    return output;
  }

  function isUnitless(value) {
    return String(parseFloat(value)).length === String(value).length;
  }

  function responsiveFontSizes(themeInput) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var _options$breakpoints = options.breakpoints,
        breakpoints = _options$breakpoints === void 0 ? ['sm', 'md', 'lg'] : _options$breakpoints,
        _options$disableAlign = options.disableAlign,
        disableAlign = _options$disableAlign === void 0 ? false : _options$disableAlign,
        _options$factor = options.factor,
        factor = _options$factor === void 0 ? 2 : _options$factor,
        _options$variants = options.variants,
        variants = _options$variants === void 0 ? ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'caption', 'button', 'overline'] : _options$variants;

    var theme = _extends({}, themeInput);

    theme.typography = _extends({}, theme.typography);
    var typography = theme.typography; // Convert between css lengths e.g. em->px or px->rem
    // Set the baseFontSize for your project. Defaults to 16px (also the browser default).

    var convert = convertLength(typography.htmlFontSize);
    var breakpointValues = breakpoints.map(function (x) {
      return theme.breakpoints.values[x];
    });
    variants.forEach(function (variant) {
      var style = typography[variant];
      var remFontSize = parseFloat(convert(style.fontSize, 'rem'));

      if (remFontSize <= 1) {
        return;
      }

      var maxFontSize = remFontSize;
      var minFontSize = 1 + (maxFontSize - 1) / factor;
      var lineHeight = style.lineHeight;

      if (!isUnitless(lineHeight) && !disableAlign) {
        throw new Error(["Material-UI: unsupported non-unitless line height with grid alignment.", 'Use unitless line heights instead.'].join('\n'));
      }

      if (!isUnitless(lineHeight)) {
        // make it unitless
        lineHeight = parseFloat(convert(lineHeight, 'rem')) / parseFloat(remFontSize);
      }

      var transform = null;

      if (!disableAlign) {
        transform = function transform(value) {
          return alignProperty({
            size: value,
            grid: fontGrid({
              pixels: 4,
              lineHeight: lineHeight,
              htmlFontSize: typography.htmlFontSize
            })
          });
        };
      }

      typography[variant] = _extends({}, style, {}, responsiveProperty({
        cssProperty: 'fontSize',
        min: minFontSize,
        max: maxFontSize,
        unit: 'rem',
        breakpoints: breakpointValues,
        transform: transform
      }));
    });
    return theme;
  }

  var styled$1 = function styled$1(Component) {
    var componentCreator = styled(Component);
    return function (style, options) {
      return componentCreator(style, _extends({
        defaultTheme: defaultTheme
      }, options));
    };
  };

  function useTheme$1() {
    return useTheme() || defaultTheme;
  }

  function withStyles$1(stylesOrCreator, options) {
    return withStyles(stylesOrCreator, _extends({
      defaultTheme: defaultTheme
    }, options));
  }

  var withTheme$1 = withThemeCreator({
    defaultTheme: defaultTheme
  });

  // It should to be noted that this function isn't equivalent to `text-transform: capitalize`.
  //
  // A strict capitalization should uppercase the first letter of each word a the sentence.
  // We only handle the first word.
  function capitalize(string) {
    {
      if (typeof string !== 'string') {
        throw new Error('Material-UI: capitalize(string) expects a string argument.');
      }
    }

    return string.charAt(0).toUpperCase() + string.slice(1);
  }

  var styles = function styles(theme) {
    var elevations = {};
    theme.shadows.forEach(function (shadow, index) {
      elevations["elevation".concat(index)] = {
        boxShadow: shadow
      };
    });
    return _extends({
      /* Styles applied to the root element. */
      root: {
        backgroundColor: theme.palette.background.paper,
        color: theme.palette.text.primary,
        transition: theme.transitions.create('box-shadow')
      },

      /* Styles applied to the root element if `square={false}`. */
      rounded: {
        borderRadius: theme.shape.borderRadius
      }
    }, elevations);
  };
  var Paper = React__default.forwardRef(function Paper(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        _props$square = props.square,
        square = _props$square === void 0 ? false : _props$square,
        _props$elevation = props.elevation,
        elevation = _props$elevation === void 0 ? 1 : _props$elevation,
        other = _objectWithoutProperties(props, ["classes", "className", "component", "square", "elevation"]);

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      var theme = useTheme$1();

      if (!theme.shadows[elevation]) {
        console.error("Material-UI: this elevation `".concat(elevation, "` is not implemented."));
      }
    }

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, classes["elevation".concat(elevation)], className, !square && classes.rounded),
      ref: ref
    }, other));
  });
   Paper.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Shadow depth, corresponds to `dp` in the spec.
     * It accepts values between 0 and 24 inclusive.
     */
    elevation: propTypes.number,

    /**
     * If `true`, rounded corners are disabled.
     */
    square: propTypes.bool
  } ;
  var Paper$1 = withStyles$1(styles, {
    name: 'MuiPaper'
  })(Paper);

  var styles$1 = function styles(theme) {
    var backgroundColorDefault = theme.palette.type === 'light' ? theme.palette.grey[100] : theme.palette.grey[900];
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        flexDirection: 'column',
        width: '100%',
        boxSizing: 'border-box',
        // Prevent padding issue with the Modal and fixed positioned AppBar.
        zIndex: theme.zIndex.appBar,
        flexShrink: 0
      },

      /* Styles applied to the root element if `position="fixed"`. */
      positionFixed: {
        position: 'fixed',
        top: 0,
        left: 'auto',
        right: 0
      },

      /* Styles applied to the root element if `position="absolute"`. */
      positionAbsolute: {
        position: 'absolute',
        top: 0,
        left: 'auto',
        right: 0
      },

      /* Styles applied to the root element if `position="sticky"`. */
      positionSticky: {
        // ⚠️ sticky is not supported by IE 11.
        position: 'sticky',
        top: 0,
        left: 'auto',
        right: 0
      },

      /* Styles applied to the root element if `position="static"`. */
      positionStatic: {
        position: 'static',
        transform: 'translateZ(0)' // Make sure we can see the elevation.

      },

      /* Styles applied to the root element if `position="relative"`. */
      positionRelative: {
        position: 'relative'
      },

      /* Styles applied to the root element if `color="default"`. */
      colorDefault: {
        backgroundColor: backgroundColorDefault,
        color: theme.palette.getContrastText(backgroundColorDefault)
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        backgroundColor: theme.palette.primary.main,
        color: theme.palette.primary.contrastText
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        backgroundColor: theme.palette.secondary.main,
        color: theme.palette.secondary.contrastText
      }
    };
  };
  var AppBar = React__default.forwardRef(function AppBar(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'primary' : _props$color,
        _props$position = props.position,
        position = _props$position === void 0 ? 'fixed' : _props$position,
        other = _objectWithoutProperties(props, ["classes", "className", "color", "position"]);

    return React__default.createElement(Paper$1, _extends({
      square: true,
      component: "header",
      elevation: 4,
      className: clsx(classes.root, classes["position".concat(capitalize(position))], className, color !== 'inherit' && classes["color".concat(capitalize(color))], {
        fixed: 'mui-fixed'
      }[position]),
      ref: ref
    }, other));
  });
   AppBar.propTypes = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'inherit', 'primary', 'secondary']),

    /**
     * The positioning type. The behavior of the different options is described
     * [in the MDN web docs](https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout/Positioning).
     * Note: `sticky` is not universally supported and will fall back to `static` when unavailable.
     */
    position: propTypes.oneOf(['absolute', 'fixed', 'relative', 'static', 'sticky'])
  } ;
  var AppBar$1 = withStyles$1(styles$1, {
    name: 'MuiAppBar'
  })(AppBar);

  var styles$2 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
        flexShrink: 0,
        width: 40,
        height: 40,
        fontFamily: theme.typography.fontFamily,
        fontSize: theme.typography.pxToRem(20),
        lineHeight: 1,
        borderRadius: '50%',
        overflow: 'hidden',
        userSelect: 'none'
      },

      /* Styles applied to the root element if there are children and not `src` or `srcSet`. */
      colorDefault: {
        color: theme.palette.background.default,
        backgroundColor: theme.palette.type === 'light' ? theme.palette.grey[400] : theme.palette.grey[600]
      },

      /* Styles applied to the root element if `variant="circle"`. */
      circle: {},

      /* Styles applied to the root element if `variant="rounded"`. */
      rounded: {
        borderRadius: theme.shape.borderRadius
      },

      /* Styles applied to the root element if `variant="square"`. */
      square: {
        borderRadius: 0
      },

      /* Styles applied to the img element if either `src` or `srcSet` is defined. */
      img: {
        width: '100%',
        height: '100%',
        textAlign: 'center',
        // Handle non-square image. The property isn't supported by IE 11.
        objectFit: 'cover'
      }
    };
  };
  var Avatar = React__default.forwardRef(function Avatar(props, ref) {
    var alt = props.alt,
        childrenProp = props.children,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        imgProps = props.imgProps,
        sizes = props.sizes,
        src = props.src,
        srcSet = props.srcSet,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'circle' : _props$variant,
        other = _objectWithoutProperties(props, ["alt", "children", "classes", "className", "component", "imgProps", "sizes", "src", "srcSet", "variant"]);

    var children = null;
    var img = src || srcSet;

    if (img) {
      children = React__default.createElement("img", _extends({
        alt: alt,
        src: src,
        srcSet: srcSet,
        sizes: sizes,
        className: classes.img
      }, imgProps));
    } else {
      children = childrenProp;
    }

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, classes.system, classes[variant], className, !img && classes.colorDefault),
      ref: ref
    }, other), children);
  });
   Avatar.propTypes = {
    /**
     * Used in combination with `src` or `srcSet` to
     * provide an alt attribute for the rendered `img` element.
     */
    alt: propTypes.string,

    /**
     * Used to render icon or text elements inside the Avatar if `src` is not set.
     * This can be an element, or just a string.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Attributes applied to the `img` element if the component
     * is used to display an image.
     */
    imgProps: propTypes.object,

    /**
     * The `sizes` attribute for the `img` element.
     */
    sizes: propTypes.string,

    /**
     * The `src` attribute for the `img` element.
     */
    src: propTypes.string,

    /**
     * The `srcSet` attribute for the `img` element.
     */
    srcSet: propTypes.string,

    /**
     * The shape of the avatar.
     */
    variant: propTypes.oneOf(['circle', 'rounded', 'square'])
  } ;
  var Avatar$1 = withStyles$1(styles$2, {
    name: 'MuiAvatar'
  })(Avatar);

  var config = {
    disabled: false
  };

  var timeoutsShape =  propTypes.oneOfType([propTypes.number, propTypes.shape({
    enter: propTypes.number,
    exit: propTypes.number,
    appear: propTypes.number
  }).isRequired]) ;
  var classNamesShape =  propTypes.oneOfType([propTypes.string, propTypes.shape({
    enter: propTypes.string,
    exit: propTypes.string,
    active: propTypes.string
  }), propTypes.shape({
    enter: propTypes.string,
    enterDone: propTypes.string,
    enterActive: propTypes.string,
    exit: propTypes.string,
    exitDone: propTypes.string,
    exitActive: propTypes.string
  })]) ;

  var TransitionGroupContext = React__default.createContext(null);

  var UNMOUNTED = 'unmounted';
  var EXITED = 'exited';
  var ENTERING = 'entering';
  var ENTERED = 'entered';
  var EXITING = 'exiting';
  /**
   * The Transition component lets you describe a transition from one component
   * state to another _over time_ with a simple declarative API. Most commonly
   * it's used to animate the mounting and unmounting of a component, but can also
   * be used to describe in-place transition states as well.
   *
   * ---
   *
   * **Note**: `Transition` is a platform-agnostic base component. If you're using
   * transitions in CSS, you'll probably want to use
   * [`CSSTransition`](https://reactcommunity.org/react-transition-group/css-transition)
   * instead. It inherits all the features of `Transition`, but contains
   * additional features necessary to play nice with CSS transitions (hence the
   * name of the component).
   *
   * ---
   *
   * By default the `Transition` component does not alter the behavior of the
   * component it renders, it only tracks "enter" and "exit" states for the
   * components. It's up to you to give meaning and effect to those states. For
   * example we can add styles to a component when it enters or exits:
   *
   * ```jsx
   * import { Transition } from 'react-transition-group';
   *
   * const duration = 300;
   *
   * const defaultStyle = {
   *   transition: `opacity ${duration}ms ease-in-out`,
   *   opacity: 0,
   * }
   *
   * const transitionStyles = {
   *   entering: { opacity: 1 },
   *   entered:  { opacity: 1 },
   *   exiting:  { opacity: 0 },
   *   exited:  { opacity: 0 },
   * };
   *
   * const Fade = ({ in: inProp }) => (
   *   <Transition in={inProp} timeout={duration}>
   *     {state => (
   *       <div style={{
   *         ...defaultStyle,
   *         ...transitionStyles[state]
   *       }}>
   *         I'm a fade Transition!
   *       </div>
   *     )}
   *   </Transition>
   * );
   * ```
   *
   * There are 4 main states a Transition can be in:
   *  - `'entering'`
   *  - `'entered'`
   *  - `'exiting'`
   *  - `'exited'`
   *
   * Transition state is toggled via the `in` prop. When `true` the component
   * begins the "Enter" stage. During this stage, the component will shift from
   * its current transition state, to `'entering'` for the duration of the
   * transition and then to the `'entered'` stage once it's complete. Let's take
   * the following example (we'll use the
   * [useState](https://reactjs.org/docs/hooks-reference.html#usestate) hook):
   *
   * ```jsx
   * function App() {
   *   const [inProp, setInProp] = useState(false);
   *   return (
   *     <div>
   *       <Transition in={inProp} timeout={500}>
   *         {state => (
   *           // ...
   *         )}
   *       </Transition>
   *       <button onClick={() => setInProp(true)}>
   *         Click to Enter
   *       </button>
   *     </div>
   *   );
   * }
   * ```
   *
   * When the button is clicked the component will shift to the `'entering'` state
   * and stay there for 500ms (the value of `timeout`) before it finally switches
   * to `'entered'`.
   *
   * When `in` is `false` the same thing happens except the state moves from
   * `'exiting'` to `'exited'`.
   */

  var Transition =
  /*#__PURE__*/
  function (_React$Component) {
    _inheritsLoose(Transition, _React$Component);

    function Transition(props, context) {
      var _this;

      _this = _React$Component.call(this, props, context) || this;
      var parentGroup = context; // In the context of a TransitionGroup all enters are really appears

      var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;
      var initialStatus;
      _this.appearStatus = null;

      if (props.in) {
        if (appear) {
          initialStatus = EXITED;
          _this.appearStatus = ENTERING;
        } else {
          initialStatus = ENTERED;
        }
      } else {
        if (props.unmountOnExit || props.mountOnEnter) {
          initialStatus = UNMOUNTED;
        } else {
          initialStatus = EXITED;
        }
      }

      _this.state = {
        status: initialStatus
      };
      _this.nextCallback = null;
      return _this;
    }

    Transition.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {
      var nextIn = _ref.in;

      if (nextIn && prevState.status === UNMOUNTED) {
        return {
          status: EXITED
        };
      }

      return null;
    }; // getSnapshotBeforeUpdate(prevProps) {
    //   let nextStatus = null
    //   if (prevProps !== this.props) {
    //     const { status } = this.state
    //     if (this.props.in) {
    //       if (status !== ENTERING && status !== ENTERED) {
    //         nextStatus = ENTERING
    //       }
    //     } else {
    //       if (status === ENTERING || status === ENTERED) {
    //         nextStatus = EXITING
    //       }
    //     }
    //   }
    //   return { nextStatus }
    // }


    var _proto = Transition.prototype;

    _proto.componentDidMount = function componentDidMount() {
      this.updateStatus(true, this.appearStatus);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      var nextStatus = null;

      if (prevProps !== this.props) {
        var status = this.state.status;

        if (this.props.in) {
          if (status !== ENTERING && status !== ENTERED) {
            nextStatus = ENTERING;
          }
        } else {
          if (status === ENTERING || status === ENTERED) {
            nextStatus = EXITING;
          }
        }
      }

      this.updateStatus(false, nextStatus);
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      this.cancelNextCallback();
    };

    _proto.getTimeouts = function getTimeouts() {
      var timeout = this.props.timeout;
      var exit, enter, appear;
      exit = enter = appear = timeout;

      if (timeout != null && typeof timeout !== 'number') {
        exit = timeout.exit;
        enter = timeout.enter; // TODO: remove fallback for next major

        appear = timeout.appear !== undefined ? timeout.appear : enter;
      }

      return {
        exit: exit,
        enter: enter,
        appear: appear
      };
    };

    _proto.updateStatus = function updateStatus(mounting, nextStatus) {
      if (mounting === void 0) {
        mounting = false;
      }

      if (nextStatus !== null) {
        // nextStatus will always be ENTERING or EXITING.
        this.cancelNextCallback();
        var node = ReactDOM.findDOMNode(this);

        if (nextStatus === ENTERING) {
          this.performEnter(node, mounting);
        } else {
          this.performExit(node);
        }
      } else if (this.props.unmountOnExit && this.state.status === EXITED) {
        this.setState({
          status: UNMOUNTED
        });
      }
    };

    _proto.performEnter = function performEnter(node, mounting) {
      var _this2 = this;

      var enter = this.props.enter;
      var appearing = this.context ? this.context.isMounting : mounting;
      var timeouts = this.getTimeouts();
      var enterTimeout = appearing ? timeouts.appear : timeouts.enter; // no enter animation skip right to ENTERED
      // if we are mounting and running this it means appear _must_ be set

      if (!mounting && !enter || config.disabled) {
        this.safeSetState({
          status: ENTERED
        }, function () {
          _this2.props.onEntered(node);
        });
        return;
      }

      this.props.onEnter(node, appearing);
      this.safeSetState({
        status: ENTERING
      }, function () {
        _this2.props.onEntering(node, appearing);

        _this2.onTransitionEnd(node, enterTimeout, function () {
          _this2.safeSetState({
            status: ENTERED
          }, function () {
            _this2.props.onEntered(node, appearing);
          });
        });
      });
    };

    _proto.performExit = function performExit(node) {
      var _this3 = this;

      var exit = this.props.exit;
      var timeouts = this.getTimeouts(); // no exit animation skip right to EXITED

      if (!exit || config.disabled) {
        this.safeSetState({
          status: EXITED
        }, function () {
          _this3.props.onExited(node);
        });
        return;
      }

      this.props.onExit(node);
      this.safeSetState({
        status: EXITING
      }, function () {
        _this3.props.onExiting(node);

        _this3.onTransitionEnd(node, timeouts.exit, function () {
          _this3.safeSetState({
            status: EXITED
          }, function () {
            _this3.props.onExited(node);
          });
        });
      });
    };

    _proto.cancelNextCallback = function cancelNextCallback() {
      if (this.nextCallback !== null) {
        this.nextCallback.cancel();
        this.nextCallback = null;
      }
    };

    _proto.safeSetState = function safeSetState(nextState, callback) {
      // This shouldn't be necessary, but there are weird race conditions with
      // setState callbacks and unmounting in testing, so always make sure that
      // we can cancel any pending setState callbacks after we unmount.
      callback = this.setNextCallback(callback);
      this.setState(nextState, callback);
    };

    _proto.setNextCallback = function setNextCallback(callback) {
      var _this4 = this;

      var active = true;

      this.nextCallback = function (event) {
        if (active) {
          active = false;
          _this4.nextCallback = null;
          callback(event);
        }
      };

      this.nextCallback.cancel = function () {
        active = false;
      };

      return this.nextCallback;
    };

    _proto.onTransitionEnd = function onTransitionEnd(node, timeout, handler) {
      this.setNextCallback(handler);
      var doesNotHaveTimeoutOrListener = timeout == null && !this.props.addEndListener;

      if (!node || doesNotHaveTimeoutOrListener) {
        setTimeout(this.nextCallback, 0);
        return;
      }

      if (this.props.addEndListener) {
        this.props.addEndListener(node, this.nextCallback);
      }

      if (timeout != null) {
        setTimeout(this.nextCallback, timeout);
      }
    };

    _proto.render = function render() {
      var status = this.state.status;

      if (status === UNMOUNTED) {
        return null;
      }

      var _this$props = this.props,
          children = _this$props.children,
          childProps = _objectWithoutPropertiesLoose(_this$props, ["children"]); // filter props for Transtition


      delete childProps.in;
      delete childProps.mountOnEnter;
      delete childProps.unmountOnExit;
      delete childProps.appear;
      delete childProps.enter;
      delete childProps.exit;
      delete childProps.timeout;
      delete childProps.addEndListener;
      delete childProps.onEnter;
      delete childProps.onEntering;
      delete childProps.onEntered;
      delete childProps.onExit;
      delete childProps.onExiting;
      delete childProps.onExited;

      if (typeof children === 'function') {
        // allows for nested Transitions
        return React__default.createElement(TransitionGroupContext.Provider, {
          value: null
        }, children(status, childProps));
      }

      var child = React__default.Children.only(children);
      return (// allows for nested Transitions
        React__default.createElement(TransitionGroupContext.Provider, {
          value: null
        }, React__default.cloneElement(child, childProps))
      );
    };

    return Transition;
  }(React__default.Component);

  Transition.contextType = TransitionGroupContext;
  Transition.propTypes =  {
    /**
     * A `function` child can be used instead of a React element. This function is
     * called with the current transition status (`'entering'`, `'entered'`,
     * `'exiting'`, `'exited'`), which can be used to apply context
     * specific props to a component.
     *
     * ```jsx
     * <Transition in={this.state.in} timeout={150}>
     *   {state => (
     *     <MyComponent className={`fade fade-${state}`} />
     *   )}
     * </Transition>
     * ```
     */
    children: propTypes.oneOfType([propTypes.func.isRequired, propTypes.element.isRequired]).isRequired,

    /**
     * Show the component; triggers the enter or exit states
     */
    in: propTypes.bool,

    /**
     * By default the child component is mounted immediately along with
     * the parent `Transition` component. If you want to "lazy mount" the component on the
     * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay
     * mounted, even on "exited", unless you also specify `unmountOnExit`.
     */
    mountOnEnter: propTypes.bool,

    /**
     * By default the child component stays mounted after it reaches the `'exited'` state.
     * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.
     */
    unmountOnExit: propTypes.bool,

    /**
     * Normally a component is not transitioned if it is shown when the
     * `<Transition>` component mounts. If you want to transition on the first
     * mount set `appear` to `true`, and the component will transition in as soon
     * as the `<Transition>` mounts.
     *
     * > **Note**: there are no special appear states like `appearing`/`appeared`, this prop
     * > only adds an additional enter transition. However, in the
     * > `<CSSTransition>` component that first enter transition does result in
     * > additional `.appear-*` classes, that way you can choose to style it
     * > differently.
     */
    appear: propTypes.bool,

    /**
     * Enable or disable enter transitions.
     */
    enter: propTypes.bool,

    /**
     * Enable or disable exit transitions.
     */
    exit: propTypes.bool,

    /**
     * The duration of the transition, in milliseconds.
     * Required unless `addEndListener` is provided.
     *
     * You may specify a single timeout for all transitions:
     *
     * ```jsx
     * timeout={500}
     * ```
     *
     * or individually:
     *
     * ```jsx
     * timeout={{
     *  appear: 500,
     *  enter: 300,
     *  exit: 500,
     * }}
     * ```
     *
     * - `appear` defaults to the value of `enter`
     * - `enter` defaults to `0`
     * - `exit` defaults to `0`
     *
     * @type {number | { enter?: number, exit?: number, appear?: number }}
     */
    timeout: function timeout(props) {
      var pt = timeoutsShape;
      if (!props.addEndListener) pt = pt.isRequired;

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return pt.apply(void 0, [props].concat(args));
    },

    /**
     * Add a custom transition end trigger. Called with the transitioning
     * DOM node and a `done` callback. Allows for more fine grained transition end
     * logic. **Note:** Timeouts are still used as a fallback if provided.
     *
     * ```jsx
     * addEndListener={(node, done) => {
     *   // use the css transitionend event to mark the finish of a transition
     *   node.addEventListener('transitionend', done, false);
     * }}
     * ```
     */
    addEndListener: propTypes.func,

    /**
     * Callback fired before the "entering" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * @type Function(node: HtmlElement, isAppearing: bool) -> void
     */
    onEnter: propTypes.func,

    /**
     * Callback fired after the "entering" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * @type Function(node: HtmlElement, isAppearing: bool)
     */
    onEntering: propTypes.func,

    /**
     * Callback fired after the "entered" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * @type Function(node: HtmlElement, isAppearing: bool) -> void
     */
    onEntered: propTypes.func,

    /**
     * Callback fired before the "exiting" status is applied.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExit: propTypes.func,

    /**
     * Callback fired after the "exiting" status is applied.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExiting: propTypes.func,

    /**
     * Callback fired after the "exited" status is applied.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExited: propTypes.func // Name the function so it is clearer in the documentation

  } ;

  function noop() {}

  Transition.defaultProps = {
    in: false,
    mountOnEnter: false,
    unmountOnExit: false,
    appear: false,
    enter: true,
    exit: true,
    onEnter: noop,
    onEntering: noop,
    onEntered: noop,
    onExit: noop,
    onExiting: noop,
    onExited: noop
  };
  Transition.UNMOUNTED = 0;
  Transition.EXITED = 1;
  Transition.ENTERING = 2;
  Transition.ENTERED = 3;
  Transition.EXITING = 4;

  /**
   * Given `this.props.children`, return an object mapping key to child.
   *
   * @param {*} children `this.props.children`
   * @return {object} Mapping of key to child
   */

  function getChildMapping(children, mapFn) {
    var mapper = function mapper(child) {
      return mapFn && React.isValidElement(child) ? mapFn(child) : child;
    };

    var result = Object.create(null);
    if (children) React.Children.map(children, function (c) {
      return c;
    }).forEach(function (child) {
      // run the map function here instead so that the key is the computed one
      result[child.key] = mapper(child);
    });
    return result;
  }
  /**
   * When you're adding or removing children some may be added or removed in the
   * same render pass. We want to show *both* since we want to simultaneously
   * animate elements in and out. This function takes a previous set of keys
   * and a new set of keys and merges them with its best guess of the correct
   * ordering. In the future we may expose some of the utilities in
   * ReactMultiChild to make this easy, but for now React itself does not
   * directly have this concept of the union of prevChildren and nextChildren
   * so we implement it here.
   *
   * @param {object} prev prev children as returned from
   * `ReactTransitionChildMapping.getChildMapping()`.
   * @param {object} next next children as returned from
   * `ReactTransitionChildMapping.getChildMapping()`.
   * @return {object} a key set that contains all keys in `prev` and all keys
   * in `next` in a reasonable order.
   */

  function mergeChildMappings(prev, next) {
    prev = prev || {};
    next = next || {};

    function getValueForKey(key) {
      return key in next ? next[key] : prev[key];
    } // For each key of `next`, the list of keys to insert before that key in
    // the combined list


    var nextKeysPending = Object.create(null);
    var pendingKeys = [];

    for (var prevKey in prev) {
      if (prevKey in next) {
        if (pendingKeys.length) {
          nextKeysPending[prevKey] = pendingKeys;
          pendingKeys = [];
        }
      } else {
        pendingKeys.push(prevKey);
      }
    }

    var i;
    var childMapping = {};

    for (var nextKey in next) {
      if (nextKeysPending[nextKey]) {
        for (i = 0; i < nextKeysPending[nextKey].length; i++) {
          var pendingNextKey = nextKeysPending[nextKey][i];
          childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
        }
      }

      childMapping[nextKey] = getValueForKey(nextKey);
    } // Finally, add the keys which didn't appear before any key in `next`


    for (i = 0; i < pendingKeys.length; i++) {
      childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
    }

    return childMapping;
  }

  function getProp(child, prop, props) {
    return props[prop] != null ? props[prop] : child.props[prop];
  }

  function getInitialChildMapping(props, onExited) {
    return getChildMapping(props.children, function (child) {
      return React.cloneElement(child, {
        onExited: onExited.bind(null, child),
        in: true,
        appear: getProp(child, 'appear', props),
        enter: getProp(child, 'enter', props),
        exit: getProp(child, 'exit', props)
      });
    });
  }
  function getNextChildMapping(nextProps, prevChildMapping, onExited) {
    var nextChildMapping = getChildMapping(nextProps.children);
    var children = mergeChildMappings(prevChildMapping, nextChildMapping);
    Object.keys(children).forEach(function (key) {
      var child = children[key];
      if (!React.isValidElement(child)) return;
      var hasPrev = key in prevChildMapping;
      var hasNext = key in nextChildMapping;
      var prevChild = prevChildMapping[key];
      var isLeaving = React.isValidElement(prevChild) && !prevChild.props.in; // item is new (entering)

      if (hasNext && (!hasPrev || isLeaving)) {
        // console.log('entering', key)
        children[key] = React.cloneElement(child, {
          onExited: onExited.bind(null, child),
          in: true,
          exit: getProp(child, 'exit', nextProps),
          enter: getProp(child, 'enter', nextProps)
        });
      } else if (!hasNext && hasPrev && !isLeaving) {
        // item is old (exiting)
        // console.log('leaving', key)
        children[key] = React.cloneElement(child, {
          in: false
        });
      } else if (hasNext && hasPrev && React.isValidElement(prevChild)) {
        // item hasn't changed transition states
        // copy over the last transition props;
        // console.log('unchanged', key)
        children[key] = React.cloneElement(child, {
          onExited: onExited.bind(null, child),
          in: prevChild.props.in,
          exit: getProp(child, 'exit', nextProps),
          enter: getProp(child, 'enter', nextProps)
        });
      }
    });
    return children;
  }

  var values = Object.values || function (obj) {
    return Object.keys(obj).map(function (k) {
      return obj[k];
    });
  };

  var defaultProps = {
    component: 'div',
    childFactory: function childFactory(child) {
      return child;
    }
    /**
     * The `<TransitionGroup>` component manages a set of transition components
     * (`<Transition>` and `<CSSTransition>`) in a list. Like with the transition
     * components, `<TransitionGroup>` is a state machine for managing the mounting
     * and unmounting of components over time.
     *
     * Consider the example below. As items are removed or added to the TodoList the
     * `in` prop is toggled automatically by the `<TransitionGroup>`.
     *
     * Note that `<TransitionGroup>`  does not define any animation behavior!
     * Exactly _how_ a list item animates is up to the individual transition
     * component. This means you can mix and match animations across different list
     * items.
     */

  };

  var TransitionGroup =
  /*#__PURE__*/
  function (_React$Component) {
    _inheritsLoose(TransitionGroup, _React$Component);

    function TransitionGroup(props, context) {
      var _this;

      _this = _React$Component.call(this, props, context) || this;

      var handleExited = _this.handleExited.bind(_assertThisInitialized(_assertThisInitialized(_this))); // Initial children should all be entering, dependent on appear


      _this.state = {
        contextValue: {
          isMounting: true
        },
        handleExited: handleExited,
        firstRender: true
      };
      return _this;
    }

    var _proto = TransitionGroup.prototype;

    _proto.componentDidMount = function componentDidMount() {
      this.mounted = true;
      this.setState({
        contextValue: {
          isMounting: false
        }
      });
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      this.mounted = false;
    };

    TransitionGroup.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, _ref) {
      var prevChildMapping = _ref.children,
          handleExited = _ref.handleExited,
          firstRender = _ref.firstRender;
      return {
        children: firstRender ? getInitialChildMapping(nextProps, handleExited) : getNextChildMapping(nextProps, prevChildMapping, handleExited),
        firstRender: false
      };
    };

    _proto.handleExited = function handleExited(child, node) {
      var currentChildMapping = getChildMapping(this.props.children);
      if (child.key in currentChildMapping) return;

      if (child.props.onExited) {
        child.props.onExited(node);
      }

      if (this.mounted) {
        this.setState(function (state) {
          var children = _extends({}, state.children);

          delete children[child.key];
          return {
            children: children
          };
        });
      }
    };

    _proto.render = function render() {
      var _this$props = this.props,
          Component = _this$props.component,
          childFactory = _this$props.childFactory,
          props = _objectWithoutPropertiesLoose(_this$props, ["component", "childFactory"]);

      var contextValue = this.state.contextValue;
      var children = values(this.state.children).map(childFactory);
      delete props.appear;
      delete props.enter;
      delete props.exit;

      if (Component === null) {
        return React__default.createElement(TransitionGroupContext.Provider, {
          value: contextValue
        }, children);
      }

      return React__default.createElement(TransitionGroupContext.Provider, {
        value: contextValue
      }, React__default.createElement(Component, props, children));
    };

    return TransitionGroup;
  }(React__default.Component);

  TransitionGroup.propTypes =  {
    /**
     * `<TransitionGroup>` renders a `<div>` by default. You can change this
     * behavior by providing a `component` prop.
     * If you use React v16+ and would like to avoid a wrapping `<div>` element
     * you can pass in `component={null}`. This is useful if the wrapping div
     * borks your css styles.
     */
    component: propTypes.any,

    /**
     * A set of `<Transition>` components, that are toggled `in` and out as they
     * leave. the `<TransitionGroup>` will inject specific transition props, so
     * remember to spread them through if you are wrapping the `<Transition>` as
     * with our `<Fade>` example.
     *
     * While this component is meant for multiple `Transition` or `CSSTransition`
     * children, sometimes you may want to have a single transition child with
     * content that you want to be transitioned out and in when you change it
     * (e.g. routes, images etc.) In that case you can change the `key` prop of
     * the transition child as you change its content, this will cause
     * `TransitionGroup` to transition the child out and back in.
     */
    children: propTypes.node,

    /**
     * A convenience prop that enables or disables appear animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    appear: propTypes.bool,

    /**
     * A convenience prop that enables or disables enter animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    enter: propTypes.bool,

    /**
     * A convenience prop that enables or disables exit animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    exit: propTypes.bool,

    /**
     * You may need to apply reactive updates to a child as it is exiting.
     * This is generally done by using `cloneElement` however in the case of an exiting
     * child the element has already been removed and not accessible to the consumer.
     *
     * If you do need to update a child as it leaves you can provide a `childFactory`
     * to wrap every child, even the ones that are leaving.
     *
     * @type Function(child: ReactElement) -> ReactElement
     */
    childFactory: propTypes.func
  } ;
  TransitionGroup.defaultProps = defaultProps;

  var reflow = function reflow(node) {
    return node.scrollTop;
  };
  function getTransitionProps(props, options) {
    var timeout = props.timeout,
        _props$style = props.style,
        style = _props$style === void 0 ? {} : _props$style;
    return {
      duration: style.transitionDuration || typeof timeout === 'number' ? timeout : timeout[options.mode] || 0,
      delay: style.transitionDelay
    };
  }

  // TODO: Make it private only in v5
  function setRef(ref, value) {
    if (typeof ref === 'function') {
      ref(value);
    } else if (ref) {
      ref.current = value;
    }
  }

  function useForkRef(refA, refB) {
    /**
     * This will create a new function if the ref props change and are defined.
     * This means react will call the old forkRef with `null` and the new forkRef
     * with the ref. Cleanup naturally emerges from this behavior
     */
    return React__default.useMemo(function () {
      if (refA == null && refB == null) {
        return null;
      }

      return function (refValue) {
        setRef(refA, refValue);
        setRef(refB, refValue);
      };
    }, [refA, refB]);
  }

  var styles$3 = {
    entering: {
      opacity: 1
    },
    entered: {
      opacity: 1
    }
  };
  var defaultTimeout = {
    enter: duration.enteringScreen,
    exit: duration.leavingScreen
  };
  /**
   * The Fade transition is used by the [Modal](/components/modal/) component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  var Fade = React__default.forwardRef(function Fade(props, ref) {
    var children = props.children,
        inProp = props.in,
        onEnter = props.onEnter,
        onExit = props.onExit,
        style = props.style,
        _props$timeout = props.timeout,
        timeout = _props$timeout === void 0 ? defaultTimeout : _props$timeout,
        other = _objectWithoutProperties(props, ["children", "in", "onEnter", "onExit", "style", "timeout"]);

    var theme = useTheme$1();
    var handleRef = useForkRef(children.ref, ref);

    var handleEnter = function handleEnter(node, isAppearing) {
      reflow(node); // So the animation always start from the start.

      var transitionProps = getTransitionProps({
        style: style,
        timeout: timeout
      }, {
        mode: 'enter'
      });
      node.style.webkitTransition = theme.transitions.create('opacity', transitionProps);
      node.style.transition = theme.transitions.create('opacity', transitionProps);

      if (onEnter) {
        onEnter(node, isAppearing);
      }
    };

    var handleExit = function handleExit(node) {
      var transitionProps = getTransitionProps({
        style: style,
        timeout: timeout
      }, {
        mode: 'exit'
      });
      node.style.webkitTransition = theme.transitions.create('opacity', transitionProps);
      node.style.transition = theme.transitions.create('opacity', transitionProps);

      if (onExit) {
        onExit(node);
      }
    };

    return React__default.createElement(Transition, _extends({
      appear: true,
      in: inProp,
      onEnter: handleEnter,
      onExit: handleExit,
      timeout: timeout
    }, other), function (state, childProps) {
      return React__default.cloneElement(children, _extends({
        style: _extends({
          opacity: 0,
          visibility: state === 'exited' && !inProp ? 'hidden' : undefined
        }, styles$3[state], {}, style, {}, children.props.style),
        ref: handleRef
      }, childProps));
    });
  });
   Fade.propTypes = {
    /**
     * A single child content element.
     */
    children: propTypes.element,

    /**
     * If `true`, the component will transition in.
     */
    in: propTypes.bool,

    /**
     * @ignore
     */
    onEnter: propTypes.func,

    /**
     * @ignore
     */
    onExit: propTypes.func,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    timeout: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })])
  } ;

  var styles$4 = {
    /* Styles applied to the root element. */
    root: {
      zIndex: -1,
      position: 'fixed',
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      right: 0,
      bottom: 0,
      top: 0,
      left: 0,
      backgroundColor: 'rgba(0, 0, 0, 0.5)',
      // Remove grey highlight
      WebkitTapHighlightColor: 'transparent',
      // Disable scroll capabilities.
      touchAction: 'none'
    },

    /* Styles applied to the root element if `invisible={true}`. */
    invisible: {
      backgroundColor: 'transparent'
    }
  };
  var Backdrop = React__default.forwardRef(function Backdrop(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$invisible = props.invisible,
        invisible = _props$invisible === void 0 ? false : _props$invisible,
        open = props.open,
        transitionDuration = props.transitionDuration,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "invisible", "open", "transitionDuration"]);

    return React__default.createElement(Fade, _extends({
      in: open,
      timeout: transitionDuration
    }, other), React__default.createElement("div", {
      className: clsx(classes.root, className, invisible && classes.invisible),
      "aria-hidden": true,
      ref: ref
    }, children));
  });
   Backdrop.propTypes = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the backdrop is invisible.
     * It can be used when rendering a popover or a custom select component.
     */
    invisible: propTypes.bool,

    /**
     * If `true`, the backdrop is open.
     */
    open: propTypes.bool.isRequired,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      appear: propTypes.number,
      enter: propTypes.number,
      exit: propTypes.number
    })])
  } ;
  var Backdrop$1 = withStyles$1(styles$4, {
    name: 'MuiBackdrop'
  })(Backdrop);

  var RADIUS_STANDARD = 10;
  var RADIUS_DOT = 3;
  var styles$5 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        display: 'inline-flex',
        // For correct alignment with the text.
        verticalAlign: 'middle',
        flexShrink: 0
      },

      /* Styles applied to the badge `span` element. */
      badge: {
        display: 'flex',
        flexDirection: 'row',
        flexWrap: 'wrap',
        justifyContent: 'center',
        alignContent: 'center',
        alignItems: 'center',
        position: 'absolute',
        boxSizing: 'border-box',
        fontFamily: theme.typography.fontFamily,
        fontWeight: theme.typography.fontWeightMedium,
        fontSize: theme.typography.pxToRem(12),
        minWidth: RADIUS_STANDARD * 2,
        lineHeight: 1,
        padding: '0 6px',
        height: RADIUS_STANDARD * 2,
        borderRadius: RADIUS_STANDARD,
        backgroundColor: theme.palette.color,
        color: theme.palette.textColor,
        zIndex: 1,
        // Render the badge on top of potential ripples.
        transition: theme.transitions.create('transform', {
          easing: theme.transitions.easing.easeInOut,
          duration: theme.transitions.duration.enteringScreen
        })
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        backgroundColor: theme.palette.primary.main,
        color: theme.palette.primary.contrastText
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        backgroundColor: theme.palette.secondary.main,
        color: theme.palette.secondary.contrastText
      },

      /* Styles applied to the root element if `color="error"`. */
      colorError: {
        backgroundColor: theme.palette.error.main,
        color: theme.palette.error.contrastText
      },

      /* Styles applied to the root element if `variant="dot"`. */
      dot: {
        height: RADIUS_DOT * 2,
        minWidth: RADIUS_DOT * 2,
        padding: 0
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'right' }} overlap="rectangle"`. */
      anchorOriginTopRightRectangle: {
        top: 0,
        right: 0,
        transform: 'scale(1) translate(50%, -50%)',
        transformOrigin: '100% 0%',
        '&$invisible': {
          transform: 'scale(0) translate(50%, -50%)'
        }
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'right' }} overlap="rectangle"`. */
      anchorOriginBottomRightRectangle: {
        bottom: 0,
        right: 0,
        transform: 'scale(1) translate(50%, 50%)',
        transformOrigin: '100% 100%',
        '&$invisible': {
          transform: 'scale(0) translate(50%, 50%)'
        }
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'left' }} overlap="rectangle"`. */
      anchorOriginTopLeftRectangle: {
        top: 0,
        left: 0,
        transform: 'scale(1) translate(-50%, -50%)',
        transformOrigin: '0% 0%',
        '&$invisible': {
          transform: 'scale(0) translate(-50%, -50%)'
        }
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'left' }} overlap="rectangle"`. */
      anchorOriginBottomLeftRectangle: {
        bottom: 0,
        left: 0,
        transform: 'scale(1) translate(-50%, 50%)',
        transformOrigin: '0% 100%',
        '&$invisible': {
          transform: 'scale(0) translate(-50%, 50%)'
        }
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'right' }} overlap="circle"`. */
      anchorOriginTopRightCircle: {
        top: '14%',
        right: '14%',
        transform: 'scale(1) translate(50%, -50%)',
        transformOrigin: '100% 0%',
        '&$invisible': {
          transform: 'scale(0) translate(50%, -50%)'
        }
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'right' }} overlap="circle"`. */
      anchorOriginBottomRightCircle: {
        bottom: '14%',
        right: '14%',
        transform: 'scale(1) translate(50%, 50%)',
        transformOrigin: '100% 100%',
        '&$invisible': {
          transform: 'scale(0) translate(50%, 50%)'
        }
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'left' }} overlap="circle"`. */
      anchorOriginTopLeftCircle: {
        top: '14%',
        left: '14%',
        transform: 'scale(1) translate(-50%, -50%)',
        transformOrigin: '0% 0%',
        '&$invisible': {
          transform: 'scale(0) translate(-50%, -50%)'
        }
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'left' }} overlap="circle"`. */
      anchorOriginBottomLeftCircle: {
        bottom: '14%',
        left: '14%',
        transform: 'scale(1) translate(-50%, 50%)',
        transformOrigin: '0% 100%',
        '&$invisible': {
          transform: 'scale(0) translate(-50%, 50%)'
        }
      },

      /* Pseudo-class to the badge `span` element if `invisible={true}`. */
      invisible: {
        transition: theme.transitions.create('transform', {
          easing: theme.transitions.easing.easeInOut,
          duration: theme.transitions.duration.leavingScreen
        })
      }
    };
  };
  var Badge = React__default.forwardRef(function Badge(props, ref) {
    var _props$anchorOrigin = props.anchorOrigin,
        anchorOrigin = _props$anchorOrigin === void 0 ? {
      vertical: 'top',
      horizontal: 'right'
    } : _props$anchorOrigin,
        badgeContent = props.badgeContent,
        children = props.children,
        classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'default' : _props$color,
        _props$component = props.component,
        ComponentProp = _props$component === void 0 ? 'span' : _props$component,
        invisibleProp = props.invisible,
        _props$max = props.max,
        max = _props$max === void 0 ? 99 : _props$max,
        _props$overlap = props.overlap,
        overlap = _props$overlap === void 0 ? 'rectangle' : _props$overlap,
        _props$showZero = props.showZero,
        showZero = _props$showZero === void 0 ? false : _props$showZero,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'standard' : _props$variant,
        other = _objectWithoutProperties(props, ["anchorOrigin", "badgeContent", "children", "classes", "className", "color", "component", "invisible", "max", "overlap", "showZero", "variant"]);

    var invisible = invisibleProp;

    if (invisibleProp == null && (badgeContent === 0 && !showZero || badgeContent == null && variant !== 'dot')) {
      invisible = true;
    }

    var displayValue = '';

    if (variant !== 'dot') {
      displayValue = badgeContent > max ? "".concat(max, "+") : badgeContent;
    }

    return React__default.createElement(ComponentProp, _extends({
      className: clsx(classes.root, className),
      ref: ref
    }, other), children, React__default.createElement("span", {
      className: clsx(classes.badge, classes["".concat(anchorOrigin.horizontal).concat(capitalize(anchorOrigin.vertical), "}")], classes["anchorOrigin".concat(capitalize(anchorOrigin.vertical)).concat(capitalize(anchorOrigin.horizontal)).concat(capitalize(overlap))], color !== 'default' && classes["color".concat(capitalize(color))], invisible && classes.invisible, {
        dot: classes.dot
      }[variant])
    }, displayValue));
  });
   Badge.propTypes = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The anchor of the badge.
     */
    anchorOrigin: propTypes.shape({
      horizontal: propTypes.oneOf(['left', 'right']).isRequired,
      vertical: propTypes.oneOf(['bottom', 'top']).isRequired
    }),

    /**
     * The content rendered within the badge.
     */
    badgeContent: propTypes.node,

    /**
     * The badge will be added relative to this node.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'error', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the badge will be invisible.
     */
    invisible: propTypes.bool,

    /**
     * Max count to show.
     */
    max: propTypes.number,

    /**
     * Wrapped shape the badge should overlap.
     */
    overlap: propTypes.oneOf(['circle', 'rectangle']),

    /**
     * Controls whether the badge is hidden when `badgeContent` is zero.
     */
    showZero: propTypes.bool,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['dot', 'standard'])
  } ;
  var Badge$1 = withStyles$1(styles$5, {
    name: 'MuiBadge'
  })(Badge);

  var styles$6 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        justifyContent: 'center',
        height: 56,
        backgroundColor: theme.palette.background.paper
      }
    };
  };
  var BottomNavigation = React__default.forwardRef(function BottomNavigation(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        onChange = props.onChange,
        _props$showLabels = props.showLabels,
        showLabels = _props$showLabels === void 0 ? false : _props$showLabels,
        value = props.value,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "component", "onChange", "showLabels", "value"]);

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className),
      ref: ref
    }, other), React__default.Children.map(children, function (child, childIndex) {
      if (!React__default.isValidElement(child)) {
        return null;
      }

      {
        if (child.type === React__default.Fragment) {
          console.error(["Material-UI: the BottomNavigation component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      var childValue = child.props.value === undefined ? childIndex : child.props.value;
      return React__default.cloneElement(child, {
        selected: childValue === value,
        showLabel: child.props.showLabel !== undefined ? child.props.showLabel : showLabels,
        value: childValue,
        onChange: onChange
      });
    }));
  });
   BottomNavigation.propTypes = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Callback fired when the value changes.
     *
     * @param {object} event The event source of the callback
     * @param {any} value We default to the index of the child
     */
    onChange: propTypes.func,

    /**
     * If `true`, all `BottomNavigationAction`s will show their labels.
     * By default, only the selected `BottomNavigationAction` will show its label.
     */
    showLabels: propTypes.bool,

    /**
     * The value of the currently selected `BottomNavigationAction`.
     */
    value: propTypes.any
  } ;
  var BottomNavigation$1 = withStyles$1(styles$6, {
    name: 'MuiBottomNavigation'
  })(BottomNavigation);

  var useEnhancedEffect = typeof window !== 'undefined' ? React__default.useLayoutEffect : React__default.useEffect;
  /**
   * https://github.com/facebook/react/issues/14099#issuecomment-440013892
   *
   * @param {function} fn
   */

  function useEventCallback(fn) {
    var ref = React__default.useRef(fn);
    useEnhancedEffect(function () {
      ref.current = fn;
    });
    return React__default.useCallback(function () {
      return (ref.current).apply(void 0, arguments);
    }, []);
  }

  var useEnhancedEffect$1 = typeof window !== 'undefined' && "development" !== 'test' ? React__default.useLayoutEffect : React__default.useEffect;
  /**
   * NoSsr purposely removes components from the subject of Server Side Rendering (SSR).
   *
   * This component can be useful in a variety of situations:
   * - Escape hatch for broken dependencies not supporting SSR.
   * - Improve the time-to-first paint on the client by only rendering above the fold.
   * - Reduce the rendering time on the server.
   * - Under too heavy server load, you can turn on service degradation.
   */

  function NoSsr(props) {
    var children = props.children,
        _props$defer = props.defer,
        defer = _props$defer === void 0 ? false : _props$defer,
        _props$fallback = props.fallback,
        fallback = _props$fallback === void 0 ? null : _props$fallback;

    var _React$useState = React__default.useState(false),
        mountedState = _React$useState[0],
        setMountedState = _React$useState[1];

    useEnhancedEffect$1(function () {
      if (!defer) {
        setMountedState(true);
      }
    }, [defer]);
    React__default.useEffect(function () {
      if (defer) {
        setMountedState(true);
      }
    }, [defer]); // We need the Fragment here to force react-docgen to recognise NoSsr as a component.

    return React__default.createElement(React__default.Fragment, null, mountedState ? children : fallback);
  }

   NoSsr.propTypes = {
    /**
     * You can wrap a node.
     */
    children: propTypes.node.isRequired,

    /**
     * If `true`, the component will not only prevent server-side rendering.
     * It will also defer the rendering of the children into a different screen frame.
     */
    defer: propTypes.bool,

    /**
     * The fallback content to display.
     */
    fallback: propTypes.node
  } ;

  {
    // eslint-disable-next-line
    NoSsr['propTypes' + ''] = exactProp(NoSsr.propTypes);
  }

  // based on https://github.com/WICG/focus-visible/blob/v4.1.5/src/focus-visible.js
  var hadKeyboardEvent = true;
  var hadFocusVisibleRecently = false;
  var hadFocusVisibleRecentlyTimeout = null;
  var inputTypesWhitelist = {
    text: true,
    search: true,
    url: true,
    tel: true,
    email: true,
    password: true,
    number: true,
    date: true,
    month: true,
    week: true,
    time: true,
    datetime: true,
    'datetime-local': true
  };
  /**
   * Computes whether the given element should automatically trigger the
   * `focus-visible` class being added, i.e. whether it should always match
   * `:focus-visible` when focused.
   * @param {Element} node
   * @return {boolean}
   */

  function focusTriggersKeyboardModality(node) {
    var type = node.type,
        tagName = node.tagName;

    if (tagName === 'INPUT' && inputTypesWhitelist[type] && !node.readOnly) {
      return true;
    }

    if (tagName === 'TEXTAREA' && !node.readOnly) {
      return true;
    }

    if (node.isContentEditable) {
      return true;
    }

    return false;
  }
  /**
   * Keep track of our keyboard modality state with `hadKeyboardEvent`.
   * If the most recent user interaction was via the keyboard;
   * and the key press did not include a meta, alt/option, or control key;
   * then the modality is keyboard. Otherwise, the modality is not keyboard.
   * @param {KeyboardEvent} event
   */


  function handleKeyDown(event) {
    if (event.metaKey || event.altKey || event.ctrlKey) {
      return;
    }

    hadKeyboardEvent = true;
  }
  /**
   * If at any point a user clicks with a pointing device, ensure that we change
   * the modality away from keyboard.
   * This avoids the situation where a user presses a key on an already focused
   * element, and then clicks on a different element, focusing it with a
   * pointing device, while we still think we're in keyboard modality.
   */


  function handlePointerDown() {
    hadKeyboardEvent = false;
  }

  function handleVisibilityChange() {
    if (this.visibilityState === 'hidden') {
      // If the tab becomes active again, the browser will handle calling focus
      // on the element (Safari actually calls it twice).
      // If this tab change caused a blur on an element with focus-visible,
      // re-apply the class when the user switches back to the tab.
      if (hadFocusVisibleRecently) {
        hadKeyboardEvent = true;
      }
    }
  }

  function prepare(ownerDocument) {
    ownerDocument.addEventListener('keydown', handleKeyDown, true);
    ownerDocument.addEventListener('mousedown', handlePointerDown, true);
    ownerDocument.addEventListener('pointerdown', handlePointerDown, true);
    ownerDocument.addEventListener('touchstart', handlePointerDown, true);
    ownerDocument.addEventListener('visibilitychange', handleVisibilityChange, true);
  }

  function isFocusVisible(event) {
    var target = event.target;

    try {
      return target.matches(':focus-visible');
    } catch (error) {} // browsers not implementing :focus-visible will throw a SyntaxError
    // we use our own heuristic for those browsers
    // rethrow might be better if it's not the expected error but do we really
    // want to crash if focus-visible malfunctioned?
    // no need for validFocusTarget check. the user does that by attaching it to
    // focusable events only


    return hadKeyboardEvent || focusTriggersKeyboardModality(target);
  }
  /**
   * Should be called if a blur event is fired on a focus-visible element
   */


  function handleBlurVisible() {
    // To detect a tab/window switch, we look for a blur event followed
    // rapidly by a visibility change.
    // If we don't see a visibility change within 100ms, it's probably a
    // regular focus change.
    hadFocusVisibleRecently = true;
    window.clearTimeout(hadFocusVisibleRecentlyTimeout);
    hadFocusVisibleRecentlyTimeout = window.setTimeout(function () {
      hadFocusVisibleRecently = false;
    }, 100);
  }

  function useIsFocusVisible() {
    var ref = React__default.useCallback(function (instance) {
      var node = ReactDOM.findDOMNode(instance);

      if (node != null) {
        prepare(node.ownerDocument);
      }
    }, []);
    return {
      isFocusVisible: isFocusVisible,
      onBlurVisible: handleBlurVisible,
      ref: ref
    };
  }

  var useEnhancedEffect$2 = typeof window === 'undefined' ? React__default.useEffect : React__default.useLayoutEffect;
  /**
   * @ignore - internal component.
   */

  function Ripple(props) {
    var classes = props.classes,
        _props$pulsate = props.pulsate,
        pulsate = _props$pulsate === void 0 ? false : _props$pulsate,
        rippleX = props.rippleX,
        rippleY = props.rippleY,
        rippleSize = props.rippleSize,
        inProp = props.in,
        _props$onExited = props.onExited,
        onExited = _props$onExited === void 0 ? function () {} : _props$onExited,
        timeout = props.timeout;

    var _React$useState = React__default.useState(false),
        leaving = _React$useState[0],
        setLeaving = _React$useState[1];

    var rippleClassName = clsx(classes.ripple, classes.rippleVisible, pulsate && classes.ripplePulsate);
    var rippleStyles = {
      width: rippleSize,
      height: rippleSize,
      top: -(rippleSize / 2) + rippleY,
      left: -(rippleSize / 2) + rippleX
    };
    var childClassName = clsx(classes.child, leaving && classes.childLeaving, pulsate && classes.childPulsate);
    var handleExited = useEventCallback(onExited); // Ripple is used for user feedback (e.g. click or press) so we want to apply styles with the highest priority

    useEnhancedEffect$2(function () {
      if (!inProp) {
        // react-transition-group#onExit
        setLeaving(true); // react-transition-group#onExited

        var timeoutId = setTimeout(handleExited, timeout);
        return function () {
          clearTimeout(timeoutId);
        };
      }

      return undefined;
    }, [handleExited, inProp, timeout]);
    return React__default.createElement("span", {
      className: rippleClassName,
      style: rippleStyles
    }, React__default.createElement("span", {
      className: childClassName
    }));
  }

   Ripple.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore - injected from TransitionGroup
     */
    in: propTypes.bool,

    /**
     * @ignore - injected from TransitionGroup
     */
    onExited: propTypes.func,

    /**
     * If `true`, the ripple pulsates, typically indicating the keyboard focus state of an element.
     */
    pulsate: propTypes.bool,

    /**
     * Diameter of the ripple.
     */
    rippleSize: propTypes.number,

    /**
     * Horizontal position of the ripple center.
     */
    rippleX: propTypes.number,

    /**
     * Vertical position of the ripple center.
     */
    rippleY: propTypes.number,

    /**
     * exit delay
     */
    timeout: propTypes.number.isRequired
  } ;

  var DURATION = 550;
  var DELAY_RIPPLE = 80;
  var styles$7 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        overflow: 'hidden',
        pointerEvents: 'none',
        position: 'absolute',
        zIndex: 0,
        top: 0,
        right: 0,
        bottom: 0,
        left: 0,
        borderRadius: 'inherit'
      },

      /* Styles applied to the internal `Ripple` components `ripple` class. */
      ripple: {
        opacity: 0,
        position: 'absolute'
      },

      /* Styles applied to the internal `Ripple` components `rippleVisible` class. */
      rippleVisible: {
        opacity: 0.3,
        transform: 'scale(1)',
        animation: "$enter ".concat(DURATION, "ms ").concat(theme.transitions.easing.easeInOut)
      },

      /* Styles applied to the internal `Ripple` components `ripplePulsate` class. */
      ripplePulsate: {
        animationDuration: "".concat(theme.transitions.duration.shorter, "ms")
      },

      /* Styles applied to the internal `Ripple` components `child` class. */
      child: {
        opacity: 1,
        display: 'block',
        width: '100%',
        height: '100%',
        borderRadius: '50%',
        backgroundColor: 'currentColor'
      },

      /* Styles applied to the internal `Ripple` components `childLeaving` class. */
      childLeaving: {
        opacity: 0,
        animation: "$exit ".concat(DURATION, "ms ").concat(theme.transitions.easing.easeInOut)
      },

      /* Styles applied to the internal `Ripple` components `childPulsate` class. */
      childPulsate: {
        position: 'absolute',
        left: 0,
        top: 0,
        animation: "$pulsate 2500ms ".concat(theme.transitions.easing.easeInOut, " 200ms infinite")
      },
      '@keyframes enter': {
        '0%': {
          transform: 'scale(0)',
          opacity: 0.1
        },
        '100%': {
          transform: 'scale(1)',
          opacity: 0.3
        }
      },
      '@keyframes exit': {
        '0%': {
          opacity: 1
        },
        '100%': {
          opacity: 0
        }
      },
      '@keyframes pulsate': {
        '0%': {
          transform: 'scale(1)'
        },
        '50%': {
          transform: 'scale(0.92)'
        },
        '100%': {
          transform: 'scale(1)'
        }
      }
    };
  };
  /**
   * @ignore - internal component.
   *
   * TODO v5: Make private
   */

  var TouchRipple = React__default.forwardRef(function TouchRipple(props, ref) {
    var _props$center = props.center,
        centerProp = _props$center === void 0 ? false : _props$center,
        classes = props.classes,
        className = props.className,
        other = _objectWithoutProperties(props, ["center", "classes", "className"]);

    var _React$useState = React__default.useState([]),
        ripples = _React$useState[0],
        setRipples = _React$useState[1];

    var nextKey = React__default.useRef(0);
    var rippleCallback = React__default.useRef(null);
    React__default.useEffect(function () {
      if (rippleCallback.current) {
        rippleCallback.current();
        rippleCallback.current = null;
      }
    }, [ripples]); // Used to filter out mouse emulated events on mobile.

    var ignoringMouseDown = React__default.useRef(false); // We use a timer in order to only show the ripples for touch "click" like events.
    // We don't want to display the ripple for touch scroll events.

    var startTimer = React__default.useRef(null); // This is the hook called once the previous timeout is ready.

    var startTimerCommit = React__default.useRef(null);
    var container = React__default.useRef(null);
    React__default.useEffect(function () {
      return function () {
        clearTimeout(startTimer.current);
      };
    }, []);
    var startCommit = React__default.useCallback(function (params) {
      var pulsate = params.pulsate,
          rippleX = params.rippleX,
          rippleY = params.rippleY,
          rippleSize = params.rippleSize,
          cb = params.cb;
      setRipples(function (oldRipples) {
        return [].concat(_toConsumableArray(oldRipples), [React__default.createElement(Ripple, {
          key: nextKey.current,
          classes: classes,
          timeout: DURATION,
          pulsate: pulsate,
          rippleX: rippleX,
          rippleY: rippleY,
          rippleSize: rippleSize
        })]);
      });
      nextKey.current += 1;
      rippleCallback.current = cb;
    }, [classes]);
    var start = React__default.useCallback(function () {
      var event = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var cb = arguments.length > 2 ? arguments[2] : undefined;
      var _options$pulsate = options.pulsate,
          pulsate = _options$pulsate === void 0 ? false : _options$pulsate,
          _options$center = options.center,
          center = _options$center === void 0 ? centerProp || options.pulsate : _options$center,
          _options$fakeElement = options.fakeElement,
          fakeElement = _options$fakeElement === void 0 ? false : _options$fakeElement;

      if (event.type === 'mousedown' && ignoringMouseDown.current) {
        ignoringMouseDown.current = false;
        return;
      }

      if (event.type === 'touchstart') {
        ignoringMouseDown.current = true;
      }

      var element = fakeElement ? null : container.current;
      var rect = element ? element.getBoundingClientRect() : {
        width: 0,
        height: 0,
        left: 0,
        top: 0
      }; // Get the size of the ripple

      var rippleX;
      var rippleY;
      var rippleSize;

      if (center || event.clientX === 0 && event.clientY === 0 || !event.clientX && !event.touches) {
        rippleX = Math.round(rect.width / 2);
        rippleY = Math.round(rect.height / 2);
      } else {
        var clientX = event.clientX ? event.clientX : event.touches[0].clientX;
        var clientY = event.clientY ? event.clientY : event.touches[0].clientY;
        rippleX = Math.round(clientX - rect.left);
        rippleY = Math.round(clientY - rect.top);
      }

      if (center) {
        rippleSize = Math.sqrt((2 * Math.pow(rect.width, 2) + Math.pow(rect.height, 2)) / 3); // For some reason the animation is broken on Mobile Chrome if the size if even.

        if (rippleSize % 2 === 0) {
          rippleSize += 1;
        }
      } else {
        var sizeX = Math.max(Math.abs((element ? element.clientWidth : 0) - rippleX), rippleX) * 2 + 2;
        var sizeY = Math.max(Math.abs((element ? element.clientHeight : 0) - rippleY), rippleY) * 2 + 2;
        rippleSize = Math.sqrt(Math.pow(sizeX, 2) + Math.pow(sizeY, 2));
      } // Touche devices


      if (event.touches) {
        // Prepare the ripple effect.
        startTimerCommit.current = function () {
          startCommit({
            pulsate: pulsate,
            rippleX: rippleX,
            rippleY: rippleY,
            rippleSize: rippleSize,
            cb: cb
          });
        }; // Delay the execution of the ripple effect.


        startTimer.current = setTimeout(function () {
          if (startTimerCommit.current) {
            startTimerCommit.current();
            startTimerCommit.current = null;
          }
        }, DELAY_RIPPLE); // We have to make a tradeoff with this value.
      } else {
        startCommit({
          pulsate: pulsate,
          rippleX: rippleX,
          rippleY: rippleY,
          rippleSize: rippleSize,
          cb: cb
        });
      }
    }, [centerProp, startCommit]);
    var pulsate = React__default.useCallback(function () {
      start({}, {
        pulsate: true
      });
    }, [start]);
    var stop = React__default.useCallback(function (event, cb) {
      clearTimeout(startTimer.current); // The touch interaction occurs too quickly.
      // We still want to show ripple effect.

      if (event.type === 'touchend' && startTimerCommit.current) {
        event.persist();
        startTimerCommit.current();
        startTimerCommit.current = null;
        startTimer.current = setTimeout(function () {
          stop(event, cb);
        });
        return;
      }

      startTimerCommit.current = null;
      setRipples(function (oldRipples) {
        if (oldRipples.length > 0) {
          return oldRipples.slice(1);
        }

        return oldRipples;
      });
      rippleCallback.current = cb;
    }, []);
    React__default.useImperativeHandle(ref, function () {
      return {
        pulsate: pulsate,
        start: start,
        stop: stop
      };
    }, [pulsate, start, stop]);
    return React__default.createElement("span", _extends({
      className: clsx(classes.root, className),
      ref: container
    }, other), React__default.createElement(TransitionGroup, {
      component: null,
      exit: true
    }, ripples));
  }); // TODO cleanup after https://github.com/reactjs/react-docgen/pull/378 is released

  function withMuiName(Component) {
    Component.muiName = 'MuiTouchRipple';
    return Component;
  }

   TouchRipple.propTypes = {
    /**
     * If `true`, the ripple starts at the center of the component
     * rather than at the point of interaction.
     */
    center: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  } ;
  var TouchRipple$1 = withStyles$1(styles$7, {
    flip: false,
    name: 'MuiTouchRipple'
  })(withMuiName(React__default.memo(TouchRipple)));

  var styles$8 = {
    /* Styles applied to the root element. */
    root: {
      display: 'inline-flex',
      alignItems: 'center',
      justifyContent: 'center',
      position: 'relative',
      // Remove grey highlight
      WebkitTapHighlightColor: 'transparent',
      backgroundColor: 'transparent',
      // Reset default value
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 0,
      border: 0,
      margin: 0,
      // Remove the margin in Safari
      borderRadius: 0,
      padding: 0,
      // Remove the padding in Firefox
      cursor: 'pointer',
      userSelect: 'none',
      verticalAlign: 'middle',
      '-moz-appearance': 'none',
      // Reset
      '-webkit-appearance': 'none',
      // Reset
      textDecoration: 'none',
      // So we take precedent over the style of a native <a /> element.
      color: 'inherit',
      '&::-moz-focus-inner': {
        borderStyle: 'none' // Remove Firefox dotted outline.

      },
      '&$disabled': {
        pointerEvents: 'none',
        // Disable link interactions
        cursor: 'default'
      }
    },

    /* Pseudo-class applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Pseudo-class applied to the root element if keyboard focused. */
    focusVisible: {}
  };
  /**
   * `ButtonBase` contains as few styles as possible.
   * It aims to be a simple building block for creating a button.
   * It contains a load of style reset and some focus/ripple logic.
   */

  var ButtonBase = React__default.forwardRef(function ButtonBase(props, ref) {
    var action = props.action,
        buttonRefProp = props.buttonRef,
        _props$centerRipple = props.centerRipple,
        centerRipple = _props$centerRipple === void 0 ? false : _props$centerRipple,
        children = props.children,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        component = _props$component === void 0 ? 'button' : _props$component,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$disableRipple = props.disableRipple,
        disableRipple = _props$disableRipple === void 0 ? false : _props$disableRipple,
        _props$disableTouchRi = props.disableTouchRipple,
        disableTouchRipple = _props$disableTouchRi === void 0 ? false : _props$disableTouchRi,
        _props$focusRipple = props.focusRipple,
        focusRipple = _props$focusRipple === void 0 ? false : _props$focusRipple,
        focusVisibleClassName = props.focusVisibleClassName,
        onBlur = props.onBlur,
        onClick = props.onClick,
        onFocus = props.onFocus,
        onFocusVisible = props.onFocusVisible,
        onKeyDown = props.onKeyDown,
        onKeyUp = props.onKeyUp,
        onMouseDown = props.onMouseDown,
        onMouseLeave = props.onMouseLeave,
        onMouseUp = props.onMouseUp,
        onTouchEnd = props.onTouchEnd,
        onTouchMove = props.onTouchMove,
        onTouchStart = props.onTouchStart,
        onDragLeave = props.onDragLeave,
        _props$tabIndex = props.tabIndex,
        tabIndex = _props$tabIndex === void 0 ? 0 : _props$tabIndex,
        TouchRippleProps = props.TouchRippleProps,
        _props$type = props.type,
        type = _props$type === void 0 ? 'button' : _props$type,
        other = _objectWithoutProperties(props, ["action", "buttonRef", "centerRipple", "children", "classes", "className", "component", "disabled", "disableRipple", "disableTouchRipple", "focusRipple", "focusVisibleClassName", "onBlur", "onClick", "onFocus", "onFocusVisible", "onKeyDown", "onKeyUp", "onMouseDown", "onMouseLeave", "onMouseUp", "onTouchEnd", "onTouchMove", "onTouchStart", "onDragLeave", "tabIndex", "TouchRippleProps", "type"]);

    var buttonRef = React__default.useRef(null);

    function getButtonNode() {
      // #StrictMode ready
      return ReactDOM.findDOMNode(buttonRef.current);
    }

    var rippleRef = React__default.useRef(null);

    var _React$useState = React__default.useState(false),
        focusVisible = _React$useState[0],
        setFocusVisible = _React$useState[1];

    if (disabled && focusVisible) {
      setFocusVisible(false);
    }

    var _useIsFocusVisible = useIsFocusVisible(),
        isFocusVisible = _useIsFocusVisible.isFocusVisible,
        onBlurVisible = _useIsFocusVisible.onBlurVisible,
        focusVisibleRef = _useIsFocusVisible.ref;

    React__default.useImperativeHandle(action, function () {
      return {
        focusVisible: function focusVisible() {
          setFocusVisible(true);
          buttonRef.current.focus();
        }
      };
    }, []);
    React__default.useEffect(function () {
      if (focusVisible && focusRipple && !disableRipple) {
        rippleRef.current.pulsate();
      }
    }, [disableRipple, focusRipple, focusVisible]);

    function useRippleHandler(rippleAction, eventCallback) {
      var skipRippleAction = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : disableTouchRipple;
      return useEventCallback(function (event) {
        if (eventCallback) {
          eventCallback(event);
        }

        var ignore = skipRippleAction;

        if (!ignore && rippleRef.current) {
          rippleRef.current[rippleAction](event);
        }

        return true;
      });
    }

    var handleMouseDown = useRippleHandler('start', onMouseDown);
    var handleDragLeave = useRippleHandler('stop', onDragLeave);
    var handleMouseUp = useRippleHandler('stop', onMouseUp);
    var handleMouseLeave = useRippleHandler('stop', function (event) {
      if (focusVisible) {
        event.preventDefault();
      }

      if (onMouseLeave) {
        onMouseLeave(event);
      }
    });
    var handleTouchStart = useRippleHandler('start', onTouchStart);
    var handleTouchEnd = useRippleHandler('stop', onTouchEnd);
    var handleTouchMove = useRippleHandler('stop', onTouchMove);
    var handleBlur = useRippleHandler('stop', function (event) {
      if (focusVisible) {
        onBlurVisible(event);
        setFocusVisible(false);
      }

      if (onBlur) {
        onBlur(event);
      }
    }, false);
    var handleFocus = useEventCallback(function (event) {
      if (disabled) {
        return;
      } // Fix for https://github.com/facebook/react/issues/7769


      if (!buttonRef.current) {
        buttonRef.current = event.currentTarget;
      }

      if (isFocusVisible(event)) {
        setFocusVisible(true);

        if (onFocusVisible) {
          onFocusVisible(event);
        }
      }

      if (onFocus) {
        onFocus(event);
      }
    });

    var isNonNativeButton = function isNonNativeButton() {
      var button = getButtonNode();
      return component && component !== 'button' && !(button.tagName === 'A' && button.href);
    };
    /**
     * IE 11 shim for https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/repeat
     */


    var keydownRef = React__default.useRef(false);
    var handleKeyDown = useEventCallback(function (event) {
      // Check if key is already down to avoid repeats being counted as multiple activations
      if (focusRipple && !keydownRef.current && focusVisible && rippleRef.current && event.key === ' ') {
        keydownRef.current = true;
        event.persist();
        rippleRef.current.stop(event, function () {
          rippleRef.current.start(event);
        });
      }

      if (onKeyDown) {
        onKeyDown(event);
      } // Keyboard accessibility for non interactive elements


      if (event.target === event.currentTarget && isNonNativeButton() && event.key === 'Enter') {
        event.preventDefault();

        if (onClick) {
          onClick(event);
        }
      }
    });
    var handleKeyUp = useEventCallback(function (event) {
      if (focusRipple && event.key === ' ' && rippleRef.current && focusVisible) {
        keydownRef.current = false;
        event.persist();
        rippleRef.current.stop(event, function () {
          rippleRef.current.pulsate(event);
        });
      }

      if (onKeyUp) {
        onKeyUp(event);
      } // Keyboard accessibility for non interactive elements


      if (event.target === event.currentTarget && isNonNativeButton() && event.key === ' ') {
        event.preventDefault();

        if (onClick) {
          onClick(event);
        }
      }
    });
    var ComponentProp = component;

    if (ComponentProp === 'button' && other.href) {
      ComponentProp = 'a';
    }

    var buttonProps = {};

    if (ComponentProp === 'button') {
      buttonProps.type = type;
      buttonProps.disabled = disabled;
    } else {
      if (ComponentProp !== 'a' || !other.href) {
        buttonProps.role = 'button';
      }

      buttonProps['aria-disabled'] = disabled;
    }

    var handleUserRef = useForkRef(buttonRefProp, ref);
    var handleOwnRef = useForkRef(focusVisibleRef, buttonRef);
    var handleRef = useForkRef(handleUserRef, handleOwnRef);
    return React__default.createElement(ComponentProp, _extends({
      className: clsx(classes.root, className, focusVisible && [classes.focusVisible, focusVisibleClassName], disabled && classes.disabled),
      onBlur: handleBlur,
      onClick: onClick,
      onFocus: handleFocus,
      onKeyDown: handleKeyDown,
      onKeyUp: handleKeyUp,
      onMouseDown: handleMouseDown,
      onMouseLeave: handleMouseLeave,
      onMouseUp: handleMouseUp,
      onDragLeave: handleDragLeave,
      onTouchEnd: handleTouchEnd,
      onTouchMove: handleTouchMove,
      onTouchStart: handleTouchStart,
      ref: handleRef,
      tabIndex: disabled ? -1 : tabIndex
    }, buttonProps, other), children, !disableRipple && !disabled ? React__default.createElement(NoSsr, null, React__default.createElement(TouchRipple$1, _extends({
      ref: rippleRef,
      center: centerRipple
    }, TouchRippleProps))) : null);
  });
   ButtonBase.propTypes = {
    /**
     * A ref for imperative actions.
     * It currently only supports `focusVisible()` action.
     */
    action: refType,

    /**
     * @ignore
     *
     * Use that prop to pass a ref to the native button component.
     * @deprecated Use `ref` instead.
     */
    buttonRef: refType,

    /**
     * If `true`, the ripples will be centered.
     * They won't start at the cursor interaction position.
     */
    centerRipple: propTypes.bool,

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: elementTypeAcceptingRef$1,

    /**
     * If `true`, the base button will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     *
     * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
     * to highlight the element by applying separate styles with the `focusVisibleClassName`.
     */
    disableRipple: propTypes.bool,

    /**
     * If `true`, the touch ripple effect will be disabled.
     */
    disableTouchRipple: propTypes.bool,

    /**
     * If `true`, the base button will have a keyboard focus ripple.
     * `disableRipple` must also be `false`.
     */
    focusRipple: propTypes.bool,

    /**
     * This prop can help a person know which element has the keyboard focus.
     * The class name will be applied when the element gain the focus through a keyboard interaction.
     * It's a polyfill for the [CSS :focus-visible selector](https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo).
     * The rationale for using this feature [is explained here](https://github.com/WICG/focus-visible/blob/master/explainer.md).
     * A [polyfill can be used](https://github.com/WICG/focus-visible) to apply a `focus-visible` class to other components
     * if needed.
     */
    focusVisibleClassName: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * @ignore
     */
    onDragLeave: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * Callback fired when the component is focused with a keyboard.
     * We trigger a `onFocus` callback too.
     */
    onFocusVisible: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * @ignore
     */
    onKeyUp: propTypes.func,

    /**
     * @ignore
     */
    onMouseDown: propTypes.func,

    /**
     * @ignore
     */
    onMouseLeave: propTypes.func,

    /**
     * @ignore
     */
    onMouseUp: propTypes.func,

    /**
     * @ignore
     */
    onTouchEnd: propTypes.func,

    /**
     * @ignore
     */
    onTouchMove: propTypes.func,

    /**
     * @ignore
     */
    onTouchStart: propTypes.func,

    /**
     * @ignore
     */
    role: propTypes.string,

    /**
     * @ignore
     */
    tabIndex: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * Props applied to the `TouchRipple` element.
     */
    TouchRippleProps: propTypes.object,

    /**
     * Used to control the button's purpose.
     * This prop passes the value to the `type` attribute of the native button component.
     */
    type: propTypes.oneOf(['submit', 'reset', 'button'])
  } ;
  var ButtonBase$1 = withStyles$1(styles$8, {
    name: 'MuiButtonBase'
  })(ButtonBase);

  function unsupportedProp(props, propName, componentName, location, propFullName) {

    var propFullNameSafe = propFullName || propName;

    if (typeof props[propName] !== 'undefined') {
      return new Error("The prop `".concat(propFullNameSafe, "` is not supported. Please remove it."));
    }

    return null;
  }

  var styles$9 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        transition: theme.transitions.create(['color', 'padding-top'], {
          duration: theme.transitions.duration.short
        }),
        padding: '6px 12px 8px',
        minWidth: 80,
        maxWidth: 168,
        color: theme.palette.text.secondary,
        flex: '1',
        '&$iconOnly': {
          paddingTop: 16
        },
        '&$selected': {
          paddingTop: 6,
          color: theme.palette.primary.main
        }
      },

      /* Pseudo-class applied to the root element if selected. */
      selected: {},

      /* Pseudo-class applied to the root element if `showLabel={false}` and not selected. */
      iconOnly: {},

      /* Styles applied to the span element that wraps the icon and label. */
      wrapper: {
        display: 'inline-flex',
        alignItems: 'center',
        justifyContent: 'center',
        width: '100%',
        flexDirection: 'column'
      },

      /* Styles applied to the label's span element. */
      label: {
        fontFamily: theme.typography.fontFamily,
        fontSize: theme.typography.pxToRem(12),
        opacity: 1,
        transition: 'font-size 0.2s, opacity 0.2s',
        transitionDelay: '0.1s',
        '&$iconOnly': {
          opacity: 0,
          transitionDelay: '0s'
        },
        '&$selected': {
          fontSize: theme.typography.pxToRem(14)
        }
      }
    };
  };
  var BottomNavigationAction = React__default.forwardRef(function BottomNavigationAction(props, ref) {
    var classes = props.classes,
        className = props.className,
        icon = props.icon,
        label = props.label,
        onChange = props.onChange,
        onClick = props.onClick,
        selected = props.selected,
        showLabel = props.showLabel,
        value = props.value,
        other = _objectWithoutProperties(props, ["classes", "className", "icon", "label", "onChange", "onClick", "selected", "showLabel", "value"]);

    var handleChange = function handleChange(event) {
      if (onChange) {
        onChange(event, value);
      }

      if (onClick) {
        onClick(event);
      }
    };

    return React__default.createElement(ButtonBase$1, _extends({
      ref: ref,
      className: clsx(classes.root, className, selected ? classes.selected : !showLabel && classes.iconOnly),
      focusRipple: true,
      onClick: handleChange
    }, other), React__default.createElement("span", {
      className: classes.wrapper
    }, icon, React__default.createElement("span", {
      className: clsx(classes.label, selected ? classes.selected : !showLabel && classes.iconOnly)
    }, label)));
  });
   BottomNavigationAction.propTypes = {
    /**
     * This prop isn't supported.
     * Use the `component` prop if you need to change the children structure.
     */
    children: unsupportedProp,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The icon element.
     */
    icon: propTypes.node,

    /**
     * The label element.
     */
    label: propTypes.node,

    /**
     * @ignore
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * @ignore
     */
    selected: propTypes.bool,

    /**
     * If `true`, the `BottomNavigationAction` will show its label.
     * By default, only the selected `BottomNavigationAction`
     * inside `BottomNavigation` will show its label.
     */
    showLabel: propTypes.bool,

    /**
     * You can provide your own value. Otherwise, we fallback to the child position index.
     */
    value: propTypes.any
  } ;
  var BottomNavigationAction$1 = withStyles$1(styles$9, {
    name: 'MuiBottomNavigationAction'
  })(BottomNavigationAction);

  var responsivePropType =  propTypes.oneOfType([propTypes.number, propTypes.string, propTypes.object, propTypes.array]) ;

  function merge(acc, item) {
    if (!item) {
      return acc;
    }

    return deepmerge(acc, item, {
      clone: false // No need to clone deep, it's way faster.

    });
  }

  // For instance with the first breakpoint xs: [xs, sm[.

  var values$1 = {
    xs: 0,
    sm: 600,
    md: 960,
    lg: 1280,
    xl: 1920
  };
  var defaultBreakpoints = {
    // Sorted ASC by size. That's important.
    // It can't be configured as it's used statically for propTypes.
    keys: ['xs', 'sm', 'md', 'lg', 'xl'],
    up: function up(key) {
      return "@media (min-width:".concat(values$1[key], "px)");
    }
  };
  function handleBreakpoints(props, propValue, styleFromPropValue) {
    {
      if (!props.theme) {
        console.error('@material-ui/system: you are calling a style function without a theme value.');
      }
    }

    if (Array.isArray(propValue)) {
      var themeBreakpoints = props.theme.breakpoints || defaultBreakpoints;
      return propValue.reduce(function (acc, item, index) {
        acc[themeBreakpoints.up(themeBreakpoints.keys[index])] = styleFromPropValue(propValue[index]);
        return acc;
      }, {});
    }

    if (_typeof(propValue) === 'object') {
      var _themeBreakpoints = props.theme.breakpoints || defaultBreakpoints;

      return Object.keys(propValue).reduce(function (acc, breakpoint) {
        acc[_themeBreakpoints.up(breakpoint)] = styleFromPropValue(propValue[breakpoint]);
        return acc;
      }, {});
    }

    var output = styleFromPropValue(propValue);
    return output;
  }

  function getPath(obj, path) {
    if (!path || typeof path !== 'string') {
      return null;
    }

    return path.split('.').reduce(function (acc, item) {
      return acc && acc[item] ? acc[item] : null;
    }, obj);
  }

  function style$1(options) {
    var prop = options.prop,
        _options$cssProperty = options.cssProperty,
        cssProperty = _options$cssProperty === void 0 ? options.prop : _options$cssProperty,
        themeKey = options.themeKey,
        transform = options.transform;

    var fn = function fn(props) {
      if (props[prop] == null) {
        return null;
      }

      var propValue = props[prop];
      var theme = props.theme;
      var themeMapping = getPath(theme, themeKey) || {};

      var styleFromPropValue = function styleFromPropValue(propValueFinal) {
        var value;

        if (typeof themeMapping === 'function') {
          value = themeMapping(propValueFinal);
        } else if (Array.isArray(themeMapping)) {
          value = themeMapping[propValueFinal] || propValueFinal;
        } else {
          value = getPath(themeMapping, propValueFinal) || propValueFinal;

          if (transform) {
            value = transform(value);
          }
        }

        if (cssProperty === false) {
          return value;
        }

        return _defineProperty({}, cssProperty, value);
      };

      return handleBreakpoints(props, propValue, styleFromPropValue);
    };

    fn.propTypes =  _defineProperty({}, prop, responsivePropType) ;
    fn.filterProps = [prop];
    return fn;
  }

  function compose() {
    for (var _len = arguments.length, styles = new Array(_len), _key = 0; _key < _len; _key++) {
      styles[_key] = arguments[_key];
    }

    var fn = function fn(props) {
      return styles.reduce(function (acc, style) {
        var output = style(props);

        if (output) {
          return merge(acc, output);
        }

        return acc;
      }, {});
    }; // Alternative approach that doesn't yield any performance gain.
    // const handlers = styles.reduce((acc, style) => {
    //   style.filterProps.forEach(prop => {
    //     acc[prop] = style;
    //   });
    //   return acc;
    // }, {});
    // const fn = props => {
    //   return Object.keys(props).reduce((acc, prop) => {
    //     if (handlers[prop]) {
    //       return merge(acc, handlers[prop](props));
    //     }
    //     return acc;
    //   }, {});
    // };


    fn.propTypes =  styles.reduce(function (acc, style) {
      return _extends(acc, style.propTypes);
    }, {}) ;
    fn.filterProps = styles.reduce(function (acc, style) {
      return acc.concat(style.filterProps);
    }, []);
    return fn;
  }

  function getBorder(value) {
    if (typeof value !== 'number') {
      return value;
    }

    return "".concat(value, "px solid");
  }

  var border = style$1({
    prop: 'border',
    themeKey: 'borders',
    transform: getBorder
  });
  var borderTop = style$1({
    prop: 'borderTop',
    themeKey: 'borders',
    transform: getBorder
  });
  var borderRight = style$1({
    prop: 'borderRight',
    themeKey: 'borders',
    transform: getBorder
  });
  var borderBottom = style$1({
    prop: 'borderBottom',
    themeKey: 'borders',
    transform: getBorder
  });
  var borderLeft = style$1({
    prop: 'borderLeft',
    themeKey: 'borders',
    transform: getBorder
  });
  var borderColor = style$1({
    prop: 'borderColor',
    themeKey: 'palette'
  });
  var borderRadius = style$1({
    prop: 'borderRadius',
    themeKey: 'shape'
  });
  var borders = compose(border, borderTop, borderRight, borderBottom, borderLeft, borderColor, borderRadius);

  function omit$1(input, fields) {
    var output = {};
    Object.keys(input).forEach(function (prop) {
      if (fields.indexOf(prop) === -1) {
        output[prop] = input[prop];
      }
    });
    return output;
  }

  function css$1(styleFunction) {
    var newStyleFunction = function newStyleFunction(props) {
      var output = styleFunction(props);

      if (props.css) {
        return _extends({}, merge(output, styleFunction(_extends({
          theme: props.theme
        }, props.css))), {}, omit$1(props.css, [styleFunction.filterProps]));
      }

      return output;
    };

    newStyleFunction.propTypes =  _extends({}, styleFunction.propTypes, {
      css: propTypes.object
    }) ;
    newStyleFunction.filterProps = ['css'].concat(_toConsumableArray(styleFunction.filterProps));
    return newStyleFunction;
  }

  var displayPrint = style$1({
    prop: 'displayPrint',
    cssProperty: false,
    transform: function transform(value) {
      return {
        '@media print': {
          display: value
        }
      };
    }
  });
  var displayRaw = style$1({
    prop: 'display'
  });
  var overflow = style$1({
    prop: 'overflow'
  });
  var textOverflow = style$1({
    prop: 'textOverflow'
  });
  var visibility = style$1({
    prop: 'visibility'
  });
  var whiteSpace = style$1({
    prop: 'whiteSpace'
  });
  var display = compose(displayPrint, displayRaw, overflow, textOverflow, visibility, whiteSpace);

  var flexBasis = style$1({
    prop: 'flexBasis'
  });
  var flexDirection = style$1({
    prop: 'flexDirection'
  });
  var flexWrap = style$1({
    prop: 'flexWrap'
  });
  var justifyContent = style$1({
    prop: 'justifyContent'
  });
  var alignItems = style$1({
    prop: 'alignItems'
  });
  var alignContent = style$1({
    prop: 'alignContent'
  });
  var order = style$1({
    prop: 'order'
  });
  var flex = style$1({
    prop: 'flex'
  });
  var flexGrow = style$1({
    prop: 'flexGrow'
  });
  var flexShrink = style$1({
    prop: 'flexShrink'
  });
  var alignSelf = style$1({
    prop: 'alignSelf'
  });
  var justifyItems = style$1({
    prop: 'justifyItems'
  });
  var justifySelf = style$1({
    prop: 'justifySelf'
  });
  var flexbox = compose(flexBasis, flexDirection, flexWrap, justifyContent, alignItems, alignContent, order, flex, flexGrow, flexShrink, alignSelf, justifyItems, justifySelf);

  var color = style$1({
    prop: 'color',
    themeKey: 'palette'
  });
  var bgcolor = style$1({
    prop: 'bgcolor',
    cssProperty: 'backgroundColor',
    themeKey: 'palette'
  });
  var palette = compose(color, bgcolor);

  var position = style$1({
    prop: 'position'
  });
  var zIndex$1 = style$1({
    prop: 'zIndex',
    themeKey: 'zIndex'
  });
  var top = style$1({
    prop: 'top'
  });
  var right = style$1({
    prop: 'right'
  });
  var bottom = style$1({
    prop: 'bottom'
  });
  var left = style$1({
    prop: 'left'
  });
  var positions = compose(position, zIndex$1, top, right, bottom, left);

  var boxShadow = style$1({
    prop: 'boxShadow',
    themeKey: 'shadows'
  });

  function transform$1(value) {
    return value <= 1 ? "".concat(value * 100, "%") : value;
  }

  var width = style$1({
    prop: 'width',
    transform: transform$1
  });
  var maxWidth = style$1({
    prop: 'maxWidth',
    transform: transform$1
  });
  var minWidth = style$1({
    prop: 'minWidth',
    transform: transform$1
  });
  var height = style$1({
    prop: 'height',
    transform: transform$1
  });
  var maxHeight = style$1({
    prop: 'maxHeight',
    transform: transform$1
  });
  var minHeight = style$1({
    prop: 'minHeight',
    transform: transform$1
  });
  var sizeWidth = style$1({
    prop: 'size',
    cssProperty: 'width',
    transform: transform$1
  });
  var sizeHeight = style$1({
    prop: 'size',
    cssProperty: 'height',
    transform: transform$1
  });
  var sizing = compose(width, maxWidth, minWidth, height, maxHeight, minHeight);

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }

    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function memoize$1(fn) {
    var cache = {};
    return function (arg) {
      if (cache[arg] === undefined) {
        cache[arg] = fn(arg);
      }

      return cache[arg];
    };
  }

  var properties = {
    m: 'margin',
    p: 'padding'
  };
  var directions = {
    t: 'Top',
    r: 'Right',
    b: 'Bottom',
    l: 'Left',
    x: ['Left', 'Right'],
    y: ['Top', 'Bottom']
  };
  var aliases = {
    marginX: 'mx',
    marginY: 'my',
    paddingX: 'px',
    paddingY: 'py'
  }; // memoize() impact:
  // From 300,000 ops/sec
  // To 350,000 ops/sec

  var getCssProperties = memoize$1(function (prop) {
    // It's not a shorthand notation.
    if (prop.length > 2) {
      if (aliases[prop]) {
        prop = aliases[prop];
      } else {
        return [prop];
      }
    }

    var _prop$split = prop.split(''),
        _prop$split2 = _slicedToArray(_prop$split, 2),
        a = _prop$split2[0],
        b = _prop$split2[1];

    var property = properties[a];
    var direction = directions[b] || '';
    return Array.isArray(direction) ? direction.map(function (dir) {
      return property + dir;
    }) : [property + direction];
  });
  var spacingKeys = ['m', 'mt', 'mr', 'mb', 'ml', 'mx', 'my', 'p', 'pt', 'pr', 'pb', 'pl', 'px', 'py', 'margin', 'marginTop', 'marginRight', 'marginBottom', 'marginLeft', 'marginX', 'marginY', 'padding', 'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft', 'paddingX', 'paddingY'];

  function getTransformer(theme) {
    var themeSpacing = theme.spacing || 8;

    if (typeof themeSpacing === 'number') {
      return function (abs) {
        return themeSpacing * abs;
      };
    }

    if (Array.isArray(themeSpacing)) {
      return function (abs) {
        {
          if (abs > themeSpacing.length - 1) {
            console.error(["@material-ui/system: the value provided (".concat(abs, ") overflows."), "The supported values are: ".concat(JSON.stringify(themeSpacing), "."), "".concat(abs, " > ").concat(themeSpacing.length - 1, ", you need to add the missing values.")].join('\n'));
          }
        }

        return themeSpacing[abs];
      };
    }

    if (typeof themeSpacing === 'function') {
      return themeSpacing;
    }

    {
      console.error(["@material-ui/system: the `theme.spacing` value (".concat(themeSpacing, ") is invalid."), 'It should be a number, an array or a function.'].join('\n'));
    }

    return function () {
      return undefined;
    };
  }

  function getValue(transformer, propValue) {
    if (typeof propValue === 'string') {
      return propValue;
    }

    var abs = Math.abs(propValue);
    var transformed = transformer(abs);

    if (propValue >= 0) {
      return transformed;
    }

    if (typeof transformed === 'number') {
      return -transformed;
    }

    return "-".concat(transformed);
  }

  function getStyleFromPropValue(cssProperties, transformer) {
    return function (propValue) {
      return cssProperties.reduce(function (acc, cssProperty) {
        acc[cssProperty] = getValue(transformer, propValue);
        return acc;
      }, {});
    };
  }

  function spacing(props) {
    var theme = props.theme;
    var transformer = getTransformer(theme);
    return Object.keys(props).map(function (prop) {
      // Using a hash computation over an array iteration could be faster, but with only 28 items,
      // it's doesn't worth the bundle size.
      if (spacingKeys.indexOf(prop) === -1) {
        return null;
      }

      var cssProperties = getCssProperties(prop);
      var styleFromPropValue = getStyleFromPropValue(cssProperties, transformer);
      var propValue = props[prop];
      return handleBreakpoints(props, propValue, styleFromPropValue);
    }).reduce(merge, {});
  }

  spacing.propTypes =  spacingKeys.reduce(function (obj, key) {
    obj[key] = responsivePropType;
    return obj;
  }, {}) ;
  spacing.filterProps = spacingKeys;

  var fontFamily = style$1({
    prop: 'fontFamily',
    themeKey: 'typography'
  });
  var fontSize = style$1({
    prop: 'fontSize',
    themeKey: 'typography'
  });
  var fontStyle = style$1({
    prop: 'fontStyle',
    themeKey: 'typography'
  });
  var fontWeight = style$1({
    prop: 'fontWeight',
    themeKey: 'typography'
  });
  var letterSpacing = style$1({
    prop: 'letterSpacing'
  });
  var lineHeight = style$1({
    prop: 'lineHeight'
  });
  var textAlign = style$1({
    prop: 'textAlign'
  });
  var typography = compose(fontFamily, fontSize, fontStyle, fontWeight, letterSpacing, lineHeight, textAlign);

  var styleFunction = css$1(compose(borders, display, flexbox, positions, palette, boxShadow, sizing, spacing, typography));
  /**
   * @ignore - do not document.
   */

  var Box = styled$1('div')(styleFunction, {
    name: 'MuiBox'
  });

  var styles$a = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        margin: 0
      },

      /* Styles applied to the root element if `variant="body2"`. */
      body2: theme.typography.body2,

      /* Styles applied to the root element if `variant="body1"`. */
      body1: theme.typography.body1,

      /* Styles applied to the root element if `variant="caption"`. */
      caption: theme.typography.caption,

      /* Styles applied to the root element if `variant="button"`. */
      button: theme.typography.button,

      /* Styles applied to the root element if `variant="h1"`. */
      h1: theme.typography.h1,

      /* Styles applied to the root element if `variant="h2"`. */
      h2: theme.typography.h2,

      /* Styles applied to the root element if `variant="h3"`. */
      h3: theme.typography.h3,

      /* Styles applied to the root element if `variant="h4"`. */
      h4: theme.typography.h4,

      /* Styles applied to the root element if `variant="h5"`. */
      h5: theme.typography.h5,

      /* Styles applied to the root element if `variant="h6"`. */
      h6: theme.typography.h6,

      /* Styles applied to the root element if `variant="subtitle1"`. */
      subtitle1: theme.typography.subtitle1,

      /* Styles applied to the root element if `variant="subtitle2"`. */
      subtitle2: theme.typography.subtitle2,

      /* Styles applied to the root element if `variant="overline"`. */
      overline: theme.typography.overline,

      /* Styles applied to the root element if `variant="srOnly"`. Only accessible to screen readers. */
      srOnly: {
        position: 'absolute',
        height: 1,
        width: 1,
        overflow: 'hidden'
      },

      /* Styles applied to the root element if `align="left"`. */
      alignLeft: {
        textAlign: 'left'
      },

      /* Styles applied to the root element if `align="center"`. */
      alignCenter: {
        textAlign: 'center'
      },

      /* Styles applied to the root element if `align="right"`. */
      alignRight: {
        textAlign: 'right'
      },

      /* Styles applied to the root element if `align="justify"`. */
      alignJustify: {
        textAlign: 'justify'
      },

      /* Styles applied to the root element if `nowrap={true}`. */
      noWrap: {
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap'
      },

      /* Styles applied to the root element if `gutterBottom={true}`. */
      gutterBottom: {
        marginBottom: '0.35em'
      },

      /* Styles applied to the root element if `paragraph={true}`. */
      paragraph: {
        marginBottom: 16
      },

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit'
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the root element if `color="textPrimary"`. */
      colorTextPrimary: {
        color: theme.palette.text.primary
      },

      /* Styles applied to the root element if `color="textSecondary"`. */
      colorTextSecondary: {
        color: theme.palette.text.secondary
      },

      /* Styles applied to the root element if `color="error"`. */
      colorError: {
        color: theme.palette.error.main
      },

      /* Styles applied to the root element if `display="inline"`. */
      displayInline: {
        display: 'inline'
      },

      /* Styles applied to the root element if `display="block"`. */
      displayBlock: {
        display: 'block'
      }
    };
  };
  var defaultVariantMapping = {
    h1: 'h1',
    h2: 'h2',
    h3: 'h3',
    h4: 'h4',
    h5: 'h5',
    h6: 'h6',
    subtitle1: 'h6',
    subtitle2: 'h6',
    body1: 'p',
    body2: 'p'
  };
  var Typography = React__default.forwardRef(function Typography(props, ref) {
    var _props$align = props.align,
        align = _props$align === void 0 ? 'inherit' : _props$align,
        classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'initial' : _props$color,
        component = props.component,
        _props$display = props.display,
        display = _props$display === void 0 ? 'initial' : _props$display,
        _props$gutterBottom = props.gutterBottom,
        gutterBottom = _props$gutterBottom === void 0 ? false : _props$gutterBottom,
        _props$noWrap = props.noWrap,
        noWrap = _props$noWrap === void 0 ? false : _props$noWrap,
        _props$paragraph = props.paragraph,
        paragraph = _props$paragraph === void 0 ? false : _props$paragraph,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'body1' : _props$variant,
        _props$variantMapping = props.variantMapping,
        variantMapping = _props$variantMapping === void 0 ? defaultVariantMapping : _props$variantMapping,
        other = _objectWithoutProperties(props, ["align", "classes", "className", "color", "component", "display", "gutterBottom", "noWrap", "paragraph", "variant", "variantMapping"]);

    var Component = component || (paragraph ? 'p' : variantMapping[variant] || defaultVariantMapping[variant]) || 'span';
    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, variant !== 'inherit' && classes[variant], color !== 'initial' && classes["color".concat(capitalize(color))], noWrap && classes.noWrap, gutterBottom && classes.gutterBottom, paragraph && classes.paragraph, align !== 'inherit' && classes["align".concat(capitalize(align))], display !== 'initial' && classes["display".concat(capitalize(display))]),
      ref: ref
    }, other));
  });
   Typography.propTypes = {
    /**
     * Set the text-align on the component.
     */
    align: propTypes.oneOf(['inherit', 'left', 'center', 'right', 'justify']),

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['initial', 'inherit', 'primary', 'secondary', 'textPrimary', 'textSecondary', 'error']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     * By default, it maps the variant to a good default headline component.
     */
    component: propTypes.elementType,

    /**
     * Controls the display type
     */
    display: propTypes.oneOf(['initial', 'block', 'inline']),

    /**
     * If `true`, the text will have a bottom margin.
     */
    gutterBottom: propTypes.bool,

    /**
     * If `true`, the text will not wrap, but instead will truncate with a text overflow ellipsis.
     *
     * Note that text overflow can only happen with block or inline-block level elements
     * (the element needs to have a width in order to overflow).
     */
    noWrap: propTypes.bool,

    /**
     * If `true`, the text will have a bottom margin.
     */
    paragraph: propTypes.bool,

    /**
     * Applies the theme typography styles.
     */
    variant: propTypes.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'caption', 'button', 'overline', 'srOnly', 'inherit']),

    /**
     * We are empirically mapping the variant prop to a range of different DOM element types.
     * For instance, subtitle1 to `<h6>`.
     * If you wish to change that mapping, you can provide your own.
     * Alternatively, you can use the `component` prop.
     */
    variantMapping: propTypes.object
  } ;
  var Typography$1 = withStyles$1(styles$a, {
    name: 'MuiTypography'
  })(Typography);

  var styles$b = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        userSelect: 'none',
        width: '1em',
        height: '1em',
        display: 'inline-block',
        fill: 'currentColor',
        flexShrink: 0,
        fontSize: theme.typography.pxToRem(24),
        transition: theme.transitions.create('fill', {
          duration: theme.transitions.duration.shorter
        })
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the root element if `color="action"`. */
      colorAction: {
        color: theme.palette.action.active
      },

      /* Styles applied to the root element if `color="error"`. */
      colorError: {
        color: theme.palette.error.main
      },

      /* Styles applied to the root element if `color="disabled"`. */
      colorDisabled: {
        color: theme.palette.action.disabled
      },

      /* Styles applied to the root element if `fontSize="inherit"`. */
      fontSizeInherit: {
        fontSize: 'inherit'
      },

      /* Styles applied to the root element if `fontSize="small"`. */
      fontSizeSmall: {
        fontSize: theme.typography.pxToRem(20)
      },

      /* Styles applied to the root element if `fontSize="large"`. */
      fontSizeLarge: {
        fontSize: theme.typography.pxToRem(35)
      }
    };
  };
  var SvgIcon = React__default.forwardRef(function SvgIcon(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'inherit' : _props$color,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'svg' : _props$component,
        _props$fontSize = props.fontSize,
        fontSize = _props$fontSize === void 0 ? 'default' : _props$fontSize,
        htmlColor = props.htmlColor,
        titleAccess = props.titleAccess,
        _props$viewBox = props.viewBox,
        viewBox = _props$viewBox === void 0 ? '0 0 24 24' : _props$viewBox,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "color", "component", "fontSize", "htmlColor", "titleAccess", "viewBox"]);

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, color !== 'inherit' && classes["color".concat(capitalize(color))], fontSize !== 'default' && classes["fontSize".concat(capitalize(fontSize))]),
      focusable: "false",
      viewBox: viewBox,
      color: htmlColor,
      "aria-hidden": titleAccess ? 'false' : 'true',
      role: titleAccess ? 'img' : 'presentation',
      ref: ref
    }, other), children, titleAccess ? React__default.createElement("title", null, titleAccess) : null);
  });
   SvgIcon.propTypes = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * Node passed into the SVG element.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     * You can use the `htmlColor` prop to apply a color attribute to the SVG element.
     */
    color: propTypes.oneOf(['action', 'disabled', 'error', 'inherit', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * The fontSize applied to the icon. Defaults to 24px, but can be configure to inherit font size.
     */
    fontSize: propTypes.oneOf(['default', 'inherit', 'large', 'small']),

    /**
     * Applies a color attribute to the SVG element.
     */
    htmlColor: propTypes.string,

    /**
     * The shape-rendering attribute. The behavior of the different options is described on the
     * [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/shape-rendering).
     * If you are having issues with blurry icons you should investigate this property.
     */
    shapeRendering: propTypes.string,

    /**
     * Provides a human-readable title for the element that contains it.
     * https://www.w3.org/TR/SVG-access/#Equivalent
     */
    titleAccess: propTypes.string,

    /**
     * Allows you to redefine what the coordinates without units mean inside an SVG element.
     * For example, if the SVG element is 500 (width) by 200 (height),
     * and you pass viewBox="0 0 50 20",
     * this means that the coordinates inside the SVG will go from the top left corner (0,0)
     * to bottom right (50,20) and each unit will be worth 10px.
     */
    viewBox: propTypes.string
  } ;
  SvgIcon.muiName = 'SvgIcon';
  var SvgIcon$1 = withStyles$1(styles$b, {
    name: 'MuiSvgIcon'
  })(SvgIcon);

  function createSvgIcon(path, displayName) {
    var Component = React__default.memo(React__default.forwardRef(function (props, ref) {
      return React__default.createElement(SvgIcon$1, _extends({}, props, {
        ref: ref
      }), path);
    }));

    {
      Component.displayName = "".concat(displayName, "Icon");
    }

    Component.muiName = SvgIcon$1.muiName;
    return Component;
  }

  /**
   * @ignore - internal component.
   */

  var MoreHorizIcon = createSvgIcon(React__default.createElement("path", {
    d: "M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"
  }), 'MoreHoriz');

  var styles$c = function styles(theme) {
    return {
      root: {
        display: 'flex'
      },
      icon: {
        width: 24,
        height: 16,
        backgroundColor: theme.palette.grey[100],
        color: theme.palette.grey[700],
        borderRadius: 2,
        marginLeft: theme.spacing(0.5),
        marginRight: theme.spacing(0.5),
        cursor: 'pointer',
        '&:hover, &:focus': {
          backgroundColor: theme.palette.grey[200]
        },
        '&:active': {
          boxShadow: theme.shadows[0],
          backgroundColor: emphasize(theme.palette.grey[200], 0.12)
        }
      }
    };
  };
  /**
   * @ignore - internal component.
   */


  function BreadcrumbCollapsed(props) {
    var classes = props.classes,
        other = _objectWithoutProperties(props, ["classes"]);

    return React__default.createElement("li", _extends({
      className: classes.root
    }, other), React__default.createElement(MoreHorizIcon, {
      className: classes.icon
    }));
  }

   BreadcrumbCollapsed.propTypes = {
    /**
     * @ignore
     */
    classes: propTypes.object.isRequired
  } ;
  var BreadcrumbCollapsed$1 = withStyles$1(styles$c, {
    name: 'PrivateBreadcrumbCollapsed'
  })(BreadcrumbCollapsed);

  var styles$d = {
    root: {
      display: 'flex',
      userSelect: 'none',
      marginLeft: 8,
      marginRight: 8
    }
  };
  /**
   * @ignore - internal component.
   */

  function BreadcrumbSeparator(props) {
    var classes = props.classes,
        className = props.className,
        other = _objectWithoutProperties(props, ["classes", "className"]);

    return React__default.createElement("li", _extends({
      "aria-hidden": true,
      className: clsx(classes.root, className)
    }, other));
  }

   BreadcrumbSeparator.propTypes = {
    children: propTypes.node.isRequired,
    classes: propTypes.object.isRequired,
    className: propTypes.string
  } ;
  var BreadcrumbSeparator$1 = withStyles$1(styles$d, {
    name: 'PrivateBreadcrumbSeparator'
  })(BreadcrumbSeparator);

  var styles$e = {
    /* Styles applied to the root element. */
    root: {},

    /* Styles applied to the ol element. */
    ol: {
      display: 'flex',
      flexWrap: 'wrap',
      alignItems: 'center',
      padding: 0,
      // Reset
      margin: 0 // Reset

    },

    /* Styles applied to the li element. */
    li: {
      listStyle: 'none'
    },

    /* Styles applied to the separator element. */
    separator: {}
  };

  function insertSeparators(items, className, separator) {
    return items.reduce(function (acc, current, index) {
      if (index < items.length - 1) {
        acc = acc.concat(current, React__default.createElement(BreadcrumbSeparator$1, {
          key: "separator-".concat(index),
          className: className
        }, separator));
      } else {
        acc.push(current);
      }

      return acc;
    }, []);
  }

  var Breadcrumbs = React__default.forwardRef(function Breadcrumbs(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'nav' : _props$component,
        _props$itemsAfterColl = props.itemsAfterCollapse,
        itemsAfterCollapse = _props$itemsAfterColl === void 0 ? 1 : _props$itemsAfterColl,
        _props$itemsBeforeCol = props.itemsBeforeCollapse,
        itemsBeforeCollapse = _props$itemsBeforeCol === void 0 ? 1 : _props$itemsBeforeCol,
        _props$maxItems = props.maxItems,
        maxItems = _props$maxItems === void 0 ? 8 : _props$maxItems,
        _props$separator = props.separator,
        separator = _props$separator === void 0 ? '/' : _props$separator,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "component", "itemsAfterCollapse", "itemsBeforeCollapse", "maxItems", "separator"]);

    var _React$useState = React__default.useState(false),
        expanded = _React$useState[0],
        setExpanded = _React$useState[1];

    var renderItemsBeforeAndAfter = function renderItemsBeforeAndAfter(allItems) {
      var handleClickExpand = function handleClickExpand() {
        setExpanded(true);
      }; // This defends against someone passing weird input, to ensure that if all
      // items would be shown anyway, we just show all items without the EllipsisItem


      if (itemsBeforeCollapse + itemsAfterCollapse >= allItems.length) {
        {
          console.error(['Material-UI: you have provided an invalid combination of props to the Breadcrumbs.', "itemsAfterCollapse={".concat(itemsAfterCollapse, "} + itemsBeforeCollapse={").concat(itemsBeforeCollapse, "} >= maxItems={").concat(maxItems, "}")].join('\n'));
        }

        return allItems;
      }

      return [].concat(_toConsumableArray(allItems.slice(0, itemsBeforeCollapse)), [React__default.createElement(BreadcrumbCollapsed$1, {
        key: "ellipsis",
        onClick: handleClickExpand
      })], _toConsumableArray(allItems.slice(allItems.length - itemsAfterCollapse, allItems.length)));
    };

    var allItems = React__default.Children.toArray(children).filter(function (child) {
      {
        if (child.type === React__default.Fragment) {
          console.error(["Material-UI: the Breadcrumbs component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      return React__default.isValidElement(child);
    }).map(function (child, index) {
      return React__default.createElement("li", {
        className: classes.li,
        key: "child-".concat(index)
      }, child);
    });
    return React__default.createElement(Typography$1, _extends({
      ref: ref,
      component: Component,
      color: "textSecondary",
      className: clsx(classes.root, className)
    }, other), React__default.createElement("ol", {
      className: classes.ol
    }, insertSeparators(expanded || maxItems && allItems.length <= maxItems ? allItems : renderItemsBeforeAndAfter(allItems), classes.separator, separator)));
  });
   Breadcrumbs.propTypes = {
    /**
     * The breadcrumb children.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     * By default, it maps the variant to a good default headline component.
     */
    component: propTypes.elementType,

    /**
     * If max items is exceeded, the number of items to show after the ellipsis.
     */
    itemsAfterCollapse: propTypes.number,

    /**
     * If max items is exceeded, the number of items to show before the ellipsis.
     */
    itemsBeforeCollapse: propTypes.number,

    /**
     * Specifies the maximum number of breadcrumbs to display. When there are more
     * than the maximum number, only the first `itemsBeforeCollapse` and last `itemsAfterCollapse`
     * will be shown, with an ellipsis in between.
     */
    maxItems: propTypes.number,

    /**
     * Custom separator node.
     */
    separator: propTypes.node
  } ;
  var Breadcrumbs$1 = withStyles$1(styles$e, {
    name: 'MuiBreadcrumbs'
  })(Breadcrumbs);

  var styles$f = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends({}, theme.typography.button, {
        boxSizing: 'border-box',
        minWidth: 64,
        padding: '6px 16px',
        borderRadius: theme.shape.borderRadius,
        color: theme.palette.text.primary,
        transition: theme.transitions.create(['background-color', 'box-shadow', 'border'], {
          duration: theme.transitions.duration.short
        }),
        '&:hover': {
          textDecoration: 'none',
          backgroundColor: fade(theme.palette.text.primary, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          },
          '&$disabled': {
            backgroundColor: 'transparent'
          }
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      }),

      /* Styles applied to the span element that wraps the children. */
      label: {
        width: '100%',
        // Ensure the correct width for iOS Safari
        display: 'inherit',
        alignItems: 'inherit',
        justifyContent: 'inherit'
      },

      /* Styles applied to the root element if `variant="text"`. */
      text: {
        padding: '6px 8px'
      },

      /* Styles applied to the root element if `variant="text"` and `color="primary"`. */
      textPrimary: {
        color: theme.palette.primary.main,
        '&:hover': {
          backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element if `variant="text"` and `color="secondary"`. */
      textSecondary: {
        color: theme.palette.secondary.main,
        '&:hover': {
          backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element if `variant="outlined"`. */
      outlined: {
        padding: '5px 15px',
        border: "1px solid ".concat(theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)'),
        '&$disabled': {
          border: "1px solid ".concat(theme.palette.action.disabled)
        }
      },

      /* Styles applied to the root element if `variant="outlined"` and `color="primary"`. */
      outlinedPrimary: {
        color: theme.palette.primary.main,
        border: "1px solid ".concat(fade(theme.palette.primary.main, 0.5)),
        '&:hover': {
          border: "1px solid ".concat(theme.palette.primary.main),
          backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element if `variant="outlined"` and `color="secondary"`. */
      outlinedSecondary: {
        color: theme.palette.secondary.main,
        border: "1px solid ".concat(fade(theme.palette.secondary.main, 0.5)),
        '&:hover': {
          border: "1px solid ".concat(theme.palette.secondary.main),
          backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        },
        '&$disabled': {
          border: "1px solid ".concat(theme.palette.action.disabled)
        }
      },

      /* Styles applied to the root element if `variant="contained"`. */
      contained: {
        color: theme.palette.getContrastText(theme.palette.grey[300]),
        backgroundColor: theme.palette.grey[300],
        boxShadow: theme.shadows[2],
        '&:hover': {
          backgroundColor: theme.palette.grey.A100,
          boxShadow: theme.shadows[4],
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            boxShadow: theme.shadows[2],
            backgroundColor: theme.palette.grey[300]
          },
          '&$disabled': {
            backgroundColor: theme.palette.action.disabledBackground
          }
        },
        '&$focusVisible': {
          boxShadow: theme.shadows[6]
        },
        '&:active': {
          boxShadow: theme.shadows[8]
        },
        '&$disabled': {
          color: theme.palette.action.disabled,
          boxShadow: theme.shadows[0],
          backgroundColor: theme.palette.action.disabledBackground
        }
      },

      /* Styles applied to the root element if `variant="contained"` and `color="primary"`. */
      containedPrimary: {
        color: theme.palette.primary.contrastText,
        backgroundColor: theme.palette.primary.main,
        '&:hover': {
          backgroundColor: theme.palette.primary.dark,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.primary.main
          }
        }
      },

      /* Styles applied to the root element if `variant="contained"` and `color="secondary"`. */
      containedSecondary: {
        color: theme.palette.secondary.contrastText,
        backgroundColor: theme.palette.secondary.main,
        '&:hover': {
          backgroundColor: theme.palette.secondary.dark,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.secondary.main
          }
        }
      },

      /* Pseudo-class applied to the ButtonBase root element if the button is keyboard focused. */
      focusVisible: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit',
        borderColor: 'currentColor'
      },

      /* Styles applied to the root element if `size="small"` and `variant="text"`. */
      textSizeSmall: {
        padding: '4px 5px',
        fontSize: theme.typography.pxToRem(13)
      },

      /* Styles applied to the root element if `size="large"` and `variant="text"`. */
      textSizeLarge: {
        padding: '8px 11px',
        fontSize: theme.typography.pxToRem(15)
      },

      /* Styles applied to the root element if `size="small"` and `variant="outlined"`. */
      outlinedSizeSmall: {
        padding: '3px 9px',
        fontSize: theme.typography.pxToRem(13)
      },

      /* Styles applied to the root element if `size="large"` and `variant="outlined"`. */
      outlinedSizeLarge: {
        padding: '7px 21px',
        fontSize: theme.typography.pxToRem(15)
      },

      /* Styles applied to the root element if `size="small"` and `variant="contained"`. */
      containedSizeSmall: {
        padding: '4px 10px',
        fontSize: theme.typography.pxToRem(13)
      },

      /* Styles applied to the root element if `size="large"` and `variant="contained"`. */
      containedSizeLarge: {
        padding: '8px 22px',
        fontSize: theme.typography.pxToRem(15)
      },

      /* Styles applied to the root element if `size="small"`. */
      sizeSmall: {},

      /* Styles applied to the root element if `size="large"`. */
      sizeLarge: {},

      /* Styles applied to the root element if `fullWidth={true}`. */
      fullWidth: {
        width: '100%'
      },

      /* Styles applied to the startIcon element if supplied. */
      startIcon: {
        display: 'inherit',
        marginRight: 8,
        marginLeft: -4,
        '&$iconSizeSmall': {
          marginLeft: -2
        }
      },

      /* Styles applied to the endIcon element if supplied. */
      endIcon: {
        display: 'inherit',
        marginRight: -4,
        marginLeft: 8,
        '&$iconSizeSmall': {
          marginRight: -2
        }
      },

      /* Styles applied to the icon element if supplied and `size="small"`. */
      iconSizeSmall: {
        '& > *:first-child': {
          fontSize: 18
        }
      },

      /* Styles applied to the icon element if supplied and `size="medium"`. */
      iconSizeMedium: {
        '& > *:first-child': {
          fontSize: 20
        }
      },

      /* Styles applied to the icon element if supplied and `size="large"`. */
      iconSizeLarge: {
        '& > *:first-child': {
          fontSize: 22
        }
      }
    };
  };
  var Button = React__default.forwardRef(function Button(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'default' : _props$color,
        _props$component = props.component,
        component = _props$component === void 0 ? 'button' : _props$component,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$disableFocusRi = props.disableFocusRipple,
        disableFocusRipple = _props$disableFocusRi === void 0 ? false : _props$disableFocusRi,
        endIconProp = props.endIcon,
        focusVisibleClassName = props.focusVisibleClassName,
        _props$fullWidth = props.fullWidth,
        fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
        _props$size = props.size,
        size = _props$size === void 0 ? 'medium' : _props$size,
        startIconProp = props.startIcon,
        _props$type = props.type,
        type = _props$type === void 0 ? 'button' : _props$type,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'text' : _props$variant,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "color", "component", "disabled", "disableFocusRipple", "endIcon", "focusVisibleClassName", "fullWidth", "size", "startIcon", "type", "variant"]);

    var startIcon = startIconProp && React__default.createElement("span", {
      className: clsx(classes.startIcon, classes["iconSize".concat(capitalize(size))])
    }, startIconProp);
    var endIcon = endIconProp && React__default.createElement("span", {
      className: clsx(classes.endIcon, classes["iconSize".concat(capitalize(size))])
    }, endIconProp);
    return React__default.createElement(ButtonBase$1, _extends({
      className: clsx(classes.root, classes[variant], className, color === 'inherit' ? classes.colorInherit : color !== 'default' && classes["".concat(variant).concat(capitalize(color))], size !== 'medium' && [classes["".concat(variant, "Size").concat(capitalize(size))], classes["size".concat(capitalize(size))]], disabled && classes.disabled, fullWidth && classes.fullWidth),
      component: component,
      disabled: disabled,
      focusRipple: !disableFocusRipple,
      focusVisibleClassName: clsx(classes.focusVisible, focusVisibleClassName),
      ref: ref,
      type: type
    }, other), React__default.createElement("span", {
      className: classes.label
    }, startIcon, children, endIcon));
  });
   Button.propTypes = {
    /**
     * The content of the button.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'inherit', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the button will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple will be disabled.
     * `disableRipple` must also be true.
     */
    disableFocusRipple: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     *
     * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
     * to highlight the element by applying separate styles with the `focusVisibleClassName`.
     */
    disableRipple: propTypes.bool,

    /**
     * Element placed after the children.
     */
    endIcon: propTypes.node,

    /**
     * @ignore
     */
    focusVisibleClassName: propTypes.string,

    /**
     * If `true`, the button will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The URL to link to when the button is clicked.
     * If defined, an `a` element will be used as the root node.
     */
    href: propTypes.string,

    /**
     * The size of the button.
     * `small` is equivalent to the dense button styling.
     */
    size: propTypes.oneOf(['small', 'medium', 'large']),

    /**
     * Element placed before the children.
     */
    startIcon: propTypes.node,

    /**
     * @ignore
     */
    type: propTypes.string,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['text', 'outlined', 'contained'])
  } ;
  var Button$1 = withStyles$1(styles$f, {
    name: 'MuiButton'
  })(Button);

  // eslint-disable-next-line no-unused-expressions

  Button$1.styles;
  var styles$g = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'inline-flex',
        borderRadius: theme.shape.borderRadius
      },

      /* Styles applied to the root element if `variant="contained"`. */
      contained: {
        boxShadow: theme.shadows[2]
      },

      /* Styles applied to the root element if `fullWidth={true}`. */
      fullWidth: {
        width: '100%'
      },

      /* Styles applied to the children. */
      grouped: {
        minWidth: 40,
        '&:not(:first-child)': {
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        },
        '&:not(:last-child)': {
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },

      /* Styles applied to the children if `variant="text"`. */
      groupedText: {
        '&:not(:last-child)': {
          borderRight: "1px solid ".concat(theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)')
        }
      },

      /* Styles applied to the children if `variant="text"` and `color="primary"`. */
      groupedTextPrimary: {
        '&:not(:last-child)': {
          borderColor: fade(theme.palette.primary.main, 0.5)
        }
      },

      /* Styles applied to the children if `variant="text"` and `color="secondary"`. */
      groupedTextSecondary: {
        '&:not(:last-child)': {
          borderColor: fade(theme.palette.secondary.main, 0.5)
        }
      },

      /* Styles applied to the children if `variant="outlined"`. */
      groupedOutlined: {
        '&:not(:first-child)': {
          marginLeft: -1
        },
        '&:not(:last-child)': {
          borderRightColor: 'transparent'
        }
      },

      /* Styles applied to the children if `variant="outlined"` and `color="primary"`. */
      groupedOutlinedPrimary: {
        '&:hover': {
          borderColor: theme.palette.primary.main
        }
      },

      /* Styles applied to the children if `variant="outlined"` and `color="secondary"`. */
      groupedOutlinedSecondary: {
        '&:hover': {
          borderColor: theme.palette.secondary.main
        }
      },

      /* Styles applied to the children if `variant="contained"`. */
      groupedContained: {
        boxShadow: 'none',
        '&:not(:last-child)': {
          borderRight: "1px solid ".concat(theme.palette.grey[400]),
          '&$disabled': {
            borderRight: "1px solid ".concat(theme.palette.action.disabled)
          }
        }
      },

      /* Styles applied to the children if `variant="contained"` and `color="primary"`. */
      groupedContainedPrimary: {
        '&:not(:last-child)': {
          borderRight: "1px solid ".concat(theme.palette.primary.dark)
        }
      },

      /* Styles applied to the children if `variant="contained"` and `color="secondary"`. */
      groupedContainedSecondary: {
        '&:not(:last-child)': {
          borderRight: "1px solid ".concat(theme.palette.secondary.dark)
        }
      },

      /* Pseudo-class applied to child elements if `disabled={true}`. */
      disabled: {}
    };
  };
  var ButtonGroup = React__default.forwardRef(function ButtonGroup(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'default' : _props$color,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$disableFocusRi = props.disableFocusRipple,
        disableFocusRipple = _props$disableFocusRi === void 0 ? false : _props$disableFocusRi,
        _props$disableRipple = props.disableRipple,
        disableRipple = _props$disableRipple === void 0 ? false : _props$disableRipple,
        _props$fullWidth = props.fullWidth,
        fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
        _props$size = props.size,
        size = _props$size === void 0 ? 'medium' : _props$size,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'outlined' : _props$variant,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "color", "component", "disabled", "disableFocusRipple", "disableRipple", "fullWidth", "size", "variant"]);

    var buttonClassName = clsx(classes.grouped, classes["grouped".concat(capitalize(variant))], classes["grouped".concat(capitalize(variant)).concat(color !== 'default' ? capitalize(color) : '')], disabled && classes.disabled);
    return React__default.createElement(Component, _extends({
      role: "group",
      className: clsx(classes.root, className, fullWidth && classes.fullWidth, {
        contained: classes.contained
      }[variant]),
      ref: ref
    }, other), React__default.Children.map(children, function (child) {
      if (!React__default.isValidElement(child)) {
        return null;
      }

      {
        if (child.type === React__default.Fragment) {
          console.error(["Material-UI: the ButtonGroup component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      return React__default.cloneElement(child, {
        className: clsx(buttonClassName, child.props.className),
        disabled: child.props.disabled || disabled,
        color: child.props.color || color,
        disableFocusRipple: disableFocusRipple,
        disableRipple: disableRipple,
        fullWidth: fullWidth,
        size: child.props.size || size,
        variant: child.props.variant || variant
      });
    }));
  });
   ButtonGroup.propTypes = {
    /**
     * The content of the button group.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'inherit', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the buttons will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the button keyboard focus ripple will be disabled.
     * `disableRipple` must also be true.
     */
    disableFocusRipple: propTypes.bool,

    /**
     * If `true`, the button ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * If `true`, the buttons will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The size of the button.
     * `small` is equivalent to the dense button styling.
     */
    size: propTypes.oneOf(['small', 'medium', 'large']),

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['text', 'outlined', 'contained'])
  } ;
  var ButtonGroup$1 = withStyles$1(styles$g, {
    name: 'MuiButtonGroup'
  })(ButtonGroup);

  var styles$h = {
    /* Styles applied to the root element. */
    root: {
      overflow: 'hidden'
    }
  };
  var Card = React__default.forwardRef(function Card(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$raised = props.raised,
        raised = _props$raised === void 0 ? false : _props$raised,
        other = _objectWithoutProperties(props, ["classes", "className", "raised"]);

    return React__default.createElement(Paper$1, _extends({
      className: clsx(classes.root, className),
      elevation: raised ? 8 : 1,
      ref: ref
    }, other));
  });
   Card.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the card will use raised styling.
     */
    raised: propTypes.bool
  } ;
  var Card$1 = withStyles$1(styles$h, {
    name: 'MuiCard'
  })(Card);

  var styles$i = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'block',
        textAlign: 'inherit',
        width: '100%',
        '&:hover $focusHighlight': {
          opacity: theme.palette.action.hoverOpacity
        },
        '&$focusVisible $focusHighlight': {
          opacity: 0.12
        }
      },

      /* Pseudo-class applied to the ButtonBase root element if the action area is keyboard focused. */
      focusVisible: {},

      /* Styles applied to the overlay that covers the action area when it is keyboard focused. */
      focusHighlight: {
        overflow: 'hidden',
        pointerEvents: 'none',
        position: 'absolute',
        top: 0,
        right: 0,
        bottom: 0,
        left: 0,
        borderRadius: 'inherit',
        opacity: 0,
        backgroundColor: 'currentcolor',
        transition: theme.transitions.create('opacity', {
          duration: theme.transitions.duration.short
        })
      }
    };
  };
  var CardActionArea = React__default.forwardRef(function CardActionArea(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        focusVisibleClassName = props.focusVisibleClassName,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "focusVisibleClassName"]);

    return React__default.createElement(ButtonBase$1, _extends({
      className: clsx(classes.root, className),
      focusVisibleClassName: clsx(focusVisibleClassName, classes.focusVisible),
      ref: ref
    }, other), children, React__default.createElement("span", {
      className: classes.focusHighlight
    }));
  });
   CardActionArea.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     */
    focusVisibleClassName: propTypes.string
  } ;
  var CardActionArea$1 = withStyles$1(styles$i, {
    name: 'MuiCardActionArea'
  })(CardActionArea);

  var styles$j = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      alignItems: 'center',
      padding: 8
    },

    /* Styles applied to the root element if `disableSpacing={false}`. */
    spacing: {
      '& > :not(:first-child)': {
        marginLeft: 8
      }
    }
  };
  var CardActions = React__default.forwardRef(function CardActions(props, ref) {
    var _props$disableSpacing = props.disableSpacing,
        disableSpacing = _props$disableSpacing === void 0 ? false : _props$disableSpacing,
        classes = props.classes,
        className = props.className,
        other = _objectWithoutProperties(props, ["disableSpacing", "classes", "className"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, !disableSpacing && classes.spacing),
      ref: ref
    }, other));
  });
   CardActions.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the actions do not have additional margin.
     */
    disableSpacing: propTypes.bool
  } ;
  var CardActions$1 = withStyles$1(styles$j, {
    name: 'MuiCardActions'
  })(CardActions);

  var styles$k = {
    /* Styles applied to the root element. */
    root: {
      padding: 16,
      '&:last-child': {
        paddingBottom: 24
      }
    }
  };
  var CardContent = React__default.forwardRef(function CardContent(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        other = _objectWithoutProperties(props, ["classes", "className", "component"]);

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className),
      ref: ref
    }, other));
  });
   CardContent.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType
  } ;
  var CardContent$1 = withStyles$1(styles$k, {
    name: 'MuiCardContent'
  })(CardContent);

  var styles$l = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      alignItems: 'center',
      padding: 16
    },

    /* Styles applied to the avatar element. */
    avatar: {
      flex: '0 0 auto',
      marginRight: 16
    },

    /* Styles applied to the action element. */
    action: {
      flex: '0 0 auto',
      alignSelf: 'flex-start',
      marginTop: -8,
      marginRight: -8
    },

    /* Styles applied to the content wrapper element. */
    content: {
      flex: '1 1 auto'
    },

    /* Styles applied to the title Typography element. */
    title: {},

    /* Styles applied to the subheader Typography element. */
    subheader: {}
  };
  var CardHeader = React__default.forwardRef(function CardHeader(props, ref) {
    var action = props.action,
        avatar = props.avatar,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        _props$disableTypogra = props.disableTypography,
        disableTypography = _props$disableTypogra === void 0 ? false : _props$disableTypogra,
        subheaderProp = props.subheader,
        subheaderTypographyProps = props.subheaderTypographyProps,
        titleProp = props.title,
        titleTypographyProps = props.titleTypographyProps,
        other = _objectWithoutProperties(props, ["action", "avatar", "classes", "className", "component", "disableTypography", "subheader", "subheaderTypographyProps", "title", "titleTypographyProps"]);

    var title = titleProp;

    if (title != null && title.type !== Typography$1 && !disableTypography) {
      title = React__default.createElement(Typography$1, _extends({
        variant: avatar ? 'body2' : 'h5',
        className: classes.title,
        component: "span",
        display: "block"
      }, titleTypographyProps), title);
    }

    var subheader = subheaderProp;

    if (subheader != null && subheader.type !== Typography$1 && !disableTypography) {
      subheader = React__default.createElement(Typography$1, _extends({
        variant: avatar ? 'body2' : 'body1',
        className: classes.subheader,
        color: "textSecondary",
        component: "span",
        display: "block"
      }, subheaderTypographyProps), subheader);
    }

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className),
      ref: ref
    }, other), avatar && React__default.createElement("div", {
      className: classes.avatar
    }, avatar), React__default.createElement("div", {
      className: classes.content
    }, title, subheader), action && React__default.createElement("div", {
      className: classes.action
    }, action));
  });
   CardHeader.propTypes = {
    /**
     * The action to display in the card header.
     */
    action: propTypes.node,

    /**
     * The Avatar for the Card Header.
     */
    avatar: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, `subheader` and `title` won't be wrapped by a Typography component.
     * This can be useful to render an alternative Typography variant by wrapping
     * the `title` text, and optional `subheader` text
     * with the Typography component.
     */
    disableTypography: propTypes.bool,

    /**
     * The content of the component.
     */
    subheader: propTypes.node,

    /**
     * These props will be forwarded to the subheader
     * (as long as disableTypography is not `true`).
     */
    subheaderTypographyProps: propTypes.object,

    /**
     * The content of the Card Title.
     */
    title: propTypes.node,

    /**
     * These props will be forwarded to the title
     * (as long as disableTypography is not `true`).
     */
    titleTypographyProps: propTypes.object
  } ;
  var CardHeader$1 = withStyles$1(styles$l, {
    name: 'MuiCardHeader'
  })(CardHeader);

  var styles$m = {
    /* Styles applied to the root element. */
    root: {
      display: 'block',
      backgroundSize: 'cover',
      backgroundRepeat: 'no-repeat',
      backgroundPosition: 'center'
    },

    /* Styles applied to the root element if `component="video, audio, picture, iframe, or img"`. */
    media: {
      width: '100%'
    },

    /* Styles applied to the root element if `component="picture or img"`. */
    img: {
      // ⚠️ object-fit is not supported by IE 11.
      objectFit: 'cover'
    }
  };
  var MEDIA_COMPONENTS = ['video', 'audio', 'picture', 'iframe', 'img'];
  var CardMedia = React__default.forwardRef(function CardMedia(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        image = props.image,
        src = props.src,
        style = props.style,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "component", "image", "src", "style"]);

    {
      if (!children && !image && !src) {
        console.error('Material-UI: either `children`, `image` or `src` prop must be specified.');
      }
    }

    var isMediaComponent = MEDIA_COMPONENTS.indexOf(Component) !== -1;
    var composedStyle = !isMediaComponent && image ? _extends({
      backgroundImage: "url(\"".concat(image, "\")")
    }, style) : style;
    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, isMediaComponent && classes.media, "picture img".indexOf(Component) !== -1 && classes.img),
      ref: ref,
      style: composedStyle,
      src: isMediaComponent ? image || src : undefined
    }, other), children);
  });
   CardMedia.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Component for rendering image.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Image to be displayed as a background image.
     * Either `image` or `src` prop must be specified.
     * Note that caller must specify height otherwise the image will not be visible.
     */
    image: propTypes.string,

    /**
     * An alias for `image` property.
     * Available only with media components.
     * Media components: `video`, `audio`, `picture`, `iframe`, `img`.
     */
    src: propTypes.string,

    /**
     * @ignore
     */
    style: propTypes.object
  } ;
  var CardMedia$1 = withStyles$1(styles$m, {
    name: 'MuiCardMedia'
  })(CardMedia);

  /**
   * @ignore - internal component.
   */

  var FormControlContext = React__default.createContext();
  function useFormControl() {
    return React__default.useContext(FormControlContext);
  }

  function useFormControl$1() {
    return React__default.useContext(FormControlContext);
  }

  var styles$n = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        textAlign: 'center',
        flex: '0 0 auto',
        fontSize: theme.typography.pxToRem(24),
        padding: 12,
        borderRadius: '50%',
        overflow: 'visible',
        // Explicitly set the default value to solve a bug on IE 11.
        color: theme.palette.action.active,
        transition: theme.transitions.create('background-color', {
          duration: theme.transitions.duration.shortest
        }),
        '&:hover': {
          backgroundColor: fade(theme.palette.action.active, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        },
        '&$disabled': {
          backgroundColor: 'transparent',
          color: theme.palette.action.disabled
        }
      },

      /* Styles applied to the root element if `edge="start"`. */
      edgeStart: {
        marginLeft: -12,
        '$sizeSmall&': {
          marginLeft: -3
        }
      },

      /* Styles applied to the root element if `edge="end"`. */
      edgeEnd: {
        marginRight: -12,
        '$sizeSmall&': {
          marginRight: -3
        }
      },

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit'
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main,
        '&:hover': {
          backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main,
        '&:hover': {
          backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `size="small"`. */
      sizeSmall: {
        padding: 3,
        fontSize: theme.typography.pxToRem(18)
      },

      /* Styles applied to the children container element. */
      label: {
        width: '100%',
        display: 'flex',
        alignItems: 'inherit',
        justifyContent: 'inherit'
      }
    };
  };
  /**
   * Refer to the [Icons](/components/icons/) section of the documentation
   * regarding the available icon options.
   */

  var IconButton = React__default.forwardRef(function IconButton(props, ref) {
    var _props$edge = props.edge,
        edge = _props$edge === void 0 ? false : _props$edge,
        children = props.children,
        classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'default' : _props$color,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$disableFocusRi = props.disableFocusRipple,
        disableFocusRipple = _props$disableFocusRi === void 0 ? false : _props$disableFocusRi,
        _props$size = props.size,
        size = _props$size === void 0 ? 'medium' : _props$size,
        other = _objectWithoutProperties(props, ["edge", "children", "classes", "className", "color", "disabled", "disableFocusRipple", "size"]);

    return React__default.createElement(ButtonBase$1, _extends({
      className: clsx(classes.root, className, color !== 'default' && classes["color".concat(capitalize(color))], disabled && classes.disabled, {
        small: classes["size".concat(capitalize(size))]
      }[size], {
        start: classes.edgeStart,
        end: classes.edgeEnd
      }[edge]),
      centerRipple: true,
      focusRipple: !disableFocusRipple,
      disabled: disabled,
      ref: ref
    }, other), React__default.createElement("span", {
      className: classes.label
    }, children));
  });
   IconButton.propTypes = {
    /**
     * The icon element.
     */
    children: chainPropTypes(propTypes.node, function (props) {
      var found = React__default.Children.toArray(props.children).some(function (child) {
        return React__default.isValidElement(child) && child.props.onClick;
      });

      if (found) {
        return new Error(['Material-UI: you are providing an onClick event listener ' + 'to a child of a button element.', 'Firefox will never trigger the event.', 'You should move the onClick listener to the parent button element.', 'https://github.com/mui-org/material-ui/issues/13957'].join('\n'));
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'inherit', 'primary', 'secondary']),

    /**
     * If `true`, the button will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple will be disabled.
     * `disableRipple` must also be true.
     */
    disableFocusRipple: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * If given, uses a negative margin to counteract the padding on one
     * side (this is often helpful for aligning the left or right
     * side of the icon with content above or below, without ruining the border
     * size and shape).
     */
    edge: propTypes.oneOf(['start', 'end', false]),

    /**
     * The size of the button.
     * `small` is equivalent to the dense button styling.
     */
    size: propTypes.oneOf(['small', 'medium'])
  } ;
  var IconButton$1 = withStyles$1(styles$n, {
    name: 'MuiIconButton'
  })(IconButton);

  var styles$o = {
    root: {
      padding: 9
    },
    checked: {},
    disabled: {},
    input: {
      cursor: 'inherit',
      position: 'absolute',
      opacity: 0,
      width: '100%',
      height: '100%',
      top: 0,
      left: 0,
      margin: 0,
      padding: 0,
      zIndex: 1
    }
  };
  /**
   * @ignore - internal component.
   */

  var SwitchBase = React__default.forwardRef(function SwitchBase(props, ref) {
    var autoFocus = props.autoFocus,
        checkedProp = props.checked,
        checkedIcon = props.checkedIcon,
        classes = props.classes,
        className = props.className,
        defaultChecked = props.defaultChecked,
        disabledProp = props.disabled,
        icon = props.icon,
        id = props.id,
        inputProps = props.inputProps,
        inputRef = props.inputRef,
        name = props.name,
        onBlur = props.onBlur,
        onChange = props.onChange,
        onFocus = props.onFocus,
        readOnly = props.readOnly,
        required = props.required,
        tabIndex = props.tabIndex,
        type = props.type,
        value = props.value,
        other = _objectWithoutProperties(props, ["autoFocus", "checked", "checkedIcon", "classes", "className", "defaultChecked", "disabled", "icon", "id", "inputProps", "inputRef", "name", "onBlur", "onChange", "onFocus", "readOnly", "required", "tabIndex", "type", "value"]);

    var _React$useRef = React__default.useRef(checkedProp != null),
        isControlled = _React$useRef.current;

    var _React$useState = React__default.useState(Boolean(defaultChecked)),
        checkedState = _React$useState[0],
        setCheckedState = _React$useState[1];

    var checked = isControlled ? checkedProp : checkedState;
    var muiFormControl = useFormControl$1();

    var handleFocus = function handleFocus(event) {
      if (onFocus) {
        onFocus(event);
      }

      if (muiFormControl && muiFormControl.onFocus) {
        muiFormControl.onFocus(event);
      }
    };

    var handleBlur = function handleBlur(event) {
      if (onBlur) {
        onBlur(event);
      }

      if (muiFormControl && muiFormControl.onBlur) {
        muiFormControl.onBlur(event);
      }
    };

    var handleInputChange = function handleInputChange(event) {
      var newChecked = event.target.checked;

      if (!isControlled) {
        setCheckedState(newChecked);
      }

      if (onChange) {
        onChange(event, newChecked);
      }
    };

    var disabled = disabledProp;

    if (muiFormControl) {
      if (typeof disabled === 'undefined') {
        disabled = muiFormControl.disabled;
      }
    }

    var hasLabelFor = type === 'checkbox' || type === 'radio';
    return React__default.createElement(IconButton$1, _extends({
      component: "span",
      className: clsx(classes.root, className, checked && classes.checked, disabled && classes.disabled),
      disabled: disabled,
      tabIndex: null,
      role: undefined,
      onFocus: handleFocus,
      onBlur: handleBlur,
      ref: ref
    }, other), React__default.createElement("input", _extends({
      autoFocus: autoFocus,
      checked: checkedProp,
      defaultChecked: defaultChecked,
      className: classes.input,
      disabled: disabled,
      id: hasLabelFor && id,
      name: name,
      onChange: handleInputChange,
      readOnly: readOnly,
      ref: inputRef,
      required: required,
      tabIndex: tabIndex,
      type: type,
      value: value
    }, inputProps)), checked ? checkedIcon : icon);
  }); // NB: If changed, please update Checkbox, Switch and Radio
  // so that the API documentation is updated.

   SwitchBase.propTypes = {
    /**
     * If `true`, the `input` element will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * If `true`, the component is checked.
     */
    checked: propTypes.bool,

    /**
     * The icon to display when the component is checked.
     */
    checkedIcon: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     */
    defaultChecked: propTypes.bool,

    /**
     * If `true`, the switch will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * The icon to display when the component is unchecked.
     */
    icon: propTypes.node.isRequired,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType,

    /*
     * @ignore
     */
    name: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new checked state by accessing `event.target.checked` (boolean).
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * If `true`, the `input` element will be required.
     */
    required: propTypes.bool,

    /**
     * @ignore
     */
    tabIndex: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * The input component prop `type`.
     */
    type: propTypes.string.isRequired,

    /**
     * The value of the component.
     */
    value: propTypes.any
  } ;
  var SwitchBase$1 = withStyles$1(styles$o, {
    name: 'PrivateSwitchBase'
  })(SwitchBase);

  /**
   * @ignore - internal component.
   */

  var CheckBoxOutlineBlankIcon = createSvgIcon(React__default.createElement("path", {
    d: "M19 5v14H5V5h14m0-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"
  }), 'CheckBoxOutlineBlank');

  /**
   * @ignore - internal component.
   */

  var CheckBoxIcon = createSvgIcon(React__default.createElement("path", {
    d: "M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-9 14l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"
  }), 'CheckBox');

  /**
   * @ignore - internal component.
   */

  var IndeterminateCheckBoxIcon = createSvgIcon(React__default.createElement("path", {
    d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10H7v-2h10v2z"
  }), 'IndeterminateCheckBox');

  var styles$p = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        color: theme.palette.text.secondary
      },

      /* Pseudo-class applied to the root element if `checked={true}`. */
      checked: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Pseudo-class applied to the root element if `indeterminate={true}`. */
      indeterminate: {},

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        '&$checked': {
          color: theme.palette.primary.main,
          '&:hover': {
            backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity),
            // Reset on touch devices, it doesn't add specificity
            '@media (hover: none)': {
              backgroundColor: 'transparent'
            }
          }
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        '&$checked': {
          color: theme.palette.secondary.main,
          '&:hover': {
            backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
            // Reset on touch devices, it doesn't add specificity
            '@media (hover: none)': {
              backgroundColor: 'transparent'
            }
          }
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      }
    };
  };
  var defaultCheckedIcon = React__default.createElement(CheckBoxIcon, null);
  var defaultIcon = React__default.createElement(CheckBoxOutlineBlankIcon, null);
  var defaultIndeterminateIcon = React__default.createElement(IndeterminateCheckBoxIcon, null);
  var Checkbox = React__default.forwardRef(function Checkbox(props, ref) {
    var _props$checkedIcon = props.checkedIcon,
        checkedIcon = _props$checkedIcon === void 0 ? defaultCheckedIcon : _props$checkedIcon,
        classes = props.classes,
        _props$color = props.color,
        color = _props$color === void 0 ? 'secondary' : _props$color,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$icon = props.icon,
        icon = _props$icon === void 0 ? defaultIcon : _props$icon,
        _props$indeterminate = props.indeterminate,
        indeterminate = _props$indeterminate === void 0 ? false : _props$indeterminate,
        _props$indeterminateI = props.indeterminateIcon,
        indeterminateIcon = _props$indeterminateI === void 0 ? defaultIndeterminateIcon : _props$indeterminateI,
        inputProps = props.inputProps,
        other = _objectWithoutProperties(props, ["checkedIcon", "classes", "color", "disabled", "icon", "indeterminate", "indeterminateIcon", "inputProps"]);

    return React__default.createElement(SwitchBase$1, _extends({
      type: "checkbox",
      checkedIcon: indeterminate ? indeterminateIcon : checkedIcon,
      classes: {
        root: clsx(classes.root, classes["color".concat(capitalize(color))], indeterminate && classes.indeterminate),
        checked: classes.checked,
        disabled: classes.disabled
      },
      color: color,
      inputProps: _extends({
        'data-indeterminate': indeterminate
      }, inputProps),
      icon: indeterminate ? indeterminateIcon : icon,
      ref: ref,
      disabled: disabled
    }, other));
  });
   Checkbox.propTypes = {
    /**
     * If `true`, the component is checked.
     */
    checked: propTypes.bool,

    /**
     * The icon to display when the component is checked.
     */
    checkedIcon: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary', 'default']),

    /**
     * If `true`, the switch will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * The icon to display when the component is unchecked.
     */
    icon: propTypes.node,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * If `true`, the component appears indeterminate.
     * This does not set the native input element to indeterminate due
     * to inconsistent behavior across browsers.
     * However, we set a `data-indeterminate` attribute on the input.
     */
    indeterminate: propTypes.bool,

    /**
     * The icon to display when the component is indeterminate.
     */
    indeterminateIcon: propTypes.node,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType,

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new checked state by accessing `event.target.checked` (boolean).
     */
    onChange: propTypes.func,

    /**
     * If `true`, the `input` element will be required.
     */
    required: propTypes.bool,

    /**
     * The input component prop `type`.
     */
    type: propTypes.string,

    /**
     * The value of the component. The DOM API casts this to a string.
     */
    value: propTypes.any
  } ;
  var Checkbox$1 = withStyles$1(styles$p, {
    name: 'MuiCheckbox'
  })(Checkbox);

  /**
   * @ignore - internal component.
   */

  var CancelIcon = createSvgIcon(React__default.createElement("path", {
    d: "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"
  }), 'Cancel');

  var styles$q = function styles(theme) {
    var backgroundColor = theme.palette.type === 'light' ? theme.palette.grey[300] : theme.palette.grey[700];
    var deleteIconColor = fade(theme.palette.text.primary, 0.26);
    return {
      /* Styles applied to the root element. */
      root: {
        fontFamily: theme.typography.fontFamily,
        fontSize: theme.typography.pxToRem(13),
        display: 'inline-flex',
        alignItems: 'center',
        justifyContent: 'center',
        height: 32,
        color: theme.palette.getContrastText(backgroundColor),
        backgroundColor: backgroundColor,
        borderRadius: 32 / 2,
        whiteSpace: 'nowrap',
        transition: theme.transitions.create(['background-color', 'box-shadow']),
        // label will inherit this from root, then `clickable` class overrides this for both
        cursor: 'default',
        // We disable the focus ring for mouse, touch and keyboard users.
        outline: 0,
        textDecoration: 'none',
        border: 'none',
        // Remove `button` border
        padding: 0,
        // Remove `button` padding
        verticalAlign: 'middle',
        boxSizing: 'border-box',
        '&$disabled': {
          opacity: 0.5,
          pointerEvents: 'none'
        },
        '& $avatar': {
          marginLeft: 5,
          marginRight: -6,
          width: 24,
          height: 24,
          color: theme.palette.type === 'light' ? theme.palette.grey[700] : theme.palette.grey[300],
          fontSize: theme.typography.pxToRem(12)
        },
        '& $avatarColorPrimary': {
          color: theme.palette.primary.contrastText,
          backgroundColor: theme.palette.primary.dark
        },
        '& $avatarColorSecondary': {
          color: theme.palette.secondary.contrastText,
          backgroundColor: theme.palette.secondary.dark
        },
        '& $avatarSmall': {
          marginLeft: 4,
          marginRight: -4,
          width: 18,
          height: 18,
          fontSize: theme.typography.pxToRem(10)
        }
      },

      /* Styles applied to the root element if `size="small"`. */
      sizeSmall: {
        height: 24
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        backgroundColor: theme.palette.primary.main,
        color: theme.palette.primary.contrastText
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        backgroundColor: theme.palette.secondary.main,
        color: theme.palette.secondary.contrastText
      },

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `onClick` is defined or `clickable={true}`. */
      clickable: {
        userSelect: 'none',
        WebkitTapHighlightColor: 'transparent',
        // Remove grey highlight
        cursor: 'pointer',
        '&:hover, &:focus': {
          backgroundColor: emphasize(backgroundColor, 0.08)
        },
        '&:active': {
          boxShadow: theme.shadows[1]
        }
      },

      /* Styles applied to the root element if `onClick` and `color="primary"` is defined or `clickable={true}`. */
      clickableColorPrimary: {
        '&:hover, &:focus': {
          backgroundColor: emphasize(theme.palette.primary.main, 0.08)
        }
      },

      /* Styles applied to the root element if `onClick` and `color="secondary"` is defined or `clickable={true}`. */
      clickableColorSecondary: {
        '&:hover, &:focus': {
          backgroundColor: emphasize(theme.palette.secondary.main, 0.08)
        }
      },

      /* Styles applied to the root element if `onDelete` is defined. */
      deletable: {
        '&:focus': {
          backgroundColor: emphasize(backgroundColor, 0.08)
        }
      },

      /* Styles applied to the root element if `onDelete` and `color="primary"` is defined. */
      deletableColorPrimary: {
        '&:focus': {
          backgroundColor: emphasize(theme.palette.primary.main, 0.2)
        }
      },

      /* Styles applied to the root element if `onDelete` and `color="secondary"` is defined. */
      deletableColorSecondary: {
        '&:focus': {
          backgroundColor: emphasize(theme.palette.secondary.main, 0.2)
        }
      },

      /* Styles applied to the root element if `variant="outlined"`. */
      outlined: {
        backgroundColor: 'transparent',
        border: "1px solid ".concat(theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)'),
        '$clickable&:hover, $clickable&:focus, $deletable&:focus': {
          backgroundColor: fade(theme.palette.text.primary, theme.palette.action.hoverOpacity)
        },
        '& $avatar': {
          marginLeft: 4
        },
        '& $avatarSmall': {
          marginLeft: 2
        },
        '& $icon': {
          marginLeft: 4
        },
        '& $iconSmall': {
          marginLeft: 2
        },
        '& $deleteIcon': {
          marginRight: 5
        },
        '& $deleteIconSmall': {
          marginRight: 3
        }
      },

      /* Styles applied to the root element if `variant="outlined"` and `color="primary"`. */
      outlinedPrimary: {
        color: theme.palette.primary.main,
        border: "1px solid ".concat(theme.palette.primary.main),
        '$clickable&:hover, $clickable&:focus, $deletable&:focus': {
          backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity)
        }
      },

      /* Styles applied to the root element if `variant="outlined"` and `color="secondary"`. */
      outlinedSecondary: {
        color: theme.palette.secondary.main,
        border: "1px solid ".concat(theme.palette.secondary.main),
        '$clickable&:hover, $clickable&:focus, $deletable&:focus': {
          backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity)
        }
      },
      // TODO remove in V5

      /* Styles applied to the `avatar` element. */
      avatar: {},

      /* Styles applied to the `avatar` element if `size="small"`. */
      avatarSmall: {},

      /* Styles applied to the `avatar` element if `color="primary"`. */
      avatarColorPrimary: {},

      /* Styles applied to the `avatar` element if `color="secondary"`. */
      avatarColorSecondary: {},

      /* Styles applied to the `icon` element. */
      icon: {
        color: theme.palette.type === 'light' ? theme.palette.grey[700] : theme.palette.grey[300],
        marginLeft: 5,
        marginRight: -6
      },

      /* Styles applied to the `icon` element if `size="small"`. */
      iconSmall: {
        width: 18,
        height: 18,
        marginLeft: 4,
        marginRight: -4
      },

      /* Styles applied to the `icon` element if `color="primary"`. */
      iconColorPrimary: {
        color: 'inherit'
      },

      /* Styles applied to the `icon` element if `color="secondary"`. */
      iconColorSecondary: {
        color: 'inherit'
      },

      /* Styles applied to the label `span` element`. */
      label: {
        display: 'flex',
        alignItems: 'center',
        paddingLeft: 12,
        paddingRight: 12,
        whiteSpace: 'nowrap'
      },
      labelSmall: {
        paddingLeft: 8,
        paddingRight: 8
      },

      /* Styles applied to the `deleteIcon` element. */
      deleteIcon: {
        // Remove grey highlight
        WebkitTapHighlightColor: 'transparent',
        color: deleteIconColor,
        height: 22,
        width: 22,
        cursor: 'pointer',
        margin: '0 5px 0 -6px',
        '&:hover': {
          color: fade(deleteIconColor, 0.4)
        }
      },

      /* Styles applied to the `deleteIcon` element if `size="small"`. */
      deleteIconSmall: {
        height: 16,
        width: 16,
        marginRight: 4,
        marginLeft: -4
      },

      /* Styles applied to the deleteIcon element if `color="primary"` and `variant="default"`. */
      deleteIconColorPrimary: {
        color: fade(theme.palette.primary.contrastText, 0.7),
        '&:hover, &:active': {
          color: theme.palette.primary.contrastText
        }
      },

      /* Styles applied to the deleteIcon element if `color="secondary"` and `variant="default"`. */
      deleteIconColorSecondary: {
        color: fade(theme.palette.secondary.contrastText, 0.7),
        '&:hover, &:active': {
          color: theme.palette.secondary.contrastText
        }
      },

      /* Styles applied to the deleteIcon element if `color="primary"` and `variant="outlined"`. */
      deleteIconOutlinedColorPrimary: {
        color: fade(theme.palette.primary.main, 0.7),
        '&:hover, &:active': {
          color: theme.palette.primary.main
        }
      },

      /* Styles applied to the deleteIcon element if `color="secondary"` and `variant="outlined"`. */
      deleteIconOutlinedColorSecondary: {
        color: fade(theme.palette.secondary.main, 0.7),
        '&:hover, &:active': {
          color: theme.palette.secondary.main
        }
      }
    };
  };
  /**
   * Chips represent complex entities in small blocks, such as a contact.
   */

  var Chip = React__default.forwardRef(function Chip(props, ref) {
    var avatarProp = props.avatar,
        classes = props.classes,
        className = props.className,
        clickableProp = props.clickable,
        _props$color = props.color,
        color = _props$color === void 0 ? 'default' : _props$color,
        ComponentProp = props.component,
        deleteIconProp = props.deleteIcon,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        iconProp = props.icon,
        label = props.label,
        onClick = props.onClick,
        onDelete = props.onDelete,
        onKeyUp = props.onKeyUp,
        _props$size = props.size,
        size = _props$size === void 0 ? 'medium' : _props$size,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'default' : _props$variant,
        other = _objectWithoutProperties(props, ["avatar", "classes", "className", "clickable", "color", "component", "deleteIcon", "disabled", "icon", "label", "onClick", "onDelete", "onKeyUp", "size", "variant"]);

    var chipRef = React__default.useRef(null);
    var handleRef = useForkRef(chipRef, ref);

    var handleDeleteIconClick = function handleDeleteIconClick(event) {
      // Stop the event from bubbling up to the `Chip`
      event.stopPropagation();

      if (onDelete) {
        onDelete(event);
      }
    };

    var handleKeyUp = function handleKeyUp(event) {
      if (onKeyUp) {
        onKeyUp(event);
      } // Ignore events from children of `Chip`.


      if (event.currentTarget !== event.target) {
        return;
      }

      var key = event.key;

      if (onDelete && (key === 'Backspace' || key === 'Delete')) {
        onDelete(event);
      } else if (key === 'Escape' && chipRef.current) {
        chipRef.current.blur();
      }
    };

    var clickable = clickableProp !== false && onClick ? true : clickableProp;
    var small = size === 'small';
    var Component = ComponentProp || (clickable ? ButtonBase$1 : 'div');
    var moreProps = Component === ButtonBase$1 ? {
      component: 'div'
    } : {};
    var deleteIcon = null;

    if (onDelete) {
      var customClasses = clsx(color !== 'default' && (variant === "default" ? classes["deleteIconColor".concat(capitalize(color))] : classes["deleteIconOutlinedColor".concat(capitalize(color))]), small && classes.deleteIconSmall);
      deleteIcon = deleteIconProp && React__default.isValidElement(deleteIconProp) ? React__default.cloneElement(deleteIconProp, {
        className: clsx(deleteIconProp.props.className, classes.deleteIcon, customClasses),
        onClick: handleDeleteIconClick
      }) : React__default.createElement(CancelIcon, {
        className: clsx(classes.deleteIcon, customClasses),
        onClick: handleDeleteIconClick
      });
    }

    var avatar = null;

    if (avatarProp && React__default.isValidElement(avatarProp)) {
      avatar = React__default.cloneElement(avatarProp, {
        className: clsx(classes.avatar, avatarProp.props.className, small && classes.avatarSmall, color !== 'default' && classes["avatarColor".concat(capitalize(color))])
      });
    }

    var icon = null;

    if (iconProp && React__default.isValidElement(iconProp)) {
      icon = React__default.cloneElement(iconProp, {
        className: clsx(classes.icon, iconProp.props.className, small && classes.iconSmall, color !== 'default' && classes["iconColor".concat(capitalize(color))])
      });
    }

    {
      if (avatar && icon) {
        console.error('Material-UI: the Chip component can not handle the avatar ' + 'and the icon prop at the same time. Pick one.');
      }
    }

    return React__default.createElement(Component, _extends({
      role: clickable || onDelete ? 'button' : undefined,
      className: clsx(classes.root, className, color !== 'default' && [classes["color".concat(capitalize(color))], clickable && classes["clickableColor".concat(capitalize(color))], onDelete && classes["deletableColor".concat(capitalize(color))]], variant !== "default" && [classes.outlined, {
        primary: classes.outlinedPrimary,
        secondary: classes.outlinedSecondary
      }[color]], disabled && classes.disabled, small && classes.sizeSmall, clickable && classes.clickable, onDelete && classes.deletable),
      "aria-disabled": disabled ? true : undefined,
      tabIndex: clickable || onDelete ? 0 : undefined,
      onClick: onClick,
      onKeyUp: handleKeyUp,
      ref: handleRef
    }, moreProps, other), avatar || icon, React__default.createElement("span", {
      className: clsx(classes.label, small && classes.labelSmall)
    }, label), deleteIcon);
  });
   Chip.propTypes = {
    /**
     * Avatar element.
     */
    avatar: propTypes.element,

    /**
     * This prop isn't supported.
     * Use the `component` prop if you need to change the children structure.
     */
    children: unsupportedProp,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If true, the chip will appear clickable, and will raise when pressed,
     * even if the onClick prop is not defined.
     * If false, the chip will not be clickable, even if onClick prop is defined.
     * This can be used, for example,
     * along with the component prop to indicate an anchor Chip is clickable.
     */
    clickable: propTypes.bool,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Override the default delete icon element. Shown only if `onDelete` is set.
     */
    deleteIcon: propTypes.element,

    /**
     * If `true`, the chip should be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * Icon element.
     */
    icon: propTypes.element,

    /**
     * The content of the label.
     */
    label: propTypes.node,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * Callback function fired when the delete icon is clicked.
     * If set, the delete icon will be shown.
     */
    onDelete: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * @ignore
     */
    onKeyUp: propTypes.func,

    /**
     * The size of the chip.
     */
    size: propTypes.oneOf(['small', 'medium']),

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['default', 'outlined'])
  } ;
  var Chip$1 = withStyles$1(styles$q, {
    name: 'MuiChip'
  })(Chip);

  var SIZE = 44;

  function getRelativeValue(value, min, max) {
    var clampedValue = Math.min(Math.max(min, value), max);
    return (clampedValue - min) / (max - min);
  }

  function easeOut(t) {
    t = getRelativeValue(t, 0, 1); // https://gist.github.com/gre/1650294

    t = (t -= 1) * t * t + 1;
    return t;
  }

  function easeIn(t) {
    return t * t;
  }

  var styles$r = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'inline-block'
      },

      /* Styles applied to the root element if `variant="static"`. */
      static: {
        transition: theme.transitions.create('transform')
      },

      /* Styles applied to the root element if `variant="indeterminate"`. */
      indeterminate: {
        animation: '$circular-rotate 1.4s linear infinite'
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the `svg` element. */
      svg: {
        display: 'block' // Keeps the progress centered

      },

      /* Styles applied to the `circle` svg path. */
      circle: {
        stroke: 'currentColor' // Use butt to follow the specification, by chance, it's already the default CSS value.
        // strokeLinecap: 'butt',

      },

      /* Styles applied to the `circle` svg path if `variant="static"`. */
      circleStatic: {
        transition: theme.transitions.create('stroke-dashoffset')
      },

      /* Styles applied to the `circle` svg path if `variant="indeterminate"`. */
      circleIndeterminate: {
        animation: '$circular-dash 1.4s ease-in-out infinite',
        // Some default value that looks fine waiting for the animation to kicks in.
        strokeDasharray: '80px, 200px',
        strokeDashoffset: '0px' // Add the unit to fix a Edge 16 and below bug.

      },
      '@keyframes circular-rotate': {
        '100%': {
          transform: 'rotate(360deg)'
        }
      },
      '@keyframes circular-dash': {
        '0%': {
          strokeDasharray: '1px, 200px',
          strokeDashoffset: '0px'
        },
        '50%': {
          strokeDasharray: '100px, 200px',
          strokeDashoffset: '-15px'
        },
        '100%': {
          strokeDasharray: '100px, 200px',
          strokeDashoffset: '-125px'
        }
      },

      /* Styles applied to the `circle` svg path if `disableShrink={true}`. */
      circleDisableShrink: {
        animation: 'none'
      }
    };
  };
  /**
   * ## ARIA
   *
   * If the progress bar is describing the loading progress of a particular region of a page,
   * you should use `aria-describedby` to point to the progress bar, and set the `aria-busy`
   * attribute to `true` on that region until it has finished loading.
   */

  var CircularProgress = React__default.forwardRef(function CircularProgress(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'primary' : _props$color,
        _props$disableShrink = props.disableShrink,
        disableShrink = _props$disableShrink === void 0 ? false : _props$disableShrink,
        _props$size = props.size,
        size = _props$size === void 0 ? 40 : _props$size,
        style = props.style,
        _props$thickness = props.thickness,
        thickness = _props$thickness === void 0 ? 3.6 : _props$thickness,
        _props$value = props.value,
        value = _props$value === void 0 ? 0 : _props$value,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'indeterminate' : _props$variant,
        other = _objectWithoutProperties(props, ["classes", "className", "color", "disableShrink", "size", "style", "thickness", "value", "variant"]);

    var circleStyle = {};
    var rootStyle = {};
    var rootProps = {};

    if (variant === 'determinate' || variant === 'static') {
      var circumference = 2 * Math.PI * ((SIZE - thickness) / 2);
      circleStyle.strokeDasharray = circumference.toFixed(3);
      rootProps['aria-valuenow'] = Math.round(value);

      if (variant === 'static') {
        circleStyle.strokeDashoffset = "".concat(((100 - value) / 100 * circumference).toFixed(3), "px");
        rootStyle.transform = 'rotate(-90deg)';
      } else {
        circleStyle.strokeDashoffset = "".concat((easeIn((100 - value) / 100) * circumference).toFixed(3), "px");
        rootStyle.transform = "rotate(".concat((easeOut(value / 70) * 270).toFixed(3), "deg)");
      }
    }

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, color !== 'inherit' && classes["color".concat(capitalize(color))], {
        indeterminate: classes.indeterminate,
        static: classes.static
      }[variant]),
      style: _extends({
        width: size,
        height: size
      }, rootStyle, {}, style),
      ref: ref,
      role: "progressbar"
    }, rootProps, other), React__default.createElement("svg", {
      className: classes.svg,
      viewBox: "".concat(SIZE / 2, " ").concat(SIZE / 2, " ").concat(SIZE, " ").concat(SIZE)
    }, React__default.createElement("circle", {
      className: clsx(classes.circle, disableShrink && classes.circleDisableShrink, {
        indeterminate: classes.circleIndeterminate,
        static: classes.circleStatic
      }[variant]),
      style: circleStyle,
      cx: SIZE,
      cy: SIZE,
      r: (SIZE - thickness) / 2,
      fill: "none",
      strokeWidth: thickness
    })));
  });
   CircularProgress.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary', 'inherit']),

    /**
     * If `true`, the shrink animation is disabled.
     * This only works if variant is `indeterminate`.
     */
    disableShrink: chainPropTypes(propTypes.bool, function (props) {
      if (props.disableShrink && props.variant && props.variant !== 'indeterminate') {
        return new Error('Material-UI: you have provided the `disableShrink` prop ' + 'with a variant other than `indeterminate`. This will have no effect.');
      }

      return null;
    }),

    /**
     * The size of the circle.
     * If using a number, the pixel unit is assumed.
     * If using a string, you need to provide the CSS unit, e.g '3rem'.
     */
    size: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * The thickness of the circle.
     */
    thickness: propTypes.number,

    /**
     * The value of the progress indicator for the determinate and static variants.
     * Value between 0 and 100.
     */
    value: propTypes.number,

    /**
     * The variant to use.
     * Use indeterminate when there is no progress value.
     */
    variant: propTypes.oneOf(['determinate', 'indeterminate', 'static'])
  } ;
  var CircularProgress$1 = withStyles$1(styles$r, {
    name: 'MuiCircularProgress',
    flip: false
  })(CircularProgress);

  function ownerDocument(node) {
    return node && node.ownerDocument || document;
  }

  function mapEventPropToEvent(eventProp) {
    return eventProp.substring(2).toLowerCase();
  }
  /**
   * Listen for click events that occur somewhere in the document, outside of the element itself.
   * For instance, if you need to hide a menu when people click anywhere else on your page.
   */


  var ClickAwayListener = React__default.forwardRef(function ClickAwayListener(props, ref) {
    var children = props.children,
        _props$mouseEvent = props.mouseEvent,
        mouseEvent = _props$mouseEvent === void 0 ? 'onClick' : _props$mouseEvent,
        _props$touchEvent = props.touchEvent,
        touchEvent = _props$touchEvent === void 0 ? 'onTouchEnd' : _props$touchEvent,
        onClickAway = props.onClickAway;
    var movedRef = React__default.useRef(false);
    var nodeRef = React__default.useRef(null);
    var mountedRef = React__default.useRef(false);
    React__default.useEffect(function () {
      mountedRef.current = true;
      return function () {
        mountedRef.current = false;
      };
    }, []);
    var handleNodeRef = useForkRef(nodeRef, ref); // can be removed once we drop support for non ref forwarding class components

    var handleOwnRef = React__default.useCallback(function (instance) {
      // #StrictMode ready
      setRef(handleNodeRef, ReactDOM.findDOMNode(instance));
    }, [handleNodeRef]);
    var handleRef = useForkRef(children.ref, handleOwnRef);
    var handleClickAway = useEventCallback(function (event) {
      // Ignore events that have been `event.preventDefault()` marked.
      if (event.defaultPrevented) {
        return;
      } // IE 11 support, which trigger the handleClickAway even after the unbind


      if (!mountedRef.current) {
        return;
      } // Do not act if user performed touchmove


      if (movedRef.current) {
        movedRef.current = false;
        return;
      } // The child might render null.


      if (!nodeRef.current) {
        return;
      } // Multi window support


      var doc = ownerDocument(nodeRef.current);

      if (doc.documentElement && doc.documentElement.contains(event.target) && !nodeRef.current.contains(event.target)) {
        onClickAway(event);
      }
    });
    var handleTouchMove = React__default.useCallback(function () {
      movedRef.current = true;
    }, []);
    React__default.useEffect(function () {
      if (touchEvent !== false) {
        var mappedTouchEvent = mapEventPropToEvent(touchEvent);
        document.addEventListener(mappedTouchEvent, handleClickAway);
        document.addEventListener('touchmove', handleTouchMove);
        return function () {
          document.removeEventListener(mappedTouchEvent, handleClickAway);
          document.removeEventListener('touchmove', handleTouchMove);
        };
      }

      return undefined;
    }, [handleClickAway, handleTouchMove, touchEvent]);
    React__default.useEffect(function () {
      if (mouseEvent !== false) {
        var mappedMouseEvent = mapEventPropToEvent(mouseEvent);
        document.addEventListener(mappedMouseEvent, handleClickAway);
        return function () {
          document.removeEventListener(mappedMouseEvent, handleClickAway);
        };
      }

      return undefined;
    }, [handleClickAway, mouseEvent]);
    return React__default.createElement(React__default.Fragment, null, React__default.cloneElement(children, {
      ref: handleRef
    }));
  });
   ClickAwayListener.propTypes = {
    /**
     * The wrapped element.
     */
    children: elementAcceptingRef.isRequired,

    /**
     * The mouse event to listen to. You can disable the listener by providing `false`.
     */
    mouseEvent: propTypes.oneOf(['onClick', 'onMouseDown', 'onMouseUp', false]),

    /**
     * Callback fired when a "click away" event is detected.
     */
    onClickAway: propTypes.func.isRequired,

    /**
     * The touch event to listen to. You can disable the listener by providing `false`.
     */
    touchEvent: propTypes.oneOf(['onTouchStart', 'onTouchEnd', false])
  } ;

  {
    // eslint-disable-next-line
    ClickAwayListener['propTypes' + ''] = exactProp(ClickAwayListener.propTypes);
  }

  var styles$s = function styles(theme) {
    return {
      /* Styles applied to the container element. */
      container: {
        height: 0,
        overflow: 'hidden',
        transition: theme.transitions.create('height')
      },

      /* Styles applied to the container element when the transition has entered. */
      entered: {
        height: 'auto',
        overflow: 'visible'
      },

      /* Styles applied to the container element when the transition has exited and `collapsedHeight` != 0px. */
      hidden: {
        visibility: 'hidden'
      },

      /* Styles applied to the outer wrapper element. */
      wrapper: {
        // Hack to get children with a negative margin to not falsify the height computation.
        display: 'flex'
      },

      /* Styles applied to the inner wrapper element. */
      wrapperInner: {
        width: '100%'
      }
    };
  };
  /**
   * The Collapse transition is used by the
   * [Vertical Stepper](/components/steppers/#vertical-stepper) StepContent component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  var Collapse = React__default.forwardRef(function Collapse(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$collapsedHeigh = props.collapsedHeight,
        collapsedHeight = _props$collapsedHeigh === void 0 ? '0px' : _props$collapsedHeigh,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        inProp = props.in,
        onEnter = props.onEnter,
        onEntered = props.onEntered,
        onEntering = props.onEntering,
        onExit = props.onExit,
        onExiting = props.onExiting,
        style = props.style,
        _props$timeout = props.timeout,
        timeout = _props$timeout === void 0 ? duration.standard : _props$timeout,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "collapsedHeight", "component", "in", "onEnter", "onEntered", "onEntering", "onExit", "onExiting", "style", "timeout"]);

    var theme = useTheme$1();
    var timer = React__default.useRef();
    var wrapperRef = React__default.useRef(null);
    var autoTransitionDuration = React__default.useRef();
    React__default.useEffect(function () {
      return function () {
        clearTimeout(timer.current);
      };
    }, []);

    var handleEnter = function handleEnter(node, isAppearing) {
      node.style.height = collapsedHeight;

      if (onEnter) {
        onEnter(node, isAppearing);
      }
    };

    var handleEntering = function handleEntering(node, isAppearing) {
      var wrapperHeight = wrapperRef.current ? wrapperRef.current.clientHeight : 0;

      var _getTransitionProps = getTransitionProps({
        style: style,
        timeout: timeout
      }, {
        mode: 'enter'
      }),
          transitionDuration = _getTransitionProps.duration;

      if (timeout === 'auto') {
        var duration2 = theme.transitions.getAutoHeightDuration(wrapperHeight);
        node.style.transitionDuration = "".concat(duration2, "ms");
        autoTransitionDuration.current = duration2;
      } else {
        node.style.transitionDuration = typeof transitionDuration === 'string' ? transitionDuration : "".concat(transitionDuration, "ms");
      }

      node.style.height = "".concat(wrapperHeight, "px");

      if (onEntering) {
        onEntering(node, isAppearing);
      }
    };

    var handleEntered = function handleEntered(node, isAppearing) {
      node.style.height = 'auto';

      if (onEntered) {
        onEntered(node, isAppearing);
      }
    };

    var handleExit = function handleExit(node) {
      var wrapperHeight = wrapperRef.current ? wrapperRef.current.clientHeight : 0;
      node.style.height = "".concat(wrapperHeight, "px");

      if (onExit) {
        onExit(node);
      }
    };

    var handleExiting = function handleExiting(node) {
      var wrapperHeight = wrapperRef.current ? wrapperRef.current.clientHeight : 0;

      var _getTransitionProps2 = getTransitionProps({
        style: style,
        timeout: timeout
      }, {
        mode: 'exit'
      }),
          transitionDuration = _getTransitionProps2.duration;

      if (timeout === 'auto') {
        var duration2 = theme.transitions.getAutoHeightDuration(wrapperHeight);
        node.style.transitionDuration = "".concat(duration2, "ms");
        autoTransitionDuration.current = duration2;
      } else {
        node.style.transitionDuration = typeof transitionDuration === 'string' ? transitionDuration : "".concat(transitionDuration, "ms");
      }

      node.style.height = collapsedHeight;

      if (onExiting) {
        onExiting(node);
      }
    };

    var addEndListener = function addEndListener(_, next) {
      if (timeout === 'auto') {
        timer.current = setTimeout(next, autoTransitionDuration.current || 0);
      }
    };

    return React__default.createElement(Transition, _extends({
      in: inProp,
      onEnter: handleEnter,
      onEntered: handleEntered,
      onEntering: handleEntering,
      onExit: handleExit,
      onExiting: handleExiting,
      addEndListener: addEndListener,
      timeout: timeout === 'auto' ? null : timeout
    }, other), function (state, childProps) {
      return React__default.createElement(Component, _extends({
        className: clsx(classes.container, className, {
          entered: classes.entered,
          exited: !inProp && collapsedHeight === '0px' && classes.hidden
        }[state]),
        style: _extends({
          minHeight: collapsedHeight
        }, style),
        ref: ref
      }, childProps), React__default.createElement("div", {
        className: classes.wrapper,
        ref: wrapperRef
      }, React__default.createElement("div", {
        className: classes.wrapperInner
      }, children)));
    });
  });
   Collapse.propTypes = {
    /**
     * The content node to be collapsed.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The height of the container when collapsed.
     */
    collapsedHeight: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the component will transition in.
     */
    in: propTypes.bool,

    /**
     * @ignore
     */
    onEnter: propTypes.func,

    /**
     * @ignore
     */
    onEntered: propTypes.func,

    /**
     * @ignore
     */
    onEntering: propTypes.func,

    /**
     * @ignore
     */
    onExit: propTypes.func,

    /**
     * @ignore
     */
    onExiting: propTypes.func,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     *
     * Set to 'auto' to automatically calculate transition time based on height.
     */
    timeout: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])])
  } ;
  Collapse.muiSupportAuto = true;
  var Collapse$1 = withStyles$1(styles$s, {
    name: 'MuiCollapse'
  })(Collapse);

  var styles$t = function styles(theme) {
    var _root;

    return {
      /* Styles applied to the root element. */
      root: (_root = {
        width: '100%',
        marginLeft: 'auto',
        boxSizing: 'border-box',
        marginRight: 'auto',
        paddingLeft: theme.spacing(2),
        paddingRight: theme.spacing(2)
      }, _defineProperty(_root, theme.breakpoints.up('sm'), {
        paddingLeft: theme.spacing(3),
        paddingRight: theme.spacing(3)
      }), _defineProperty(_root, theme.breakpoints.up('md'), {
        paddingLeft: theme.spacing(4),
        paddingRight: theme.spacing(4)
      }), _root),

      /* Styles applied to the root element if `fixed={true}`. */
      fixed: Object.keys(theme.breakpoints.values).reduce(function (acc, breakpoint) {
        var value = theme.breakpoints.values[breakpoint];

        if (value !== 0) {
          acc[theme.breakpoints.up(breakpoint)] = {
            maxWidth: value
          };
        }

        return acc;
      }, {}),

      /* Styles applied to the root element if `maxWidth="xs"`. */
      maxWidthXs: _defineProperty({}, theme.breakpoints.up('xs'), {
        maxWidth: Math.max(theme.breakpoints.values.xs, 444)
      }),

      /* Styles applied to the root element if `maxWidth="sm"`. */
      maxWidthSm: _defineProperty({}, theme.breakpoints.up('sm'), {
        maxWidth: theme.breakpoints.values.sm
      }),

      /* Styles applied to the root element if `maxWidth="md"`. */
      maxWidthMd: _defineProperty({}, theme.breakpoints.up('md'), {
        maxWidth: theme.breakpoints.values.md
      }),

      /* Styles applied to the root element if `maxWidth="lg"`. */
      maxWidthLg: _defineProperty({}, theme.breakpoints.up('lg'), {
        maxWidth: theme.breakpoints.values.lg
      }),

      /* Styles applied to the root element if `maxWidth="xl"`. */
      maxWidthXl: _defineProperty({}, theme.breakpoints.up('xl'), {
        maxWidth: theme.breakpoints.values.xl
      })
    };
  };
  var Container = React__default.forwardRef(function Container(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        _props$fixed = props.fixed,
        fixed = _props$fixed === void 0 ? false : _props$fixed,
        _props$maxWidth = props.maxWidth,
        maxWidth = _props$maxWidth === void 0 ? 'lg' : _props$maxWidth,
        other = _objectWithoutProperties(props, ["classes", "className", "component", "fixed", "maxWidth"]);

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, fixed && classes.fixed, maxWidth !== false && classes["maxWidth".concat(capitalize(String(maxWidth)))]),
      ref: ref
    }, other));
  });
   Container.propTypes = {
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Set the max-width to match the min-width of the current breakpoint.
     * This is useful if you'd prefer to design for a fixed set of sizes
     * instead of trying to accommodate a fully fluid viewport.
     * It's fluid by default.
     */
    fixed: propTypes.bool,

    /**
     * Determine the max-width of the container.
     * The container width grows with the size of the screen.
     * Set to `false` to disable `maxWidth`.
     */
    maxWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl', false])
  } ;
  var Container$1 = withStyles$1(styles$t, {
    name: 'MuiContainer'
  })(Container);

  var useStyles = makeStyles$1(function (theme) {
    return {
      '@global': {
        html: {
          WebkitFontSmoothing: 'antialiased',
          // Antialiasing.
          MozOsxFontSmoothing: 'grayscale',
          // Antialiasing.
          // Change from `box-sizing: content-box` so that `width`
          // is not affected by `padding` or `border`.
          boxSizing: 'border-box'
        },
        '*, *::before, *::after': {
          boxSizing: 'inherit'
        },
        'strong, b': {
          fontWeight: 'bolder'
        },
        body: _extends({
          margin: 0,
          // Remove the margin in all browsers.
          color: theme.palette.text.primary
        }, theme.typography.body2, {
          backgroundColor: theme.palette.background.default,
          '@media print': {
            // Save printer ink.
            backgroundColor: theme.palette.common.white
          },
          // Add support for document.body.requestFullScreen().
          // Other elements, if background transparent, are not supported.
          '&::backdrop': {
            backgroundColor: theme.palette.background.default
          }
        })
      }
    };
  }, {
    name: 'MuiCssBaseline'
  });
  /**
   * Kickstart an elegant, consistent, and simple baseline to build upon.
   */

  function CssBaseline(props) {
    var _props$children = props.children,
        children = _props$children === void 0 ? null : _props$children;
    useStyles();
    return React__default.createElement(React__default.Fragment, null, children);
  }

   CssBaseline.propTypes = {
    /**
     * You can wrap a node.
     */
    children: propTypes.node
  } ;

  {
    // eslint-disable-next-line
    CssBaseline['propTypes' + ''] = exactProp(CssBaseline.propTypes);
  }

  function getContainer(container) {
    container = typeof container === 'function' ? container() : container; // #StrictMode ready

    return ReactDOM.findDOMNode(container);
  }

  var useEnhancedEffect$3 = typeof window !== 'undefined' ? React__default.useLayoutEffect : React__default.useEffect;
  /**
   * Portals provide a first-class way to render children into a DOM node
   * that exists outside the DOM hierarchy of the parent component.
   */

  var Portal = React__default.forwardRef(function Portal(props, ref) {
    var children = props.children,
        container = props.container,
        _props$disablePortal = props.disablePortal,
        disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal,
        onRendered = props.onRendered;

    var _React$useState = React__default.useState(null),
        mountNode = _React$useState[0],
        setMountNode = _React$useState[1];

    var handleRef = useForkRef(children.ref, ref);
    useEnhancedEffect$3(function () {
      if (!disablePortal) {
        setMountNode(getContainer(container) || document.body);
      }
    }, [container, disablePortal]);
    useEnhancedEffect$3(function () {
      if (mountNode && !disablePortal) {
        setRef(ref, mountNode);
        return function () {
          setRef(ref, null);
        };
      }

      return undefined;
    }, [ref, mountNode, disablePortal]);
    useEnhancedEffect$3(function () {
      if (onRendered && (mountNode || disablePortal)) {
        onRendered();
      }
    }, [onRendered, mountNode, disablePortal]);

    if (disablePortal) {
      React__default.Children.only(children);
      return React__default.cloneElement(children, {
        ref: handleRef
      });
    }

    return mountNode ? ReactDOM.createPortal(children, mountNode) : mountNode;
  });
   Portal.propTypes = {
    // ----------------------------- Warning --------------------------------
    // | These PropTypes are generated from the TypeScript type definitions |
    // |     To update them edit the d.ts file and run "yarn proptypes"     |
    // ----------------------------------------------------------------------

    /**
     * The children to render into the `container`.
     */
    children: propTypes.node,

    /**
     * A node, component instance, or function that returns either.
     * The `container` will have the portal children appended to it.
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: propTypes.oneOfType([propTypes.func, propTypes.instanceOf(React__default.Component), propTypes.instanceOf(typeof Element === 'undefined' ? Object : Element)]),

    /**
     * Disable the portal behavior.
     * The children stay within it's parent DOM hierarchy.
     */
    disablePortal: propTypes.bool,

    /**
     * Callback fired once the children has been mounted into the `container`.
     *
     * This prop will be deprecated and removed in v5, the ref can be used instead.
     */
    onRendered: propTypes.func
  } ;

  {
    // eslint-disable-next-line
    Portal['propTypes' + ''] = exactProp(Portal.propTypes);
  }

  /**
   * Safe chained function
   *
   * Will only create a new function if needed,
   * otherwise will pass back existing functions or null.
   *
   * @param {function} functions to chain
   * @returns {function|null}
   */
  function createChainedFunction() {
    for (var _len = arguments.length, funcs = new Array(_len), _key = 0; _key < _len; _key++) {
      funcs[_key] = arguments[_key];
    }

    return funcs.reduce(function (acc, func) {
      if (func == null) {
        return acc;
      }

      {
        if (typeof func !== 'function') {
          console.error('Material-UI: invalid Argument Type, must only provide functions, undefined, or null.');
        }
      }

      return function chainedFunction() {
        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        acc.apply(this, args);
        func.apply(this, args);
      };
    }, function () {});
  }

  // A change of the browser zoom change the scrollbar size.
  // Credit https://github.com/twbs/bootstrap/blob/3ffe3a5d82f6f561b82ff78d82b32a7d14aed558/js/src/modal.js#L512-L519
  function getScrollbarSize() {
    var scrollDiv = document.createElement('div');
    scrollDiv.style.width = '99px';
    scrollDiv.style.height = '99px';
    scrollDiv.style.position = 'absolute';
    scrollDiv.style.top = '-9999px';
    scrollDiv.style.overflow = 'scroll';
    document.body.appendChild(scrollDiv);
    var scrollbarSize = scrollDiv.offsetWidth - scrollDiv.clientWidth;
    document.body.removeChild(scrollDiv);
    return scrollbarSize;
  }

  function ownerWindow(node) {
    var doc = ownerDocument(node);
    return doc.defaultView || window;
  }

  function isOverflowing(container) {
    var doc = ownerDocument(container);

    if (doc.body === container) {
      return ownerWindow(doc).innerWidth > doc.documentElement.clientWidth;
    }

    return container.scrollHeight > container.clientHeight;
  }

  function ariaHidden(node, show) {
    if (show) {
      node.setAttribute('aria-hidden', 'true');
    } else {
      node.removeAttribute('aria-hidden');
    }
  }

  function getPaddingRight(node) {
    return parseInt(window.getComputedStyle(node)['padding-right'], 10) || 0;
  }

  function ariaHiddenSiblings(container, mountNode, currentNode) {
    var nodesToExclude = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
    var show = arguments.length > 4 ? arguments[4] : undefined;
    var blacklist = [mountNode, currentNode].concat(_toConsumableArray(nodesToExclude));
    var blacklistTagNames = ['TEMPLATE', 'SCRIPT', 'STYLE'];
    [].forEach.call(container.children, function (node) {
      if (node.nodeType === 1 && blacklist.indexOf(node) === -1 && blacklistTagNames.indexOf(node.tagName) === -1) {
        ariaHidden(node, show);
      }
    });
  }

  function findIndexOf(containerInfo, callback) {
    var idx = -1;
    containerInfo.some(function (item, index) {
      if (callback(item)) {
        idx = index;
        return true;
      }

      return false;
    });
    return idx;
  }

  function handleContainer(containerInfo, props) {
    var restoreStyle = [];
    var restorePaddings = [];
    var container = containerInfo.container;
    var fixedNodes;

    if (!props.disableScrollLock) {
      var overflowing = isOverflowing(container); // Improve Gatsby support
      // https://css-tricks.com/snippets/css/force-vertical-scrollbar/

      var parent = container.parentElement;
      var scrollContainer = parent.nodeName === 'HTML' ? parent : container;
      restoreStyle.push({
        value: scrollContainer.style.overflow,
        key: 'overflow',
        el: scrollContainer
      }); // Block the scroll even if no scrollbar is visible to account for mobile keyboard
      // screensize shrink.

      scrollContainer.style.overflow = 'hidden';

      if (overflowing) {
        var scrollbarSize = getScrollbarSize();
        restoreStyle.push({
          value: container.style.paddingRight,
          key: 'padding-right',
          el: container
        }); // Use computed style, here to get the real padding to add our scrollbar width.

        container.style['padding-right'] = "".concat(getPaddingRight(container) + scrollbarSize, "px"); // .mui-fixed is a global helper.

        fixedNodes = ownerDocument(container).querySelectorAll('.mui-fixed');
        [].forEach.call(fixedNodes, function (node) {
          restorePaddings.push(node.style.paddingRight);
          node.style.paddingRight = "".concat(getPaddingRight(node) + scrollbarSize, "px");
        });
      }
    }

    var restore = function restore() {
      if (fixedNodes) {
        [].forEach.call(fixedNodes, function (node, i) {
          if (restorePaddings[i]) {
            node.style.paddingRight = restorePaddings[i];
          } else {
            node.style.removeProperty('padding-right');
          }
        });
      }

      restoreStyle.forEach(function (_ref) {
        var value = _ref.value,
            el = _ref.el,
            key = _ref.key;

        if (value) {
          el.style.setProperty(key, value);
        } else {
          el.style.removeProperty(key);
        }
      });
    };

    return restore;
  }

  function getHiddenSiblings(container) {
    var hiddenSiblings = [];
    [].forEach.call(container.children, function (node) {
      if (node.getAttribute && node.getAttribute('aria-hidden') === 'true') {
        hiddenSiblings.push(node);
      }
    });
    return hiddenSiblings;
  }
  /**
   * @ignore - do not document.
   *
   * Proper state management for containers and the modals in those containers.
   * Simplified, but inspired by react-overlay's ModalManager class.
   * Used by the Modal to ensure proper styling of containers.
   */


  var ModalManager =
  /*#__PURE__*/
  function () {
    function ModalManager() {
      _classCallCheck(this, ModalManager);

      // this.modals[modalIndex] = modal
      this.modals = []; // this.containers[containerIndex] = {
      //   modals: [],
      //   container,
      //   restore: null,
      // }

      this.containers = [];
    }

    _createClass(ModalManager, [{
      key: "add",
      value: function add(modal, container) {
        var modalIndex = this.modals.indexOf(modal);

        if (modalIndex !== -1) {
          return modalIndex;
        }

        modalIndex = this.modals.length;
        this.modals.push(modal); // If the modal we are adding is already in the DOM.

        if (modal.modalRef) {
          ariaHidden(modal.modalRef, false);
        }

        var hiddenSiblingNodes = getHiddenSiblings(container);
        ariaHiddenSiblings(container, modal.mountNode, modal.modalRef, hiddenSiblingNodes, true);
        var containerIndex = findIndexOf(this.containers, function (item) {
          return item.container === container;
        });

        if (containerIndex !== -1) {
          this.containers[containerIndex].modals.push(modal);
          return modalIndex;
        }

        this.containers.push({
          modals: [modal],
          container: container,
          restore: null,
          hiddenSiblingNodes: hiddenSiblingNodes
        });
        return modalIndex;
      }
    }, {
      key: "mount",
      value: function mount(modal, props) {
        var containerIndex = findIndexOf(this.containers, function (item) {
          return item.modals.indexOf(modal) !== -1;
        });
        var containerInfo = this.containers[containerIndex];

        if (!containerInfo.restore) {
          containerInfo.restore = handleContainer(containerInfo, props);
        }
      }
    }, {
      key: "remove",
      value: function remove(modal) {
        var modalIndex = this.modals.indexOf(modal);

        if (modalIndex === -1) {
          return modalIndex;
        }

        var containerIndex = findIndexOf(this.containers, function (item) {
          return item.modals.indexOf(modal) !== -1;
        });
        var containerInfo = this.containers[containerIndex];
        containerInfo.modals.splice(containerInfo.modals.indexOf(modal), 1);
        this.modals.splice(modalIndex, 1); // If that was the last modal in a container, clean up the container.

        if (containerInfo.modals.length === 0) {
          // The modal might be closed before it had the chance to be mounted in the DOM.
          if (containerInfo.restore) {
            containerInfo.restore();
          }

          if (modal.modalRef) {
            // In case the modal wasn't in the DOM yet.
            ariaHidden(modal.modalRef, true);
          }

          ariaHiddenSiblings(containerInfo.container, modal.mountNode, modal.modalRef, containerInfo.hiddenSiblingNodes, false);
          this.containers.splice(containerIndex, 1);
        } else {
          // Otherwise make sure the next top modal is visible to a screen reader.
          var nextTop = containerInfo.modals[containerInfo.modals.length - 1]; // as soon as a modal is adding its modalRef is undefined. it can't set
          // aria-hidden because the dom element doesn't exist either
          // when modal was unmounted before modalRef gets null

          if (nextTop.modalRef) {
            ariaHidden(nextTop.modalRef, false);
          }
        }

        return modalIndex;
      }
    }, {
      key: "isTopModal",
      value: function isTopModal(modal) {
        return this.modals.length > 0 && this.modals[this.modals.length - 1] === modal;
      }
    }]);

    return ModalManager;
  }();

  /**
   * @ignore - internal component.
   */

  function TrapFocus(props) {
    var children = props.children,
        _props$disableAutoFoc = props.disableAutoFocus,
        disableAutoFocus = _props$disableAutoFoc === void 0 ? false : _props$disableAutoFoc,
        _props$disableEnforce = props.disableEnforceFocus,
        disableEnforceFocus = _props$disableEnforce === void 0 ? false : _props$disableEnforce,
        _props$disableRestore = props.disableRestoreFocus,
        disableRestoreFocus = _props$disableRestore === void 0 ? false : _props$disableRestore,
        getDoc = props.getDoc,
        isEnabled = props.isEnabled,
        open = props.open;
    var ignoreNextEnforceFocus = React__default.useRef();
    var sentinelStart = React__default.useRef(null);
    var sentinelEnd = React__default.useRef(null);
    var nodeToRestore = React__default.useRef();
    var rootRef = React__default.useRef(null); // can be removed once we drop support for non ref forwarding class components

    var handleOwnRef = React__default.useCallback(function (instance) {
      // #StrictMode ready
      rootRef.current = ReactDOM.findDOMNode(instance);
    }, []);
    var handleRef = useForkRef(children.ref, handleOwnRef); // ⚠️ You may rely on React.useMemo as a performance optimization, not as a semantic guarantee.
    // https://reactjs.org/docs/hooks-reference.html#usememo

    React__default.useMemo(function () {
      if (!open || typeof window === 'undefined') {
        return;
      }

      nodeToRestore.current = getDoc().activeElement;
    }, [open]); // eslint-disable-line react-hooks/exhaustive-deps

    React__default.useEffect(function () {
      if (!open) {
        return;
      }

      var doc = ownerDocument(rootRef.current); // We might render an empty child.

      if (!disableAutoFocus && rootRef.current && !rootRef.current.contains(doc.activeElement)) {
        if (!rootRef.current.hasAttribute('tabIndex')) {
          {
            console.error(['Material-UI: the modal content node does not accept focus.', 'For the benefit of assistive technologies, ' + 'the tabIndex of the node is being set to "-1".'].join('\n'));
          }

          rootRef.current.setAttribute('tabIndex', -1);
        }

        rootRef.current.focus();
      }

      var contain = function contain() {
        if (disableEnforceFocus || !isEnabled() || ignoreNextEnforceFocus.current) {
          ignoreNextEnforceFocus.current = false;
          return;
        }

        if (rootRef.current && !rootRef.current.contains(doc.activeElement)) {
          rootRef.current.focus();
        }
      };

      var loopFocus = function loopFocus(event) {
        // 9 = Tab
        if (disableEnforceFocus || !isEnabled() || event.keyCode !== 9) {
          return;
        } // Make sure the next tab starts from the right place.


        if (doc.activeElement === rootRef.current) {
          // We need to ignore the next contain as
          // it will try to move the focus back to the rootRef element.
          ignoreNextEnforceFocus.current = true;

          if (event.shiftKey) {
            sentinelEnd.current.focus();
          } else {
            sentinelStart.current.focus();
          }
        }
      };

      doc.addEventListener('focus', contain, true);
      doc.addEventListener('keydown', loopFocus, true); // With Edge, Safari and Firefox, no focus related events are fired when the focused area stops being a focused area
      // e.g. https://bugzilla.mozilla.org/show_bug.cgi?id=559561.
      //
      // The whatwg spec defines how the browser should behave but does not explicitly mention any events:
      // https://html.spec.whatwg.org/multipage/interaction.html#focus-fixup-rule.

      var interval = setInterval(function () {
        contain();
      }, 50);
      return function () {
        clearInterval(interval);
        doc.removeEventListener('focus', contain, true);
        doc.removeEventListener('keydown', loopFocus, true); // restoreLastFocus()

        if (!disableRestoreFocus) {
          // In IE 11 it is possible for document.activeElement to be null resulting
          // in nodeToRestore.current being null.
          // Not all elements in IE 11 have a focus method.
          // Once IE 11 support is dropped the focus() call can be unconditional.
          if (nodeToRestore.current && nodeToRestore.current.focus) {
            nodeToRestore.current.focus();
          }

          nodeToRestore.current = null;
        }
      };
    }, [disableAutoFocus, disableEnforceFocus, disableRestoreFocus, isEnabled, open]);
    return React__default.createElement(React__default.Fragment, null, React__default.createElement("div", {
      tabIndex: 0,
      ref: sentinelStart,
      "data-test": "sentinelStart"
    }), React__default.cloneElement(children, {
      ref: handleRef
    }), React__default.createElement("div", {
      tabIndex: 0,
      ref: sentinelEnd,
      "data-test": "sentinelEnd"
    }));
  }

   TrapFocus.propTypes = {
    /**
     * A single child content element.
     */
    children: propTypes.element.isRequired,

    /**
     * If `true`, the modal will not automatically shift focus to itself when it opens, and
     * replace it to the last focused element when it closes.
     * This also works correctly with any modal children that have the `disableAutoFocus` prop.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     */
    disableAutoFocus: propTypes.bool,

    /**
     * If `true`, the modal will not prevent focus from leaving the modal while open.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     */
    disableEnforceFocus: propTypes.bool,

    /**
     * If `true`, the modal will not restore focus to previously focused element once
     * modal is hidden.
     */
    disableRestoreFocus: propTypes.bool,

    /**
     * Return the document to consider.
     * We use it to implement the restore focus between different browser documents.
     */
    getDoc: propTypes.func.isRequired,

    /**
     * Do we still want to enforce the focus?
     * This prop helps nesting TrapFocus elements.
     */
    isEnabled: propTypes.func.isRequired,

    /**
     * If `true`, the modal is open.
     */
    open: propTypes.bool.isRequired
  } ;

  var styles$u = {
    /* Styles applied to the root element. */
    root: {
      zIndex: -1,
      position: 'fixed',
      right: 0,
      bottom: 0,
      top: 0,
      left: 0,
      backgroundColor: 'rgba(0, 0, 0, 0.5)',
      // Remove grey highlight
      WebkitTapHighlightColor: 'transparent',
      // Disable scroll capabilities.
      touchAction: 'none'
    },

    /* Styles applied to the root element if `invisible={true}`. */
    invisible: {
      backgroundColor: 'transparent'
    }
  };
  /**
   * @ignore - internal component.
   */

  var SimpleBackdrop = React__default.forwardRef(function SimpleBackdrop(props, ref) {
    var _props$invisible = props.invisible,
        invisible = _props$invisible === void 0 ? false : _props$invisible,
        open = props.open,
        other = _objectWithoutProperties(props, ["invisible", "open"]);

    return open ? React__default.createElement("div", _extends({
      "aria-hidden": true,
      ref: ref
    }, other, {
      style: _extends({}, styles$u.root, {}, invisible ? styles$u.invisible : {}, {}, other.style)
    })) : null;
  });
   SimpleBackdrop.propTypes = {
    /**
     * If `true`, the backdrop is invisible.
     * It can be used when rendering a popover or a custom select component.
     */
    invisible: propTypes.bool,

    /**
     * If `true`, the backdrop is open.
     */
    open: propTypes.bool.isRequired
  } ;

  function getContainer$1(container) {
    container = typeof container === 'function' ? container() : container;
    return ReactDOM.findDOMNode(container);
  }

  function getHasTransition(props) {
    return props.children ? props.children.props.hasOwnProperty('in') : false;
  } // A modal manager used to track and manage the state of open Modals.
  // Modals don't open on the server so this won't conflict with concurrent requests.


  var defaultManager = new ModalManager();
  var styles$v = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'fixed',
        zIndex: theme.zIndex.modal,
        right: 0,
        bottom: 0,
        top: 0,
        left: 0
      },

      /* Styles applied to the root element if the `Modal` has exited. */
      hidden: {
        visibility: 'hidden'
      }
    };
  };
  /**
   * Modal is a lower-level construct that is leveraged by the following components:
   *
   * - [Dialog](/api/dialog/)
   * - [Drawer](/api/drawer/)
   * - [Menu](/api/menu/)
   * - [Popover](/api/popover/)
   *
   * If you are creating a modal dialog, you probably want to use the [Dialog](/api/dialog/) component
   * rather than directly using Modal.
   *
   * This component shares many concepts with [react-overlays](https://react-bootstrap.github.io/react-overlays/#modals).
   */

  var Modal = React__default.forwardRef(function Modal(inProps, ref) {
    var theme = useTheme();
    var props = getThemeProps({
      name: 'MuiModal',
      props: _extends({}, inProps),
      theme: theme
    });

    var _props$BackdropCompon = props.BackdropComponent,
        BackdropComponent = _props$BackdropCompon === void 0 ? SimpleBackdrop : _props$BackdropCompon,
        BackdropProps = props.BackdropProps,
        children = props.children,
        _props$closeAfterTran = props.closeAfterTransition,
        closeAfterTransition = _props$closeAfterTran === void 0 ? false : _props$closeAfterTran,
        container = props.container,
        _props$disableAutoFoc = props.disableAutoFocus,
        disableAutoFocus = _props$disableAutoFoc === void 0 ? false : _props$disableAutoFoc,
        _props$disableBackdro = props.disableBackdropClick,
        disableBackdropClick = _props$disableBackdro === void 0 ? false : _props$disableBackdro,
        _props$disableEnforce = props.disableEnforceFocus,
        disableEnforceFocus = _props$disableEnforce === void 0 ? false : _props$disableEnforce,
        _props$disableEscapeK = props.disableEscapeKeyDown,
        disableEscapeKeyDown = _props$disableEscapeK === void 0 ? false : _props$disableEscapeK,
        _props$disablePortal = props.disablePortal,
        disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal,
        _props$disableRestore = props.disableRestoreFocus,
        disableRestoreFocus = _props$disableRestore === void 0 ? false : _props$disableRestore,
        _props$disableScrollL = props.disableScrollLock,
        disableScrollLock = _props$disableScrollL === void 0 ? false : _props$disableScrollL,
        _props$hideBackdrop = props.hideBackdrop,
        hideBackdrop = _props$hideBackdrop === void 0 ? false : _props$hideBackdrop,
        _props$keepMounted = props.keepMounted,
        keepMounted = _props$keepMounted === void 0 ? false : _props$keepMounted,
        _props$manager = props.manager,
        manager = _props$manager === void 0 ? defaultManager : _props$manager,
        onBackdropClick = props.onBackdropClick,
        onClose = props.onClose,
        onEscapeKeyDown = props.onEscapeKeyDown,
        onRendered = props.onRendered,
        open = props.open,
        other = _objectWithoutProperties(props, ["BackdropComponent", "BackdropProps", "children", "closeAfterTransition", "container", "disableAutoFocus", "disableBackdropClick", "disableEnforceFocus", "disableEscapeKeyDown", "disablePortal", "disableRestoreFocus", "disableScrollLock", "hideBackdrop", "keepMounted", "manager", "onBackdropClick", "onClose", "onEscapeKeyDown", "onRendered", "open"]);

    var _React$useState = React__default.useState(true),
        exited = _React$useState[0],
        setExited = _React$useState[1];

    var modal = React__default.useRef({});
    var mountNodeRef = React__default.useRef(null);
    var modalRef = React__default.useRef(null);
    var handleRef = useForkRef(modalRef, ref);
    var hasTransition = getHasTransition(props);

    var getDoc = function getDoc() {
      return ownerDocument(mountNodeRef.current);
    };

    var getModal = function getModal() {
      modal.current.modalRef = modalRef.current;
      modal.current.mountNode = mountNodeRef.current;
      return modal.current;
    };

    var handleMounted = function handleMounted() {
      manager.mount(getModal(), {
        disableScrollLock: disableScrollLock
      }); // Fix a bug on Chrome where the scroll isn't initially 0.

      modalRef.current.scrollTop = 0;
    };

    var handleOpen = useEventCallback(function () {
      var resolvedContainer = getContainer$1(container) || getDoc().body;
      manager.add(getModal(), resolvedContainer); // The element was already mounted.

      if (modalRef.current) {
        handleMounted();
      }
    });
    var isTopModal = React__default.useCallback(function () {
      return manager.isTopModal(getModal());
    }, [manager]);
    var handlePortalRef = useEventCallback(function (node) {
      mountNodeRef.current = node;

      if (!node) {
        return;
      }

      if (onRendered) {
        onRendered();
      }

      if (open && isTopModal()) {
        handleMounted();
      } else {
        ariaHidden(modalRef.current, true);
      }
    });
    var handleClose = React__default.useCallback(function () {
      manager.remove(getModal());
    }, [manager]);
    React__default.useEffect(function () {
      return function () {
        handleClose();
      };
    }, [handleClose]);
    React__default.useEffect(function () {
      if (open) {
        handleOpen();
      } else if (!hasTransition || !closeAfterTransition) {
        handleClose();
      }
    }, [open, handleClose, hasTransition, closeAfterTransition, handleOpen]);

    if (!keepMounted && !open && (!hasTransition || exited)) {
      return null;
    }

    var handleEnter = function handleEnter() {
      setExited(false);
    };

    var handleExited = function handleExited() {
      setExited(true);

      if (closeAfterTransition) {
        handleClose();
      }
    };

    var handleBackdropClick = function handleBackdropClick(event) {
      if (event.target !== event.currentTarget) {
        return;
      }

      if (onBackdropClick) {
        onBackdropClick(event);
      }

      if (!disableBackdropClick && onClose) {
        onClose(event, 'backdropClick');
      }
    };

    var handleKeyDown = function handleKeyDown(event) {
      // We don't take event.defaultPrevented into account:
      //
      // event.preventDefault() is meant to stop default behaviours like
      // clicking a checkbox to check it, hitting a button to submit a form,
      // and hitting left arrow to move the cursor in a text input etc.
      // Only special HTML elements have these default behaviors.
      if (event.key !== 'Escape' || !isTopModal()) {
        return;
      } // Swallow the event, in case someone is listening for the escape key on the body.


      event.stopPropagation();

      if (onEscapeKeyDown) {
        onEscapeKeyDown(event);
      }

      if (!disableEscapeKeyDown && onClose) {
        onClose(event, 'escapeKeyDown');
      }
    };

    var inlineStyle = styles$v(theme || {
      zIndex: zIndex
    });
    var childProps = {};

    if (children.props.tabIndex === undefined) {
      childProps.tabIndex = children.props.tabIndex || '-1';
    } // It's a Transition like component


    if (hasTransition) {
      childProps.onEnter = createChainedFunction(handleEnter, children.props.onEnter);
      childProps.onExited = createChainedFunction(handleExited, children.props.onExited);
    }

    return React__default.createElement(Portal, {
      ref: handlePortalRef,
      container: container,
      disablePortal: disablePortal
    }, React__default.createElement("div", _extends({
      ref: handleRef,
      onKeyDown: handleKeyDown,
      role: "presentation"
    }, other, {
      style: _extends({}, inlineStyle.root, {}, !open && exited ? inlineStyle.hidden : {}, {}, other.style)
    }), hideBackdrop ? null : React__default.createElement(BackdropComponent, _extends({
      open: open,
      onClick: handleBackdropClick
    }, BackdropProps)), React__default.createElement(TrapFocus, {
      disableEnforceFocus: disableEnforceFocus,
      disableAutoFocus: disableAutoFocus,
      disableRestoreFocus: disableRestoreFocus,
      getDoc: getDoc,
      isEnabled: isTopModal,
      open: open
    }, React__default.cloneElement(children, childProps))));
  });
   Modal.propTypes = {
    /**
     * A backdrop component. This prop enables custom backdrop rendering.
     */
    BackdropComponent: propTypes.elementType,

    /**
     * Props applied to the [`Backdrop`](/api/backdrop/) element.
     */
    BackdropProps: propTypes.object,

    /**
     * A single child content element.
     */
    children: elementAcceptingRef.isRequired,

    /**
     * When set to true the Modal waits until a nested Transition is completed before closing.
     */
    closeAfterTransition: propTypes.bool,

    /**
     * A node, component instance, or function that returns either.
     * The `container` will have the portal children appended to it.
     */
    container: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * If `true`, the modal will not automatically shift focus to itself when it opens, and
     * replace it to the last focused element when it closes.
     * This also works correctly with any modal children that have the `disableAutoFocus` prop.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     */
    disableAutoFocus: propTypes.bool,

    /**
     * If `true`, clicking the backdrop will not fire any callback.
     */
    disableBackdropClick: propTypes.bool,

    /**
     * If `true`, the modal will not prevent focus from leaving the modal while open.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     */
    disableEnforceFocus: propTypes.bool,

    /**
     * If `true`, hitting escape will not fire any callback.
     */
    disableEscapeKeyDown: propTypes.bool,

    /**
     * Disable the portal behavior.
     * The children stay within it's parent DOM hierarchy.
     */
    disablePortal: propTypes.bool,

    /**
     * If `true`, the modal will not restore focus to previously focused element once
     * modal is hidden.
     */
    disableRestoreFocus: propTypes.bool,

    /**
     * Disable the scroll lock behavior.
     */
    disableScrollLock: propTypes.bool,

    /**
     * If `true`, the backdrop is not rendered.
     */
    hideBackdrop: propTypes.bool,

    /**
     * Always keep the children in the DOM.
     * This prop can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Modal.
     */
    keepMounted: propTypes.bool,

    /**
     * @ignore
     */
    manager: propTypes.object,

    /**
     * Callback fired when the backdrop is clicked.
     */
    onBackdropClick: propTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     * The `reason` parameter can optionally be used to control the response to `onClose`.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be:`"escapeKeyDown"`, `"backdropClick"`.
     */
    onClose: propTypes.func,

    /**
     * Callback fired when the escape key is pressed,
     * `disableEscapeKeyDown` is false and the modal is in focus.
     */
    onEscapeKeyDown: propTypes.func,

    /**
     * Callback fired once the children has been mounted into the `container`.
     * It signals that the `open={true}` prop took effect.
     *
     * This prop will be deprecated and removed in v5, the ref can be used instead.
     */
    onRendered: propTypes.func,

    /**
     * If `true`, the modal is open.
     */
    open: propTypes.bool.isRequired
  } ;

  var styles$w = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        '@media print': {
          // Use !important to override the Modal inline-style.
          position: 'absolute !important'
        }
      },

      /* Styles applied to the container element if `scroll="paper"`. */
      scrollPaper: {
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center'
      },

      /* Styles applied to the container element if `scroll="body"`. */
      scrollBody: {
        overflowY: 'auto',
        overflowX: 'hidden',
        textAlign: 'center',
        '&:after': {
          content: '""',
          display: 'inline-block',
          verticalAlign: 'middle',
          height: '100%',
          width: '0'
        }
      },

      /* Styles applied to the container element. */
      container: {
        height: '100%',
        '@media print': {
          height: 'auto'
        },
        // We disable the focus ring for mouse, touch and keyboard users.
        outline: 0
      },

      /* Styles applied to the `Paper` component. */
      paper: {
        margin: 32,
        position: 'relative',
        overflowY: 'auto',
        // Fix IE 11 issue, to remove at some point.
        '@media print': {
          overflowY: 'visible',
          boxShadow: 'none'
        }
      },

      /* Styles applied to the `Paper` component if `scroll="paper"`. */
      paperScrollPaper: {
        display: 'flex',
        flexDirection: 'column',
        maxHeight: 'calc(100% - 64px)'
      },

      /* Styles applied to the `Paper` component if `scroll="body"`. */
      paperScrollBody: {
        display: 'inline-block',
        verticalAlign: 'middle',
        textAlign: 'left' // 'initial' doesn't work on IE 11

      },

      /* Styles applied to the `Paper` component if `maxWidth=false`. */
      paperWidthFalse: {
        maxWidth: 'calc(100% - 64px)'
      },

      /* Styles applied to the `Paper` component if `maxWidth="xs"`. */
      paperWidthXs: {
        maxWidth: Math.max(theme.breakpoints.values.xs, 444),
        '&$paperScrollBody': _defineProperty({}, theme.breakpoints.down(Math.max(theme.breakpoints.values.xs, 444) + 32 * 2), {
          maxWidth: 'calc(100% - 64px)'
        })
      },

      /* Styles applied to the `Paper` component if `maxWidth="sm"`. */
      paperWidthSm: {
        maxWidth: theme.breakpoints.values.sm,
        '&$paperScrollBody': _defineProperty({}, theme.breakpoints.down(theme.breakpoints.values.sm + 32 * 2), {
          maxWidth: 'calc(100% - 64px)'
        })
      },

      /* Styles applied to the `Paper` component if `maxWidth="md"`. */
      paperWidthMd: {
        maxWidth: theme.breakpoints.values.md,
        '&$paperScrollBody': _defineProperty({}, theme.breakpoints.down(theme.breakpoints.values.md + 32 * 2), {
          maxWidth: 'calc(100% - 64px)'
        })
      },

      /* Styles applied to the `Paper` component if `maxWidth="lg"`. */
      paperWidthLg: {
        maxWidth: theme.breakpoints.values.lg,
        '&$paperScrollBody': _defineProperty({}, theme.breakpoints.down(theme.breakpoints.values.lg + 32 * 2), {
          maxWidth: 'calc(100% - 64px)'
        })
      },

      /* Styles applied to the `Paper` component if `maxWidth="xl"`. */
      paperWidthXl: {
        maxWidth: theme.breakpoints.values.xl,
        '&$paperScrollBody': _defineProperty({}, theme.breakpoints.down(theme.breakpoints.values.xl + 32 * 2), {
          maxWidth: 'calc(100% - 64px)'
        })
      },

      /* Styles applied to the `Paper` component if `fullWidth={true}`. */
      paperFullWidth: {
        width: 'calc(100% - 64px)'
      },

      /* Styles applied to the `Paper` component if `fullScreen={true}`. */
      paperFullScreen: {
        margin: 0,
        width: '100%',
        maxWidth: '100%',
        height: '100%',
        maxHeight: 'none',
        borderRadius: 0,
        '&$paperScrollBody': {
          margin: 0,
          maxWidth: '100%'
        }
      }
    };
  };
  var defaultTransitionDuration = {
    enter: duration.enteringScreen,
    exit: duration.leavingScreen
  };
  /**
   * Dialogs are overlaid modal paper based components with a backdrop.
   */

  var Dialog = React__default.forwardRef(function Dialog(props, ref) {
    var BackdropProps = props.BackdropProps,
        children = props.children,
        classes = props.classes,
        className = props.className,
        _props$disableBackdro = props.disableBackdropClick,
        disableBackdropClick = _props$disableBackdro === void 0 ? false : _props$disableBackdro,
        _props$disableEscapeK = props.disableEscapeKeyDown,
        disableEscapeKeyDown = _props$disableEscapeK === void 0 ? false : _props$disableEscapeK,
        _props$fullScreen = props.fullScreen,
        fullScreen = _props$fullScreen === void 0 ? false : _props$fullScreen,
        _props$fullWidth = props.fullWidth,
        fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
        _props$maxWidth = props.maxWidth,
        maxWidth = _props$maxWidth === void 0 ? 'sm' : _props$maxWidth,
        onBackdropClick = props.onBackdropClick,
        onClose = props.onClose,
        onEnter = props.onEnter,
        onEntered = props.onEntered,
        onEntering = props.onEntering,
        onEscapeKeyDown = props.onEscapeKeyDown,
        onExit = props.onExit,
        onExited = props.onExited,
        onExiting = props.onExiting,
        open = props.open,
        _props$PaperComponent = props.PaperComponent,
        PaperComponent = _props$PaperComponent === void 0 ? Paper$1 : _props$PaperComponent,
        _props$PaperProps = props.PaperProps,
        PaperProps = _props$PaperProps === void 0 ? {} : _props$PaperProps,
        _props$scroll = props.scroll,
        scroll = _props$scroll === void 0 ? 'paper' : _props$scroll,
        _props$TransitionComp = props.TransitionComponent,
        TransitionComponent = _props$TransitionComp === void 0 ? Fade : _props$TransitionComp,
        _props$transitionDura = props.transitionDuration,
        transitionDuration = _props$transitionDura === void 0 ? defaultTransitionDuration : _props$transitionDura,
        TransitionProps = props.TransitionProps,
        ariaDescribedby = props['aria-describedby'],
        ariaLabelledby = props['aria-labelledby'],
        other = _objectWithoutProperties(props, ["BackdropProps", "children", "classes", "className", "disableBackdropClick", "disableEscapeKeyDown", "fullScreen", "fullWidth", "maxWidth", "onBackdropClick", "onClose", "onEnter", "onEntered", "onEntering", "onEscapeKeyDown", "onExit", "onExited", "onExiting", "open", "PaperComponent", "PaperProps", "scroll", "TransitionComponent", "transitionDuration", "TransitionProps", "aria-describedby", "aria-labelledby"]);

    var mouseDownTarget = React__default.useRef();

    var handleMouseDown = function handleMouseDown(event) {
      mouseDownTarget.current = event.target;
    };

    var handleBackdropClick = function handleBackdropClick(event) {
      // Ignore the events not coming from the "backdrop"
      // We don't want to close the dialog when clicking the dialog content.
      if (event.target !== event.currentTarget) {
        return;
      } // Make sure the event starts and ends on the same DOM element.


      if (event.target !== mouseDownTarget.current) {
        return;
      }

      mouseDownTarget.current = null;

      if (onBackdropClick) {
        onBackdropClick(event);
      }

      if (!disableBackdropClick && onClose) {
        onClose(event, 'backdropClick');
      }
    };

    return React__default.createElement(Modal, _extends({
      className: clsx(classes.root, className),
      BackdropComponent: Backdrop$1,
      BackdropProps: _extends({
        transitionDuration: transitionDuration
      }, BackdropProps),
      closeAfterTransition: true,
      disableBackdropClick: disableBackdropClick,
      disableEscapeKeyDown: disableEscapeKeyDown,
      onEscapeKeyDown: onEscapeKeyDown,
      onClose: onClose,
      open: open,
      ref: ref
    }, other), React__default.createElement(TransitionComponent, _extends({
      appear: true,
      in: open,
      timeout: transitionDuration,
      onEnter: onEnter,
      onEntering: onEntering,
      onEntered: onEntered,
      onExit: onExit,
      onExiting: onExiting,
      onExited: onExited,
      role: "none presentation"
    }, TransitionProps), React__default.createElement("div", {
      className: clsx(classes.container, classes["scroll".concat(capitalize(scroll))]),
      onClick: handleBackdropClick,
      onMouseDown: handleMouseDown
    }, React__default.createElement(PaperComponent, _extends({
      elevation: 24,
      role: "dialog",
      "aria-describedby": ariaDescribedby,
      "aria-labelledby": ariaLabelledby
    }, PaperProps, {
      className: clsx(classes.paper, classes["paperScroll".concat(capitalize(scroll))], classes["paperWidth".concat(capitalize(String(maxWidth)))], PaperProps.className, fullScreen && classes.paperFullScreen, fullWidth && classes.paperFullWidth)
    }), children))));
  });
   Dialog.propTypes = {
    /**
     * The id(s) of the element(s) that describe the dialog.
     */
    'aria-describedby': propTypes.string,

    /**
     * The id(s) of the element(s) that label the dialog.
     */
    'aria-labelledby': propTypes.string,

    /**
     * @ignore
     */
    BackdropProps: propTypes.object,

    /**
     * Dialog children, usually the included sub-components.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, clicking the backdrop will not fire the `onClose` callback.
     */
    disableBackdropClick: propTypes.bool,

    /**
     * If `true`, hitting escape will not fire the `onClose` callback.
     */
    disableEscapeKeyDown: propTypes.bool,

    /**
     * If `true`, the dialog will be full-screen
     */
    fullScreen: propTypes.bool,

    /**
     * If `true`, the dialog stretches to `maxWidth`.
     *
     * Notice that the dialog width grow is limited by the default margin.
     */
    fullWidth: propTypes.bool,

    /**
     * Determine the max-width of the dialog.
     * The dialog width grows with the size of the screen.
     * Set to `false` to disable `maxWidth`.
     */
    maxWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl', false]),

    /**
     * Callback fired when the backdrop is clicked.
     */
    onBackdropClick: propTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be:`"escapeKeyDown"`, `"backdropClick"`.
     */
    onClose: propTypes.func,

    /**
     * Callback fired before the dialog enters.
     */
    onEnter: propTypes.func,

    /**
     * Callback fired when the dialog has entered.
     */
    onEntered: propTypes.func,

    /**
     * Callback fired when the dialog is entering.
     */
    onEntering: propTypes.func,

    /**
     * Callback fired when the escape key is pressed,
     * `disableKeyboard` is false and the modal is in focus.
     */
    onEscapeKeyDown: propTypes.func,

    /**
     * Callback fired before the dialog exits.
     */
    onExit: propTypes.func,

    /**
     * Callback fired when the dialog has exited.
     */
    onExited: propTypes.func,

    /**
     * Callback fired when the dialog is exiting.
     */
    onExiting: propTypes.func,

    /**
     * If `true`, the Dialog is open.
     */
    open: propTypes.bool.isRequired,

    /**
     * The component used to render the body of the dialog.
     */
    PaperComponent: propTypes.elementType,

    /**
     * Props applied to the [`Paper`](/api/paper/) element.
     */
    PaperProps: propTypes.object,

    /**
     * Determine the container for scrolling the dialog.
     */
    scroll: propTypes.oneOf(['body', 'paper']),

    /**
     * The component used for the transition.
     */
    TransitionComponent: propTypes.elementType,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })]),

    /**
     * Props applied to the `Transition` element.
     */
    TransitionProps: propTypes.object
  } ;
  var Dialog$1 = withStyles$1(styles$w, {
    name: 'MuiDialog'
  })(Dialog);

  var styles$x = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      alignItems: 'center',
      padding: 8,
      justifyContent: 'flex-end',
      flex: '0 0 auto'
    },

    /* Styles applied to the root element if `disableSpacing={false}`. */
    spacing: {
      '& > :not(:first-child)': {
        marginLeft: 8
      }
    }
  };
  var DialogActions = React__default.forwardRef(function DialogActions(props, ref) {
    var _props$disableSpacing = props.disableSpacing,
        disableSpacing = _props$disableSpacing === void 0 ? false : _props$disableSpacing,
        classes = props.classes,
        className = props.className,
        other = _objectWithoutProperties(props, ["disableSpacing", "classes", "className"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, !disableSpacing && classes.spacing),
      ref: ref
    }, other));
  });
   DialogActions.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the actions do not have additional margin.
     */
    disableSpacing: propTypes.bool
  } ;
  var DialogActions$1 = withStyles$1(styles$x, {
    name: 'MuiDialogActions'
  })(DialogActions);

  var styles$y = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        flex: '1 1 auto',
        WebkitOverflowScrolling: 'touch',
        // Add iOS momentum scrolling.
        overflowY: 'auto',
        padding: '8px 24px',
        '&:first-child': {
          // dialog without title
          paddingTop: 20
        }
      },

      /* Styles applied to the root element if `dividers={true}`. */
      dividers: {
        padding: '16px 24px',
        borderTop: "1px solid ".concat(theme.palette.divider),
        borderBottom: "1px solid ".concat(theme.palette.divider)
      }
    };
  };
  var DialogContent = React__default.forwardRef(function DialogContent(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$dividers = props.dividers,
        dividers = _props$dividers === void 0 ? false : _props$dividers,
        other = _objectWithoutProperties(props, ["classes", "className", "dividers"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, dividers && classes.dividers),
      ref: ref
    }, other));
  });
   DialogContent.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Display the top and bottom dividers.
     */
    dividers: propTypes.bool
  } ;
  var DialogContent$1 = withStyles$1(styles$y, {
    name: 'MuiDialogContent'
  })(DialogContent);

  var styles$z = {
    /* Styles applied to the root element. */
    root: {
      marginBottom: 12
    }
  };
  var DialogContentText = React__default.forwardRef(function DialogContentText(props, ref) {
    return React__default.createElement(Typography$1, _extends({
      component: "p",
      variant: "body1",
      color: "textSecondary",
      ref: ref
    }, props));
  });
   DialogContentText.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired
  } ;
  var DialogContentText$1 = withStyles$1(styles$z, {
    name: 'MuiDialogContentText'
  })(DialogContentText);

  var styles$A = {
    /* Styles applied to the root element. */
    root: {
      margin: 0,
      padding: '16px 24px',
      flex: '0 0 auto'
    }
  };
  var DialogTitle = React__default.forwardRef(function DialogTitle(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$disableTypogra = props.disableTypography,
        disableTypography = _props$disableTypogra === void 0 ? false : _props$disableTypogra,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "disableTypography"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className),
      ref: ref
    }, other), disableTypography ? children : React__default.createElement(Typography$1, {
      component: "h2",
      variant: "h6"
    }, children));
  });
   DialogTitle.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the children won't be wrapped by a typography component.
     * For instance, this can be useful to render an h4 instead of the default h2.
     */
    disableTypography: propTypes.bool
  } ;
  var DialogTitle$1 = withStyles$1(styles$A, {
    name: 'MuiDialogTitle'
  })(DialogTitle);

  var styles$B = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        height: 1,
        margin: 0,
        // Reset browser default style.
        border: 'none',
        flexShrink: 0,
        backgroundColor: theme.palette.divider
      },

      /* Styles applied to the root element if `absolute={true}`. */
      absolute: {
        position: 'absolute',
        bottom: 0,
        left: 0,
        width: '100%'
      },

      /* Styles applied to the root element if `variant="inset"`. */
      inset: {
        marginLeft: 72
      },

      /* Styles applied to the root element if `light={true}`. */
      light: {
        backgroundColor: fade(theme.palette.divider, 0.08)
      },

      /* Styles applied to the root element if `variant="middle"`. */
      middle: {
        marginLeft: theme.spacing(2),
        marginRight: theme.spacing(2)
      },

      /* Styles applied to the root element if `orientation="vertical"`. */
      vertical: {
        height: '100%',
        width: 1
      }
    };
  };
  var Divider = React__default.forwardRef(function Divider(props, ref) {
    var _props$absolute = props.absolute,
        absolute = _props$absolute === void 0 ? false : _props$absolute,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'hr' : _props$component,
        _props$light = props.light,
        light = _props$light === void 0 ? false : _props$light,
        _props$orientation = props.orientation,
        orientation = _props$orientation === void 0 ? 'horizontal' : _props$orientation,
        _props$role = props.role,
        role = _props$role === void 0 ? Component !== 'hr' ? 'separator' : undefined : _props$role,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'fullWidth' : _props$variant,
        other = _objectWithoutProperties(props, ["absolute", "classes", "className", "component", "light", "orientation", "role", "variant"]);

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, variant !== 'fullWidth' && classes[variant], absolute && classes.absolute, light && classes.light, {
        vertical: classes.vertical
      }[orientation]),
      role: role,
      ref: ref
    }, other));
  });
   Divider.propTypes = {
    /**
     * Absolutely position the element.
     */
    absolute: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the divider will have a lighter color.
     */
    light: propTypes.bool,

    /**
     * The divider orientation.
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical']),

    /**
     * @ignore
     */
    role: propTypes.string,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['fullWidth', 'inset', 'middle'])
  } ;
  var Divider$1 = withStyles$1(styles$B, {
    name: 'MuiDivider'
  })(Divider);

  // Corresponds to 10 frames at 60 Hz.
  // A few bytes payload overhead when lodash/debounce is ~3 kB and debounce ~300 B.
  function debounce(func) {
    var wait = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 166;
    var timeout;

    function debounced() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      // eslint-disable-next-line consistent-this
      var that = this;

      var later = function later() {
        func.apply(that, args);
      };

      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
    }

    debounced.clear = function () {
      clearTimeout(timeout);
    };

    return debounced;
  }

  // Later, we gonna translate back the node to his original location
  // with `none`.`

  function getTranslateValue(direction, node) {
    var rect = node.getBoundingClientRect();
    var transform;

    if (node.fakeTransform) {
      transform = node.fakeTransform;
    } else {
      var computedStyle = window.getComputedStyle(node);
      transform = computedStyle.getPropertyValue('-webkit-transform') || computedStyle.getPropertyValue('transform');
    }

    var offsetX = 0;
    var offsetY = 0;

    if (transform && transform !== 'none' && typeof transform === 'string') {
      var transformValues = transform.split('(')[1].split(')')[0].split(',');
      offsetX = parseInt(transformValues[4], 10);
      offsetY = parseInt(transformValues[5], 10);
    }

    if (direction === 'left') {
      return "translateX(".concat(window.innerWidth, "px) translateX(-").concat(rect.left - offsetX, "px)");
    }

    if (direction === 'right') {
      return "translateX(-".concat(rect.left + rect.width - offsetX, "px)");
    }

    if (direction === 'up') {
      return "translateY(".concat(window.innerHeight, "px) translateY(-").concat(rect.top - offsetY, "px)");
    } // direction === 'down'


    return "translateY(-".concat(rect.top + rect.height - offsetY, "px)");
  }

  function setTranslateValue(direction, node) {
    var transform = getTranslateValue(direction, node);

    if (transform) {
      node.style.webkitTransform = transform;
      node.style.transform = transform;
    }
  }
  var defaultTimeout$1 = {
    enter: duration.enteringScreen,
    exit: duration.leavingScreen
  };
  /**
   * The Slide transition is used by the [Drawer](/components/drawers/) component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  var Slide = React__default.forwardRef(function Slide(props, ref) {
    var children = props.children,
        _props$direction = props.direction,
        direction = _props$direction === void 0 ? 'down' : _props$direction,
        inProp = props.in,
        onEnter = props.onEnter,
        onEntering = props.onEntering,
        onExit = props.onExit,
        onExited = props.onExited,
        style = props.style,
        _props$timeout = props.timeout,
        timeout = _props$timeout === void 0 ? defaultTimeout$1 : _props$timeout,
        other = _objectWithoutProperties(props, ["children", "direction", "in", "onEnter", "onEntering", "onExit", "onExited", "style", "timeout"]);

    var theme = useTheme$1();
    var childrenRef = React__default.useRef(null);
    /**
     * used in cloneElement(children, { ref: handleRef })
     */

    var handleOwnRef = React__default.useCallback(function (instance) {
      // #StrictMode ready
      childrenRef.current = ReactDOM.findDOMNode(instance);
    }, []);
    var handleRefIntermediary = useForkRef(children.ref, handleOwnRef);
    var handleRef = useForkRef(handleRefIntermediary, ref);

    var handleEnter = function handleEnter(_, isAppearing) {
      var node = childrenRef.current;
      setTranslateValue(direction, node);
      reflow(node);

      if (onEnter) {
        onEnter(node, isAppearing);
      }
    };

    var handleEntering = function handleEntering(_, isAppearing) {
      var node = childrenRef.current;
      var transitionProps = getTransitionProps({
        timeout: timeout,
        style: style
      }, {
        mode: 'enter'
      });
      node.style.webkitTransition = theme.transitions.create('-webkit-transform', _extends({}, transitionProps, {
        easing: theme.transitions.easing.easeOut
      }));
      node.style.transition = theme.transitions.create('transform', _extends({}, transitionProps, {
        easing: theme.transitions.easing.easeOut
      }));
      node.style.webkitTransform = 'none';
      node.style.transform = 'none';

      if (onEntering) {
        onEntering(node, isAppearing);
      }
    };

    var handleExit = function handleExit() {
      var node = childrenRef.current;
      var transitionProps = getTransitionProps({
        timeout: timeout,
        style: style
      }, {
        mode: 'exit'
      });
      node.style.webkitTransition = theme.transitions.create('-webkit-transform', _extends({}, transitionProps, {
        easing: theme.transitions.easing.sharp
      }));
      node.style.transition = theme.transitions.create('transform', _extends({}, transitionProps, {
        easing: theme.transitions.easing.sharp
      }));
      setTranslateValue(direction, node);

      if (onExit) {
        onExit(node);
      }
    };

    var handleExited = function handleExited() {
      var node = childrenRef.current; // No need for transitions when the component is hidden

      node.style.webkitTransition = '';
      node.style.transition = '';

      if (onExited) {
        onExited(node);
      }
    };

    var updatePosition = React__default.useCallback(function () {
      if (childrenRef.current) {
        setTranslateValue(direction, childrenRef.current);
      }
    }, [direction]);
    React__default.useEffect(function () {
      // Skip configuration where the position is screen size invariant.
      if (!inProp && direction !== 'down' && direction !== 'right') {
        var handleResize = debounce(function () {
          if (childrenRef.current) {
            setTranslateValue(direction, childrenRef.current);
          }
        });
        window.addEventListener('resize', handleResize);
        return function () {
          handleResize.clear();
          window.removeEventListener('resize', handleResize);
        };
      }

      return undefined;
    }, [direction, inProp]);
    React__default.useEffect(function () {
      if (!inProp) {
        // We need to update the position of the drawer when the direction change and
        // when it's hidden.
        updatePosition();
      }
    }, [inProp, updatePosition]);
    return React__default.createElement(Transition, _extends({
      onEnter: handleEnter,
      onEntering: handleEntering,
      onExit: handleExit,
      onExited: handleExited,
      appear: true,
      in: inProp,
      timeout: timeout
    }, other), function (state, childProps) {
      return React__default.cloneElement(children, _extends({
        ref: handleRef,
        style: _extends({
          visibility: state === 'exited' && !inProp ? 'hidden' : undefined
        }, style, {}, children.props.style)
      }, childProps));
    });
  });
   Slide.propTypes = {
    /**
     * A single child content element.
     */
    children: elementAcceptingRef,

    /**
     * Direction the child node will enter from.
     */
    direction: propTypes.oneOf(['left', 'right', 'up', 'down']),

    /**
     * If `true`, show the component; triggers the enter or exit animation.
     */
    in: propTypes.bool,

    /**
     * @ignore
     */
    onEnter: propTypes.func,

    /**
     * @ignore
     */
    onEntering: propTypes.func,

    /**
     * @ignore
     */
    onExit: propTypes.func,

    /**
     * @ignore
     */
    onExited: propTypes.func,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    timeout: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })])
  } ;

  var styles$C = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {},

      /* Styles applied to the root element if `variant="permanent or persistent"`. */
      docked: {
        flex: '0 0 auto'
      },

      /* Styles applied to the `Paper` component. */
      paper: {
        overflowY: 'auto',
        display: 'flex',
        flexDirection: 'column',
        height: '100%',
        flex: '1 0 auto',
        zIndex: theme.zIndex.drawer,
        WebkitOverflowScrolling: 'touch',
        // Add iOS momentum scrolling.
        // temporary style
        position: 'fixed',
        top: 0,
        // We disable the focus ring for mouse, touch and keyboard users.
        // At some point, it would be better to keep it for keyboard users.
        // :focus-ring CSS pseudo-class will help.
        outline: 0
      },

      /* Styles applied to the `Paper` component if `anchor="left"`. */
      paperAnchorLeft: {
        left: 0,
        right: 'auto'
      },

      /* Styles applied to the `Paper` component if `anchor="right"`. */
      paperAnchorRight: {
        left: 'auto',
        right: 0
      },

      /* Styles applied to the `Paper` component if `anchor="top"`. */
      paperAnchorTop: {
        top: 0,
        left: 0,
        bottom: 'auto',
        right: 0,
        height: 'auto',
        maxHeight: '100%'
      },

      /* Styles applied to the `Paper` component if `anchor="bottom"`. */
      paperAnchorBottom: {
        top: 'auto',
        left: 0,
        bottom: 0,
        right: 0,
        height: 'auto',
        maxHeight: '100%'
      },

      /* Styles applied to the `Paper` component if `anchor="left"` and `variant` is not "temporary". */
      paperAnchorDockedLeft: {
        borderRight: "1px solid ".concat(theme.palette.divider)
      },

      /* Styles applied to the `Paper` component if `anchor="top"` and `variant` is not "temporary". */
      paperAnchorDockedTop: {
        borderBottom: "1px solid ".concat(theme.palette.divider)
      },

      /* Styles applied to the `Paper` component if `anchor="right"` and `variant` is not "temporary". */
      paperAnchorDockedRight: {
        borderLeft: "1px solid ".concat(theme.palette.divider)
      },

      /* Styles applied to the `Paper` component if `anchor="bottom"` and `variant` is not "temporary". */
      paperAnchorDockedBottom: {
        borderTop: "1px solid ".concat(theme.palette.divider)
      },

      /* Styles applied to the `Modal` component. */
      modal: {}
    };
  };
  var oppositeDirection = {
    left: 'right',
    right: 'left',
    top: 'down',
    bottom: 'up'
  };
  function isHorizontal(anchor) {
    return ['left', 'right'].indexOf(anchor) !== -1;
  }
  function getAnchor(theme, anchor) {
    return theme.direction === 'rtl' && isHorizontal(anchor) ? oppositeDirection[anchor] : anchor;
  }
  var defaultTransitionDuration$1 = {
    enter: duration.enteringScreen,
    exit: duration.leavingScreen
  };
  /**
   * The props of the [Modal](/api/modal/) component are available
   * when `variant="temporary"` is set.
   */

  var Drawer = React__default.forwardRef(function Drawer(props, ref) {
    var _props$anchor = props.anchor,
        anchorProp = _props$anchor === void 0 ? 'left' : _props$anchor,
        BackdropProps = props.BackdropProps,
        children = props.children,
        classes = props.classes,
        className = props.className,
        _props$elevation = props.elevation,
        elevation = _props$elevation === void 0 ? 16 : _props$elevation,
        _props$ModalProps = props.ModalProps;
    _props$ModalProps = _props$ModalProps === void 0 ? {} : _props$ModalProps;

    var BackdropPropsProp = _props$ModalProps.BackdropProps,
        ModalProps = _objectWithoutProperties(_props$ModalProps, ["BackdropProps"]),
        onClose = props.onClose,
        _props$open = props.open,
        open = _props$open === void 0 ? false : _props$open,
        PaperProps = props.PaperProps,
        SlideProps = props.SlideProps,
        _props$transitionDura = props.transitionDuration,
        transitionDuration = _props$transitionDura === void 0 ? defaultTransitionDuration$1 : _props$transitionDura,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'temporary' : _props$variant,
        other = _objectWithoutProperties(props, ["anchor", "BackdropProps", "children", "classes", "className", "elevation", "ModalProps", "onClose", "open", "PaperProps", "SlideProps", "transitionDuration", "variant"]);

    var theme = useTheme$1(); // Let's assume that the Drawer will always be rendered on user space.
    // We use this state is order to skip the appear transition during the
    // initial mount of the component.

    var mounted = React__default.useRef(false);
    React__default.useEffect(function () {
      mounted.current = true;
    }, []);
    var anchor = getAnchor(theme, anchorProp);
    var drawer = React__default.createElement(Paper$1, _extends({
      elevation: variant === 'temporary' ? elevation : 0,
      square: true,
      className: clsx(classes.paper, classes["paperAnchor".concat(capitalize(anchor))], variant !== 'temporary' && classes["paperAnchorDocked".concat(capitalize(anchor))])
    }, PaperProps), children);

    if (variant === 'permanent') {
      return React__default.createElement("div", _extends({
        className: clsx(classes.root, classes.docked, className),
        ref: ref
      }, other), drawer);
    }

    var slidingDrawer = React__default.createElement(Slide, _extends({
      in: open,
      direction: oppositeDirection[anchor],
      timeout: transitionDuration,
      appear: mounted.current
    }, SlideProps), drawer);

    if (variant === 'persistent') {
      return React__default.createElement("div", _extends({
        className: clsx(classes.root, classes.docked, className),
        ref: ref
      }, other), slidingDrawer);
    } // variant === temporary


    return React__default.createElement(Modal, _extends({
      BackdropProps: _extends({}, BackdropProps, {}, BackdropPropsProp, {
        transitionDuration: transitionDuration
      }),
      BackdropComponent: Backdrop$1,
      className: clsx(classes.root, classes.modal, className),
      open: open,
      onClose: onClose,
      ref: ref
    }, other, ModalProps), slidingDrawer);
  });
   Drawer.propTypes = {
    /**
     * Side from which the drawer will appear.
     */
    anchor: propTypes.oneOf(['left', 'top', 'right', 'bottom']),

    /**
     * @ignore
     */
    BackdropProps: propTypes.object,

    /**
     * The contents of the drawer.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The elevation of the drawer.
     */
    elevation: propTypes.number,

    /**
     * Props applied to the [`Modal`](/api/modal/) element.
     */
    ModalProps: propTypes.object,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback.
     */
    onClose: propTypes.func,

    /**
     * If `true`, the drawer is open.
     */
    open: propTypes.bool,

    /**
     * Props applied to the [`Paper`](/api/paper/) element.
     */
    PaperProps: propTypes.object,

    /**
     * Props applied to the [`Slide`](/api/slide/) element.
     */
    SlideProps: propTypes.object,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })]),

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['permanent', 'persistent', 'temporary'])
  } ;
  var Drawer$1 = withStyles$1(styles$C, {
    name: 'MuiDrawer',
    flip: false
  })(Drawer);

  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
  }

  /**
   * @ignore - internal component.
   * @type {React.Context<{} | {expanded: boolean, disabled: boolean, toggle: () => void}>}
   */

  var ExpansionPanelContext = React__default.createContext({});

  var styles$D = function styles(theme) {
    var transition = {
      duration: theme.transitions.duration.shortest
    };
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        transition: theme.transitions.create(['margin'], transition),
        '&:before': {
          position: 'absolute',
          left: 0,
          top: -1,
          right: 0,
          height: 1,
          content: '""',
          opacity: 1,
          backgroundColor: theme.palette.divider,
          transition: theme.transitions.create(['opacity', 'background-color'], transition)
        },
        '&:first-child': {
          '&:before': {
            display: 'none'
          }
        },
        '&$expanded': {
          margin: '16px 0',
          '&:first-child': {
            marginTop: 0
          },
          '&:last-child': {
            marginBottom: 0
          },
          '&:before': {
            opacity: 0
          }
        },
        '&$expanded + &': {
          '&:before': {
            display: 'none'
          }
        },
        '&$disabled': {
          backgroundColor: theme.palette.action.disabledBackground
        }
      },

      /* Styles applied to the root element if `square={false}`. */
      rounded: {
        borderRadius: 0,
        '&:first-child': {
          borderTopLeftRadius: theme.shape.borderRadius,
          borderTopRightRadius: theme.shape.borderRadius
        },
        '&:last-child': {
          borderBottomLeftRadius: theme.shape.borderRadius,
          borderBottomRightRadius: theme.shape.borderRadius,
          // Fix a rendering issue on Edge
          '@supports (-ms-ime-align: auto)': {
            borderBottomLeftRadius: 0,
            borderBottomRightRadius: 0
          }
        }
      },

      /* Styles applied to the root element if `expanded={true}`. */
      expanded: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {}
    };
  };
  var ExpansionPanel = React__default.forwardRef(function ExpansionPanel(props, ref) {
    var childrenProp = props.children,
        classes = props.classes,
        className = props.className,
        _props$defaultExpande = props.defaultExpanded,
        defaultExpanded = _props$defaultExpande === void 0 ? false : _props$defaultExpande,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        expandedProp = props.expanded,
        onChange = props.onChange,
        _props$square = props.square,
        square = _props$square === void 0 ? false : _props$square,
        _props$TransitionComp = props.TransitionComponent,
        TransitionComponent = _props$TransitionComp === void 0 ? Collapse$1 : _props$TransitionComp,
        TransitionProps = props.TransitionProps,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "defaultExpanded", "disabled", "expanded", "onChange", "square", "TransitionComponent", "TransitionProps"]);

    var _React$useRef = React__default.useRef(expandedProp != null),
        isControlled = _React$useRef.current;

    var _React$useState = React__default.useState(defaultExpanded),
        expandedState = _React$useState[0],
        setExpandedState = _React$useState[1];

    var expanded = isControlled ? expandedProp : expandedState;

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__default.useEffect(function () {
        if (isControlled !== (expandedProp != null)) {
          console.error(["Material-UI: A component is changing ".concat(isControlled ? 'a ' : 'an un', "controlled ExpansionPanel to be ").concat(isControlled ? 'un' : '', "controlled."), 'Elements should not switch from uncontrolled to controlled (or vice versa).', 'Decide between using a controlled or uncontrolled ExpansionPanel ' + 'element for the lifetime of the component.', 'More info: https://fb.me/react-controlled-components'].join('\n'));
        }
      }, [expandedProp, isControlled]);
    }

    var handleChange = React__default.useCallback(function (event) {
      if (!isControlled) {
        setExpandedState(!expanded);
      }

      if (onChange) {
        onChange(event, !expanded);
      }
    }, [expanded, isControlled, onChange]);

    var _React$Children$toArr = React__default.Children.toArray(childrenProp),
        _React$Children$toArr2 = _toArray(_React$Children$toArr),
        summary = _React$Children$toArr2[0],
        children = _React$Children$toArr2.slice(1);

    var contextValue = React__default.useMemo(function () {
      return {
        expanded: expanded,
        disabled: disabled,
        toggle: handleChange
      };
    }, [expanded, disabled, handleChange]);
    return React__default.createElement(Paper$1, _extends({
      className: clsx(classes.root, className, expanded && classes.expanded, disabled && classes.disabled, !square && classes.rounded),
      ref: ref,
      square: square
    }, other), React__default.createElement(ExpansionPanelContext.Provider, {
      value: contextValue
    }, summary), React__default.createElement(TransitionComponent, _extends({
      in: expanded,
      timeout: "auto"
    }, TransitionProps), React__default.createElement("div", {
      "aria-labelledby": summary.props.id,
      id: summary.props['aria-controls'],
      role: "region"
    }, children)));
  });
   ExpansionPanel.propTypes = {
    /**
     * The content of the expansion panel.
     */
    children: chainPropTypes(propTypes.node.isRequired, function (props) {
      var summary = React__default.Children.toArray(props.children)[0];

      if (summary.type === React__default.Fragment) {
        return new Error("Material-UI: the ExpansionPanel doesn't accept a Fragment as a child. " + 'Consider providing an array instead.');
      }

      if (!React__default.isValidElement(summary)) {
        return new Error('Material-UI: expected the first child of ExpansionPanel to be a valid element.');
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, expands the panel by default.
     */
    defaultExpanded: propTypes.bool,

    /**
     * If `true`, the panel will be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, expands the panel, otherwise collapse it.
     * Setting this prop enables control over the panel.
     */
    expanded: propTypes.bool,

    /**
     * Callback fired when the expand/collapse state is changed.
     *
     * @param {object} event The event source of the callback.
     * @param {boolean} expanded The `expanded` state of the panel.
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    square: propTypes.bool,

    /**
     * The component used for the collapse effect.
     */
    TransitionComponent: propTypes.elementType,

    /**
     * Props applied to the `Transition` element.
     */
    TransitionProps: propTypes.object
  } ;
  var ExpansionPanel$1 = withStyles$1(styles$D, {
    name: 'MuiExpansionPanel'
  })(ExpansionPanel);

  var styles$E = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      alignItems: 'center',
      padding: 8,
      justifyContent: 'flex-end'
    },

    /* Styles applied to the root element if `disableSpacing={false}`. */
    spacing: {
      '& > :not(:first-child)': {
        marginLeft: 8
      }
    }
  };
  var ExpansionPanelActions = React__default.forwardRef(function ExpansionPanelActions(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$disableSpacing = props.disableSpacing,
        disableSpacing = _props$disableSpacing === void 0 ? false : _props$disableSpacing,
        other = _objectWithoutProperties(props, ["classes", "className", "disableSpacing"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, !disableSpacing && classes.spacing),
      ref: ref
    }, other));
  });
   ExpansionPanelActions.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the actions do not have additional margin.
     */
    disableSpacing: propTypes.bool
  } ;
  var ExpansionPanelActions$1 = withStyles$1(styles$E, {
    name: 'MuiExpansionPanelActions'
  })(ExpansionPanelActions);

  var styles$F = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      padding: '8px 24px 24px'
    }
  };
  var ExpansionPanelDetails = React__default.forwardRef(function ExpansionPanelDetails(props, ref) {
    var classes = props.classes,
        className = props.className,
        other = _objectWithoutProperties(props, ["classes", "className"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className),
      ref: ref
    }, other));
  });
   ExpansionPanelDetails.propTypes = {
    /**
     * The content of the expansion panel details.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  } ;
  var ExpansionPanelDetails$1 = withStyles$1(styles$F, {
    name: 'MuiExpansionPanelDetails'
  })(ExpansionPanelDetails);

  var styles$G = function styles(theme) {
    var transition = {
      duration: theme.transitions.duration.shortest
    };
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        minHeight: 8 * 6,
        transition: theme.transitions.create(['min-height', 'background-color'], transition),
        padding: '0 24px 0 24px',
        '&:hover:not($disabled)': {
          cursor: 'pointer'
        },
        '&$expanded': {
          minHeight: 64
        },
        '&$focused': {
          backgroundColor: theme.palette.grey[300]
        },
        '&$disabled': {
          opacity: 0.38
        }
      },

      /* Pseudo-class applied to the root element, children wrapper element and `IconButton` component if `expanded={true}`. */
      expanded: {},

      /* Pseudo-class applied to the root element if `focused={true}`. */
      focused: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the children wrapper element. */
      content: {
        display: 'flex',
        flexGrow: 1,
        transition: theme.transitions.create(['margin'], transition),
        margin: '12px 0',
        '&$expanded': {
          margin: '20px 0'
        }
      },

      /* Styles applied to the `IconButton` component when `expandIcon` is supplied. */
      expandIcon: {
        transform: 'rotate(0deg)',
        transition: theme.transitions.create('transform', transition),
        '&:hover': {
          // Disable the hover effect for the IconButton,
          // because a hover effect should apply to the entire Expand button and
          // not only to the IconButton.
          backgroundColor: 'transparent'
        },
        '&$expanded': {
          transform: 'rotate(180deg)'
        }
      }
    };
  };
  var ExpansionPanelSummary = React__default.forwardRef(function ExpansionPanelSummary(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        expandIcon = props.expandIcon,
        IconButtonProps = props.IconButtonProps,
        onBlur = props.onBlur,
        onClick = props.onClick,
        onFocusVisible = props.onFocusVisible,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "expandIcon", "IconButtonProps", "onBlur", "onClick", "onFocusVisible"]);

    var _React$useState = React__default.useState(false),
        focusedState = _React$useState[0],
        setFocusedState = _React$useState[1];

    var handleFocusVisible = function handleFocusVisible(event) {
      setFocusedState(true);

      if (onFocusVisible) {
        onFocusVisible(event);
      }
    };

    var handleBlur = function handleBlur(event) {
      setFocusedState(false);

      if (onBlur) {
        onBlur(event);
      }
    };

    var _React$useContext = React__default.useContext(ExpansionPanelContext),
        _React$useContext$dis = _React$useContext.disabled,
        disabled = _React$useContext$dis === void 0 ? false : _React$useContext$dis,
        expanded = _React$useContext.expanded,
        toggle = _React$useContext.toggle;

    var handleChange = function handleChange(event) {
      if (toggle) {
        toggle(event);
      }

      if (onClick) {
        onClick(event);
      }
    };

    return React__default.createElement(ButtonBase$1, _extends({
      focusRipple: false,
      disableRipple: true,
      disabled: disabled,
      component: "div",
      "aria-expanded": expanded,
      className: clsx(classes.root, className, disabled && classes.disabled, expanded && classes.expanded, focusedState && classes.focused),
      onFocusVisible: handleFocusVisible,
      onBlur: handleBlur,
      onClick: handleChange,
      ref: ref
    }, other), React__default.createElement("div", {
      className: clsx(classes.content, expanded && classes.expanded)
    }, children), expandIcon && React__default.createElement(IconButton$1, _extends({
      className: clsx(classes.expandIcon, expanded && classes.expanded),
      edge: "end",
      component: "div",
      tabIndex: null,
      role: null,
      "aria-hidden": true
    }, IconButtonProps), expandIcon));
  });
   ExpansionPanelSummary.propTypes = {
    /**
     * The content of the expansion panel summary.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The icon to display as the expand indicator.
     */
    expandIcon: propTypes.node,

    /**
     * Props applied to the `IconButton` element wrapping the expand icon.
     */
    IconButtonProps: propTypes.object,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * @ignore
     */
    onFocusVisible: propTypes.func
  } ;
  var ExpansionPanelSummary$1 = withStyles$1(styles$G, {
    name: 'MuiExpansionPanelSummary'
  })(ExpansionPanelSummary);

  var styles$H = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends({}, theme.typography.button, {
        boxSizing: 'border-box',
        minHeight: 36,
        transition: theme.transitions.create(['background-color', 'box-shadow', 'border'], {
          duration: theme.transitions.duration.short
        }),
        borderRadius: '50%',
        padding: 0,
        minWidth: 0,
        width: 56,
        height: 56,
        boxShadow: theme.shadows[6],
        '&:active': {
          boxShadow: theme.shadows[12]
        },
        color: theme.palette.getContrastText(theme.palette.grey[300]),
        backgroundColor: theme.palette.grey[300],
        '&$focusVisible': {
          boxShadow: theme.shadows[6]
        },
        '&:hover': {
          backgroundColor: theme.palette.grey.A100,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.grey[300]
          },
          '&$disabled': {
            backgroundColor: theme.palette.action.disabledBackground
          },
          textDecoration: 'none'
        },
        '&$disabled': {
          color: theme.palette.action.disabled,
          boxShadow: theme.shadows[0],
          backgroundColor: theme.palette.action.disabledBackground
        }
      }),

      /* Styles applied to the span element that wraps the children. */
      label: {
        width: '100%',
        // assure the correct width for iOS Safari
        display: 'inherit',
        alignItems: 'inherit',
        justifyContent: 'inherit'
      },

      /* Styles applied to the root element if `color="primary"`. */
      primary: {
        color: theme.palette.primary.contrastText,
        backgroundColor: theme.palette.primary.main,
        '&:hover': {
          backgroundColor: theme.palette.primary.dark,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.primary.main
          }
        }
      },

      /* Styles applied to the root element if `color="secondary"`. */
      secondary: {
        color: theme.palette.secondary.contrastText,
        backgroundColor: theme.palette.secondary.main,
        '&:hover': {
          backgroundColor: theme.palette.secondary.dark,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.secondary.main
          }
        }
      },

      /* Styles applied to the root element if `variant="extended"`. */
      extended: {
        borderRadius: 48 / 2,
        padding: '0 16px',
        width: 'auto',
        minHeight: 'auto',
        minWidth: 48,
        height: 48,
        '&$sizeSmall': {
          width: 'auto',
          padding: '0 8px',
          borderRadius: 34 / 2,
          minWidth: 34,
          height: 34
        },
        '&$sizeMedium': {
          width: 'auto',
          padding: '0 16px',
          borderRadius: 40 / 2,
          minWidth: 40,
          height: 40
        }
      },

      /* Pseudo-class applied to the ButtonBase root element if the button is keyboard focused. */
      focusVisible: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit'
      },

      /* Styles applied to the root element if `size="small"``. */
      sizeSmall: {
        width: 40,
        height: 40
      },

      /* Styles applied to the root element if `size="medium"``. */
      sizeMedium: {
        width: 48,
        height: 48
      }
    };
  };
  var Fab = React__default.forwardRef(function Fab(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'default' : _props$color,
        _props$component = props.component,
        component = _props$component === void 0 ? 'button' : _props$component,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$disableFocusRi = props.disableFocusRipple,
        disableFocusRipple = _props$disableFocusRi === void 0 ? false : _props$disableFocusRi,
        focusVisibleClassName = props.focusVisibleClassName,
        _props$size = props.size,
        size = _props$size === void 0 ? 'large' : _props$size,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'round' : _props$variant,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "color", "component", "disabled", "disableFocusRipple", "focusVisibleClassName", "size", "variant"]);

    return React__default.createElement(ButtonBase$1, _extends({
      className: clsx(classes.root, className, variant !== "round" && classes.extended, size !== 'large' && classes["size".concat(capitalize(size))], disabled && classes.disabled, {
        primary: classes.primary,
        secondary: classes.secondary,
        inherit: classes.colorInherit
      }[color]),
      component: component,
      disabled: disabled,
      focusRipple: !disableFocusRipple,
      focusVisibleClassName: clsx(classes.focusVisible, focusVisibleClassName),
      ref: ref
    }, other), React__default.createElement("span", {
      className: classes.label
    }, children));
  });
   Fab.propTypes = {
    /**
     * The content of the button.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'inherit', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the button will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple will be disabled.
     * `disableRipple` must also be true.
     */
    disableFocusRipple: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * @ignore
     */
    focusVisibleClassName: propTypes.string,

    /**
     * The URL to link to when the button is clicked.
     * If defined, an `a` element will be used as the root node.
     */
    href: propTypes.string,

    /**
     * The size of the button.
     * `small` is equivalent to the dense button styling.
     */
    size: propTypes.oneOf(['small', 'medium', 'large']),

    /**
     * @ignore
     */
    type: propTypes.string,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['round', 'extended'])
  } ;
  var Fab$1 = withStyles$1(styles$H, {
    name: 'MuiFab'
  })(Fab);

  function formControlState(_ref) {
    var props = _ref.props,
        states = _ref.states,
        muiFormControl = _ref.muiFormControl;
    return states.reduce(function (acc, state) {
      acc[state] = props[state];

      if (muiFormControl) {
        if (typeof props[state] === 'undefined') {
          acc[state] = muiFormControl[state];
        }
      }

      return acc;
    }, {});
  }

  function getStyleValue(computedStyle, property) {
    return parseInt(computedStyle[property], 10) || 0;
  }

  var useEnhancedEffect$4 = typeof window !== 'undefined' ? React__default.useLayoutEffect : React__default.useEffect;
  var styles$I = {
    /* Styles applied to the shadow textarea element. */
    shadow: {
      // Visibility needed to hide the extra text area on iPads
      visibility: 'hidden',
      // Remove from the content flow
      position: 'absolute',
      // Ignore the scrollbar width
      overflow: 'hidden',
      height: 0,
      top: 0,
      left: 0,
      // Create a new layer, increase the isolation of the computed values
      transform: 'translateZ(0)'
    }
  };
  var TextareaAutosize = React__default.forwardRef(function TextareaAutosize(props, ref) {
    var onChange = props.onChange,
        rows = props.rows,
        rowsMax = props.rowsMax,
        style = props.style,
        value = props.value,
        other = _objectWithoutProperties(props, ["onChange", "rows", "rowsMax", "style", "value"]);

    var _React$useRef = React__default.useRef(value != null),
        isControlled = _React$useRef.current;

    var inputRef = React__default.useRef(null);
    var handleRef = useForkRef(ref, inputRef);
    var shadowRef = React__default.useRef(null);

    var _React$useState = React__default.useState({}),
        state = _React$useState[0],
        setState = _React$useState[1];

    var syncHeight = React__default.useCallback(function () {
      var input = inputRef.current;
      var computedStyle = window.getComputedStyle(input);
      var inputShallow = shadowRef.current;
      inputShallow.style.width = computedStyle.width;
      inputShallow.value = input.value || props.placeholder || 'x';
      var boxSizing = computedStyle['box-sizing'];
      var padding = getStyleValue(computedStyle, 'padding-bottom') + getStyleValue(computedStyle, 'padding-top');
      var border = getStyleValue(computedStyle, 'border-bottom-width') + getStyleValue(computedStyle, 'border-top-width'); // The height of the inner content

      var innerHeight = inputShallow.scrollHeight - padding; // Measure height of a textarea with a single row

      inputShallow.value = 'x';
      var singleRowHeight = inputShallow.scrollHeight - padding; // The height of the outer content

      var outerHeight = innerHeight;

      if (rows != null) {
        outerHeight = Math.max(Number(rows) * singleRowHeight, outerHeight);
      }

      if (rowsMax != null) {
        outerHeight = Math.min(Number(rowsMax) * singleRowHeight, outerHeight);
      }

      outerHeight = Math.max(outerHeight, singleRowHeight); // Take the box sizing into account for applying this value as a style.

      var outerHeightStyle = outerHeight + (boxSizing === 'border-box' ? padding + border : 0);
      var overflow = Math.abs(outerHeight - innerHeight) <= 1;
      setState(function (prevState) {
        // Need a large enough different to update the height.
        // This prevents infinite rendering loop.
        if (outerHeightStyle > 0 && Math.abs((prevState.outerHeightStyle || 0) - outerHeightStyle) > 1 || prevState.overflow !== overflow) {
          return {
            overflow: overflow,
            outerHeightStyle: outerHeightStyle
          };
        }

        return prevState;
      });
    }, [rows, rowsMax, props.placeholder]);
    React__default.useEffect(function () {
      var handleResize = debounce(function () {
        syncHeight();
      });
      window.addEventListener('resize', handleResize);
      return function () {
        handleResize.clear();
        window.removeEventListener('resize', handleResize);
      };
    }, [syncHeight]);
    useEnhancedEffect$4(function () {
      syncHeight();
    });

    var handleChange = function handleChange(event) {
      if (!isControlled) {
        syncHeight();
      }

      if (onChange) {
        onChange(event);
      }
    };

    return React__default.createElement(React__default.Fragment, null, React__default.createElement("textarea", _extends({
      value: value,
      onChange: handleChange,
      ref: handleRef // Apply the rows prop to get a "correct" first SSR paint
      ,
      rows: rows || 1,
      style: _extends({
        height: state.outerHeightStyle,
        // Need a large enough different to allow scrolling.
        // This prevents infinite rendering loop.
        overflow: state.overflow ? 'hidden' : null
      }, style)
    }, other)), React__default.createElement("textarea", {
      "aria-hidden": true,
      className: props.className,
      readOnly: true,
      ref: shadowRef,
      tabIndex: -1,
      style: _extends({}, styles$I.shadow, {}, style)
    }));
  });
   TextareaAutosize.propTypes = {
    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    placeholder: propTypes.string,

    /**
     * Minimum number of rows to display.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * @ignore
     */
    value: propTypes.any
  } ;

  // Supports determination of isControlled().
  // Controlled input accepts its current value as a prop.
  //
  // @see https://facebook.github.io/react/docs/forms.html#controlled-components
  // @param value
  // @returns {boolean} true if string (including '') or number (including zero)
  function hasValue(value) {
    return value != null && !(Array.isArray(value) && value.length === 0);
  } // Determine if field is empty or filled.
  // Response determines if label is presented above field or as placeholder.
  //
  // @param obj
  // @param SSR
  // @returns {boolean} False when not present or empty string.
  //                    True when any number or string with length.

  function isFilled(obj) {
    var SSR = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return obj && (hasValue(obj.value) && obj.value !== '' || SSR && hasValue(obj.defaultValue) && obj.defaultValue !== '');
  } // Determine if an Input is adorned on start.
  // It's corresponding to the left with LTR.
  //
  // @param obj
  // @returns {boolean} False when no adornments.
  //                    True when adorned at the start.

  function isAdornedStart(obj) {
    return obj.startAdornment;
  }

  var styles$J = function styles(theme) {
    var light = theme.palette.type === 'light';
    var placeholder = {
      color: 'currentColor',
      opacity: light ? 0.42 : 0.5,
      transition: theme.transitions.create('opacity', {
        duration: theme.transitions.duration.shorter
      })
    };
    var placeholderHidden = {
      opacity: '0 !important'
    };
    var placeholderVisible = {
      opacity: light ? 0.42 : 0.5
    };
    return {
      /* Styles applied to the root element. */
      root: {
        // Mimics the default input display property used by browsers for an input.
        fontFamily: theme.typography.fontFamily,
        color: theme.palette.text.primary,
        fontSize: theme.typography.pxToRem(16),
        lineHeight: '1.1875em',
        // Reset (19px), match the native input line-height
        boxSizing: 'border-box',
        // Prevent padding issue with fullWidth.
        position: 'relative',
        cursor: 'text',
        display: 'inline-flex',
        alignItems: 'center',
        '&$disabled': {
          color: theme.palette.text.disabled,
          cursor: 'default'
        }
      },

      /* Styles applied to the root element if the component is a descendant of `FormControl`. */
      formControl: {},

      /* Styles applied to the root element if the component is focused. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `startAdornment` is provided. */
      adornedStart: {},

      /* Styles applied to the root element if `endAdornment` is provided. */
      adornedEnd: {},

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the `input` element if `margin="dense"`. */
      marginDense: {},

      /* Styles applied to the root element if `multiline={true}`. */
      multiline: {
        padding: "".concat(8 - 2, "px 0 ").concat(8 - 1, "px"),
        '&$marginDense': {
          paddingTop: 4 - 1
        }
      },

      /* Styles applied to the root element if the color is secondary. */
      colorSecondary: {},

      /* Styles applied to the root element if `fullWidth={true}`. */
      fullWidth: {
        width: '100%'
      },

      /* Styles applied to the `input` element. */
      input: {
        font: 'inherit',
        color: 'currentColor',
        padding: "".concat(8 - 2, "px 0 ").concat(8 - 1, "px"),
        border: 0,
        boxSizing: 'content-box',
        background: 'none',
        height: '1.1875em',
        // Reset (19px), match the native input line-height
        margin: 0,
        // Reset for Safari
        // Remove grey highlight
        WebkitTapHighlightColor: 'transparent',
        display: 'block',
        // Make the flex item shrink with Firefox
        minWidth: 0,
        width: '100%',
        // Fix IE 11 width issue
        animationName: '$auto-fill-cancel',
        '&::-webkit-input-placeholder': placeholder,
        '&::-moz-placeholder': placeholder,
        // Firefox 19+
        '&:-ms-input-placeholder': placeholder,
        // IE 11
        '&::-ms-input-placeholder': placeholder,
        // Edge
        '&:focus': {
          outline: 0
        },
        // Reset Firefox invalid required input style
        '&:invalid': {
          boxShadow: 'none'
        },
        '&::-webkit-search-decoration': {
          // Remove the padding when type=search.
          '-webkit-appearance': 'none'
        },
        // Show and hide the placeholder logic
        'label[data-shrink=false] + $formControl &': {
          '&::-webkit-input-placeholder': placeholderHidden,
          '&::-moz-placeholder': placeholderHidden,
          // Firefox 19+
          '&:-ms-input-placeholder': placeholderHidden,
          // IE 11
          '&::-ms-input-placeholder': placeholderHidden,
          // Edge
          '&:focus::-webkit-input-placeholder': placeholderVisible,
          '&:focus::-moz-placeholder': placeholderVisible,
          // Firefox 19+
          '&:focus:-ms-input-placeholder': placeholderVisible,
          // IE 11
          '&:focus::-ms-input-placeholder': placeholderVisible // Edge

        },
        '&$disabled': {
          opacity: 1 // Reset iOS opacity

        },
        '&:-webkit-autofill': {
          animationDuration: '5000s',
          animationName: '$auto-fill'
        }
      },
      '@keyframes auto-fill': {
        from: {}
      },
      '@keyframes auto-fill-cancel': {
        from: {}
      },

      /* Styles applied to the `input` element if `margin="dense"`. */
      inputMarginDense: {
        paddingTop: 4 - 1
      },

      /* Styles applied to the `input` element if `select={true}`. */
      inputSelect: {
        paddingRight: 24
      },

      /* Styles applied to the `input` element if `multiline={true}`. */
      inputMultiline: {
        height: 'auto',
        resize: 'none',
        padding: 0
      },

      /* Styles applied to the `input` element if `type="search"`. */
      inputTypeSearch: {
        // Improve type search style.
        '-moz-appearance': 'textfield',
        '-webkit-appearance': 'textfield'
      },

      /* Styles applied to the `input` element if `startAdornment` is provided. */
      inputAdornedStart: {},

      /* Styles applied to the `input` element if `endAdornment` is provided. */
      inputAdornedEnd: {},

      /* Styles applied to the `input` element if `hiddenLabel={true}`. */
      inputHiddenLabel: {}
    };
  };
  var useEnhancedEffect$5 = typeof window === 'undefined' ? React__default.useEffect : React__default.useLayoutEffect;
  /**
   * `InputBase` contains as few styles as possible.
   * It aims to be a simple building block for creating an input.
   * It contains a load of style reset and some state logic.
   */

  var InputBase = React__default.forwardRef(function InputBase(props, ref) {
    var ariaDescribedby = props['aria-describedby'],
        autoComplete = props.autoComplete,
        autoFocus = props.autoFocus,
        classes = props.classes,
        className = props.className,
        color = props.color,
        defaultValue = props.defaultValue,
        disabled = props.disabled,
        endAdornment = props.endAdornment,
        error = props.error,
        _props$fullWidth = props.fullWidth,
        fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
        id = props.id,
        _props$inputComponent = props.inputComponent,
        inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
        _props$inputProps = props.inputProps,
        inputPropsProp = _props$inputProps === void 0 ? {} : _props$inputProps,
        inputRefProp = props.inputRef,
        margin = props.margin,
        _props$multiline = props.multiline,
        multiline = _props$multiline === void 0 ? false : _props$multiline,
        name = props.name,
        onBlur = props.onBlur,
        onChange = props.onChange,
        onClick = props.onClick,
        onFocus = props.onFocus,
        onKeyDown = props.onKeyDown,
        onKeyUp = props.onKeyUp,
        placeholder = props.placeholder,
        readOnly = props.readOnly,
        renderSuffix = props.renderSuffix,
        rows = props.rows,
        rowsMax = props.rowsMax,
        _props$select = props.select,
        select = _props$select === void 0 ? false : _props$select,
        startAdornment = props.startAdornment,
        _props$type = props.type,
        type = _props$type === void 0 ? 'text' : _props$type,
        valueProp = props.value,
        other = _objectWithoutProperties(props, ["aria-describedby", "autoComplete", "autoFocus", "classes", "className", "color", "defaultValue", "disabled", "endAdornment", "error", "fullWidth", "id", "inputComponent", "inputProps", "inputRef", "margin", "multiline", "name", "onBlur", "onChange", "onClick", "onFocus", "onKeyDown", "onKeyUp", "placeholder", "readOnly", "renderSuffix", "rows", "rowsMax", "select", "startAdornment", "type", "value"]);

    var value = inputPropsProp.value != null ? inputPropsProp.value : valueProp;

    var _React$useRef = React__default.useRef(value != null),
        isControlled = _React$useRef.current;

    var inputRef = React__default.useRef();
    var handleInputRefWarning = React__default.useCallback(function (instance) {
      {
        if (instance && !(instance instanceof HTMLInputElement) && !instance.focus) {
          console.error(['Material-UI: you have provided a `inputComponent` to the input component', 'that does not correctly handle the `inputRef` prop.', 'Make sure the `inputRef` prop is called with a HTMLInputElement.'].join('\n'));
        }
      }
    }, []);
    var handleInputPropsRefProp = useForkRef(inputPropsProp.ref, handleInputRefWarning);
    var handleInputRefProp = useForkRef(inputRefProp, handleInputPropsRefProp);
    var handleInputRef = useForkRef(inputRef, handleInputRefProp);

    var _React$useState = React__default.useState(false),
        focused = _React$useState[0],
        setFocused = _React$useState[1];

    var muiFormControl = useFormControl();

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__default.useEffect(function () {
        if (muiFormControl) {
          return muiFormControl.registerEffect();
        }

        return undefined;
      }, [muiFormControl]);
    }

    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['color', 'disabled', 'error', 'hiddenLabel', 'margin', 'required', 'filled']
    });
    fcs.focused = muiFormControl ? muiFormControl.focused : focused; // The blur won't fire when the disabled state is set on a focused input.
    // We need to book keep the focused state manually.

    React__default.useEffect(function () {
      if (!muiFormControl && disabled && focused) {
        setFocused(false);

        if (onBlur) {
          onBlur();
        }
      }
    }, [muiFormControl, disabled, focused, onBlur]);
    var onFilled = muiFormControl && muiFormControl.onFilled;
    var onEmpty = muiFormControl && muiFormControl.onEmpty;
    var checkDirty = React__default.useCallback(function (obj) {
      if (isFilled(obj)) {
        if (onFilled) {
          onFilled();
        }
      } else if (onEmpty) {
        onEmpty();
      }
    }, [onFilled, onEmpty]);
    useEnhancedEffect$5(function () {
      if (isControlled) {
        checkDirty({
          value: value
        });
      }
    }, [value, checkDirty, isControlled]);

    var handleFocus = function handleFocus(event) {
      // Fix a bug with IE 11 where the focus/blur events are triggered
      // while the input is disabled.
      if (fcs.disabled) {
        event.stopPropagation();
        return;
      }

      if (onFocus) {
        onFocus(event);
      }

      if (inputPropsProp.onFocus) {
        inputPropsProp.onFocus(event);
      }

      if (muiFormControl && muiFormControl.onFocus) {
        muiFormControl.onFocus(event);
      } else {
        setFocused(true);
      }
    };

    var handleBlur = function handleBlur(event) {
      if (onBlur) {
        onBlur(event);
      }

      if (inputPropsProp.onBlur) {
        inputPropsProp.onBlur(event);
      }

      if (muiFormControl && muiFormControl.onBlur) {
        muiFormControl.onBlur(event);
      } else {
        setFocused(false);
      }
    };

    var handleChange = function handleChange(event) {
      if (!isControlled) {
        var element = event.target || inputRef.current;

        if (element == null) {
          throw new TypeError('Material-UI: Expected valid input target. ' + 'Did you use a custom `inputComponent` and forget to forward refs? ' + 'See https://material-ui.com/r/input-component-ref-interface for more info.');
        }

        checkDirty({
          value: element.value
        });
      }

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      if (inputPropsProp.onChange) {
        inputPropsProp.onChange.apply(inputPropsProp, [event].concat(args));
      } // Perform in the willUpdate


      if (onChange) {
        onChange.apply(void 0, [event].concat(args));
      }
    }; // Check the input state on mount, in case it was filled by the user
    // or auto filled by the browser before the hydration (for SSR).


    React__default.useEffect(function () {
      checkDirty(inputRef.current);
    }, []); // eslint-disable-line react-hooks/exhaustive-deps

    var handleClick = function handleClick(event) {
      if (inputRef.current && event.currentTarget === event.target) {
        inputRef.current.focus();
      }

      if (onClick) {
        onClick(event);
      }
    };

    var InputComponent = inputComponent;

    var inputProps = _extends({}, inputPropsProp, {
      ref: handleInputRef
    });

    if (typeof InputComponent !== 'string') {
      inputProps = _extends({
        // Rename ref to inputRef as we don't know the
        // provided `inputComponent` structure.
        inputRef: handleInputRef,
        type: type
      }, inputProps, {
        ref: null
      });
    } else if (multiline) {
      if (rows && !rowsMax) {
        InputComponent = 'textarea';
      } else {
        inputProps = _extends({
          rows: rows,
          rowsMax: rowsMax
        }, inputProps);
        InputComponent = TextareaAutosize;
      }
    } else {
      inputProps = _extends({
        type: type
      }, inputProps);
    }

    var handleAutoFill = function handleAutoFill(event) {
      // Provide a fake value as Chrome might not let you access it for security reasons.
      checkDirty(event.animationName.indexOf('auto-fill-cancel') !== -1 ? inputRef.current : {
        value: 'x'
      });
    };

    React__default.useEffect(function () {
      if (muiFormControl) {
        muiFormControl.setAdornedStart(Boolean(startAdornment));
      }
    }, [muiFormControl, startAdornment]);
    return React__default.createElement("div", _extends({
      className: clsx(classes.root, classes["color".concat(capitalize(fcs.color || 'primary'))], className, fcs.disabled && classes.disabled, fcs.error && classes.error, fullWidth && classes.fullWidth, fcs.focused && classes.focused, muiFormControl && classes.formControl, multiline && classes.multiline, startAdornment && classes.adornedStart, endAdornment && classes.adornedEnd, {
        dense: classes.marginDense
      }[fcs.margin]),
      onClick: handleClick,
      ref: ref
    }, other), startAdornment, React__default.createElement(FormControlContext.Provider, {
      value: null
    }, React__default.createElement(InputComponent, _extends({
      "aria-invalid": fcs.error,
      "aria-describedby": ariaDescribedby,
      autoComplete: autoComplete,
      autoFocus: autoFocus,
      defaultValue: defaultValue,
      disabled: fcs.disabled,
      id: id,
      onAnimationStart: handleAutoFill,
      name: name,
      placeholder: placeholder,
      readOnly: readOnly,
      required: fcs.required,
      rows: rows,
      value: value,
      onKeyDown: onKeyDown,
      onKeyUp: onKeyUp
    }, inputProps, {
      className: clsx(classes.input, inputPropsProp.className, fcs.disabled && classes.disabled, multiline && classes.inputMultiline, select && classes.inputSelect, fcs.hiddenLabel && classes.inputHiddenLabel, startAdornment && classes.inputAdornedStart, endAdornment && classes.inputAdornedEnd, {
        search: classes.inputTypeSearch
      }[type], {
        dense: classes.inputMarginDense
      }[fcs.margin]),
      onBlur: handleBlur,
      onChange: handleChange,
      onFocus: handleFocus
    }))), endAdornment, renderSuffix ? renderSuffix(_extends({}, fcs, {
      startAdornment: startAdornment
    })) : null);
  });
   InputBase.propTypes = {
    /**
     * @ignore
     */
    'aria-describedby': propTypes.string,

    /**
     * This prop helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
     */
    autoComplete: propTypes.string,

    /**
     * If `true`, the `input` element will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the wrapper element.
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The default `input` element value. Use when the component is not controlled.
     */
    defaultValue: propTypes.any,

    /**
     * If `true`, the `input` element will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: propTypes.node,

    /**
     * If `true`, the input will indicate an error. This is normally obtained via context from
     * FormControl.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * The component used for the `input` element.
     * Either a string to use a DOM element or a component.
     */
    inputComponent: propTypes.elementType,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense', 'none']),

    /**
     * If `true`, a textarea element will be rendered.
     */
    multiline: propTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * Callback fired when the value is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * @ignore
     */
    onKeyUp: propTypes.func,

    /**
     * The short hint displayed in the input before the user enters a value.
     */
    placeholder: propTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * @ignore
     */
    renderSuffix: propTypes.func,

    /**
     * If `true`, the `input` element will be required.
     */
    required: propTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Should be `true` when the component hosts a select.
     */
    select: propTypes.bool,

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: propTypes.node,

    /**
     * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
     */
    type: propTypes.string,

    /**
     * The value of the `input` element, required for a controlled component.
     */
    value: propTypes.any
  } ;
  var InputBase$1 = withStyles$1(styles$J, {
    name: 'MuiInputBase'
  })(InputBase);

  var styles$K = function styles(theme) {
    var light = theme.palette.type === 'light';
    var bottomLineColor = light ? 'rgba(0, 0, 0, 0.42)' : 'rgba(255, 255, 255, 0.7)';
    var backgroundColor = light ? 'rgba(0, 0, 0, 0.09)' : 'rgba(255, 255, 255, 0.09)';
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        backgroundColor: backgroundColor,
        borderTopLeftRadius: theme.shape.borderRadius,
        borderTopRightRadius: theme.shape.borderRadius,
        transition: theme.transitions.create('background-color', {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        }),
        '&:hover': {
          backgroundColor: light ? 'rgba(0, 0, 0, 0.13)' : 'rgba(255, 255, 255, 0.13)',
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: backgroundColor
          }
        },
        '&$focused': {
          backgroundColor: light ? 'rgba(0, 0, 0, 0.09)' : 'rgba(255, 255, 255, 0.09)'
        },
        '&$disabled': {
          backgroundColor: light ? 'rgba(0, 0, 0, 0.12)' : 'rgba(255, 255, 255, 0.12)'
        }
      },

      /* Styles applied to the root element if color secondary. */
      colorSecondary: {
        '&$underline:after': {
          borderBottomColor: theme.palette.secondary.main
        }
      },

      /* Styles applied to the root element if `disableUnderline={false}`. */
      underline: {
        '&:after': {
          borderBottom: "2px solid ".concat(theme.palette.primary.main),
          left: 0,
          bottom: 0,
          // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
          content: '""',
          position: 'absolute',
          right: 0,
          transform: 'scaleX(0)',
          transition: theme.transitions.create('transform', {
            duration: theme.transitions.duration.shorter,
            easing: theme.transitions.easing.easeOut
          }),
          pointerEvents: 'none' // Transparent to the hover style.

        },
        '&$focused:after': {
          transform: 'scaleX(1)'
        },
        '&$error:after': {
          borderBottomColor: theme.palette.error.main,
          transform: 'scaleX(1)' // error is always underlined in red

        },
        '&:before': {
          borderBottom: "1px solid ".concat(bottomLineColor),
          left: 0,
          bottom: 0,
          // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
          content: '"\\00a0"',
          position: 'absolute',
          right: 0,
          transition: theme.transitions.create('border-bottom-color', {
            duration: theme.transitions.duration.shorter
          }),
          pointerEvents: 'none' // Transparent to the hover style.

        },
        '&:hover:before': {
          borderBottom: "1px solid ".concat(theme.palette.text.primary)
        },
        '&$disabled:before': {
          borderBottomStyle: 'dotted'
        }
      },

      /* Pseudo-class applied to the root element if the component is focused. */
      focused: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `startAdornment` is provided. */
      adornedStart: {
        paddingLeft: 12
      },

      /* Styles applied to the root element if `endAdornment` is provided. */
      adornedEnd: {
        paddingRight: 12
      },

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the `input` element if `margin="dense"`. */
      marginDense: {},

      /* Styles applied to the root element if `multiline={true}`. */
      multiline: {
        padding: '27px 12px 10px',
        '&$marginDense': {
          paddingTop: 23,
          paddingBottom: 6
        }
      },

      /* Styles applied to the `input` element. */
      input: {
        padding: '27px 12px 10px',
        '&:-webkit-autofill': {
          WebkitBoxShadow: theme.palette.type === 'dark' ? '0 0 0 100px #266798 inset' : null,
          WebkitTextFillColor: theme.palette.type === 'dark' ? '#fff' : null,
          borderTopLeftRadius: 'inherit',
          borderTopRightRadius: 'inherit'
        }
      },

      /* Styles applied to the `input` element if `margin="dense"`. */
      inputMarginDense: {
        paddingTop: 23,
        paddingBottom: 6
      },

      /* Styles applied to the `input` if in `<FormControl hiddenLabel />`. */
      inputHiddenLabel: {
        paddingTop: 18,
        paddingBottom: 19,
        '&$inputMarginDense': {
          paddingTop: 10,
          paddingBottom: 11
        }
      },

      /* Styles applied to the `input` element if `select={true}`. */
      inputSelect: {
        paddingRight: 24
      },

      /* Styles applied to the `input` element if `multiline={true}`. */
      inputMultiline: {
        padding: 0
      },

      /* Styles applied to the `input` element if `startAdornment` is provided. */
      inputAdornedStart: {
        paddingLeft: 0
      },

      /* Styles applied to the `input` element if `endAdornment` is provided. */
      inputAdornedEnd: {
        paddingRight: 0
      }
    };
  };
  var FilledInput = React__default.forwardRef(function FilledInput(props, ref) {
    var disableUnderline = props.disableUnderline,
        classes = props.classes,
        _props$fullWidth = props.fullWidth,
        fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
        _props$inputComponent = props.inputComponent,
        inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
        _props$multiline = props.multiline,
        multiline = _props$multiline === void 0 ? false : _props$multiline,
        _props$type = props.type,
        type = _props$type === void 0 ? 'text' : _props$type,
        other = _objectWithoutProperties(props, ["disableUnderline", "classes", "fullWidth", "inputComponent", "multiline", "type"]);

    return React__default.createElement(InputBase$1, _extends({
      classes: _extends({}, classes, {
        root: clsx(classes.root, !disableUnderline && classes.underline),
        underline: null
      }),
      fullWidth: fullWidth,
      inputComponent: inputComponent,
      multiline: multiline,
      ref: ref,
      type: type
    }, other));
  });
   FilledInput.propTypes = {
    /**
     * This prop helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
     */
    autoComplete: propTypes.string,

    /**
     * If `true`, the `input` element will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the wrapper element.
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The default `input` element value. Use when the component is not controlled.
     */
    defaultValue: propTypes.any,

    /**
     * If `true`, the `input` element will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the input will not have an underline.
     */
    disableUnderline: propTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: propTypes.node,

    /**
     * If `true`, the input will indicate an error. This is normally obtained via context from
     * FormControl.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * The component used for the native input.
     * Either a string to use a DOM element or a component.
     */
    inputComponent: propTypes.elementType,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense', 'none']),

    /**
     * If `true`, a textarea element will be rendered.
     */
    multiline: propTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * Callback fired when the value is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: propTypes.func,

    /**
     * The short hint displayed in the input before the user enters a value.
     */
    placeholder: propTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * If `true`, the `input` element will be required.
     */
    required: propTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: propTypes.node,

    /**
     * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
     */
    type: propTypes.string,

    /**
     * The value of the `input` element, required for a controlled component.
     */
    value: propTypes.any
  } ;
  FilledInput.muiName = 'Input';
  var FilledInput$1 = withStyles$1(styles$K, {
    name: 'MuiFilledInput'
  })(FilledInput);

  function isMuiElement(element, muiNames) {
    return React__default.isValidElement(element) && muiNames.indexOf(element.type.muiName) !== -1;
  }

  var styles$L = {
    /* Styles applied to the root element. */
    root: {
      display: 'inline-flex',
      flexDirection: 'column',
      position: 'relative',
      // Reset fieldset default style.
      minWidth: 0,
      padding: 0,
      margin: 0,
      border: 0,
      verticalAlign: 'top' // Fix alignment issue on Safari.

    },

    /* Styles applied to the root element if `margin="normal"`. */
    marginNormal: {
      marginTop: 16,
      marginBottom: 8
    },

    /* Styles applied to the root element if `margin="dense"`. */
    marginDense: {
      marginTop: 8,
      marginBottom: 4
    },

    /* Styles applied to the root element if `fullWidth={true}`. */
    fullWidth: {
      width: '100%'
    }
  };
  /**
   * Provides context such as filled/focused/error/required for form inputs.
   * Relying on the context provides high flexibility and ensures that the state always stays
   * consistent across the children of the `FormControl`.
   * This context is used by the following components:
   *
   *  - FormLabel
   *  - FormHelperText
   *  - Input
   *  - InputLabel
   *
   * You can find one composition example below and more going to [the demos](/components/text-fields/#components).
   *
   * ```jsx
   * <FormControl>
   *   <InputLabel htmlFor="my-input">Email address</InputLabel>
   *   <Input id="my-input" aria-describedby="my-helper-text" />
   *   <FormHelperText id="my-helper-text">We'll never share your email.</FormHelperText>
   * </FormControl>
   * ```
   *
   * ⚠️Only one input can be used within a FormControl.
   */

  var FormControl = React__default.forwardRef(function FormControl(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$error = props.error,
        error = _props$error === void 0 ? false : _props$error,
        _props$fullWidth = props.fullWidth,
        fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
        _props$hiddenLabel = props.hiddenLabel,
        hiddenLabel = _props$hiddenLabel === void 0 ? false : _props$hiddenLabel,
        _props$margin = props.margin,
        margin = _props$margin === void 0 ? 'none' : _props$margin,
        _props$color = props.color,
        color = _props$color === void 0 ? 'primary' : _props$color,
        _props$required = props.required,
        required = _props$required === void 0 ? false : _props$required,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'standard' : _props$variant,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "component", "disabled", "error", "fullWidth", "hiddenLabel", "margin", "color", "required", "variant"]);

    var _React$useState = React__default.useState(function () {
      // We need to iterate through the children and find the Input in order
      // to fully support server-side rendering.
      var initialAdornedStart = false;

      if (children) {
        React__default.Children.forEach(children, function (child) {
          if (!isMuiElement(child, ['Input', 'Select'])) {
            return;
          }

          var input = isMuiElement(child, ['Select']) ? child.props.input : child;

          if (input && isAdornedStart(input.props)) {
            initialAdornedStart = true;
          }
        });
      }

      return initialAdornedStart;
    }),
        adornedStart = _React$useState[0],
        setAdornedStart = _React$useState[1];

    var _React$useState2 = React__default.useState(function () {
      // We need to iterate through the children and find the Input in order
      // to fully support server-side rendering.
      var initialFilled = false;

      if (children) {
        React__default.Children.forEach(children, function (child) {
          if (!isMuiElement(child, ['Input', 'Select'])) {
            return;
          }

          if (isFilled(child.props, true)) {
            initialFilled = true;
          }
        });
      }

      return initialFilled;
    }),
        filled = _React$useState2[0],
        setFilled = _React$useState2[1];

    var _React$useState3 = React__default.useState(false),
        focused = _React$useState3[0],
        setFocused = _React$useState3[1];

    if (disabled && focused) {
      setFocused(false);
    }

    var registerEffect;

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      var registeredInput = React__default.useRef(false);

      registerEffect = function registerEffect() {
        if (registeredInput.current) {
          console.error(['Material-UI: there are multiple InputBase components inside a FormControl.', 'This is not supported. It might cause infinite rendering loops.', 'Only use one InputBase.'].join('\n'));
        }

        registeredInput.current = true;
        return function () {
          registeredInput.current = false;
        };
      };
    }

    var onFilled = React__default.useCallback(function () {
      setFilled(true);
    }, []);
    var onEmpty = React__default.useCallback(function () {
      setFilled(false);
    }, []);
    var childContext = {
      adornedStart: adornedStart,
      setAdornedStart: setAdornedStart,
      color: color,
      disabled: disabled,
      error: error,
      filled: filled,
      focused: focused,
      hiddenLabel: hiddenLabel,
      margin: margin,
      onBlur: function onBlur() {
        setFocused(false);
      },
      onEmpty: onEmpty,
      onFilled: onFilled,
      onFocus: function onFocus() {
        setFocused(true);
      },
      registerEffect: registerEffect,
      required: required,
      variant: variant
    };
    return React__default.createElement(FormControlContext.Provider, {
      value: childContext
    }, React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, margin !== 'none' && classes["margin".concat(capitalize(margin))], fullWidth && classes.fullWidth),
      ref: ref
    }, other), children));
  });
   FormControl.propTypes = {
    /**
     * The contents of the form control.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the label, input and helper text should be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the label should be displayed in an error state.
     */
    error: propTypes.bool,

    /**
     * If `true`, the component will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * If `true`, the label will be hidden.
     * This is used to increase density for a `FilledInput`.
     * Be sure to add `aria-label` to the `input` element.
     */
    hiddenLabel: propTypes.bool,

    /**
     * If `dense` or `normal`, will adjust vertical spacing of this and contained components.
     */
    margin: propTypes.oneOf(['none', 'dense', 'normal']),

    /**
     * If `true`, the label will indicate that the input is required.
     */
    required: propTypes.bool,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  } ;
  var FormControl$1 = withStyles$1(styles$L, {
    name: 'MuiFormControl'
  })(FormControl);

  var styles$M = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'inline-flex',
        alignItems: 'center',
        cursor: 'pointer',
        // For correct alignment with the text.
        verticalAlign: 'middle',
        // Remove grey highlight
        WebkitTapHighlightColor: 'transparent',
        marginLeft: -11,
        marginRight: 16,
        // used for row presentation of radio/checkbox
        '&$disabled': {
          cursor: 'default'
        }
      },

      /* Styles applied to the root element if `labelPlacement="start"`. */
      labelPlacementStart: {
        flexDirection: 'row-reverse',
        marginLeft: 16,
        // used for row presentation of radio/checkbox
        marginRight: -11
      },

      /* Styles applied to the root element if `labelPlacement="top"`. */
      labelPlacementTop: {
        flexDirection: 'column-reverse',
        marginLeft: 16
      },

      /* Styles applied to the root element if `labelPlacement="bottom"`. */
      labelPlacementBottom: {
        flexDirection: 'column',
        marginLeft: 16
      },

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the label's Typography component. */
      label: {
        '&$disabled': {
          color: theme.palette.text.disabled
        }
      }
    };
  };
  /**
   * Drop in replacement of the `Radio`, `Switch` and `Checkbox` component.
   * Use this component if you want to display an extra label.
   */

  var FormControlLabel = React__default.forwardRef(function FormControlLabel(props, ref) {
    var checked = props.checked,
        classes = props.classes,
        className = props.className,
        control = props.control,
        disabledProp = props.disabled,
        inputRef = props.inputRef,
        label = props.label,
        _props$labelPlacement = props.labelPlacement,
        labelPlacement = _props$labelPlacement === void 0 ? 'end' : _props$labelPlacement,
        name = props.name,
        onChange = props.onChange,
        value = props.value,
        other = _objectWithoutProperties(props, ["checked", "classes", "className", "control", "disabled", "inputRef", "label", "labelPlacement", "name", "onChange", "value"]);

    var muiFormControl = useFormControl$1();
    var disabled = disabledProp;

    if (typeof disabled === 'undefined' && typeof control.props.disabled !== 'undefined') {
      disabled = control.props.disabled;
    }

    if (typeof disabled === 'undefined' && muiFormControl) {
      disabled = muiFormControl.disabled;
    }

    var controlProps = {
      disabled: disabled
    };
    ['checked', 'name', 'onChange', 'value', 'inputRef'].forEach(function (key) {
      if (typeof control.props[key] === 'undefined' && typeof props[key] !== 'undefined') {
        controlProps[key] = props[key];
      }
    });
    return React__default.createElement("label", _extends({
      className: clsx(classes.root, className, labelPlacement !== 'end' && classes["labelPlacement".concat(capitalize(labelPlacement))], disabled && classes.disabled),
      ref: ref
    }, other), React__default.cloneElement(control, controlProps), React__default.createElement(Typography$1, {
      component: "span",
      className: clsx(classes.label, disabled && classes.disabled)
    }, label));
  });
   FormControlLabel.propTypes = {
    /**
     * If `true`, the component appears selected.
     */
    checked: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * A control element. For instance, it can be be a `Radio`, a `Switch` or a `Checkbox`.
     */
    control: propTypes.element,

    /**
     * If `true`, the control will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType,

    /**
     * The text to be used in an enclosing label element.
     */
    label: propTypes.node,

    /**
     * The position of the label.
     */
    labelPlacement: propTypes.oneOf(['end', 'start', 'top', 'bottom']),

    /*
     * @ignore
     */
    name: propTypes.string,

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new checked state by accessing `event.target.checked` (boolean).
     */
    onChange: propTypes.func,

    /**
     * The value of the component.
     */
    value: propTypes.any
  } ;
  var FormControlLabel$1 = withStyles$1(styles$M, {
    name: 'MuiFormControlLabel'
  })(FormControlLabel);

  var styles$N = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      flexDirection: 'column',
      flexWrap: 'wrap'
    },

    /* Styles applied to the root element if `row={true}`. */
    row: {
      flexDirection: 'row'
    }
  };
  /**
   * `FormGroup` wraps controls such as `Checkbox` and `Switch`.
   * It provides compact row layout.
   * For the `Radio`, you should be using the `RadioGroup` component instead of this one.
   */

  var FormGroup = React__default.forwardRef(function FormGroup(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$row = props.row,
        row = _props$row === void 0 ? false : _props$row,
        other = _objectWithoutProperties(props, ["classes", "className", "row"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, row && classes.row),
      ref: ref
    }, other));
  });
   FormGroup.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Display group of elements in a compact row.
     */
    row: propTypes.bool
  } ;
  var FormGroup$1 = withStyles$1(styles$N, {
    name: 'MuiFormGroup'
  })(FormGroup);

  var styles$O = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends({
        color: theme.palette.text.secondary
      }, theme.typography.caption, {
        textAlign: 'left',
        marginTop: 8,
        lineHeight: '1em',
        minHeight: '1em',
        margin: 0,
        '&$disabled': {
          color: theme.palette.text.disabled
        },
        '&$error': {
          color: theme.palette.error.main
        }
      }),

      /* Pseudo-class applied to the root element if `error={true}`. */
      error: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `margin="dense"`. */
      marginDense: {
        marginTop: 4
      },

      /* Styles applied to the root element if `variant="filled"` or `variant="outlined"`. */
      contained: {
        margin: '8px 14px 0'
      },

      /* Pseudo-class applied to the root element if `focused={true}`. */
      focused: {},

      /* Pseudo-class applied to the root element if `filled={true}`. */
      filled: {},

      /* Pseudo-class applied to the root element if `required={true}`. */
      required: {}
    };
  };
  var FormHelperText = React__default.forwardRef(function FormHelperText(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'p' : _props$component,
        disabled = props.disabled,
        error = props.error,
        filled = props.filled,
        focused = props.focused,
        margin = props.margin,
        required = props.required,
        variant = props.variant,
        other = _objectWithoutProperties(props, ["classes", "className", "component", "disabled", "error", "filled", "focused", "margin", "required", "variant"]);

    var muiFormControl = useFormControl$1();
    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['variant', 'margin', 'disabled', 'error', 'filled', 'focused', 'required']
    });
    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, (fcs.variant === 'filled' || fcs.variant === 'outlined') && classes.contained, className, fcs.disabled && classes.disabled, fcs.error && classes.error, fcs.filled && classes.filled, fcs.focused && classes.focused, fcs.required && classes.required, {
        dense: classes.marginDense
      }[fcs.margin]),
      ref: ref
    }, other));
  });
   FormHelperText.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the helper text should be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, helper text should be displayed in an error state.
     */
    error: propTypes.bool,

    /**
     * If `true`, the helper text should use filled classes key.
     */
    filled: propTypes.bool,

    /**
     * If `true`, the helper text should use focused classes key.
     */
    focused: propTypes.bool,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense']),

    /**
     * If `true`, the helper text should use required classes key.
     */
    required: propTypes.bool,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  } ;
  var FormHelperText$1 = withStyles$1(styles$O, {
    name: 'MuiFormHelperText'
  })(FormHelperText);

  var styles$P = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends({
        color: theme.palette.text.secondary
      }, theme.typography.body1, {
        lineHeight: 1,
        padding: 0,
        '&$focused': {
          color: theme.palette.primary.main
        },
        '&$disabled': {
          color: theme.palette.text.disabled
        },
        '&$error': {
          color: theme.palette.error.main
        }
      }),

      /* Styles applied to the root element if the color is secondary. */
      colorSecondary: {
        '&$focused': {
          color: theme.palette.secondary.main
        }
      },

      /* Pseudo-class applied to the root element if `focused={true}`. */
      focused: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Pseudo-class applied to the root element if `error={true}`. */
      error: {},

      /* Pseudo-class applied to the root element if `filled={true}`. */
      filled: {},

      /* Pseudo-class applied to the root element if `required={true}`. */
      required: {},

      /* Styles applied to the asterisk element. */
      asterisk: {
        '&$error': {
          color: theme.palette.error.main
        }
      }
    };
  };
  var FormLabel = React__default.forwardRef(function FormLabel(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        color = props.color,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'label' : _props$component,
        disabled = props.disabled,
        error = props.error,
        filled = props.filled,
        focused = props.focused,
        required = props.required,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "color", "component", "disabled", "error", "filled", "focused", "required"]);

    var muiFormControl = useFormControl$1();
    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['color', 'required', 'focused', 'disabled', 'error', 'filled']
    });
    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, classes["color".concat(capitalize(fcs.color || 'primary'))], className, fcs.disabled && classes.disabled, fcs.error && classes.error, fcs.filled && classes.filled, fcs.focused && classes.focused, fcs.required && classes.required),
      ref: ref
    }, other), children, fcs.required && React__default.createElement("span", {
      className: clsx(classes.asterisk, fcs.error && classes.error)
    }, "\u2009", '*'));
  });
   FormLabel.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the label should be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the label should be displayed in an error state.
     */
    error: propTypes.bool,

    /**
     * If `true`, the label should use filled classes key.
     */
    filled: propTypes.bool,

    /**
     * If `true`, the input of this label is focused (used by `FormGroup` components).
     */
    focused: propTypes.bool,

    /**
     * If `true`, the label will indicate that the input is required.
     */
    required: propTypes.bool
  } ;
  var FormLabel$1 = withStyles$1(styles$P, {
    name: 'MuiFormLabel'
  })(FormLabel);

  function requirePropFactory(componentNameInError) {

    var requireProp = function requireProp(requiredProp) {
      return function (props, propName, componentName, location, propFullName) {
        var propFullNameSafe = propFullName || propName;

        if (typeof props[propName] !== 'undefined' && !props[requiredProp]) {
          return new Error("The prop `".concat(propFullNameSafe, "` of ") + "`".concat(componentNameInError, "` must be used on `").concat(requiredProp, "`."));
        }

        return null;
      };
    };

    return requireProp;
  }

  var SPACINGS = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  var GRID_SIZES = ['auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];

  function generateGrid(globalStyles, theme, breakpoint) {
    var styles = {};
    GRID_SIZES.forEach(function (size) {
      var key = "grid-".concat(breakpoint, "-").concat(size);

      if (size === true) {
        // For the auto layouting
        styles[key] = {
          flexBasis: 0,
          flexGrow: 1,
          maxWidth: '100%'
        };
        return;
      }

      if (size === 'auto') {
        styles[key] = {
          flexBasis: 'auto',
          flexGrow: 0,
          maxWidth: 'none'
        };
        return;
      } // Keep 7 significant numbers.


      var width = "".concat(Math.round(size / 12 * 10e7) / 10e5, "%"); // Close to the bootstrap implementation:
      // https://github.com/twbs/bootstrap/blob/8fccaa2439e97ec72a4b7dc42ccc1f649790adb0/scss/mixins/_grid.scss#L41

      styles[key] = {
        flexBasis: width,
        flexGrow: 0,
        maxWidth: width
      };
    }); // No need for a media query for the first size.

    if (breakpoint === 'xs') {
      _extends(globalStyles, styles);
    } else {
      globalStyles[theme.breakpoints.up(breakpoint)] = styles;
    }
  }

  function getOffset(val) {
    var div = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
    var parse = parseFloat(val);
    return "".concat(parse / div).concat(String(val).replace(String(parse), '') || 'px');
  }

  function generateGutter(theme, breakpoint) {
    var styles = {};
    SPACINGS.forEach(function (spacing) {
      var themeSpacing = theme.spacing(spacing);

      if (themeSpacing === 0) {
        return;
      }

      styles["spacing-".concat(breakpoint, "-").concat(spacing)] = {
        margin: "-".concat(getOffset(themeSpacing, 2)),
        width: "calc(100% + ".concat(getOffset(themeSpacing), ")"),
        '& > $item': {
          padding: getOffset(themeSpacing, 2)
        }
      };
    });
    return styles;
  } // Default CSS values
  // flex: '0 1 auto',
  // flexDirection: 'row',
  // alignItems: 'flex-start',
  // flexWrap: 'nowrap',
  // justifyContent: 'flex-start',


  var styles$Q = function styles(theme) {
    return _extends({
      /* Styles applied to the root element */
      root: {},

      /* Styles applied to the root element if `container={true}`. */
      container: {
        boxSizing: 'border-box',
        display: 'flex',
        flexWrap: 'wrap',
        width: '100%'
      },

      /* Styles applied to the root element if `item={true}`. */
      item: {
        boxSizing: 'border-box',
        margin: '0' // For instance, it's useful when used with a `figure` element.

      },

      /* Styles applied to the root element if `zeroMinWidth={true}`. */
      zeroMinWidth: {
        minWidth: 0
      },

      /* Styles applied to the root element if `direction="column"`. */
      'direction-xs-column': {
        flexDirection: 'column'
      },

      /* Styles applied to the root element if `direction="column-reverse"`. */
      'direction-xs-column-reverse': {
        flexDirection: 'column-reverse'
      },

      /* Styles applied to the root element if `direction="rwo-reverse"`. */
      'direction-xs-row-reverse': {
        flexDirection: 'row-reverse'
      },

      /* Styles applied to the root element if `wrap="nowrap"`. */
      'wrap-xs-nowrap': {
        flexWrap: 'nowrap'
      },

      /* Styles applied to the root element if `wrap="reverse"`. */
      'wrap-xs-wrap-reverse': {
        flexWrap: 'wrap-reverse'
      },

      /* Styles applied to the root element if `alignItems="center"`. */
      'align-items-xs-center': {
        alignItems: 'center'
      },

      /* Styles applied to the root element if `alignItems="flex-start"`. */
      'align-items-xs-flex-start': {
        alignItems: 'flex-start'
      },

      /* Styles applied to the root element if `alignItems="flex-end"`. */
      'align-items-xs-flex-end': {
        alignItems: 'flex-end'
      },

      /* Styles applied to the root element if `alignItems="baseline"`. */
      'align-items-xs-baseline': {
        alignItems: 'baseline'
      },

      /* Styles applied to the root element if `alignContent="center"`. */
      'align-content-xs-center': {
        alignContent: 'center'
      },

      /* Styles applied to the root element if `alignContent="flex-start"`. */
      'align-content-xs-flex-start': {
        alignContent: 'flex-start'
      },

      /* Styles applied to the root element if `alignContent="flex-end"`. */
      'align-content-xs-flex-end': {
        alignContent: 'flex-end'
      },

      /* Styles applied to the root element if `alignContent="space-between"`. */
      'align-content-xs-space-between': {
        alignContent: 'space-between'
      },

      /* Styles applied to the root element if `alignContent="space-around"`. */
      'align-content-xs-space-around': {
        alignContent: 'space-around'
      },

      /* Styles applied to the root element if `justify="center"`. */
      'justify-xs-center': {
        justifyContent: 'center'
      },

      /* Styles applied to the root element if `justify="flex-end"`. */
      'justify-xs-flex-end': {
        justifyContent: 'flex-end'
      },

      /* Styles applied to the root element if `justify="space-between"`. */
      'justify-xs-space-between': {
        justifyContent: 'space-between'
      },

      /* Styles applied to the root element if `justify="space-around"`. */
      'justify-xs-space-around': {
        justifyContent: 'space-around'
      },

      /* Styles applied to the root element if `justify="space-evenly"`. */
      'justify-xs-space-evenly': {
        justifyContent: 'space-evenly'
      }
    }, generateGutter(theme, 'xs'), {}, theme.breakpoints.keys.reduce(function (accumulator, key) {
      // Use side effect over immutability for better performance.
      generateGrid(accumulator, theme, key);
      return accumulator;
    }, {}));
  };
  var Grid = React__default.forwardRef(function (props, ref) {
    var _props$alignContent = props.alignContent,
        alignContent = _props$alignContent === void 0 ? 'stretch' : _props$alignContent,
        _props$alignItems = props.alignItems,
        alignItems = _props$alignItems === void 0 ? 'stretch' : _props$alignItems,
        classes = props.classes,
        classNameProp = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        _props$container = props.container,
        container = _props$container === void 0 ? false : _props$container,
        _props$direction = props.direction,
        direction = _props$direction === void 0 ? 'row' : _props$direction,
        _props$item = props.item,
        item = _props$item === void 0 ? false : _props$item,
        _props$justify = props.justify,
        justify = _props$justify === void 0 ? 'flex-start' : _props$justify,
        _props$lg = props.lg,
        lg = _props$lg === void 0 ? false : _props$lg,
        _props$md = props.md,
        md = _props$md === void 0 ? false : _props$md,
        _props$sm = props.sm,
        sm = _props$sm === void 0 ? false : _props$sm,
        _props$spacing = props.spacing,
        spacing = _props$spacing === void 0 ? 0 : _props$spacing,
        _props$wrap = props.wrap,
        wrap = _props$wrap === void 0 ? 'wrap' : _props$wrap,
        _props$xl = props.xl,
        xl = _props$xl === void 0 ? false : _props$xl,
        _props$xs = props.xs,
        xs = _props$xs === void 0 ? false : _props$xs,
        _props$zeroMinWidth = props.zeroMinWidth,
        zeroMinWidth = _props$zeroMinWidth === void 0 ? false : _props$zeroMinWidth,
        other = _objectWithoutProperties(props, ["alignContent", "alignItems", "classes", "className", "component", "container", "direction", "item", "justify", "lg", "md", "sm", "spacing", "wrap", "xl", "xs", "zeroMinWidth"]);

    var className = clsx(classes.root, classNameProp, container && [classes.container, spacing !== 0 && classes["spacing-xs-".concat(String(spacing))]], item && classes.item, zeroMinWidth && classes.zeroMinWidth, direction !== 'row' && classes["direction-xs-".concat(String(direction))], wrap !== 'wrap' && classes["wrap-xs-".concat(String(wrap))], alignItems !== 'stretch' && classes["align-items-xs-".concat(String(alignItems))], alignContent !== 'stretch' && classes["align-content-xs-".concat(String(alignContent))], justify !== 'flex-start' && classes["justify-xs-".concat(String(justify))], xs !== false && classes["grid-xs-".concat(String(xs))], sm !== false && classes["grid-sm-".concat(String(sm))], md !== false && classes["grid-md-".concat(String(md))], lg !== false && classes["grid-lg-".concat(String(lg))], xl !== false && classes["grid-xl-".concat(String(xl))]);
    return React__default.createElement(Component, _extends({
      className: className,
      ref: ref
    }, other));
  });

  {
    // can't use named function expression since the function body references `Grid`
    // which would point to the render function instead of the actual component
    Grid.displayName = 'ForwardRef(Grid)';
  }

   Grid.propTypes = {
    /**
     * Defines the `align-content` style property.
     * It's applied for all screen sizes.
     */
    alignContent: propTypes.oneOf(['stretch', 'center', 'flex-start', 'flex-end', 'space-between', 'space-around']),

    /**
     * Defines the `align-items` style property.
     * It's applied for all screen sizes.
     */
    alignItems: propTypes.oneOf(['flex-start', 'center', 'flex-end', 'stretch', 'baseline']),

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the component will have the flex *container* behavior.
     * You should be wrapping *items* with a *container*.
     */
    container: propTypes.bool,

    /**
     * Defines the `flex-direction` style property.
     * It is applied for all screen sizes.
     */
    direction: propTypes.oneOf(['row', 'row-reverse', 'column', 'column-reverse']),

    /**
     * If `true`, the component will have the flex *item* behavior.
     * You should be wrapping *items* with a *container*.
     */
    item: propTypes.bool,

    /**
     * Defines the `justify-content` style property.
     * It is applied for all screen sizes.
     */
    justify: propTypes.oneOf(['flex-start', 'center', 'flex-end', 'space-between', 'space-around', 'space-evenly']),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for the `lg` breakpoint and wider screens if not overridden.
     */
    lg: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for the `md` breakpoint and wider screens if not overridden.
     */
    md: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for the `sm` breakpoint and wider screens if not overridden.
     */
    sm: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * Defines the space between the type `item` component.
     * It can only be used on a type `container` component.
     */
    spacing: propTypes.oneOf(SPACINGS),

    /**
     * Defines the `flex-wrap` style property.
     * It's applied for all screen sizes.
     */
    wrap: propTypes.oneOf(['nowrap', 'wrap', 'wrap-reverse']),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for the `xl` breakpoint and wider screens.
     */
    xl: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for all the screen sizes with the lowest priority.
     */
    xs: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * If `true`, it sets `min-width: 0` on the item.
     * Refer to the limitations section of the documentation to better understand the use case.
     */
    zeroMinWidth: propTypes.bool
  } ;
  var StyledGrid = withStyles$1(styles$Q, {
    name: 'MuiGrid'
  })(Grid);

  {
    var requireProp = requirePropFactory('Grid');
    StyledGrid.propTypes = _extends({}, StyledGrid.propTypes, {
      alignContent: requireProp('container'),
      alignItems: requireProp('container'),
      direction: requireProp('container'),
      justify: requireProp('container'),
      lg: requireProp('item'),
      md: requireProp('item'),
      sm: requireProp('item'),
      spacing: requireProp('container'),
      wrap: requireProp('container'),
      xs: requireProp('item'),
      zeroMinWidth: requireProp('item')
    });
  }

  var styles$R = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      flexWrap: 'wrap',
      overflowY: 'auto',
      listStyle: 'none',
      padding: 0,
      WebkitOverflowScrolling: 'touch' // Add iOS momentum scrolling.

    }
  };
  var GridList = React__default.forwardRef(function GridList(props, ref) {
    var _props$cellHeight = props.cellHeight,
        cellHeight = _props$cellHeight === void 0 ? 180 : _props$cellHeight,
        children = props.children,
        classes = props.classes,
        className = props.className,
        _props$cols = props.cols,
        cols = _props$cols === void 0 ? 2 : _props$cols,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'ul' : _props$component,
        _props$spacing = props.spacing,
        spacing = _props$spacing === void 0 ? 4 : _props$spacing,
        style = props.style,
        other = _objectWithoutProperties(props, ["cellHeight", "children", "classes", "className", "cols", "component", "spacing", "style"]);

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className),
      ref: ref,
      style: _extends({
        margin: -spacing / 2
      }, style)
    }, other), React__default.Children.map(children, function (child) {
      if (!React__default.isValidElement(child)) {
        return null;
      }

      {
        if (child.type === React__default.Fragment) {
          console.error(["Material-UI: the GridList component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      var childCols = child.props.cols || 1;
      var childRows = child.props.rows || 1;
      return React__default.cloneElement(child, {
        style: _extends({
          width: "".concat(100 / cols * childCols, "%"),
          height: cellHeight === 'auto' ? 'auto' : cellHeight * childRows + spacing,
          padding: spacing / 2
        }, child.props.style)
      });
    }));
  });
   GridList.propTypes = {
    /**
     * Number of px for one cell height.
     * You can set `'auto'` if you want to let the children determine the height.
     */
    cellHeight: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['auto'])]),

    /**
     * Grid Tiles that will be in Grid List.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Number of columns.
     */
    cols: propTypes.number,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Number of px for the spacing between tiles.
     */
    spacing: propTypes.number,

    /**
     * @ignore
     */
    style: propTypes.object
  } ;
  var GridList$1 = withStyles$1(styles$R, {
    name: 'MuiGridList'
  })(GridList);

  var styles$S = {
    /* Styles applied to the root element. */
    root: {
      boxSizing: 'border-box',
      flexShrink: 0
    },

    /* Styles applied to the `div` element that wraps the children. */
    tile: {
      position: 'relative',
      display: 'block',
      // In case it's not rendered with a div.
      height: '100%',
      overflow: 'hidden'
    },

    /* Styles applied to an `img` element child, if needed to ensure it covers the tile. */
    imgFullHeight: {
      height: '100%',
      transform: 'translateX(-50%)',
      position: 'relative',
      left: '50%'
    },

    /* Styles applied to an `img` element child, if needed to ensure it covers the tile. */
    imgFullWidth: {
      width: '100%',
      position: 'relative',
      transform: 'translateY(-50%)',
      top: '50%'
    }
  };

  var fit = function fit(imgEl, classes) {
    if (!imgEl || !imgEl.complete) {
      return;
    }

    if (imgEl.width / imgEl.height > imgEl.parentElement.offsetWidth / imgEl.parentElement.offsetHeight) {
      var _imgEl$classList, _imgEl$classList2;

      (_imgEl$classList = imgEl.classList).remove.apply(_imgEl$classList, _toConsumableArray(classes.imgFullWidth.split(' ')));

      (_imgEl$classList2 = imgEl.classList).add.apply(_imgEl$classList2, _toConsumableArray(classes.imgFullHeight.split(' ')));
    } else {
      var _imgEl$classList3, _imgEl$classList4;

      (_imgEl$classList3 = imgEl.classList).remove.apply(_imgEl$classList3, _toConsumableArray(classes.imgFullHeight.split(' ')));

      (_imgEl$classList4 = imgEl.classList).add.apply(_imgEl$classList4, _toConsumableArray(classes.imgFullWidth.split(' ')));
    }
  };

  function ensureImageCover(imgEl, classes) {
    if (!imgEl) {
      return;
    }

    if (imgEl.complete) {
      fit(imgEl, classes);
    } else {
      imgEl.addEventListener('load', function () {
        fit(imgEl, classes);
      });
    }
  }

  var GridListTile = React__default.forwardRef(function GridListTile(props, ref) {
    // cols rows default values are for docs only
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$cols = props.cols,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'li' : _props$component,
        _props$rows = props.rows,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "cols", "component", "rows"]);

    var imgRef = React__default.useRef(null);
    React__default.useEffect(function () {
      ensureImageCover(imgRef.current, classes);
    });
    React__default.useEffect(function () {
      var handleResize = debounce(function () {
        fit(imgRef.current, classes);
      });
      window.addEventListener('resize', handleResize);
      return function () {
        handleResize.clear();
        window.removeEventListener('resize', handleResize);
      };
    }, [classes]);
    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className),
      ref: ref
    }, other), React__default.createElement("div", {
      className: classes.tile
    }, React__default.Children.map(children, function (child) {
      if (!React__default.isValidElement(child)) {
        return null;
      }

      if (child.type === 'img' || isMuiElement(child, ['Image'])) {
        return React__default.cloneElement(child, {
          ref: imgRef
        });
      }

      return child;
    })));
  });
   GridListTile.propTypes = {
    /**
     * Theoretically you can pass any node as children, but the main use case is to pass an img,
     * in which case GridListTile takes care of making the image "cover" available space
     * (similar to `background-size: cover` or to `object-fit: cover`).
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Width of the tile in number of grid cells.
     */
    cols: propTypes.number,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Height of the tile in number of grid cells.
     */
    rows: propTypes.number
  } ;
  var GridListTile$1 = withStyles$1(styles$S, {
    name: 'MuiGridListTile'
  })(GridListTile);

  var styles$T = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'absolute',
        left: 0,
        right: 0,
        height: 48,
        background: 'rgba(0, 0, 0, 0.5)',
        display: 'flex',
        alignItems: 'center',
        fontFamily: theme.typography.fontFamily
      },

      /* Styles applied to the root element if `titlePosition="bottom"`. */
      titlePositionBottom: {
        bottom: 0
      },

      /* Styles applied to the root element if `titlePosition="top"`. */
      titlePositionTop: {
        top: 0
      },

      /* Styles applied to the root element if a `subtitle` is provided. */
      rootSubtitle: {
        height: 68
      },

      /* Styles applied to the title and subtitle container element. */
      titleWrap: {
        flexGrow: 1,
        marginLeft: 16,
        marginRight: 16,
        color: theme.palette.common.white,
        overflow: 'hidden'
      },

      /* Styles applied to the container element if `actionPosition="left"`. */
      titleWrapActionPosLeft: {
        marginLeft: 0
      },

      /* Styles applied to the container element if `actionPosition="right"`. */
      titleWrapActionPosRight: {
        marginRight: 0
      },

      /* Styles applied to the title container element. */
      title: {
        fontSize: theme.typography.pxToRem(16),
        lineHeight: '24px',
        textOverflow: 'ellipsis',
        overflow: 'hidden',
        whiteSpace: 'nowrap'
      },

      /* Styles applied to the subtitle container element. */
      subtitle: {
        fontSize: theme.typography.pxToRem(12),
        lineHeight: 1,
        textOverflow: 'ellipsis',
        overflow: 'hidden',
        whiteSpace: 'nowrap'
      },

      /* Styles applied to the actionIcon if supplied. */
      actionIcon: {},

      /* Styles applied to the actionIcon if `actionPosition="left"`. */
      actionIconActionPosLeft: {
        order: -1
      }
    };
  };
  var GridListTileBar = React__default.forwardRef(function GridListTileBar(props, ref) {
    var actionIcon = props.actionIcon,
        _props$actionPosition = props.actionPosition,
        actionPosition = _props$actionPosition === void 0 ? 'right' : _props$actionPosition,
        classes = props.classes,
        className = props.className,
        subtitle = props.subtitle,
        title = props.title,
        _props$titlePosition = props.titlePosition,
        titlePosition = _props$titlePosition === void 0 ? 'bottom' : _props$titlePosition,
        other = _objectWithoutProperties(props, ["actionIcon", "actionPosition", "classes", "className", "subtitle", "title", "titlePosition"]);

    var actionPos = actionIcon && actionPosition;
    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, titlePosition === 'top' ? classes.titlePositionTop : classes.titlePositionBottom, subtitle && classes.rootSubtitle),
      ref: ref
    }, other), React__default.createElement("div", {
      className: clsx(classes.titleWrap, {
        left: classes.titleWrapActionPosLeft,
        right: classes.titleWrapActionPosRight
      }[actionPos])
    }, React__default.createElement("div", {
      className: classes.title
    }, title), subtitle ? React__default.createElement("div", {
      className: classes.subtitle
    }, subtitle) : null), actionIcon ? React__default.createElement("div", {
      className: clsx(classes.actionIcon, {
        left: classes.actionIconActionPosLeft
      }[actionPos])
    }, actionIcon) : null);
  });
   GridListTileBar.propTypes = {
    /**
     * An IconButton element to be used as secondary action target
     * (primary action target is the tile itself).
     */
    actionIcon: propTypes.node,

    /**
     * Position of secondary action IconButton.
     */
    actionPosition: propTypes.oneOf(['left', 'right']),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * String or element serving as subtitle (support text).
     */
    subtitle: propTypes.node,

    /**
     * Title to be displayed on tile.
     */
    title: propTypes.node,

    /**
     * Position of the title bar.
     */
    titlePosition: propTypes.oneOf(['top', 'bottom'])
  } ;
  var GridListTileBar$1 = withStyles$1(styles$T, {
    name: 'MuiGridListTileBar'
  })(GridListTileBar);

  function getScale(value) {
    return "scale(".concat(value, ", ").concat(Math.pow(value, 2), ")");
  }

  var styles$U = {
    entering: {
      opacity: 1,
      transform: getScale(1)
    },
    entered: {
      opacity: 1,
      transform: 'none'
    }
  };
  /**
   * The Grow transition is used by the [Tooltip](/components/tooltips/) and
   * [Popover](/components/popover/) components.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  var Grow = React__default.forwardRef(function Grow(props, ref) {
    var children = props.children,
        inProp = props.in,
        onEnter = props.onEnter,
        onExit = props.onExit,
        style = props.style,
        _props$timeout = props.timeout,
        timeout = _props$timeout === void 0 ? 'auto' : _props$timeout,
        other = _objectWithoutProperties(props, ["children", "in", "onEnter", "onExit", "style", "timeout"]);

    var timer = React__default.useRef();
    var autoTimeout = React__default.useRef();
    var handleRef = useForkRef(children.ref, ref);
    var theme = useTheme$1();

    var handleEnter = function handleEnter(node, isAppearing) {
      reflow(node); // So the animation always start from the start.

      var _getTransitionProps = getTransitionProps({
        style: style,
        timeout: timeout
      }, {
        mode: 'enter'
      }),
          transitionDuration = _getTransitionProps.duration,
          delay = _getTransitionProps.delay;

      var duration;

      if (timeout === 'auto') {
        duration = theme.transitions.getAutoHeightDuration(node.clientHeight);
        autoTimeout.current = duration;
      } else {
        duration = transitionDuration;
      }

      node.style.transition = [theme.transitions.create('opacity', {
        duration: duration,
        delay: delay
      }), theme.transitions.create('transform', {
        duration: duration * 0.666,
        delay: delay
      })].join(',');

      if (onEnter) {
        onEnter(node, isAppearing);
      }
    };

    var handleExit = function handleExit(node) {
      var _getTransitionProps2 = getTransitionProps({
        style: style,
        timeout: timeout
      }, {
        mode: 'exit'
      }),
          transitionDuration = _getTransitionProps2.duration,
          delay = _getTransitionProps2.delay;

      var duration;

      if (timeout === 'auto') {
        duration = theme.transitions.getAutoHeightDuration(node.clientHeight);
        autoTimeout.current = duration;
      } else {
        duration = transitionDuration;
      }

      node.style.transition = [theme.transitions.create('opacity', {
        duration: duration,
        delay: delay
      }), theme.transitions.create('transform', {
        duration: duration * 0.666,
        delay: delay || duration * 0.333
      })].join(',');
      node.style.opacity = '0';
      node.style.transform = getScale(0.75);

      if (onExit) {
        onExit(node);
      }
    };

    var addEndListener = function addEndListener(_, next) {
      if (timeout === 'auto') {
        timer.current = setTimeout(next, autoTimeout.current || 0);
      }
    };

    React__default.useEffect(function () {
      return function () {
        clearTimeout(timer.current);
      };
    }, []);
    return React__default.createElement(Transition, _extends({
      appear: true,
      in: inProp,
      onEnter: handleEnter,
      onExit: handleExit,
      addEndListener: addEndListener,
      timeout: timeout === 'auto' ? null : timeout
    }, other), function (state, childProps) {
      return React__default.cloneElement(children, _extends({
        style: _extends({
          opacity: 0,
          transform: getScale(0.75),
          visibility: state === 'exited' && !inProp ? 'hidden' : undefined
        }, styles$U[state], {}, style, {}, children.props.style),
        ref: handleRef
      }, childProps));
    });
  });
   Grow.propTypes = {
    /**
     * A single child content element.
     */
    children: propTypes.element,

    /**
     * If `true`, show the component; triggers the enter or exit animation.
     */
    in: propTypes.bool,

    /**
     * @ignore
     */
    onEnter: propTypes.func,

    /**
     * @ignore
     */
    onExit: propTypes.func,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     *
     * Set to 'auto' to automatically calculate transition time based on height.
     */
    timeout: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])])
  } ;
  Grow.muiSupportAuto = true;

  var hydrationCompleted = false;

  function useMediaQuery(queryInput) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var theme = useTheme();
    var props = getThemeProps({
      theme: theme,
      name: 'MuiUseMediaQuery',
      props: {}
    });

    {
      if (typeof queryInput === 'function' && theme === null) {
        console.error(['Material-UI: the `query` argument provided is invalid.', 'You are providing a function without a theme in the context.', 'One of the parent elements needs to use a ThemeProvider.'].join('\n'));
      }
    }

    var query = typeof queryInput === 'function' ? queryInput(theme) : queryInput;
    query = query.replace(/^@media( ?)/m, ''); // Wait for jsdom to support the match media feature.
    // All the browsers Material-UI support have this built-in.
    // This defensive check is here for simplicity.
    // Most of the time, the match media logic isn't central to people tests.

    var supportMatchMedia = typeof window !== 'undefined' && typeof window.matchMedia !== 'undefined';

    var _props$options = _extends({}, props, {}, options),
        _props$options$defaul = _props$options.defaultMatches,
        defaultMatches = _props$options$defaul === void 0 ? false : _props$options$defaul,
        _props$options$noSsr = _props$options.noSsr,
        noSsr = _props$options$noSsr === void 0 ? false : _props$options$noSsr,
        _props$options$ssrMat = _props$options.ssrMatchMedia,
        ssrMatchMedia = _props$options$ssrMat === void 0 ? null : _props$options$ssrMat;

    var _React$useState = React__default.useState(function () {
      if ((hydrationCompleted || noSsr) && supportMatchMedia) {
        return window.matchMedia(query).matches;
      }

      if (ssrMatchMedia) {
        return ssrMatchMedia(query).matches;
      } // Once the component is mounted, we rely on the
      // event listeners to return the correct matches value.


      return defaultMatches;
    }),
        match = _React$useState[0],
        setMatch = _React$useState[1];

    React__default.useEffect(function () {
      var active = true;
      hydrationCompleted = true;

      if (!supportMatchMedia) {
        return undefined;
      }

      var queryList = window.matchMedia(query);

      var updateMatch = function updateMatch() {
        // Workaround Safari wrong implementation of matchMedia
        // TODO can we remove it?
        // https://github.com/mui-org/material-ui/pull/17315#issuecomment-528286677
        if (active) {
          setMatch(queryList.matches);
        }
      };

      updateMatch();
      queryList.addListener(updateMatch);
      return function () {
        active = false;
        queryList.removeListener(updateMatch);
      };
    }, [query, supportMatchMedia]);
    return match;
  }

  var isWidthUp = function isWidthUp(breakpoint, width) {
    var inclusive = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

    if (inclusive) {
      return keys.indexOf(breakpoint) <= keys.indexOf(width);
    }

    return keys.indexOf(breakpoint) < keys.indexOf(width);
  }; // By default, returns true if screen width is the same or less than the given breakpoint.

  var isWidthDown = function isWidthDown(breakpoint, width) {
    var inclusive = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

    if (inclusive) {
      return keys.indexOf(width) <= keys.indexOf(breakpoint);
    }

    return keys.indexOf(width) < keys.indexOf(breakpoint);
  };
  var useEnhancedEffect$6 = typeof window === 'undefined' ? React__default.useEffect : React__default.useLayoutEffect;

  var withWidth = function withWidth() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return function (Component) {
      var _options$withTheme = options.withTheme,
          withThemeOption = _options$withTheme === void 0 ? false : _options$withTheme,
          _options$noSSR = options.noSSR,
          noSSR = _options$noSSR === void 0 ? false : _options$noSSR,
          initialWidthOption = options.initialWidth;

      function WithWidth(props) {
        var contextTheme = useTheme$1();
        var theme = props.theme || contextTheme;

        var _getThemeProps = getThemeProps({
          theme: theme,
          name: 'MuiWithWidth',
          props: _extends({}, props)
        }),
            initialWidth = _getThemeProps.initialWidth,
            width = _getThemeProps.width,
            other = _objectWithoutProperties(_getThemeProps, ["initialWidth", "width"]);

        var _React$useState = React__default.useState(false),
            mountedState = _React$useState[0],
            setMountedState = _React$useState[1];

        useEnhancedEffect$6(function () {
          setMountedState(true);
        }, []);
        /**
         * innerWidth |xs      sm      md      lg      xl
         *            |-------|-------|-------|-------|------>
         * width      |  xs   |  sm   |  md   |  lg   |  xl
         */

        var keys = _toConsumableArray(theme.breakpoints.keys).reverse();

        var widthComputed = keys.reduce(function (output, key) {
          // eslint-disable-next-line react-hooks/rules-of-hooks
          var matches = useMediaQuery(theme.breakpoints.up(key));
          return !output && matches ? key : output;
        }, null);

        var more = _extends({
          width: width || (mountedState || noSSR ? widthComputed : undefined) || initialWidth || initialWidthOption
        }, withThemeOption ? {
          theme: theme
        } : {}, {}, other); // When rendering the component on the server,
        // we have no idea about the client browser screen width.
        // In order to prevent blinks and help the reconciliation of the React tree
        // we are not rendering the child component.
        //
        // An alternative is to use the `initialWidth` property.


        if (more.width === undefined) {
          return null;
        }

        return React__default.createElement(Component, more);
      }

       WithWidth.propTypes = {
        /**
         * As `window.innerWidth` is unavailable on the server,
         * we default to rendering an empty component during the first mount.
         * You might want to use an heuristic to approximate
         * the screen width of the client browser screen width.
         *
         * For instance, you could be using the user-agent or the client-hints.
         * https://caniuse.com/#search=client%20hint
         */
        initialWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']),

        /**
         * @ignore
         */
        theme: propTypes.object,

        /**
         * Bypass the width calculation logic.
         */
        width: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl'])
      } ;

      {
        WithWidth.displayName = "WithWidth(".concat(getDisplayName(Component), ")");
      }

      hoistNonReactStatics_cjs(WithWidth, Component);
      return WithWidth;
    };
  };

  /**
   * @ignore - internal component.
   */

  function HiddenJs(props) {
    var children = props.children,
        only = props.only,
        width = props.width;
    var theme = useTheme$1();
    var visible = true; // `only` check is faster to get out sooner if used.

    if (only) {
      if (Array.isArray(only)) {
        for (var i = 0; i < only.length; i += 1) {
          var breakpoint = only[i];

          if (width === breakpoint) {
            visible = false;
            break;
          }
        }
      } else if (only && width === only) {
        visible = false;
      }
    } // Allow `only` to be combined with other props. If already hidden, no need to check others.


    if (visible) {
      // determine visibility based on the smallest size up
      for (var _i = 0; _i < theme.breakpoints.keys.length; _i += 1) {
        var _breakpoint = theme.breakpoints.keys[_i];
        var breakpointUp = props["".concat(_breakpoint, "Up")];
        var breakpointDown = props["".concat(_breakpoint, "Down")];

        if (breakpointUp && isWidthUp(_breakpoint, width) || breakpointDown && isWidthDown(_breakpoint, width)) {
          visible = false;
          break;
        }
      }
    }

    if (!visible) {
      return null;
    }

    return children;
  }

  HiddenJs.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Specify which implementation to use.  'js' is the default, 'css' works better for
     * server-side rendering.
     */
    implementation: propTypes.oneOf(['js', 'css']),

    /**
     * You can use this prop when choosing the `js` implementation with server-side rendering.
     *
     * As `window.innerWidth` is unavailable on the server,
     * we default to rendering an empty component during the first mount.
     * You might want to use an heuristic to approximate
     * the screen width of the client browser screen width.
     *
     * For instance, you could be using the user-agent or the client-hints.
     * https://caniuse.com/#search=client%20hint
     */
    initialWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']),

    /**
     * If true, screens this size and down will be hidden.
     */
    lgDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    lgUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    mdDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    mdUp: propTypes.bool,

    /**
     * Hide the given breakpoint(s).
     */
    only: propTypes.oneOfType([propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']), propTypes.arrayOf(propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']))]),

    /**
     * If true, screens this size and down will be hidden.
     */
    smDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    smUp: propTypes.bool,

    /**
     * @ignore
     * width prop provided by withWidth decorator.
     */
    width: propTypes.string.isRequired,

    /**
     * If true, screens this size and down will be hidden.
     */
    xlDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xlUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xsDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xsUp: propTypes.bool
  };

  {
    HiddenJs.propTypes = exactProp(HiddenJs.propTypes);
  }

  var HiddenJs$1 = withWidth()(HiddenJs);

  var styles$V = function styles(theme) {
    var hidden = {
      display: 'none'
    };
    return theme.breakpoints.keys.reduce(function (acc, key) {
      acc["only".concat(capitalize(key))] = _defineProperty({}, theme.breakpoints.only(key), hidden);
      acc["".concat(key, "Up")] = _defineProperty({}, theme.breakpoints.up(key), hidden);
      acc["".concat(key, "Down")] = _defineProperty({}, theme.breakpoints.down(key), hidden);
      return acc;
    }, {});
  };
  /**
   * @ignore - internal component.
   */


  function HiddenCss(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        lgDown = props.lgDown,
        lgUp = props.lgUp,
        mdDown = props.mdDown,
        mdUp = props.mdUp,
        only = props.only,
        smDown = props.smDown,
        smUp = props.smUp,
        xlDown = props.xlDown,
        xlUp = props.xlUp,
        xsDown = props.xsDown,
        xsUp = props.xsUp,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "lgDown", "lgUp", "mdDown", "mdUp", "only", "smDown", "smUp", "xlDown", "xlUp", "xsDown", "xsUp"]);

    var theme = useTheme$1();

    {
      if (Object.keys(other).length !== 0 && !(Object.keys(other).length === 1 && other.hasOwnProperty('ref'))) {
        console.error("Material-UI: unsupported props received ".concat(Object.keys(other).join(', '), " by `<Hidden />`."));
      }
    }

    var clsx = [];

    if (className) {
      clsx.push(className);
    }

    for (var i = 0; i < theme.breakpoints.keys.length; i += 1) {
      var breakpoint = theme.breakpoints.keys[i];
      var breakpointUp = props["".concat(breakpoint, "Up")];
      var breakpointDown = props["".concat(breakpoint, "Down")];

      if (breakpointUp) {
        clsx.push(classes["".concat(breakpoint, "Up")]);
      }

      if (breakpointDown) {
        clsx.push(classes["".concat(breakpoint, "Down")]);
      }
    }

    if (only) {
      var onlyBreakpoints = Array.isArray(only) ? only : [only];
      onlyBreakpoints.forEach(function (breakpoint) {
        clsx.push(classes["only".concat(capitalize(breakpoint))]);
      });
    }

    return React__default.createElement("div", {
      className: clsx.join(' ')
    }, children);
  }

   HiddenCss.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Specify which implementation to use.  'js' is the default, 'css' works better for
     * server-side rendering.
     */
    implementation: propTypes.oneOf(['js', 'css']),

    /**
     * If true, screens this size and down will be hidden.
     */
    lgDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    lgUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    mdDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    mdUp: propTypes.bool,

    /**
     * Hide the given breakpoint(s).
     */
    only: propTypes.oneOfType([propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']), propTypes.arrayOf(propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']))]),

    /**
     * If true, screens this size and down will be hidden.
     */
    smDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    smUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xlDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xlUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xsDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xsUp: propTypes.bool
  } ;
  var HiddenCss$1 = withStyles$1(styles$V, {
    name: 'PrivateHiddenCss'
  })(HiddenCss);

  /**
   * Responsively hides children based on the selected implementation.
   */

  function Hidden(props) {
    var _props$implementation = props.implementation,
        implementation = _props$implementation === void 0 ? 'js' : _props$implementation,
        _props$lgDown = props.lgDown,
        lgDown = _props$lgDown === void 0 ? false : _props$lgDown,
        _props$lgUp = props.lgUp,
        lgUp = _props$lgUp === void 0 ? false : _props$lgUp,
        _props$mdDown = props.mdDown,
        mdDown = _props$mdDown === void 0 ? false : _props$mdDown,
        _props$mdUp = props.mdUp,
        mdUp = _props$mdUp === void 0 ? false : _props$mdUp,
        _props$smDown = props.smDown,
        smDown = _props$smDown === void 0 ? false : _props$smDown,
        _props$smUp = props.smUp,
        smUp = _props$smUp === void 0 ? false : _props$smUp,
        _props$xlDown = props.xlDown,
        xlDown = _props$xlDown === void 0 ? false : _props$xlDown,
        _props$xlUp = props.xlUp,
        xlUp = _props$xlUp === void 0 ? false : _props$xlUp,
        _props$xsDown = props.xsDown,
        xsDown = _props$xsDown === void 0 ? false : _props$xsDown,
        _props$xsUp = props.xsUp,
        xsUp = _props$xsUp === void 0 ? false : _props$xsUp,
        other = _objectWithoutProperties(props, ["implementation", "lgDown", "lgUp", "mdDown", "mdUp", "smDown", "smUp", "xlDown", "xlUp", "xsDown", "xsUp"]);

    if (implementation === 'js') {
      return React__default.createElement(HiddenJs$1, _extends({
        lgDown: lgDown,
        lgUp: lgUp,
        mdDown: mdDown,
        mdUp: mdUp,
        smDown: smDown,
        smUp: smUp,
        xlDown: xlDown,
        xlUp: xlUp,
        xsDown: xsDown,
        xsUp: xsUp
      }, other));
    }

    return React__default.createElement(HiddenCss$1, _extends({
      lgDown: lgDown,
      lgUp: lgUp,
      mdDown: mdDown,
      mdUp: mdUp,
      smDown: smDown,
      smUp: smUp,
      xlDown: xlDown,
      xlUp: xlUp,
      xsDown: xsDown,
      xsUp: xsUp
    }, other));
  }

   Hidden.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Specify which implementation to use.  'js' is the default, 'css' works better for
     * server-side rendering.
     */
    implementation: propTypes.oneOf(['js', 'css']),

    /**
     * You can use this prop when choosing the `js` implementation with server-side rendering.
     *
     * As `window.innerWidth` is unavailable on the server,
     * we default to rendering an empty component during the first mount.
     * You might want to use an heuristic to approximate
     * the screen width of the client browser screen width.
     *
     * For instance, you could be using the user-agent or the client-hints.
     * https://caniuse.com/#search=client%20hint
     */
    initialWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']),

    /**
     * If true, screens this size and down will be hidden.
     */
    lgDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    lgUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    mdDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    mdUp: propTypes.bool,

    /**
     * Hide the given breakpoint(s).
     */
    only: propTypes.oneOfType([propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']), propTypes.arrayOf(propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']))]),

    /**
     * If true, screens this size and down will be hidden.
     */
    smDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    smUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xlDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xlUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xsDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xsUp: propTypes.bool
  } ;

  var styles$W = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        userSelect: 'none',
        fontSize: theme.typography.pxToRem(24),
        width: '1em',
        height: '1em',
        // Chrome fix for https://bugs.chromium.org/p/chromium/issues/detail?id=820541
        // To remove at some point.
        overflow: 'hidden',
        flexShrink: 0
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the root element if `color="action"`. */
      colorAction: {
        color: theme.palette.action.active
      },

      /* Styles applied to the root element if `color="error"`. */
      colorError: {
        color: theme.palette.error.main
      },

      /* Styles applied to the root element if `color="disabled"`. */
      colorDisabled: {
        color: theme.palette.action.disabled
      },
      fontSizeInherit: {
        fontSize: 'inherit'
      },

      /* Styles applied to the root element if `fontSize="small"`. */
      fontSizeSmall: {
        fontSize: theme.typography.pxToRem(20)
      },

      /* Styles applied to the root element if `fontSize="large"`. */
      fontSizeLarge: {
        fontSize: theme.typography.pxToRem(36)
      }
    };
  };
  var Icon = React__default.forwardRef(function Icon(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'inherit' : _props$color,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'span' : _props$component,
        _props$fontSize = props.fontSize,
        fontSize = _props$fontSize === void 0 ? 'default' : _props$fontSize,
        other = _objectWithoutProperties(props, ["classes", "className", "color", "component", "fontSize"]);

    return React__default.createElement(Component, _extends({
      className: clsx('material-icons', classes.root, className, color !== 'inherit' && classes["color".concat(capitalize(color))], fontSize !== 'default' && classes["fontSize".concat(capitalize(fontSize))]),
      "aria-hidden": true,
      ref: ref
    }, other));
  });
   Icon.propTypes = {
    /**
     * The name of the icon font ligature.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['inherit', 'primary', 'secondary', 'action', 'error', 'disabled']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * The fontSize applied to the icon. Defaults to 24px, but can be configure to inherit font size.
     */
    fontSize: propTypes.oneOf(['inherit', 'default', 'small', 'large'])
  } ;
  Icon.muiName = 'Icon';
  var Icon$1 = withStyles$1(styles$W, {
    name: 'MuiIcon'
  })(Icon);

  var styles$X = function styles(theme) {
    var light = theme.palette.type === 'light';
    var bottomLineColor = light ? 'rgba(0, 0, 0, 0.42)' : 'rgba(255, 255, 255, 0.7)';
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative'
      },

      /* Styles applied to the root element if the component is a descendant of `FormControl`. */
      formControl: {
        'label + &': {
          marginTop: 16
        }
      },

      /* Styles applied to the root element if the component is focused. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if color secondary. */
      colorSecondary: {
        '&$underline:after': {
          borderBottomColor: theme.palette.secondary.main
        }
      },

      /* Styles applied to the root element if `disableUnderline={false}`. */
      underline: {
        '&:after': {
          borderBottom: "2px solid ".concat(theme.palette.primary.main),
          left: 0,
          bottom: 0,
          // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
          content: '""',
          position: 'absolute',
          right: 0,
          transform: 'scaleX(0)',
          transition: theme.transitions.create('transform', {
            duration: theme.transitions.duration.shorter,
            easing: theme.transitions.easing.easeOut
          }),
          pointerEvents: 'none' // Transparent to the hover style.

        },
        '&$focused:after': {
          transform: 'scaleX(1)'
        },
        '&$error:after': {
          borderBottomColor: theme.palette.error.main,
          transform: 'scaleX(1)' // error is always underlined in red

        },
        '&:before': {
          borderBottom: "1px solid ".concat(bottomLineColor),
          left: 0,
          bottom: 0,
          // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
          content: '"\\00a0"',
          position: 'absolute',
          right: 0,
          transition: theme.transitions.create('border-bottom-color', {
            duration: theme.transitions.duration.shorter
          }),
          pointerEvents: 'none' // Transparent to the hover style.

        },
        '&:hover:not($disabled):before': {
          borderBottom: "2px solid ".concat(theme.palette.text.primary),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            borderBottom: "1px solid ".concat(bottomLineColor)
          }
        },
        '&$disabled:before': {
          borderBottomStyle: 'dotted'
        }
      },

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the root element if `multiline={true}`. */
      multiline: {},

      /* Styles applied to the root element if `fullWidth={true}`. */
      fullWidth: {},

      /* Styles applied to the `input` element. */
      input: {},

      /* Styles applied to the `input` element if `margin="dense"`. */
      inputMarginDense: {},

      /* Styles applied to the `input` element if `multiline={true}`. */
      inputMultiline: {},

      /* Styles applied to the `input` element if `type="search"`. */
      inputTypeSearch: {}
    };
  };
  var Input = React__default.forwardRef(function Input(props, ref) {
    var disableUnderline = props.disableUnderline,
        classes = props.classes,
        _props$fullWidth = props.fullWidth,
        fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
        _props$inputComponent = props.inputComponent,
        inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
        _props$multiline = props.multiline,
        multiline = _props$multiline === void 0 ? false : _props$multiline,
        _props$type = props.type,
        type = _props$type === void 0 ? 'text' : _props$type,
        other = _objectWithoutProperties(props, ["disableUnderline", "classes", "fullWidth", "inputComponent", "multiline", "type"]);

    return React__default.createElement(InputBase$1, _extends({
      classes: _extends({}, classes, {
        root: clsx(classes.root, !disableUnderline && classes.underline),
        underline: null
      }),
      fullWidth: fullWidth,
      inputComponent: inputComponent,
      multiline: multiline,
      ref: ref,
      type: type
    }, other));
  });
   Input.propTypes = {
    /**
     * This prop helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
     */
    autoComplete: propTypes.string,

    /**
     * If `true`, the `input` element will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the wrapper element.
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The default `input` element value. Use when the component is not controlled.
     */
    defaultValue: propTypes.any,

    /**
     * If `true`, the `input` element will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the input will not have an underline.
     */
    disableUnderline: propTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: propTypes.node,

    /**
     * If `true`, the input will indicate an error. This is normally obtained via context from
     * FormControl.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * The component used for the native input.
     * Either a string to use a DOM element or a component.
     */
    inputComponent: propTypes.elementType,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense', 'none']),

    /**
     * If `true`, a textarea element will be rendered.
     */
    multiline: propTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * Callback fired when the value is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: propTypes.func,

    /**
     * The short hint displayed in the input before the user enters a value.
     */
    placeholder: propTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * If `true`, the `input` element will be required.
     */
    required: propTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: propTypes.node,

    /**
     * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
     */
    type: propTypes.string,

    /**
     * The value of the `input` element, required for a controlled component.
     */
    value: propTypes.any
  } ;
  Input.muiName = 'Input';
  var Input$1 = withStyles$1(styles$X, {
    name: 'MuiInput'
  })(Input);

  var styles$Y = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      height: '0.01em',
      // Fix IE 11 flexbox alignment. To remove at some point.
      maxHeight: '2em',
      alignItems: 'center'
    },

    /* Styles applied to the root element if `variant="filled"`. */
    filled: {
      '&$positionStart:not($hiddenLabel)': {
        marginTop: 16
      }
    },

    /* Styles applied to the root element if `position="start"`. */
    positionStart: {
      marginRight: 8
    },

    /* Styles applied to the root element if `position="end"`. */
    positionEnd: {
      marginLeft: 8
    },

    /* Styles applied to the root element if `disablePointerEvents=true`. */
    disablePointerEvents: {
      pointerEvents: 'none'
    },

    /* Styles applied if the adornment is used inside <FormControl hiddenLabel />. */
    hiddenLabel: {},

    /* Styles applied if the adornment is used inside <FormControl margin="dense" />. */
    marginDense: {}
  };
  var InputAdornment = React__default.forwardRef(function InputAdornment(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'div' : _props$component,
        _props$disablePointer = props.disablePointerEvents,
        disablePointerEvents = _props$disablePointer === void 0 ? false : _props$disablePointer,
        _props$disableTypogra = props.disableTypography,
        disableTypography = _props$disableTypogra === void 0 ? false : _props$disableTypogra,
        position = props.position,
        variantProp = props.variant,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "component", "disablePointerEvents", "disableTypography", "position", "variant"]);

    var muiFormControl = useFormControl() || {};
    var variant = variantProp;

    if (variantProp && muiFormControl.variant) {
      {
        if (variantProp === muiFormControl.variant) {
          console.error('Material-UI: The `InputAdornment` variant infers the variant prop ' + 'you do not have to provide one.');
        }
      }
    }

    if (muiFormControl && !variant) {
      variant = muiFormControl.variant;
    }

    return React__default.createElement(FormControlContext.Provider, {
      value: null
    }, React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, disablePointerEvents && classes.disablePointerEvents, muiFormControl.hiddenLabel && classes.hiddenLabel, {
        filled: classes.filled
      }[variant], {
        start: classes.positionStart,
        end: classes.positionEnd
      }[position], {
        dense: classes.marginDense
      }[muiFormControl.margin]),
      ref: ref
    }, other), typeof children === 'string' && !disableTypography ? React__default.createElement(Typography$1, {
      color: "textSecondary"
    }, children) : children));
  });
   InputAdornment.propTypes = {
    /**
     * The content of the component, normally an `IconButton` or string.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * Disable pointer events on the root.
     * This allows for the content of the adornment to focus the input on click.
     */
    disablePointerEvents: propTypes.bool,

    /**
     * If children is a string then disable wrapping in a Typography component.
     */
    disableTypography: propTypes.bool,

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /**
     * The position this adornment should appear relative to the `Input`.
     */
    position: propTypes.oneOf(['start', 'end']),

    /**
     * The variant to use.
     * Note: If you are using the `TextField` component or the `FormControl` component
     * you do not have to set this manually.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  } ;
  var InputAdornment$1 = withStyles$1(styles$Y, {
    name: 'MuiInputAdornment'
  })(InputAdornment);

  var styles$Z = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'block',
        transformOrigin: 'top left'
      },

      /* Pseudo-class applied to the root element if `focused={true}`. */
      focused: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Pseudo-class applied to the root element if `error={true}`. */
      error: {},

      /* Pseudo-class applied to the root element if `required={true}`. */
      required: {},

      /* Pseudo-class applied to the asterisk element. */
      asterisk: {},

      /* Styles applied to the root element if the component is a descendant of `FormControl`. */
      formControl: {
        position: 'absolute',
        left: 0,
        top: 0,
        // slight alteration to spec spacing to match visual spec result
        transform: 'translate(0, 24px) scale(1)'
      },

      /* Styles applied to the root element if `margin="dense"`. */
      marginDense: {
        // Compensation for the `Input.inputDense` style.
        transform: 'translate(0, 21px) scale(1)'
      },

      /* Styles applied to the `input` element if `shrink={true}`. */
      shrink: {
        transform: 'translate(0, 1.5px) scale(0.75)',
        transformOrigin: 'top left'
      },

      /* Styles applied to the `input` element if `disableAnimation={false}`. */
      animated: {
        transition: theme.transitions.create(['color', 'transform'], {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        })
      },

      /* Styles applied to the root element if `variant="filled"`. */
      filled: {
        // Chrome's autofill feature gives the input field a yellow background.
        // Since the input field is behind the label in the HTML tree,
        // the input field is drawn last and hides the label with an opaque background color.
        // zIndex: 1 will raise the label above opaque background-colors of input.
        zIndex: 1,
        pointerEvents: 'none',
        transform: 'translate(12px, 20px) scale(1)',
        '&$marginDense': {
          transform: 'translate(12px, 17px) scale(1)'
        },
        '&$shrink': {
          transform: 'translate(12px, 10px) scale(0.75)',
          '&$marginDense': {
            transform: 'translate(12px, 7px) scale(0.75)'
          }
        }
      },

      /* Styles applied to the root element if `variant="outlined"`. */
      outlined: {
        // see comment above on filled.zIndex
        zIndex: 1,
        pointerEvents: 'none',
        transform: 'translate(14px, 20px) scale(1)',
        '&$marginDense': {
          transform: 'translate(14px, 12px) scale(1)'
        },
        '&$shrink': {
          transform: 'translate(14px, -6px) scale(0.75)'
        }
      }
    };
  };
  var InputLabel = React__default.forwardRef(function InputLabel(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$disableAnimati = props.disableAnimation,
        disableAnimation = _props$disableAnimati === void 0 ? false : _props$disableAnimati,
        margin = props.margin,
        shrinkProp = props.shrink,
        variant = props.variant,
        other = _objectWithoutProperties(props, ["classes", "className", "disableAnimation", "margin", "shrink", "variant"]);

    var muiFormControl = useFormControl$1();
    var shrink = shrinkProp;

    if (typeof shrink === 'undefined' && muiFormControl) {
      shrink = muiFormControl.filled || muiFormControl.focused || muiFormControl.adornedStart;
    }

    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['margin', 'variant']
    });
    return React__default.createElement(FormLabel$1, _extends({
      "data-shrink": shrink,
      className: clsx(classes.root, className, muiFormControl && classes.formControl, !disableAnimation && classes.animated, shrink && classes.shrink, {
        dense: classes.marginDense
      }[fcs.margin], {
        filled: classes.filled,
        outlined: classes.outlined
      }[fcs.variant]),
      classes: {
        focused: classes.focused,
        disabled: classes.disabled,
        error: classes.error,
        required: classes.required,
        asterisk: classes.asterisk
      },
      ref: ref
    }, other));
  });
   InputLabel.propTypes = {
    /**
     * The contents of the `InputLabel`.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * If `true`, the transition animation is disabled.
     */
    disableAnimation: propTypes.bool,

    /**
     * If `true`, apply disabled class.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the label will be displayed in an error state.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input of this label is focused.
     */
    focused: propTypes.bool,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense']),

    /**
     * if `true`, the label will indicate that the input is required.
     */
    required: propTypes.bool,

    /**
     * If `true`, the label is shrunk.
     */
    shrink: propTypes.bool,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  } ;
  var InputLabel$1 = withStyles$1(styles$Z, {
    name: 'MuiInputLabel'
  })(InputLabel);

  var TRANSITION_DURATION = 4; // seconds

  var styles$_ = function styles(theme) {
    var getColor = function getColor(color) {
      return theme.palette.type === 'light' ? lighten(color, 0.62) : darken(color, 0.5);
    };

    var backgroundPrimary = getColor(theme.palette.primary.main);
    var backgroundSecondary = getColor(theme.palette.secondary.main);
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        overflow: 'hidden',
        height: 4
      },

      /* Styles applied to the root and bar2 element if `color="primary"`; bar2 if `variant-"buffer"`. */
      colorPrimary: {
        backgroundColor: backgroundPrimary
      },

      /* Styles applied to the root and bar2 elements if `color="secondary"`; bar2 if `variant="buffer"`. */
      colorSecondary: {
        backgroundColor: backgroundSecondary
      },

      /* Styles applied to the root element if `variant="determinate"`. */
      determinate: {},

      /* Styles applied to the root element if `variant="indeterminate"`. */
      indeterminate: {},

      /* Styles applied to the root element if `variant="buffer"`. */
      buffer: {
        backgroundColor: 'transparent'
      },

      /* Styles applied to the root element if `variant="query"`. */
      query: {
        transform: 'rotate(180deg)'
      },

      /* Styles applied to the additional bar element if `variant="buffer"`. */
      dashed: {
        position: 'absolute',
        marginTop: 0,
        height: '100%',
        width: '100%',
        animation: '$buffer 3s infinite linear'
      },

      /* Styles applied to the additional bar element if `variant="buffer"` and `color="primary"`. */
      dashedColorPrimary: {
        backgroundImage: "radial-gradient(".concat(backgroundPrimary, " 0%, ").concat(backgroundPrimary, " 16%, transparent 42%)"),
        backgroundSize: '10px 10px',
        backgroundPosition: '0px -23px'
      },

      /* Styles applied to the additional bar element if `variant="buffer"` and `color="secondary"`. */
      dashedColorSecondary: {
        backgroundImage: "radial-gradient(".concat(backgroundSecondary, " 0%, ").concat(backgroundSecondary, " 16%, transparent 42%)"),
        backgroundSize: '10px 10px',
        backgroundPosition: '0px -23px'
      },

      /* Styles applied to the layered bar1 and bar2 elements. */
      bar: {
        width: '100%',
        position: 'absolute',
        left: 0,
        bottom: 0,
        top: 0,
        transition: 'transform 0.2s linear',
        transformOrigin: 'left'
      },

      /* Styles applied to the bar elements if `color="primary"`; bar2 if `variant` not "buffer". */
      barColorPrimary: {
        backgroundColor: theme.palette.primary.main
      },

      /* Styles applied to the bar elements if `color="secondary"`; bar2 if `variant` not "buffer". */
      barColorSecondary: {
        backgroundColor: theme.palette.secondary.main
      },

      /* Styles applied to the bar1 element if `variant="indeterminate or query"`. */
      bar1Indeterminate: {
        width: 'auto',
        animation: '$indeterminate1 2.1s cubic-bezier(0.65, 0.815, 0.735, 0.395) infinite'
      },

      /* Styles applied to the bar1 element if `variant="determinate"`. */
      bar1Determinate: {
        transition: "transform .".concat(TRANSITION_DURATION, "s linear")
      },

      /* Styles applied to the bar1 element if `variant="buffer"`. */
      bar1Buffer: {
        zIndex: 1,
        transition: "transform .".concat(TRANSITION_DURATION, "s linear")
      },

      /* Styles applied to the bar2 element if `variant="indeterminate or query"`. */
      bar2Indeterminate: {
        width: 'auto',
        animation: '$indeterminate2 2.1s cubic-bezier(0.165, 0.84, 0.44, 1) infinite',
        animationDelay: '1.15s'
      },

      /* Styles applied to the bar2 element if `variant="buffer"`. */
      bar2Buffer: {
        transition: "transform .".concat(TRANSITION_DURATION, "s linear")
      },
      // Legends:
      // || represents the viewport
      // -  represents a light background
      // x  represents a dark background
      '@keyframes indeterminate1': {
        //  |-----|---x-||-----||-----|
        '0%': {
          left: '-35%',
          right: '100%'
        },
        //  |-----|-----||-----||xxxx-|
        '60%': {
          left: '100%',
          right: '-90%'
        },
        '100%': {
          left: '100%',
          right: '-90%'
        }
      },
      '@keyframes indeterminate2': {
        //  |xxxxx|xxxxx||-----||-----|
        '0%': {
          left: '-200%',
          right: '100%'
        },
        //  |-----|-----||-----||-x----|
        '60%': {
          left: '107%',
          right: '-8%'
        },
        '100%': {
          left: '107%',
          right: '-8%'
        }
      },
      '@keyframes buffer': {
        '0%': {
          opacity: 1,
          backgroundPosition: '0px -23px'
        },
        '50%': {
          opacity: 0,
          backgroundPosition: '0px -23px'
        },
        '100%': {
          opacity: 1,
          backgroundPosition: '-200px -23px'
        }
      }
    };
  };
  /**
   * ## ARIA
   *
   * If the progress bar is describing the loading progress of a particular region of a page,
   * you should use `aria-describedby` to point to the progress bar, and set the `aria-busy`
   * attribute to `true` on that region until it has finished loading.
   */

  var LinearProgress = React__default.forwardRef(function LinearProgress(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'primary' : _props$color,
        value = props.value,
        valueBuffer = props.valueBuffer,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'indeterminate' : _props$variant,
        other = _objectWithoutProperties(props, ["classes", "className", "color", "value", "valueBuffer", "variant"]);

    var theme = useTheme$1();
    var rootProps = {};
    var inlineStyles = {
      bar1: {},
      bar2: {}
    };

    if (variant === 'determinate' || variant === 'buffer') {
      if (value !== undefined) {
        rootProps['aria-valuenow'] = Math.round(value);
        var transform = value - 100;

        if (theme.direction === 'rtl') {
          transform = -transform;
        }

        inlineStyles.bar1.transform = "translateX(".concat(transform, "%)");
      } else {
        console.error('Material-UI: you need to provide a value prop ' + 'when using the determinate or buffer variant of LinearProgress .');
      }
    }

    if (variant === 'buffer') {
      if (valueBuffer !== undefined) {
        var _transform = (valueBuffer || 0) - 100;

        if (theme.direction === 'rtl') {
          _transform = -_transform;
        }

        inlineStyles.bar2.transform = "translateX(".concat(_transform, "%)");
      } else {
        console.error('Material-UI: you need to provide a valueBuffer prop ' + 'when using the buffer variant of LinearProgress.');
      }
    }

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, classes["color".concat(capitalize(color))], className, {
        determinate: classes.determinate,
        indeterminate: classes.indeterminate,
        buffer: classes.buffer,
        query: classes.query
      }[variant]),
      role: "progressbar"
    }, rootProps, {
      ref: ref
    }, other), variant === 'buffer' ? React__default.createElement("div", {
      className: clsx(classes.dashed, classes["dashedColor".concat(capitalize(color))])
    }) : null, React__default.createElement("div", {
      className: clsx(classes.bar, classes["barColor".concat(capitalize(color))], (variant === 'indeterminate' || variant === 'query') && classes.bar1Indeterminate, {
        determinate: classes.bar1Determinate,
        buffer: classes.bar1Buffer
      }[variant]),
      style: inlineStyles.bar1
    }), variant === 'determinate' ? null : React__default.createElement("div", {
      className: clsx(classes.bar, (variant === 'indeterminate' || variant === 'query') && classes.bar2Indeterminate, variant === 'buffer' ? [classes["color".concat(capitalize(color))], classes.bar2Buffer] : classes["barColor".concat(capitalize(color))]),
      style: inlineStyles.bar2
    }));
  });
   LinearProgress.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The value of the progress indicator for the determinate and buffer variants.
     * Value between 0 and 100.
     */
    value: propTypes.number,

    /**
     * The value for the buffer variant.
     * Value between 0 and 100.
     */
    valueBuffer: propTypes.number,

    /**
     * The variant to use.
     * Use indeterminate or query when there is no progress value.
     */
    variant: propTypes.oneOf(['determinate', 'indeterminate', 'buffer', 'query'])
  } ;
  var LinearProgress$1 = withStyles$1(styles$_, {
    name: 'MuiLinearProgress'
  })(LinearProgress);

  var styles$$ = {
    /* Styles applied to the root element. */
    root: {},

    /* Styles applied to the root element if `underline="none"`. */
    underlineNone: {
      textDecoration: 'none'
    },

    /* Styles applied to the root element if `underline="hover"`. */
    underlineHover: {
      textDecoration: 'none',
      '&:hover': {
        textDecoration: 'underline'
      }
    },

    /* Styles applied to the root element if `underline="always"`. */
    underlineAlways: {
      textDecoration: 'underline'
    },
    // Same reset as ButtonBase.root

    /* Styles applied to the root element if `component="button"`. */
    button: {
      position: 'relative',
      // Remove grey highlight
      WebkitTapHighlightColor: 'transparent',
      backgroundColor: 'transparent',
      // Reset default value
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 0,
      border: 0,
      margin: 0,
      // Remove the margin in Safari
      borderRadius: 0,
      padding: 0,
      // Remove the padding in Firefox
      cursor: 'pointer',
      userSelect: 'none',
      verticalAlign: 'middle',
      '-moz-appearance': 'none',
      // Reset
      '-webkit-appearance': 'none',
      // Reset
      '&::-moz-focus-inner': {
        borderStyle: 'none' // Remove Firefox dotted outline.

      },
      '&$focusVisible': {
        outline: 'auto'
      }
    },

    /* Pseudo-class applied to the root element if the link is keyboard focused. */
    focusVisible: {}
  };
  var Link = React__default.forwardRef(function Link(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'primary' : _props$color,
        _props$component = props.component,
        component = _props$component === void 0 ? 'a' : _props$component,
        onBlur = props.onBlur,
        onFocus = props.onFocus,
        TypographyClasses = props.TypographyClasses,
        _props$underline = props.underline,
        underline = _props$underline === void 0 ? 'hover' : _props$underline,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'inherit' : _props$variant,
        other = _objectWithoutProperties(props, ["classes", "className", "color", "component", "onBlur", "onFocus", "TypographyClasses", "underline", "variant"]);

    var _useIsFocusVisible = useIsFocusVisible(),
        isFocusVisible = _useIsFocusVisible.isFocusVisible,
        onBlurVisible = _useIsFocusVisible.onBlurVisible,
        focusVisibleRef = _useIsFocusVisible.ref;

    var _React$useState = React__default.useState(false),
        focusVisible = _React$useState[0],
        setFocusVisible = _React$useState[1];

    var handlerRef = useForkRef(ref, focusVisibleRef);

    var handleBlur = function handleBlur(event) {
      if (focusVisible) {
        onBlurVisible();
        setFocusVisible(false);
      }

      if (onBlur) {
        onBlur(event);
      }
    };

    var handleFocus = function handleFocus(event) {
      if (isFocusVisible(event)) {
        setFocusVisible(true);
      }

      if (onFocus) {
        onFocus(event);
      }
    };

    return React__default.createElement(Typography$1, _extends({
      className: clsx(classes.root, classes["underline".concat(capitalize(underline))], className, focusVisible && classes.focusVisible, {
        button: classes.button
      }[component]),
      classes: TypographyClasses,
      color: color,
      component: component,
      onBlur: handleBlur,
      onFocus: handleFocus,
      ref: handlerRef,
      variant: variant
    }, other));
  });
   Link.propTypes = {
    /**
     * The content of the link.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the link.
     */
    color: propTypes.oneOf(['default', 'error', 'inherit', 'primary', 'secondary', 'textPrimary', 'textSecondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: elementTypeAcceptingRef$1,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * `classes` prop applied to the [`Typography`](/api/typography/) element.
     */
    TypographyClasses: propTypes.object,

    /**
     * Controls when the link should have an underline.
     */
    underline: propTypes.oneOf(['none', 'hover', 'always']),

    /**
     * Applies the theme typography styles.
     */
    variant: propTypes.string
  } ;
  var Link$1 = withStyles$1(styles$$, {
    name: 'MuiLink'
  })(Link);

  /**
   * @ignore - internal component.
   */

  var ListContext = React__default.createContext({});

  var styles$10 = {
    /* Styles applied to the root element. */
    root: {
      listStyle: 'none',
      margin: 0,
      padding: 0,
      position: 'relative'
    },

    /* Styles applied to the root element if `disablePadding={false}`. */
    padding: {
      paddingTop: 8,
      paddingBottom: 8
    },

    /* Styles applied to the root element if dense. */
    dense: {},

    /* Styles applied to the root element if a `subheader` is provided. */
    subheader: {
      paddingTop: 0
    }
  };
  var List = React__default.forwardRef(function List(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'ul' : _props$component,
        _props$dense = props.dense,
        dense = _props$dense === void 0 ? false : _props$dense,
        _props$disablePadding = props.disablePadding,
        disablePadding = _props$disablePadding === void 0 ? false : _props$disablePadding,
        subheader = props.subheader,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "component", "dense", "disablePadding", "subheader"]);

    var context = React__default.useMemo(function () {
      return {
        dense: dense
      };
    }, [dense]);
    return React__default.createElement(ListContext.Provider, {
      value: context
    }, React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, dense && classes.dense, !disablePadding && classes.padding, subheader && classes.subheader),
      ref: ref
    }, other), subheader, children));
  });
   List.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, compact vertical padding designed for keyboard and mouse input will be used for
     * the list and list items.
     * The prop is available to descendant components as the `dense` context.
     */
    dense: propTypes.bool,

    /**
     * If `true`, vertical padding will be removed from the list.
     */
    disablePadding: propTypes.bool,

    /**
     * The content of the subheader, normally `ListSubheader`.
     */
    subheader: propTypes.node
  } ;
  var List$1 = withStyles$1(styles$10, {
    name: 'MuiList'
  })(List);

  var styles$11 = function styles(theme) {
    return {
      /* Styles applied to the (normally root) `component` element. May be wrapped by a `container`. */
      root: {
        display: 'flex',
        justifyContent: 'flex-start',
        alignItems: 'center',
        position: 'relative',
        textDecoration: 'none',
        width: '100%',
        boxSizing: 'border-box',
        textAlign: 'left',
        paddingTop: 8,
        paddingBottom: 8,
        '&$focusVisible': {
          backgroundColor: theme.palette.action.selected
        },
        '&$selected, &$selected:hover': {
          backgroundColor: theme.palette.action.selected
        },
        '&$disabled': {
          opacity: 0.5
        }
      },

      /* Styles applied to the `container` element if `children` includes `ListItemSecondaryAction`. */
      container: {
        position: 'relative'
      },

      /* Pseudo-class applied to the `component`'s `focusVisibleClassName` prop if `button={true}`. */
      focusVisible: {},

      /* Styles applied to the `component` element if dense. */
      dense: {
        paddingTop: 4,
        paddingBottom: 4
      },

      /* Styles applied to the `component` element if `alignItems="flex-start"`. */
      alignItemsFlexStart: {
        alignItems: 'flex-start'
      },

      /* Pseudo-class applied to the inner `component` element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the inner `component` element if `divider={true}`. */
      divider: {
        borderBottom: "1px solid ".concat(theme.palette.divider),
        backgroundClip: 'padding-box'
      },

      /* Styles applied to the inner `component` element if `disableGutters={false}`. */
      gutters: {
        paddingLeft: 16,
        paddingRight: 16
      },

      /* Styles applied to the inner `component` element if `button={true}`. */
      button: {
        transition: theme.transitions.create('background-color', {
          duration: theme.transitions.duration.shortest
        }),
        '&:hover': {
          textDecoration: 'none',
          backgroundColor: theme.palette.action.hover,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the `component` element if `children` includes `ListItemSecondaryAction`. */
      secondaryAction: {
        // Add some space to avoid collision as `ListItemSecondaryAction`
        // is absolutely positioned.
        paddingRight: 48
      },

      /* Pseudo-class applied to the root element if `selected={true}`. */
      selected: {}
    };
  };
  var useEnhancedEffect$7 = typeof window === 'undefined' ? React__default.useEffect : React__default.useLayoutEffect;
  /**
   * Uses an additional container component if `ListItemSecondaryAction` is the last child.
   */

  var ListItem = React__default.forwardRef(function ListItem(props, ref) {
    var _props$alignItems = props.alignItems,
        alignItems = _props$alignItems === void 0 ? 'center' : _props$alignItems,
        _props$autoFocus = props.autoFocus,
        autoFocus = _props$autoFocus === void 0 ? false : _props$autoFocus,
        _props$button = props.button,
        button = _props$button === void 0 ? false : _props$button,
        childrenProp = props.children,
        classes = props.classes,
        className = props.className,
        componentProp = props.component,
        _props$ContainerCompo = props.ContainerComponent,
        ContainerComponent = _props$ContainerCompo === void 0 ? 'li' : _props$ContainerCompo,
        _props$ContainerProps = props.ContainerProps;
    _props$ContainerProps = _props$ContainerProps === void 0 ? {} : _props$ContainerProps;

    var ContainerClassName = _props$ContainerProps.className,
        ContainerProps = _objectWithoutProperties(_props$ContainerProps, ["className"]),
        _props$dense = props.dense,
        dense = _props$dense === void 0 ? false : _props$dense,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$disableGutters = props.disableGutters,
        disableGutters = _props$disableGutters === void 0 ? false : _props$disableGutters,
        _props$divider = props.divider,
        divider = _props$divider === void 0 ? false : _props$divider,
        focusVisibleClassName = props.focusVisibleClassName,
        _props$selected = props.selected,
        selected = _props$selected === void 0 ? false : _props$selected,
        other = _objectWithoutProperties(props, ["alignItems", "autoFocus", "button", "children", "classes", "className", "component", "ContainerComponent", "ContainerProps", "dense", "disabled", "disableGutters", "divider", "focusVisibleClassName", "selected"]);

    var context = React__default.useContext(ListContext);
    var childContext = {
      dense: dense || context.dense || false,
      alignItems: alignItems
    };
    var listItemRef = React__default.useRef(null);
    useEnhancedEffect$7(function () {
      if (autoFocus) {
        if (listItemRef.current) {
          listItemRef.current.focus();
        } else {
          console.error('Material-UI: unable to set focus to a ListItem whose component has not been rendered.');
        }
      }
    }, [autoFocus]);
    var children = React__default.Children.toArray(childrenProp);
    var hasSecondaryAction = children.length && isMuiElement(children[children.length - 1], ['ListItemSecondaryAction']);
    var handleOwnRef = React__default.useCallback(function (instance) {
      // #StrictMode ready
      listItemRef.current = ReactDOM.findDOMNode(instance);
    }, []);
    var handleRef = useForkRef(handleOwnRef, ref);

    var componentProps = _extends({
      className: clsx(classes.root, className, childContext.dense && classes.dense, !disableGutters && classes.gutters, divider && classes.divider, disabled && classes.disabled, button && classes.button, alignItems !== "center" && classes.alignItemsFlexStart, hasSecondaryAction && classes.secondaryAction, selected && classes.selected),
      disabled: disabled
    }, other);

    var Component = componentProp || 'li';

    if (button) {
      componentProps.component = componentProp || 'div';
      componentProps.focusVisibleClassName = clsx(classes.focusVisible, focusVisibleClassName);
      Component = ButtonBase$1;
    }

    if (hasSecondaryAction) {
      // Use div by default.
      Component = !componentProps.component && !componentProp ? 'div' : Component; // Avoid nesting of li > li.

      if (ContainerComponent === 'li') {
        if (Component === 'li') {
          Component = 'div';
        } else if (componentProps.component === 'li') {
          componentProps.component = 'div';
        }
      }

      return React__default.createElement(ListContext.Provider, {
        value: childContext
      }, React__default.createElement(ContainerComponent, _extends({
        className: clsx(classes.container, ContainerClassName),
        ref: handleRef
      }, ContainerProps), React__default.createElement(Component, componentProps, children), children.pop()));
    }

    return React__default.createElement(ListContext.Provider, {
      value: childContext
    }, React__default.createElement(Component, _extends({
      ref: handleRef
    }, componentProps), children));
  });
   ListItem.propTypes = {
    /**
     * Defines the `align-items` style property.
     */
    alignItems: propTypes.oneOf(['flex-start', 'center']),

    /**
     * If `true`, the list item will be focused during the first mount.
     * Focus will also be triggered if the value changes from false to true.
     */
    autoFocus: propTypes.bool,

    /**
     * If `true`, the list item will be a button (using `ButtonBase`). Props intended
     * for `ButtonBase` can then be applied to `ListItem`.
     */
    button: propTypes.bool,

    /**
     * The content of the component. If a `ListItemSecondaryAction` is used it must
     * be the last child.
     */
    children: chainPropTypes(propTypes.node, function (props) {
      var children = React__default.Children.toArray(props.children); // React.Children.toArray(props.children).findLastIndex(isListItemSecondaryAction)

      var secondaryActionIndex = -1;

      for (var i = children.length - 1; i >= 0; i -= 1) {
        var child = children[i];

        if (isMuiElement(child, ['ListItemSecondaryAction'])) {
          secondaryActionIndex = i;
          break;
        }
      } //  is ListItemSecondaryAction the last child of ListItem


      if (secondaryActionIndex !== -1 && secondaryActionIndex !== children.length - 1) {
        return new Error('Material-UI: you used an element after ListItemSecondaryAction. ' + 'For ListItem to detect that it has a secondary action ' + 'you must pass it as the last child to ListItem.');
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     * By default, it's a `li` when `button` is `false` and a `div` when `button` is `true`.
     */
    component: propTypes.elementType,

    /**
     * The container component used when a `ListItemSecondaryAction` is the last child.
     */
    ContainerComponent: propTypes.elementType,

    /**
     * Props applied to the container component if used.
     */
    ContainerProps: propTypes.object,

    /**
     * If `true`, compact vertical padding designed for keyboard and mouse input will be used.
     */
    dense: propTypes.bool,

    /**
     * If `true`, the list item will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the left and right padding is removed.
     */
    disableGutters: propTypes.bool,

    /**
     * If `true`, a 1px light border is added to the bottom of the list item.
     */
    divider: propTypes.bool,

    /**
     * @ignore
     */
    focusVisibleClassName: propTypes.string,

    /**
     * Use to apply selected styling.
     */
    selected: propTypes.bool
  } ;
  var ListItem$1 = withStyles$1(styles$11, {
    name: 'MuiListItem'
  })(ListItem);

  var styles$12 = {
    /* Styles applied to the root element. */
    root: {
      minWidth: 56,
      flexShrink: 0
    },

    /* Styles applied to the root element when the parent `ListItem` uses `alignItems="flex-start"`. */
    alignItemsFlexStart: {
      marginTop: 8
    }
  };
  /**
   * A simple wrapper to apply `List` styles to an `Avatar`.
   */

  var ListItemAvatar = React__default.forwardRef(function ListItemAvatar(props, ref) {
    var classes = props.classes,
        className = props.className,
        other = _objectWithoutProperties(props, ["classes", "className"]);

    var context = React__default.useContext(ListContext);
    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, context.alignItems === 'flex-start' && classes.alignItemsFlexStart),
      ref: ref
    }, other));
  });
   ListItemAvatar.propTypes = {
    /**
     * The content of the component – normally `Avatar`.
     */
    children: propTypes.element.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  } ;
  var ListItemAvatar$1 = withStyles$1(styles$12, {
    name: 'MuiListItemAvatar'
  })(ListItemAvatar);

  var styles$13 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        minWidth: 56,
        color: theme.palette.action.active,
        flexShrink: 0,
        display: 'inline-flex'
      },

      /* Styles applied to the root element when the parent `ListItem` uses `alignItems="flex-start"`. */
      alignItemsFlexStart: {
        marginTop: 8
      }
    };
  };
  /**
   * A simple wrapper to apply `List` styles to an `Icon` or `SvgIcon`.
   */

  var ListItemIcon = React__default.forwardRef(function ListItemIcon(props, ref) {
    var classes = props.classes,
        className = props.className,
        other = _objectWithoutProperties(props, ["classes", "className"]);

    var context = React__default.useContext(ListContext);
    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, context.alignItems === 'flex-start' && classes.alignItemsFlexStart),
      ref: ref
    }, other));
  });
   ListItemIcon.propTypes = {
    /**
     * The content of the component, normally `Icon`, `SvgIcon`,
     * or a `@material-ui/icons` SVG icon element.
     */
    children: propTypes.element.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  } ;
  var ListItemIcon$1 = withStyles$1(styles$13, {
    name: 'MuiListItemIcon'
  })(ListItemIcon);

  var styles$14 = {
    /* Styles applied to the root element. */
    root: {
      position: 'absolute',
      right: 16,
      top: '50%',
      transform: 'translateY(-50%)'
    }
  };
  /**
   * Must be used as the last child of ListItem to function properly.
   */

  var ListItemSecondaryAction = React__default.forwardRef(function ListItemSecondaryAction(props, ref) {
    var classes = props.classes,
        className = props.className,
        other = _objectWithoutProperties(props, ["classes", "className"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className),
      ref: ref
    }, other));
  });
   ListItemSecondaryAction.propTypes = {
    /**
     * The content of the component, normally an `IconButton` or selection control.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  } ;
  ListItemSecondaryAction.muiName = 'ListItemSecondaryAction';
  var ListItemSecondaryAction$1 = withStyles$1(styles$14, {
    name: 'MuiListItemSecondaryAction'
  })(ListItemSecondaryAction);

  var styles$15 = {
    /* Styles applied to the root element. */
    root: {
      flex: '1 1 auto',
      minWidth: 0,
      marginTop: 4,
      marginBottom: 4
    },

    /* Styles applied to the `Typography` components if primary and secondary are set. */
    multiline: {
      marginTop: 6,
      marginBottom: 6
    },

    /* Styles applied to the `Typography` components if dense. */
    dense: {},

    /* Styles applied to the root element if `inset={true}`. */
    inset: {
      paddingLeft: 56
    },

    /* Styles applied to the primary `Typography` component. */
    primary: {},

    /* Styles applied to the secondary `Typography` component. */
    secondary: {}
  };
  var ListItemText = React__default.forwardRef(function ListItemText(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        _props$disableTypogra = props.disableTypography,
        disableTypography = _props$disableTypogra === void 0 ? false : _props$disableTypogra,
        _props$inset = props.inset,
        inset = _props$inset === void 0 ? false : _props$inset,
        primaryProp = props.primary,
        primaryTypographyProps = props.primaryTypographyProps,
        secondaryProp = props.secondary,
        secondaryTypographyProps = props.secondaryTypographyProps,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "disableTypography", "inset", "primary", "primaryTypographyProps", "secondary", "secondaryTypographyProps"]);

    var _React$useContext = React__default.useContext(ListContext),
        dense = _React$useContext.dense;

    var primary = primaryProp != null ? primaryProp : children;

    if (primary != null && primary.type !== Typography$1 && !disableTypography) {
      primary = React__default.createElement(Typography$1, _extends({
        variant: dense ? 'body2' : 'body1',
        className: classes.primary,
        component: "span"
      }, primaryTypographyProps), primary);
    }

    var secondary = secondaryProp;

    if (secondary != null && secondary.type !== Typography$1 && !disableTypography) {
      secondary = React__default.createElement(Typography$1, _extends({
        variant: "body2",
        className: classes.secondary,
        color: "textSecondary"
      }, secondaryTypographyProps), secondary);
    }

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, className, dense && classes.dense, inset && classes.inset, primary && secondary && classes.multiline),
      ref: ref
    }, other), primary, secondary);
  });
   ListItemText.propTypes = {
    /**
     * Alias for the `primary` property.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the children won't be wrapped by a Typography component.
     * This can be useful to render an alternative Typography variant by wrapping
     * the `children` (or `primary`) text, and optional `secondary` text
     * with the Typography component.
     */
    disableTypography: propTypes.bool,

    /**
     * If `true`, the children will be indented.
     * This should be used if there is no left avatar or left icon.
     */
    inset: propTypes.bool,

    /**
     * The main content element.
     */
    primary: propTypes.node,

    /**
     * These props will be forwarded to the primary typography component
     * (as long as disableTypography is not `true`).
     */
    primaryTypographyProps: propTypes.object,

    /**
     * The secondary content element.
     */
    secondary: propTypes.node,

    /**
     * These props will be forwarded to the secondary typography component
     * (as long as disableTypography is not `true`).
     */
    secondaryTypographyProps: propTypes.object
  } ;
  var ListItemText$1 = withStyles$1(styles$15, {
    name: 'MuiListItemText'
  })(ListItemText);

  var styles$16 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        boxSizing: 'border-box',
        lineHeight: '48px',
        listStyle: 'none',
        color: theme.palette.text.secondary,
        fontFamily: theme.typography.fontFamily,
        fontWeight: theme.typography.fontWeightMedium,
        fontSize: theme.typography.pxToRem(14)
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit'
      },

      /* Styles applied to the inner `component` element if `disableGutters={false}`. */
      gutters: {
        paddingLeft: 16,
        paddingRight: 16
      },

      /* Styles applied to the root element if `inset={true}`. */
      inset: {
        paddingLeft: 72
      },

      /* Styles applied to the root element if `disableSticky={false}`. */
      sticky: {
        position: 'sticky',
        top: 0,
        zIndex: 1,
        backgroundColor: 'inherit'
      }
    };
  };
  var ListSubheader = React__default.forwardRef(function ListSubheader(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'default' : _props$color,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'li' : _props$component,
        _props$disableGutters = props.disableGutters,
        disableGutters = _props$disableGutters === void 0 ? false : _props$disableGutters,
        _props$disableSticky = props.disableSticky,
        disableSticky = _props$disableSticky === void 0 ? false : _props$disableSticky,
        _props$inset = props.inset,
        inset = _props$inset === void 0 ? false : _props$inset,
        other = _objectWithoutProperties(props, ["classes", "className", "color", "component", "disableGutters", "disableSticky", "inset"]);

    return React__default.createElement(Component, _extends({
      className: clsx(classes.root, className, color !== 'default' && classes["color".concat(capitalize(color))], inset && classes.inset, !disableSticky && classes.sticky, !disableGutters && classes.gutters),
      ref: ref
    }, other));
  });
   ListSubheader.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'primary', 'inherit']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, the List Subheader will not have gutters.
     */
    disableGutters: propTypes.bool,

    /**
     * If `true`, the List Subheader will not stick to the top during scroll.
     */
    disableSticky: propTypes.bool,

    /**
     * If `true`, the List Subheader will be indented.
     */
    inset: propTypes.bool
  } ;
  var ListSubheader$1 = withStyles$1(styles$16, {
    name: 'MuiListSubheader'
  })(ListSubheader);

  function getOffsetTop(rect, vertical) {
    var offset = 0;

    if (typeof vertical === 'number') {
      offset = vertical;
    } else if (vertical === 'center') {
      offset = rect.height / 2;
    } else if (vertical === 'bottom') {
      offset = rect.height;
    }

    return offset;
  }
  function getOffsetLeft(rect, horizontal) {
    var offset = 0;

    if (typeof horizontal === 'number') {
      offset = horizontal;
    } else if (horizontal === 'center') {
      offset = rect.width / 2;
    } else if (horizontal === 'right') {
      offset = rect.width;
    }

    return offset;
  }

  function getTransformOriginValue(transformOrigin) {
    return [transformOrigin.horizontal, transformOrigin.vertical].map(function (n) {
      return typeof n === 'number' ? "".concat(n, "px") : n;
    }).join(' ');
  } // Sum the scrollTop between two elements.


  function getScrollParent(parent, child) {
    var element = child;
    var scrollTop = 0;

    while (element && element !== parent) {
      element = element.parentElement;
      scrollTop += element.scrollTop;
    }

    return scrollTop;
  }

  function getAnchorEl(anchorEl) {
    return typeof anchorEl === 'function' ? anchorEl() : anchorEl;
  }

  var styles$17 = {
    /* Styles applied to the root element */
    root: {},

    /* Styles applied to the `Paper` component. */
    paper: {
      position: 'absolute',
      overflowY: 'auto',
      overflowX: 'hidden',
      // So we see the popover when it's empty.
      // It's most likely on issue on userland.
      minWidth: 16,
      minHeight: 16,
      maxWidth: 'calc(100% - 32px)',
      maxHeight: 'calc(100% - 32px)',
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 0
    }
  };
  var Popover = React__default.forwardRef(function Popover(props, ref) {
    var action = props.action,
        anchorEl = props.anchorEl,
        _props$anchorOrigin = props.anchorOrigin,
        anchorOrigin = _props$anchorOrigin === void 0 ? {
      vertical: 'top',
      horizontal: 'left'
    } : _props$anchorOrigin,
        anchorPosition = props.anchorPosition,
        _props$anchorReferenc = props.anchorReference,
        anchorReference = _props$anchorReferenc === void 0 ? 'anchorEl' : _props$anchorReferenc,
        children = props.children,
        classes = props.classes,
        className = props.className,
        containerProp = props.container,
        _props$elevation = props.elevation,
        elevation = _props$elevation === void 0 ? 8 : _props$elevation,
        getContentAnchorEl = props.getContentAnchorEl,
        _props$marginThreshol = props.marginThreshold,
        marginThreshold = _props$marginThreshol === void 0 ? 16 : _props$marginThreshol,
        onEnter = props.onEnter,
        onEntered = props.onEntered,
        onEntering = props.onEntering,
        onExit = props.onExit,
        onExited = props.onExited,
        onExiting = props.onExiting,
        open = props.open,
        _props$PaperProps = props.PaperProps,
        PaperProps = _props$PaperProps === void 0 ? {} : _props$PaperProps,
        _props$transformOrigi = props.transformOrigin,
        transformOrigin = _props$transformOrigi === void 0 ? {
      vertical: 'top',
      horizontal: 'left'
    } : _props$transformOrigi,
        _props$TransitionComp = props.TransitionComponent,
        TransitionComponent = _props$TransitionComp === void 0 ? Grow : _props$TransitionComp,
        _props$transitionDura = props.transitionDuration,
        transitionDurationProp = _props$transitionDura === void 0 ? 'auto' : _props$transitionDura,
        _props$TransitionProp = props.TransitionProps,
        TransitionProps = _props$TransitionProp === void 0 ? {} : _props$TransitionProp,
        other = _objectWithoutProperties(props, ["action", "anchorEl", "anchorOrigin", "anchorPosition", "anchorReference", "children", "classes", "className", "container", "elevation", "getContentAnchorEl", "marginThreshold", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "open", "PaperProps", "transformOrigin", "TransitionComponent", "transitionDuration", "TransitionProps"]);

    var paperRef = React__default.useRef(); // Returns the top/left offset of the position
    // to attach to on the anchor element (or body if none is provided)

    var getAnchorOffset = React__default.useCallback(function (contentAnchorOffset) {
      if (anchorReference === 'anchorPosition') {
        {
          if (!anchorPosition) {
            console.error('Material-UI: you need to provide a `anchorPosition` prop when using ' + '<Popover anchorReference="anchorPosition" />.');
          }
        }

        return anchorPosition;
      }

      var resolvedAnchorEl = getAnchorEl(anchorEl);
      var containerWindow = ownerWindow(resolvedAnchorEl); // If an anchor element wasn't provided, just use the parent body element of this Popover

      var anchorElement = resolvedAnchorEl instanceof containerWindow.Element ? resolvedAnchorEl : ownerDocument(paperRef.current).body;
      var anchorRect = anchorElement.getBoundingClientRect();

      {
        var box = anchorElement.getBoundingClientRect();

        if ( box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
          console.warn(['Material-UI: the `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
        }
      }

      var anchorVertical = contentAnchorOffset === 0 ? anchorOrigin.vertical : 'center';
      return {
        top: anchorRect.top + getOffsetTop(anchorRect, anchorVertical),
        left: anchorRect.left + getOffsetLeft(anchorRect, anchorOrigin.horizontal)
      };
    }, [anchorEl, anchorOrigin.horizontal, anchorOrigin.vertical, anchorPosition, anchorReference]); // Returns the vertical offset of inner content to anchor the transform on if provided

    var getContentAnchorOffset = React__default.useCallback(function (element) {
      var contentAnchorOffset = 0;

      if (getContentAnchorEl && anchorReference === 'anchorEl') {
        var contentAnchorEl = getContentAnchorEl(element);

        if (contentAnchorEl && element.contains(contentAnchorEl)) {
          var scrollTop = getScrollParent(element, contentAnchorEl);
          contentAnchorOffset = contentAnchorEl.offsetTop + contentAnchorEl.clientHeight / 2 - scrollTop || 0;
        } // != the default value


        {
          if (anchorOrigin.vertical !== 'top') {
            console.error(['Material-UI: you can not change the default `anchorOrigin.vertical` value ', 'when also providing the `getContentAnchorEl` prop to the popover component.', 'Only use one of the two props.', 'Set `getContentAnchorEl` to `null | undefined`' + ' or leave `anchorOrigin.vertical` unchanged.'].join('\n'));
          }
        }
      }

      return contentAnchorOffset;
    }, [anchorOrigin.vertical, anchorReference, getContentAnchorEl]); // Return the base transform origin using the element
    // and taking the content anchor offset into account if in use

    var getTransformOrigin = React__default.useCallback(function (elemRect) {
      var contentAnchorOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      return {
        vertical: getOffsetTop(elemRect, transformOrigin.vertical) + contentAnchorOffset,
        horizontal: getOffsetLeft(elemRect, transformOrigin.horizontal)
      };
    }, [transformOrigin.horizontal, transformOrigin.vertical]);
    var getPositioningStyle = React__default.useCallback(function (element) {
      // Check if the parent has requested anchoring on an inner content node
      var contentAnchorOffset = getContentAnchorOffset(element);
      var elemRect = {
        width: element.offsetWidth,
        height: element.offsetHeight
      }; // Get the transform origin point on the element itself

      var elemTransformOrigin = getTransformOrigin(elemRect, contentAnchorOffset);

      if (anchorReference === 'none') {
        return {
          top: null,
          left: null,
          transformOrigin: getTransformOriginValue(elemTransformOrigin)
        };
      } // Get the offset of of the anchoring element


      var anchorOffset = getAnchorOffset(contentAnchorOffset); // Calculate element positioning

      var top = anchorOffset.top - elemTransformOrigin.vertical;
      var left = anchorOffset.left - elemTransformOrigin.horizontal;
      var bottom = top + elemRect.height;
      var right = left + elemRect.width; // Use the parent window of the anchorEl if provided

      var containerWindow = ownerWindow(getAnchorEl(anchorEl)); // Window thresholds taking required margin into account

      var heightThreshold = containerWindow.innerHeight - marginThreshold;
      var widthThreshold = containerWindow.innerWidth - marginThreshold; // Check if the vertical axis needs shifting

      if (top < marginThreshold) {
        var diff = top - marginThreshold;
        top -= diff;
        elemTransformOrigin.vertical += diff;
      } else if (bottom > heightThreshold) {
        var _diff = bottom - heightThreshold;

        top -= _diff;
        elemTransformOrigin.vertical += _diff;
      }

      {
        if (elemRect.height > heightThreshold && elemRect.height && heightThreshold) {
          console.error(['Material-UI: the popover component is too tall.', "Some part of it can not be seen on the screen (".concat(elemRect.height - heightThreshold, "px)."), 'Please consider adding a `max-height` to improve the user-experience.'].join('\n'));
        }
      } // Check if the horizontal axis needs shifting


      if (left < marginThreshold) {
        var _diff2 = left - marginThreshold;

        left -= _diff2;
        elemTransformOrigin.horizontal += _diff2;
      } else if (right > widthThreshold) {
        var _diff3 = right - widthThreshold;

        left -= _diff3;
        elemTransformOrigin.horizontal += _diff3;
      }

      return {
        top: "".concat(top, "px"),
        left: "".concat(left, "px"),
        transformOrigin: getTransformOriginValue(elemTransformOrigin)
      };
    }, [anchorEl, anchorReference, getAnchorOffset, getContentAnchorOffset, getTransformOrigin, marginThreshold]);
    var setPositioningStyles = React__default.useCallback(function (element) {
      var positioning = getPositioningStyle(element);

      if (positioning.top !== null) {
        element.style.top = positioning.top;
      }

      if (positioning.left !== null) {
        element.style.left = positioning.left;
      }

      element.style.transformOrigin = positioning.transformOrigin;
    }, [getPositioningStyle]);

    var handleEntering = function handleEntering(element, isAppearing) {
      if (onEntering) {
        onEntering(element, isAppearing);
      }

      setPositioningStyles(element);
    };

    var handlePaperRef = React__default.useCallback(function (instance) {
      // #StrictMode ready
      paperRef.current = ReactDOM.findDOMNode(instance);
    }, []);
    var updatePosition = React__default.useMemo(function () {
      if (!open) {
        return undefined;
      }

      return debounce(function () {
        setPositioningStyles(paperRef.current);
      });
    }, [open, setPositioningStyles]);
    React__default.useImperativeHandle(action, function () {
      return open ? {
        updatePosition: updatePosition
      } : null;
    }, [open, updatePosition]);
    React__default.useEffect(function () {
      if (!updatePosition) {
        return undefined;
      }

      window.addEventListener('resize', updatePosition);
      return function () {
        window.removeEventListener('resize', updatePosition);
        updatePosition.clear();
      };
    }, [updatePosition]);
    var transitionDuration = transitionDurationProp;

    if (transitionDurationProp === 'auto' && !TransitionComponent.muiSupportAuto) {
      transitionDuration = undefined;
    } // If the container prop is provided, use that
    // If the anchorEl prop is provided, use its parent body element as the container
    // If neither are provided let the Modal take care of choosing the container


    var container = containerProp || (anchorEl ? ownerDocument(getAnchorEl(anchorEl)).body : undefined);
    return React__default.createElement(Modal, _extends({
      container: container,
      open: open,
      ref: ref,
      BackdropProps: {
        invisible: true
      },
      className: clsx(classes.root, className)
    }, other), React__default.createElement(TransitionComponent, _extends({
      appear: true,
      in: open,
      onEnter: onEnter,
      onEntered: onEntered,
      onExit: onExit,
      onExited: onExited,
      onExiting: onExiting,
      timeout: transitionDuration
    }, TransitionProps, {
      onEntering: createChainedFunction(handleEntering, TransitionProps.onEntering)
    }), React__default.createElement(Paper$1, _extends({
      elevation: elevation,
      ref: handlePaperRef
    }, PaperProps, {
      className: clsx(classes.paper, PaperProps.className)
    }), children)));
  });
   Popover.propTypes = {
    /**
     * A ref for imperative actions.
     * It currently only supports updatePosition() action.
     */
    action: refType,

    /**
     * This is the DOM element, or a function that returns the DOM element,
     * that may be used to set the position of the popover.
     */
    anchorEl: chainPropTypes(propTypes.oneOfType([propTypes.object, propTypes.func]), function (props) {
      if (props.open && (!props.anchorReference || props.anchorReference === 'anchorEl')) {
        var resolvedAnchorEl = getAnchorEl(props.anchorEl);
        var containerWindow = ownerWindow(resolvedAnchorEl);

        if (resolvedAnchorEl instanceof containerWindow.Element) {
          var box = resolvedAnchorEl.getBoundingClientRect();

          if ( box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
            return new Error(['Material-UI: the `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
          }
        } else {
          return new Error(['Material-UI: the `anchorEl` prop provided to the component is invalid.', "It should be an Element instance but it's `".concat(resolvedAnchorEl, "` instead.")].join('\n'));
        }
      }

      return null;
    }),

    /**
     * This is the point on the anchor where the popover's
     * `anchorEl` will attach to. This is not used when the
     * anchorReference is 'anchorPosition'.
     *
     * Options:
     * vertical: [top, center, bottom];
     * horizontal: [left, center, right].
     */
    anchorOrigin: propTypes.shape({
      horizontal: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['left', 'center', 'right'])]).isRequired,
      vertical: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['top', 'center', 'bottom'])]).isRequired
    }),

    /**
     * This is the position that may be used
     * to set the position of the popover.
     * The coordinates are relative to
     * the application's client area.
     */
    anchorPosition: propTypes.shape({
      left: propTypes.number.isRequired,
      top: propTypes.number.isRequired
    }),

    /*
     * This determines which anchor prop to refer to to set
     * the position of the popover.
     */
    anchorReference: propTypes.oneOf(['anchorEl', 'anchorPosition', 'none']),

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * A node, component instance, or function that returns either.
     * The `container` will passed to the Modal component.
     * By default, it uses the body of the anchorEl's top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * The elevation of the popover.
     */
    elevation: propTypes.number,

    /**
     * This function is called in order to retrieve the content anchor element.
     * It's the opposite of the `anchorEl` prop.
     * The content anchor element should be an element inside the popover.
     * It's used to correctly scroll and set the position of the popover.
     * The positioning strategy tries to make the content anchor element just above the
     * anchor element.
     */
    getContentAnchorEl: propTypes.func,

    /**
     * Specifies how close to the edge of the window the popover can appear.
     */
    marginThreshold: propTypes.number,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be:`"escapeKeyDown"`, `"backdropClick"`
     */
    onClose: propTypes.func,

    /**
     * Callback fired before the component is entering.
     */
    onEnter: propTypes.func,

    /**
     * Callback fired when the component has entered.
     */
    onEntered: propTypes.func,

    /**
     * Callback fired when the component is entering.
     */
    onEntering: propTypes.func,

    /**
     * Callback fired before the component is exiting.
     */
    onExit: propTypes.func,

    /**
     * Callback fired when the component has exited.
     */
    onExited: propTypes.func,

    /**
     * Callback fired when the component is exiting.
     */
    onExiting: propTypes.func,

    /**
     * If `true`, the popover is visible.
     */
    open: propTypes.bool.isRequired,

    /**
     * Props applied to the [`Paper`](/api/paper/) element.
     */
    PaperProps: propTypes.shape({
      component: elementTypeAcceptingRef$1
    }),

    /**
     * This is the point on the popover which
     * will attach to the anchor's origin.
     *
     * Options:
     * vertical: [top, center, bottom, x(px)];
     * horizontal: [left, center, right, x(px)].
     */
    transformOrigin: propTypes.shape({
      horizontal: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['left', 'center', 'right'])]).isRequired,
      vertical: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['top', 'center', 'bottom'])]).isRequired
    }),

    /**
     * The component used for the transition.
     */
    TransitionComponent: propTypes.elementType,

    /**
     * Set to 'auto' to automatically calculate transition time based on height.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])]),

    /**
     * Props applied to the `Transition` element.
     */
    TransitionProps: propTypes.object
  } ;
  var Popover$1 = withStyles$1(styles$17, {
    name: 'MuiPopover'
  })(Popover);

  function nextItem(list, item, disableListWrap) {
    if (list === item) {
      return list.firstChild;
    }

    if (item && item.nextElementSibling) {
      return item.nextElementSibling;
    }

    return disableListWrap ? null : list.firstChild;
  }

  function previousItem(list, item, disableListWrap) {
    if (list === item) {
      return disableListWrap ? list.firstChild : list.lastChild;
    }

    if (item && item.previousElementSibling) {
      return item.previousElementSibling;
    }

    return disableListWrap ? null : list.lastChild;
  }

  function textCriteriaMatches(nextFocus, textCriteria) {
    if (textCriteria === undefined) {
      return true;
    }

    var text = nextFocus.innerText;

    if (text === undefined) {
      // jsdom doesn't support innerText
      text = nextFocus.textContent;
    }

    if (text === undefined) {
      return false;
    }

    text = text.trim().toLowerCase();

    if (text.length === 0) {
      return false;
    }

    if (textCriteria.repeating) {
      return text[0] === textCriteria.keys[0];
    }

    return text.indexOf(textCriteria.keys.join('')) === 0;
  }

  function moveFocus(list, currentFocus, disableListWrap, traversalFunction, textCriteria) {
    var wrappedOnce = false;
    var nextFocus = traversalFunction(list, currentFocus, currentFocus ? disableListWrap : false);

    while (nextFocus) {
      // Prevent infinite loop.
      if (nextFocus === list.firstChild) {
        if (wrappedOnce) {
          return false;
        }

        wrappedOnce = true;
      } // Move to the next element.


      if (!nextFocus.hasAttribute('tabindex') || nextFocus.disabled || nextFocus.getAttribute('aria-disabled') === 'true' || !textCriteriaMatches(nextFocus, textCriteria)) {
        nextFocus = traversalFunction(list, nextFocus, disableListWrap);
      } else {
        nextFocus.focus();
        return true;
      }
    }

    return false;
  }

  var useEnhancedEffect$8 = typeof window === 'undefined' ? React__default.useEffect : React__default.useLayoutEffect;
  /**
   * A permanently displayed menu following https://www.w3.org/TR/wai-aria-practices/#menubutton
   * It's exposed to help customization of the [`Menu`](/api/menu/) component. If you
   * use it separately you need to move focus into the component manually. Once
   * the focus is placed inside the component it is fully keyboard accessible.
   */

  var MenuList = React__default.forwardRef(function MenuList(props, ref) {
    var actions = props.actions,
        _props$autoFocus = props.autoFocus,
        autoFocus = _props$autoFocus === void 0 ? false : _props$autoFocus,
        _props$autoFocusItem = props.autoFocusItem,
        autoFocusItem = _props$autoFocusItem === void 0 ? false : _props$autoFocusItem,
        children = props.children,
        className = props.className,
        onKeyDown = props.onKeyDown,
        _props$disableListWra = props.disableListWrap,
        disableListWrap = _props$disableListWra === void 0 ? false : _props$disableListWra,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'selectedMenu' : _props$variant,
        other = _objectWithoutProperties(props, ["actions", "autoFocus", "autoFocusItem", "children", "className", "onKeyDown", "disableListWrap", "variant"]);

    var listRef = React__default.useRef(null);
    var textCriteriaRef = React__default.useRef({
      keys: [],
      repeating: true,
      previousKeyMatched: true,
      lastTime: null
    });
    useEnhancedEffect$8(function () {
      if (autoFocus) {
        listRef.current.focus();
      }
    }, [autoFocus]);
    React__default.useImperativeHandle(actions, function () {
      return {
        adjustStyleForScrollbar: function adjustStyleForScrollbar(containerElement, theme) {
          // Let's ignore that piece of logic if users are already overriding the width
          // of the menu.
          var noExplicitWidth = !listRef.current.style.width;

          if (containerElement.clientHeight < listRef.current.clientHeight && noExplicitWidth) {
            var scrollbarSize = "".concat(getScrollbarSize(), "px");
            listRef.current.style[theme.direction === 'rtl' ? 'paddingLeft' : 'paddingRight'] = scrollbarSize;
            listRef.current.style.width = "calc(100% + ".concat(scrollbarSize, ")");
          }

          return listRef.current;
        }
      };
    }, []);

    var handleKeyDown = function handleKeyDown(event) {
      var list = listRef.current;
      var key = event.key;
      /**
       * @type {Element} - will always be defined since we are in a keydown handler
       * attached to an element. A keydown event is either dispatched to the activeElement
       * or document.body or document.documentElement. Only the first case will
       * trigger this specific handler.
       */

      var currentFocus = ownerDocument(list).activeElement;

      if (key === 'ArrowDown') {
        // Prevent scroll of the page
        event.preventDefault();
        moveFocus(list, currentFocus, disableListWrap, nextItem);
      } else if (key === 'ArrowUp') {
        event.preventDefault();
        moveFocus(list, currentFocus, disableListWrap, previousItem);
      } else if (key === 'Home') {
        event.preventDefault();
        moveFocus(list, null, disableListWrap, nextItem);
      } else if (key === 'End') {
        event.preventDefault();
        moveFocus(list, null, disableListWrap, previousItem);
      } else if (key.length === 1) {
        var criteria = textCriteriaRef.current;
        var lowerKey = key.toLowerCase();
        var currTime = performance.now();

        if (criteria.keys.length > 0) {
          // Reset
          if (currTime - criteria.lastTime > 500) {
            criteria.keys = [];
            criteria.repeating = true;
            criteria.previousKeyMatched = true;
          } else if (criteria.repeating && lowerKey !== criteria.keys[0]) {
            criteria.repeating = false;
          }
        }

        criteria.lastTime = currTime;
        criteria.keys.push(lowerKey);
        var keepFocusOnCurrent = currentFocus && !criteria.repeating && textCriteriaMatches(currentFocus, criteria);

        if (criteria.previousKeyMatched && (keepFocusOnCurrent || moveFocus(list, currentFocus, false, nextItem, criteria))) {
          event.preventDefault();
        } else {
          criteria.previousKeyMatched = false;
        }
      }

      if (onKeyDown) {
        onKeyDown(event);
      }
    };

    var handleOwnRef = React__default.useCallback(function (instance) {
      // #StrictMode ready
      listRef.current = ReactDOM.findDOMNode(instance);
    }, []);
    var handleRef = useForkRef(handleOwnRef, ref);
    /**
     * the index of the item should receive focus
     * in a `variant="selectedMenu"` it's the first `selected` item
     * otherwise it's the very first item.
     */

    var activeItemIndex = -1; // since we inject focus related props into children we have to do a lookahead
    // to check if there is a `selected` item. We're looking for the last `selected`
    // item and use the first valid item as a fallback

    React__default.Children.forEach(children, function (child, index) {
      if (!React__default.isValidElement(child)) {
        return;
      }

      {
        if (child.type === React__default.Fragment) {
          console.error(["Material-UI: the Menu component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      if (!child.props.disabled) {
        if (variant === 'selectedMenu' && child.props.selected) {
          activeItemIndex = index;
        } else if (activeItemIndex === -1) {
          activeItemIndex = index;
        }
      }
    });
    var items = React__default.Children.map(children, function (child, index) {
      if (index === activeItemIndex) {
        var newChildProps = {};

        if (autoFocusItem) {
          newChildProps.autoFocus = true;
        }

        if (child.props.tabIndex === undefined && variant === 'selectedMenu') {
          newChildProps.tabIndex = 0;
        }

        if (newChildProps !== null) {
          return React__default.cloneElement(child, newChildProps);
        }
      }

      return child;
    });
    return React__default.createElement(List$1, _extends({
      role: "menu",
      ref: handleRef,
      className: className,
      onKeyDown: handleKeyDown,
      tabIndex: autoFocus ? 0 : -1
    }, other), items);
  });
   MenuList.propTypes = {
    /**
     * @ignore
     */
    actions: propTypes.shape({
      current: propTypes.object
    }),

    /**
     * If `true`, will focus the `[role="menu"]` container and move into tab order
     */
    autoFocus: propTypes.bool,

    /**
     * If `true`, will focus the first menuitem if `variant="menu"` or selected item
     * if `variant="selectedMenu"`
     */
    autoFocusItem: propTypes.bool,

    /**
     * MenuList contents, normally `MenuItem`s.
     */
    children: propTypes.node,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the menu items will not wrap focus.
     */
    disableListWrap: propTypes.bool,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * The variant to use. Use `menu` to prevent selected items from impacting the initial focus
     * and the vertical alignment relative to the anchor element.
     */
    variant: propTypes.oneOf(['menu', 'selectedMenu'])
  } ;

  var RTL_ORIGIN = {
    vertical: 'top',
    horizontal: 'right'
  };
  var LTR_ORIGIN = {
    vertical: 'top',
    horizontal: 'left'
  };
  var styles$18 = {
    /* Styles applied to the `Paper` component. */
    paper: {
      // specZ: The maximum height of a simple menu should be one or more rows less than the view
      // height. This ensures a tapable area outside of the simple menu with which to dismiss
      // the menu.
      maxHeight: 'calc(100% - 96px)',
      // Add iOS momentum scrolling.
      WebkitOverflowScrolling: 'touch'
    },

    /* Styles applied to the `List` component via `MenuList`. */
    list: {
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 0
    }
  };
  var Menu = React__default.forwardRef(function Menu(props, ref) {
    var _props$autoFocus = props.autoFocus,
        autoFocus = _props$autoFocus === void 0 ? true : _props$autoFocus,
        children = props.children,
        classes = props.classes,
        _props$disableAutoFoc = props.disableAutoFocusItem,
        disableAutoFocusItem = _props$disableAutoFoc === void 0 ? false : _props$disableAutoFoc,
        _props$MenuListProps = props.MenuListProps,
        MenuListProps = _props$MenuListProps === void 0 ? {} : _props$MenuListProps,
        onClose = props.onClose,
        onEntering = props.onEntering,
        open = props.open,
        _props$PaperProps = props.PaperProps,
        PaperProps = _props$PaperProps === void 0 ? {} : _props$PaperProps,
        PopoverClasses = props.PopoverClasses,
        _props$transitionDura = props.transitionDuration,
        transitionDuration = _props$transitionDura === void 0 ? 'auto' : _props$transitionDura,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'selectedMenu' : _props$variant,
        other = _objectWithoutProperties(props, ["autoFocus", "children", "classes", "disableAutoFocusItem", "MenuListProps", "onClose", "onEntering", "open", "PaperProps", "PopoverClasses", "transitionDuration", "variant"]);

    var theme = useTheme$1();
    var autoFocusItem = autoFocus && !disableAutoFocusItem && open;
    var menuListActionsRef = React__default.useRef(null);
    var contentAnchorRef = React__default.useRef(null);

    var getContentAnchorEl = function getContentAnchorEl() {
      return contentAnchorRef.current;
    };

    var handleEntering = function handleEntering(element, isAppearing) {
      if (menuListActionsRef.current) {
        menuListActionsRef.current.adjustStyleForScrollbar(element, theme);
      }

      if (onEntering) {
        onEntering(element, isAppearing);
      }
    };

    var handleListKeyDown = function handleListKeyDown(event) {
      if (event.key === 'Tab') {
        event.preventDefault();

        if (onClose) {
          onClose(event, 'tabKeyDown');
        }
      }
    };
    /**
     * the index of the item should receive focus
     * in a `variant="selectedMenu"` it's the first `selected` item
     * otherwise it's the very first item.
     */


    var activeItemIndex = -1; // since we inject focus related props into children we have to do a lookahead
    // to check if there is a `selected` item. We're looking for the last `selected`
    // item and use the first valid item as a fallback

    React__default.Children.map(children, function (child, index) {
      if (!React__default.isValidElement(child)) {
        return;
      }

      {
        if (child.type === React__default.Fragment) {
          console.error(["Material-UI: the Menu component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      if (!child.props.disabled) {
        if (variant !== "menu" && child.props.selected) {
          activeItemIndex = index;
        } else if (activeItemIndex === -1) {
          activeItemIndex = index;
        }
      }
    });
    var items = React__default.Children.map(children, function (child, index) {
      if (index === activeItemIndex) {
        return React__default.cloneElement(child, {
          ref: function ref(instance) {
            // #StrictMode ready
            contentAnchorRef.current = ReactDOM.findDOMNode(instance);
            setRef(child.ref, instance);
          }
        });
      }

      return child;
    });
    return React__default.createElement(Popover$1, _extends({
      getContentAnchorEl: getContentAnchorEl,
      classes: PopoverClasses,
      onClose: onClose,
      onEntering: handleEntering,
      anchorOrigin: theme.direction === 'rtl' ? RTL_ORIGIN : LTR_ORIGIN,
      transformOrigin: theme.direction === 'rtl' ? RTL_ORIGIN : LTR_ORIGIN,
      PaperProps: _extends({}, PaperProps, {
        classes: _extends({}, PaperProps.classes, {
          root: classes.paper
        })
      }),
      open: open,
      ref: ref,
      transitionDuration: transitionDuration
    }, other), React__default.createElement(MenuList, _extends({
      onKeyDown: handleListKeyDown,
      actions: menuListActionsRef,
      autoFocus: autoFocus && (activeItemIndex === -1 || disableAutoFocusItem),
      autoFocusItem: autoFocusItem,
      variant: variant
    }, MenuListProps, {
      className: clsx(classes.list, MenuListProps.className)
    }), items));
  });
   Menu.propTypes = {
    /**
     * The DOM element used to set the position of the menu.
     */
    anchorEl: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * If `true` (Default) will focus the `[role="menu"]` if no focusable child is found. Disabled
     * children are not focusable. If you set this prop to `false` focus will be placed
     * on the parent modal container. This has severe accessibility implications
     * and should only be considered if you manage focus otherwise.
     */
    autoFocus: propTypes.bool,

    /**
     * Menu contents, normally `MenuItem`s.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * When opening the menu will not focus the active item but the `[role="menu"]`
     * unless `autoFocus` is also set to `false`. Not using the default means not
     * following WAI-ARIA authoring practices. Please be considerate about possible
     * accessibility implications.
     */
    disableAutoFocusItem: propTypes.bool,

    /**
     * Props applied to the [`MenuList`](/api/menu-list/) element.
     */
    MenuListProps: propTypes.object,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be:`"escapeKeyDown"`, `"backdropClick"`, `"tabKeyDown"`.
     */
    onClose: propTypes.func,

    /**
     * Callback fired before the Menu enters.
     */
    onEnter: propTypes.func,

    /**
     * Callback fired when the Menu has entered.
     */
    onEntered: propTypes.func,

    /**
     * Callback fired when the Menu is entering.
     */
    onEntering: propTypes.func,

    /**
     * Callback fired before the Menu exits.
     */
    onExit: propTypes.func,

    /**
     * Callback fired when the Menu has exited.
     */
    onExited: propTypes.func,

    /**
     * Callback fired when the Menu is exiting.
     */
    onExiting: propTypes.func,

    /**
     * If `true`, the menu is visible.
     */
    open: propTypes.bool.isRequired,

    /**
     * @ignore
     */
    PaperProps: propTypes.object,

    /**
     * `classes` prop applied to the [`Popover`](/api/popover/) element.
     */
    PopoverClasses: propTypes.object,

    /**
     * The length of the transition in `ms`, or 'auto'
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])]),

    /**
     * The variant to use. Use `menu` to prevent selected items from impacting the initial focus
     * and the vertical alignment relative to the anchor element.
     */
    variant: propTypes.oneOf(['menu', 'selectedMenu'])
  } ;
  var Menu$1 = withStyles$1(styles$18, {
    name: 'MuiMenu'
  })(Menu);

  var styles$19 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends({}, theme.typography.body1, _defineProperty({
        minHeight: 48,
        paddingTop: 6,
        paddingBottom: 6,
        boxSizing: 'border-box',
        width: 'auto',
        overflow: 'hidden',
        whiteSpace: 'nowrap'
      }, theme.breakpoints.up('sm'), {
        minHeight: 'auto'
      })),
      // TODO To remove in v5?

      /* Styles applied to the root element if `disableGutters={false}`. */
      gutters: {},

      /* Styles applied to the root element if `selected={true}`. */
      selected: {},

      /* Styles applied to the root element if dense. */
      dense: _extends({}, theme.typography.body2, {
        minHeight: 'auto'
      })
    };
  };
  var MenuItem = React__default.forwardRef(function MenuItem(props, ref) {
    var classes = props.classes,
        className = props.className,
        _props$component = props.component,
        component = _props$component === void 0 ? 'li' : _props$component,
        _props$disableGutters = props.disableGutters,
        disableGutters = _props$disableGutters === void 0 ? false : _props$disableGutters,
        _props$role = props.role,
        role = _props$role === void 0 ? 'menuitem' : _props$role,
        selected = props.selected,
        tabIndexProp = props.tabIndex,
        other = _objectWithoutProperties(props, ["classes", "className", "component", "disableGutters", "role", "selected", "tabIndex"]);

    var tabIndex;

    if (!props.disabled) {
      tabIndex = tabIndexProp !== undefined ? tabIndexProp : -1;
    }

    return React__default.createElement(ListItem$1, _extends({
      button: true,
      role: role,
      tabIndex: tabIndex,
      component: component,
      selected: selected,
      disableGutters: disableGutters,
      classes: {
        dense: classes.dense
      },
      className: clsx(classes.root, className, selected && classes.selected, !disableGutters && classes.gutters),
      ref: ref
    }, other));
  });
   MenuItem.propTypes = {
    /**
     * Menu item contents.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * If `true`, compact vertical padding designed for keyboard and mouse input will be used.
     */
    dense: propTypes.bool,

    /**
     * @ignore
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the left and right padding is removed.
     */
    disableGutters: propTypes.bool,

    /**
     * @ignore
     */
    role: propTypes.string,

    /**
     * @ignore
     */
    selected: propTypes.bool,

    /**
     * @ignore
     */
    tabIndex: propTypes.number
  } ;
  var MenuItem$1 = withStyles$1(styles$19, {
    name: 'MuiMenuItem'
  })(MenuItem);

  var styles$1a = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center',
        background: theme.palette.background.default,
        padding: 8
      },

      /* Styles applied to the root element if `position="bottom"`. */
      positionBottom: {
        position: 'fixed',
        bottom: 0,
        left: 0,
        right: 0,
        zIndex: theme.zIndex.mobileStepper
      },

      /* Styles applied to the root element if `position="top"`. */
      positionTop: {
        position: 'fixed',
        top: 0,
        left: 0,
        right: 0,
        zIndex: theme.zIndex.mobileStepper
      },

      /* Styles applied to the root element if `position="static"`. */
      positionStatic: {},

      /* Styles applied to the dots container if `variant="dots"`. */
      dots: {
        display: 'flex',
        flexDirection: 'row'
      },

      /* Styles applied to each dot if `variant="dots"`. */
      dot: {
        backgroundColor: theme.palette.action.disabled,
        borderRadius: '50%',
        width: 8,
        height: 8,
        margin: '0 2px'
      },

      /* Styles applied to a dot if `variant="dots"` and this is the active step. */
      dotActive: {
        backgroundColor: theme.palette.primary.main
      },

      /* Styles applied to the Linear Progress component if `variant="progress"`. */
      progress: {
        width: '50%'
      }
    };
  };
  var MobileStepper = React__default.forwardRef(function MobileStepper(props, ref) {
    var _props$activeStep = props.activeStep,
        activeStep = _props$activeStep === void 0 ? 0 : _props$activeStep,
        backButton = props.backButton,
        classes = props.classes,
        className = props.className,
        LinearProgressProps = props.LinearProgressProps,
        nextButton = props.nextButton,
        _props$position = props.position,
        position = _props$position === void 0 ? 'bottom' : _props$position,
        steps = props.steps,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'dots' : _props$variant,
        other = _objectWithoutProperties(props, ["activeStep", "backButton", "classes", "className", "LinearProgressProps", "nextButton", "position", "steps", "variant"]);

    return React__default.createElement(Paper$1, _extends({
      square: true,
      elevation: 0,
      className: clsx(classes.root, classes["position".concat(capitalize(position))], className),
      ref: ref
    }, other), backButton, variant === 'text' && React__default.createElement(React__default.Fragment, null, activeStep + 1, " / ", steps), variant === 'dots' && React__default.createElement("div", {
      className: classes.dots
    }, _toConsumableArray(new Array(steps)).map(function (_, index) {
      return React__default.createElement("div", {
        key: index,
        className: clsx(classes.dot, index === activeStep && classes.dotActive)
      });
    })), variant === 'progress' && React__default.createElement(LinearProgress$1, _extends({
      className: classes.progress,
      variant: "determinate",
      value: Math.ceil(activeStep / (steps - 1) * 100)
    }, LinearProgressProps)), nextButton);
  });
   MobileStepper.propTypes = {
    /**
     * Set the active step (zero based index).
     * Defines which dot is highlighted when the variant is 'dots'.
     */
    activeStep: propTypes.number,

    /**
     * A back button element. For instance, it can be a `Button` or an `IconButton`.
     */
    backButton: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Props applied to the `LinearProgress` element.
     */
    LinearProgressProps: propTypes.object,

    /**
     * A next button element. For instance, it can be a `Button` or an `IconButton`.
     */
    nextButton: propTypes.node,

    /**
     * Set the positioning type.
     */
    position: propTypes.oneOf(['bottom', 'top', 'static']),

    /**
     * The total steps.
     */
    steps: propTypes.number.isRequired,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['text', 'dots', 'progress'])
  } ;
  var MobileStepper$1 = withStyles$1(styles$1a, {
    name: 'MuiMobileStepper'
  })(MobileStepper);

  /**
   * @ignore - internal component.
   */

  var NativeSelectInput = React__default.forwardRef(function NativeSelectInput(props, ref) {
    var classes = props.classes,
        className = props.className,
        disabled = props.disabled,
        IconComponent = props.IconComponent,
        inputRef = props.inputRef,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'standard' : _props$variant,
        other = _objectWithoutProperties(props, ["classes", "className", "disabled", "IconComponent", "inputRef", "variant"]);

    return React__default.createElement(React__default.Fragment, null, React__default.createElement("select", _extends({
      className: clsx(classes.root, // TODO v5: merge root and select
      classes.select, classes[variant], className, disabled && classes.disabled),
      disabled: disabled,
      ref: inputRef || ref
    }, other)), props.multiple ? null : React__default.createElement(IconComponent, {
      className: clsx(classes.icon, classes["icon".concat(capitalize(variant))])
    }));
  });
   NativeSelectInput.propTypes = {
    /**
     * The option elements to populate the select with.
     * Can be some `<option>` elements.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the select element.
     */
    className: propTypes.string,

    /**
     * If `true`, the select will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * The icon that displays the arrow.
     */
    IconComponent: propTypes.elementType,

    /**
     * Use that prop to pass a ref to the native select element.
     * @deprecated
     */
    inputRef: refType,

    /**
     * @ignore
     */
    multiple: propTypes.bool,

    /**
     * Name attribute of the `select` or hidden `input` element.
     */
    name: propTypes.string,

    /**
     * Callback function fired when a menu item is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: propTypes.func,

    /**
     * The input value.
     */
    value: propTypes.any,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  } ;

  /**
   * @ignore - internal component.
   */

  var ArrowDropDownIcon = createSvgIcon(React__default.createElement("path", {
    d: "M7 10l5 5 5-5z"
  }), 'ArrowDropDown');

  var styles$1b = function styles(theme) {
    return {
      /* Styles applied to the select component `root` class. */
      root: {},

      /* Styles applied to the select component `select` class. */
      select: {
        '-moz-appearance': 'none',
        // Reset
        '-webkit-appearance': 'none',
        // Reset
        // When interacting quickly, the text can end up selected.
        // Native select can't be selected either.
        userSelect: 'none',
        borderRadius: 0,
        // Reset
        minWidth: 16,
        // So it doesn't collapse.
        cursor: 'pointer',
        '&:focus': {
          // Show that it's not an text input
          backgroundColor: theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.05)' : 'rgba(255, 255, 255, 0.05)',
          borderRadius: 0 // Reset Chrome style

        },
        // Remove IE 11 arrow
        '&::-ms-expand': {
          display: 'none'
        },
        '&$disabled': {
          cursor: 'default'
        },
        '&[multiple]': {
          height: 'auto'
        },
        '&:not([multiple]) option, &:not([multiple]) optgroup': {
          backgroundColor: theme.palette.background.paper
        }
      },

      /* Styles applied to the select component if `variant="filled"`. */
      filled: {},

      /* Styles applied to the select component if `variant="outlined"`. */
      outlined: {
        borderRadius: theme.shape.borderRadius
      },

      /* Styles applied to the select component `selectMenu` class. */
      selectMenu: {
        height: 'auto',
        // Reset
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        overflow: 'hidden'
      },

      /* Pseudo-class applied to the select component `disabled` class. */
      disabled: {},

      /* Styles applied to the icon component. */
      icon: {
        // We use a position absolute over a flexbox in order to forward the pointer events
        // to the input.
        position: 'absolute',
        right: 0,
        top: 'calc(50% - 12px)',
        // Center vertically
        color: theme.palette.action.active,
        pointerEvents: 'none' // Don't block pointer events on the select under the icon.

      },

      /* Styles applied to the icon component if the popup is open. */
      iconOpen: {
        transform: 'rotate(180deg)'
      },

      /* Styles applied to the icon component if `variant="filled"`. */
      iconFilled: {
        right: 7
      },

      /* Styles applied to the icon component if `variant="outlined"`. */
      iconOutlined: {
        right: 7
      }
    };
  };
  var defaultInput = React__default.createElement(Input$1, null);
  /**
   * An alternative to `<Select native />` with a much smaller bundle size footprint.
   */

  var NativeSelect = React__default.forwardRef(function NativeSelect(props, ref) {
    var children = props.children,
        classes = props.classes,
        _props$IconComponent = props.IconComponent,
        IconComponent = _props$IconComponent === void 0 ? ArrowDropDownIcon : _props$IconComponent,
        _props$input = props.input,
        input = _props$input === void 0 ? defaultInput : _props$input,
        inputProps = props.inputProps,
        variant = props.variant,
        other = _objectWithoutProperties(props, ["children", "classes", "IconComponent", "input", "inputProps", "variant"]);

    var muiFormControl = useFormControl$1();
    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['variant']
    });
    return React__default.cloneElement(input, _extends({
      // Most of the logic is implemented in `NativeSelectInput`.
      // The `Select` component is a simple API wrapper to expose something better to play with.
      inputComponent: NativeSelectInput,
      select: true,
      inputProps: _extends({
        children: children,
        classes: classes,
        IconComponent: IconComponent,
        variant: fcs.variant,
        type: undefined
      }, inputProps, {}, input ? input.props.inputProps : {}),
      ref: ref
    }, other));
  });
   NativeSelect.propTypes = {
    /**
     * The option elements to populate the select with.
     * Can be some `<option>` elements.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The icon that displays the arrow.
     */
    IconComponent: propTypes.elementType,

    /**
     * An `Input` element; does not have to be a material-ui specific `Input`.
     */
    input: propTypes.element,

    /**
     * Attributes applied to the `select` element.
     */
    inputProps: propTypes.object,

    /**
     * Callback function fired when a menu item is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: propTypes.func,

    /**
     * The input value. The DOM API casts this to a string.
     */
    value: propTypes.any,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  } ;
  NativeSelect.muiName = 'Select';
  var NativeSelect$1 = withStyles$1(styles$1b, {
    name: 'MuiNativeSelect'
  })(NativeSelect);

  var styles$1c = function styles(theme) {
    var align = theme.direction === 'rtl' ? 'right' : 'left';
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'absolute',
        bottom: 0,
        right: 0,
        top: -5,
        left: 0,
        margin: 0,
        padding: 0,
        pointerEvents: 'none',
        borderRadius: 'inherit',
        borderStyle: 'solid',
        borderWidth: 1,
        // Match the Input Label
        transition: theme.transitions.create(["padding-".concat(align), 'border-color', 'border-width'], {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        })
      },

      /* Styles applied to the legend element. */
      legend: {
        textAlign: 'left',
        padding: 0,
        lineHeight: '11px',
        transition: theme.transitions.create('width', {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        })
      }
    };
  };
  /**
   * @ignore - internal component.
   */

  var NotchedOutline = React__default.forwardRef(function NotchedOutline(props, ref) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        labelWidthProp = props.labelWidth,
        notched = props.notched,
        style = props.style,
        other = _objectWithoutProperties(props, ["children", "classes", "className", "labelWidth", "notched", "style"]);

    var theme = useTheme$1();
    var align = theme.direction === 'rtl' ? 'right' : 'left';
    var labelWidth = labelWidthProp > 0 ? labelWidthProp * 0.75 + 8 : 0;
    return React__default.createElement("fieldset", _extends({
      "aria-hidden": true,
      style: _extends(_defineProperty({}, "padding".concat(capitalize(align)), 8 + (notched ? 0 : labelWidth / 2)), style),
      className: clsx(classes.root, className),
      ref: ref
    }, other), React__default.createElement("legend", {
      className: classes.legend,
      style: {
        // IE 11: fieldset with legend does not render
        // a border radius. This maintains consistency
        // by always having a legend rendered
        width: notched ? labelWidth : 0.01
      }
    }, React__default.createElement("span", {
      dangerouslySetInnerHTML: {
        __html: '&#8203;'
      }
    })));
  });
   NotchedOutline.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The width of the label.
     */
    labelWidth: propTypes.number.isRequired,

    /**
     * If `true`, the outline is notched to accommodate the label.
     */
    notched: propTypes.bool.isRequired,

    /**
     * @ignore
     */
    style: propTypes.object
  } ;
  var NotchedOutline$1 = withStyles$1(styles$1c, {
    name: 'PrivateNotchedOutline'
  })(NotchedOutline);

  var styles$1d = function styles(theme) {
    var borderColor = theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)';
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        borderRadius: theme.shape.borderRadius,
        '&:hover $notchedOutline': {
          borderColor: theme.palette.text.primary
        },
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          '&:hover $notchedOutline': {
            borderColor: borderColor
          }
        },
        '&$focused $notchedOutline': {
          borderColor: theme.palette.primary.main,
          borderWidth: 2
        },
        '&$error $notchedOutline': {
          borderColor: theme.palette.error.main
        },
        '&$disabled $notchedOutline': {
          borderColor: theme.palette.action.disabled
        }
      },

      /* Styles applied to the root element if the color is secondary. */
      colorSecondary: {
        '&$focused $notchedOutline': {
          borderColor: theme.palette.secondary.main
        }
      },

      /* Styles applied to the root element if the component is focused. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `startAdornment` is provided. */
      adornedStart: {
        paddingLeft: 14
      },

      /* Styles applied to the root element if `endAdornment` is provided. */
      adornedEnd: {
        paddingRight: 14
      },

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the `input` element if `margin="dense"`. */
      marginDense: {},

      /* Styles applied to the root element if `multiline={true}`. */
      multiline: {
        padding: '18.5px 14px',
        '&$marginDense': {
          paddingTop: 10.5,
          paddingBottom: 10.5
        }
      },

      /* Styles applied to the `NotchedOutline` element. */
      notchedOutline: {
        borderColor: borderColor
      },

      /* Styles applied to the `input` element. */
      input: {
        padding: '18.5px 14px',
        '&:-webkit-autofill': {
          WebkitBoxShadow: theme.palette.type === 'dark' ? '0 0 0 100px #266798 inset' : null,
          WebkitTextFillColor: theme.palette.type === 'dark' ? '#fff' : null,
          borderRadius: 'inherit'
        }
      },

      /* Styles applied to the `input` element if `margin="dense"`. */
      inputMarginDense: {
        paddingTop: 10.5,
        paddingBottom: 10.5
      },

      /* Styles applied to the `input` element if `select={true}`. */
      inputSelect: {
        paddingRight: 24
      },

      /* Styles applied to the `input` element if `multiline={true}`. */
      inputMultiline: {
        padding: 0
      },

      /* Styles applied to the `input` element if `startAdornment` is provided. */
      inputAdornedStart: {
        paddingLeft: 0
      },

      /* Styles applied to the `input` element if `endAdornment` is provided. */
      inputAdornedEnd: {
        paddingRight: 0
      }
    };
  };
  var OutlinedInput = React__default.forwardRef(function OutlinedInput(props, ref) {
    var classes = props.classes,
        _props$fullWidth = props.fullWidth,
        fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
        _props$inputComponent = props.inputComponent,
        inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
        _props$labelWidth = props.labelWidth,
        labelWidth = _props$labelWidth === void 0 ? 0 : _props$labelWidth,
        _props$multiline = props.multiline,
        multiline = _props$multiline === void 0 ? false : _props$multiline,
        notched = props.notched,
        _props$type = props.type,
        type = _props$type === void 0 ? 'text' : _props$type,
        other = _objectWithoutProperties(props, ["classes", "fullWidth", "inputComponent", "labelWidth", "multiline", "notched", "type"]);

    return React__default.createElement(InputBase$1, _extends({
      renderSuffix: function renderSuffix(state) {
        return React__default.createElement(NotchedOutline$1, {
          className: classes.notchedOutline,
          labelWidth: labelWidth,
          notched: typeof notched !== 'undefined' ? notched : Boolean(state.startAdornment || state.filled || state.focused)
        });
      },
      classes: _extends({}, classes, {
        root: clsx(classes.root, classes.underline),
        notchedOutline: null
      }),
      fullWidth: fullWidth,
      inputComponent: inputComponent,
      multiline: multiline,
      ref: ref,
      type: type
    }, other));
  });
   OutlinedInput.propTypes = {
    /**
     * This prop helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
     */
    autoComplete: propTypes.string,

    /**
     * If `true`, the `input` element will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the wrapper element.
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The default `input` element value. Use when the component is not controlled.
     */
    defaultValue: propTypes.any,

    /**
     * If `true`, the `input` element will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: propTypes.node,

    /**
     * If `true`, the input will indicate an error. This is normally obtained via context from
     * FormControl.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * The component used for the native input.
     * Either a string to use a DOM element or a component.
     */
    inputComponent: propTypes.elementType,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType,

    /**
     * The width of the label.
     */
    labelWidth: propTypes.number,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense', 'none']),

    /**
     * If `true`, a textarea element will be rendered.
     */
    multiline: propTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * If `true`, the outline is notched to accommodate the label.
     */
    notched: propTypes.bool,

    /**
     * Callback fired when the value is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: propTypes.func,

    /**
     * The short hint displayed in the input before the user enters a value.
     */
    placeholder: propTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * If `true`, the `input` element will be required.
     */
    required: propTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: propTypes.node,

    /**
     * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
     */
    type: propTypes.string,

    /**
     * The value of the `input` element, required for a controlled component.
     */
    value: propTypes.any
  } ;
  OutlinedInput.muiName = 'Input';
  var OutlinedInput$1 = withStyles$1(styles$1d, {
    name: 'MuiOutlinedInput'
  })(OutlinedInput);

  /**!
   * @fileOverview Kickass library to create and place poppers near their reference elements.
   * @version 1.16.0
   * @license
   * Copyright (c) 2016 Federico Zivolo and contributors
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to deal
   * in the Software without restriction, including without limitation the rights
   * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   * copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in all
   * copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   * SOFTWARE.
   */
  var isBrowser$1 = typeof window !== 'undefined' && typeof document !== 'undefined' && typeof navigator !== 'undefined';

  var timeoutDuration = function () {
    var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];
    for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
      if (isBrowser$1 && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
        return 1;
      }
    }
    return 0;
  }();

  function microtaskDebounce(fn) {
    var called = false;
    return function () {
      if (called) {
        return;
      }
      called = true;
      window.Promise.resolve().then(function () {
        called = false;
        fn();
      });
    };
  }

  function taskDebounce(fn) {
    var scheduled = false;
    return function () {
      if (!scheduled) {
        scheduled = true;
        setTimeout(function () {
          scheduled = false;
          fn();
        }, timeoutDuration);
      }
    };
  }

  var supportsMicroTasks = isBrowser$1 && window.Promise;

  /**
  * Create a debounced version of a method, that's asynchronously deferred
  * but called in the minimum time possible.
  *
  * @method
  * @memberof Popper.Utils
  * @argument {Function} fn
  * @returns {Function}
  */
  var debounce$1 = supportsMicroTasks ? microtaskDebounce : taskDebounce;

  /**
   * Check if the given variable is a function
   * @method
   * @memberof Popper.Utils
   * @argument {Any} functionToCheck - variable to check
   * @returns {Boolean} answer to: is a function?
   */
  function isFunction(functionToCheck) {
    var getType = {};
    return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
  }

  /**
   * Get CSS computed property of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Eement} element
   * @argument {String} property
   */
  function getStyleComputedProperty(element, property) {
    if (element.nodeType !== 1) {
      return [];
    }
    // NOTE: 1 DOM access here
    var window = element.ownerDocument.defaultView;
    var css = window.getComputedStyle(element, null);
    return property ? css[property] : css;
  }

  /**
   * Returns the parentNode or the host of the element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} parent
   */
  function getParentNode(element) {
    if (element.nodeName === 'HTML') {
      return element;
    }
    return element.parentNode || element.host;
  }

  /**
   * Returns the scrolling parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} scroll parent
   */
  function getScrollParent$1(element) {
    // Return body, `getScroll` will take care to get the correct `scrollTop` from it
    if (!element) {
      return document.body;
    }

    switch (element.nodeName) {
      case 'HTML':
      case 'BODY':
        return element.ownerDocument.body;
      case '#document':
        return element.body;
    }

    // Firefox want us to check `-x` and `-y` variations as well

    var _getStyleComputedProp = getStyleComputedProperty(element),
        overflow = _getStyleComputedProp.overflow,
        overflowX = _getStyleComputedProp.overflowX,
        overflowY = _getStyleComputedProp.overflowY;

    if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
      return element;
    }

    return getScrollParent$1(getParentNode(element));
  }

  /**
   * Returns the reference node of the reference object, or the reference object itself.
   * @method
   * @memberof Popper.Utils
   * @param {Element|Object} reference - the reference element (the popper will be relative to this)
   * @returns {Element} parent
   */
  function getReferenceNode(reference) {
    return reference && reference.referenceNode ? reference.referenceNode : reference;
  }

  var isIE11 = isBrowser$1 && !!(window.MSInputMethodContext && document.documentMode);
  var isIE10 = isBrowser$1 && /MSIE 10/.test(navigator.userAgent);

  /**
   * Determines if the browser is Internet Explorer
   * @method
   * @memberof Popper.Utils
   * @param {Number} version to check
   * @returns {Boolean} isIE
   */
  function isIE(version) {
    if (version === 11) {
      return isIE11;
    }
    if (version === 10) {
      return isIE10;
    }
    return isIE11 || isIE10;
  }

  /**
   * Returns the offset parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} offset parent
   */
  function getOffsetParent(element) {
    if (!element) {
      return document.documentElement;
    }

    var noOffsetParent = isIE(10) ? document.body : null;

    // NOTE: 1 DOM access here
    var offsetParent = element.offsetParent || null;
    // Skip hidden elements which don't have an offsetParent
    while (offsetParent === noOffsetParent && element.nextElementSibling) {
      offsetParent = (element = element.nextElementSibling).offsetParent;
    }

    var nodeName = offsetParent && offsetParent.nodeName;

    if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
      return element ? element.ownerDocument.documentElement : document.documentElement;
    }

    // .offsetParent will return the closest TH, TD or TABLE in case
    // no offsetParent is present, I hate this job...
    if (['TH', 'TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
      return getOffsetParent(offsetParent);
    }

    return offsetParent;
  }

  function isOffsetContainer(element) {
    var nodeName = element.nodeName;

    if (nodeName === 'BODY') {
      return false;
    }
    return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
  }

  /**
   * Finds the root node (document, shadowDOM root) of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} node
   * @returns {Element} root node
   */
  function getRoot(node) {
    if (node.parentNode !== null) {
      return getRoot(node.parentNode);
    }

    return node;
  }

  /**
   * Finds the offset parent common to the two provided nodes
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element1
   * @argument {Element} element2
   * @returns {Element} common offset parent
   */
  function findCommonOffsetParent(element1, element2) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
      return document.documentElement;
    }

    // Here we make sure to give as "start" the element that comes first in the DOM
    var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
    var start = order ? element1 : element2;
    var end = order ? element2 : element1;

    // Get common ancestor container
    var range = document.createRange();
    range.setStart(start, 0);
    range.setEnd(end, 0);
    var commonAncestorContainer = range.commonAncestorContainer;

    // Both nodes are inside #document

    if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
      if (isOffsetContainer(commonAncestorContainer)) {
        return commonAncestorContainer;
      }

      return getOffsetParent(commonAncestorContainer);
    }

    // one of the nodes is inside shadowDOM, find which one
    var element1root = getRoot(element1);
    if (element1root.host) {
      return findCommonOffsetParent(element1root.host, element2);
    } else {
      return findCommonOffsetParent(element1, getRoot(element2).host);
    }
  }

  /**
   * Gets the scroll value of the given element in the given side (top and left)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {String} side `top` or `left`
   * @returns {number} amount of scrolled pixels
   */
  function getScroll(element) {
    var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';

    var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
    var nodeName = element.nodeName;

    if (nodeName === 'BODY' || nodeName === 'HTML') {
      var html = element.ownerDocument.documentElement;
      var scrollingElement = element.ownerDocument.scrollingElement || html;
      return scrollingElement[upperSide];
    }

    return element[upperSide];
  }

  /*
   * Sum or subtract the element scroll values (left and top) from a given rect object
   * @method
   * @memberof Popper.Utils
   * @param {Object} rect - Rect object you want to change
   * @param {HTMLElement} element - The element from the function reads the scroll values
   * @param {Boolean} subtract - set to true if you want to subtract the scroll values
   * @return {Object} rect - The modifier rect object
   */
  function includeScroll(rect, element) {
    var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    var scrollTop = getScroll(element, 'top');
    var scrollLeft = getScroll(element, 'left');
    var modifier = subtract ? -1 : 1;
    rect.top += scrollTop * modifier;
    rect.bottom += scrollTop * modifier;
    rect.left += scrollLeft * modifier;
    rect.right += scrollLeft * modifier;
    return rect;
  }

  /*
   * Helper to detect borders of a given element
   * @method
   * @memberof Popper.Utils
   * @param {CSSStyleDeclaration} styles
   * Result of `getStyleComputedProperty` on the given element
   * @param {String} axis - `x` or `y`
   * @return {number} borders - The borders size of the given axis
   */

  function getBordersSize(styles, axis) {
    var sideA = axis === 'x' ? 'Left' : 'Top';
    var sideB = sideA === 'Left' ? 'Right' : 'Bottom';

    return parseFloat(styles['border' + sideA + 'Width'], 10) + parseFloat(styles['border' + sideB + 'Width'], 10);
  }

  function getSize(axis, body, html, computedStyle) {
    return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE(10) ? parseInt(html['offset' + axis]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')]) : 0);
  }

  function getWindowSizes(document) {
    var body = document.body;
    var html = document.documentElement;
    var computedStyle = isIE(10) && getComputedStyle(html);

    return {
      height: getSize('Height', body, html, computedStyle),
      width: getSize('Width', body, html, computedStyle)
    };
  }

  var classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

  var createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();





  var defineProperty$1 = function (obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  };

  var _extends$1 = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  /**
   * Given element offsets, generate an output similar to getBoundingClientRect
   * @method
   * @memberof Popper.Utils
   * @argument {Object} offsets
   * @returns {Object} ClientRect like output
   */
  function getClientRect(offsets) {
    return _extends$1({}, offsets, {
      right: offsets.left + offsets.width,
      bottom: offsets.top + offsets.height
    });
  }

  /**
   * Get bounding client rect of given element
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} element
   * @return {Object} client rect
   */
  function getBoundingClientRect(element) {
    var rect = {};

    // IE10 10 FIX: Please, don't ask, the element isn't
    // considered in DOM in some circumstances...
    // This isn't reproducible in IE10 compatibility mode of IE11
    try {
      if (isIE(10)) {
        rect = element.getBoundingClientRect();
        var scrollTop = getScroll(element, 'top');
        var scrollLeft = getScroll(element, 'left');
        rect.top += scrollTop;
        rect.left += scrollLeft;
        rect.bottom += scrollTop;
        rect.right += scrollLeft;
      } else {
        rect = element.getBoundingClientRect();
      }
    } catch (e) {}

    var result = {
      left: rect.left,
      top: rect.top,
      width: rect.right - rect.left,
      height: rect.bottom - rect.top
    };

    // subtract scrollbar size from sizes
    var sizes = element.nodeName === 'HTML' ? getWindowSizes(element.ownerDocument) : {};
    var width = sizes.width || element.clientWidth || result.width;
    var height = sizes.height || element.clientHeight || result.height;

    var horizScrollbar = element.offsetWidth - width;
    var vertScrollbar = element.offsetHeight - height;

    // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
    // we make this check conditional for performance reasons
    if (horizScrollbar || vertScrollbar) {
      var styles = getStyleComputedProperty(element);
      horizScrollbar -= getBordersSize(styles, 'x');
      vertScrollbar -= getBordersSize(styles, 'y');

      result.width -= horizScrollbar;
      result.height -= vertScrollbar;
    }

    return getClientRect(result);
  }

  function getOffsetRectRelativeToArbitraryNode(children, parent) {
    var fixedPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    var isIE10 = isIE(10);
    var isHTML = parent.nodeName === 'HTML';
    var childrenRect = getBoundingClientRect(children);
    var parentRect = getBoundingClientRect(parent);
    var scrollParent = getScrollParent$1(children);

    var styles = getStyleComputedProperty(parent);
    var borderTopWidth = parseFloat(styles.borderTopWidth, 10);
    var borderLeftWidth = parseFloat(styles.borderLeftWidth, 10);

    // In cases where the parent is fixed, we must ignore negative scroll in offset calc
    if (fixedPosition && isHTML) {
      parentRect.top = Math.max(parentRect.top, 0);
      parentRect.left = Math.max(parentRect.left, 0);
    }
    var offsets = getClientRect({
      top: childrenRect.top - parentRect.top - borderTopWidth,
      left: childrenRect.left - parentRect.left - borderLeftWidth,
      width: childrenRect.width,
      height: childrenRect.height
    });
    offsets.marginTop = 0;
    offsets.marginLeft = 0;

    // Subtract margins of documentElement in case it's being used as parent
    // we do this only on HTML because it's the only element that behaves
    // differently when margins are applied to it. The margins are included in
    // the box of the documentElement, in the other cases not.
    if (!isIE10 && isHTML) {
      var marginTop = parseFloat(styles.marginTop, 10);
      var marginLeft = parseFloat(styles.marginLeft, 10);

      offsets.top -= borderTopWidth - marginTop;
      offsets.bottom -= borderTopWidth - marginTop;
      offsets.left -= borderLeftWidth - marginLeft;
      offsets.right -= borderLeftWidth - marginLeft;

      // Attach marginTop and marginLeft because in some circumstances we may need them
      offsets.marginTop = marginTop;
      offsets.marginLeft = marginLeft;
    }

    if (isIE10 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
      offsets = includeScroll(offsets, parent);
    }

    return offsets;
  }

  function getViewportOffsetRectRelativeToArtbitraryNode(element) {
    var excludeScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var html = element.ownerDocument.documentElement;
    var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
    var width = Math.max(html.clientWidth, window.innerWidth || 0);
    var height = Math.max(html.clientHeight, window.innerHeight || 0);

    var scrollTop = !excludeScroll ? getScroll(html) : 0;
    var scrollLeft = !excludeScroll ? getScroll(html, 'left') : 0;

    var offset = {
      top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
      left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
      width: width,
      height: height
    };

    return getClientRect(offset);
  }

  /**
   * Check if the given element is fixed or is inside a fixed parent
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {Element} customContainer
   * @returns {Boolean} answer to "isFixed?"
   */
  function isFixed(element) {
    var nodeName = element.nodeName;
    if (nodeName === 'BODY' || nodeName === 'HTML') {
      return false;
    }
    if (getStyleComputedProperty(element, 'position') === 'fixed') {
      return true;
    }
    var parentNode = getParentNode(element);
    if (!parentNode) {
      return false;
    }
    return isFixed(parentNode);
  }

  /**
   * Finds the first parent of an element that has a transformed property defined
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} first transformed parent or documentElement
   */

  function getFixedPositionOffsetParent(element) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element || !element.parentElement || isIE()) {
      return document.documentElement;
    }
    var el = element.parentElement;
    while (el && getStyleComputedProperty(el, 'transform') === 'none') {
      el = el.parentElement;
    }
    return el || document.documentElement;
  }

  /**
   * Computed the boundaries limits and return them
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} popper
   * @param {HTMLElement} reference
   * @param {number} padding
   * @param {HTMLElement} boundariesElement - Element used to define the boundaries
   * @param {Boolean} fixedPosition - Is in fixed position mode
   * @returns {Object} Coordinates of the boundaries
   */
  function getBoundaries(popper, reference, padding, boundariesElement) {
    var fixedPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

    // NOTE: 1 DOM access here

    var boundaries = { top: 0, left: 0 };
    var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference));

    // Handle viewport case
    if (boundariesElement === 'viewport') {
      boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
    } else {
      // Handle other cases based on DOM element used as boundaries
      var boundariesNode = void 0;
      if (boundariesElement === 'scrollParent') {
        boundariesNode = getScrollParent$1(getParentNode(reference));
        if (boundariesNode.nodeName === 'BODY') {
          boundariesNode = popper.ownerDocument.documentElement;
        }
      } else if (boundariesElement === 'window') {
        boundariesNode = popper.ownerDocument.documentElement;
      } else {
        boundariesNode = boundariesElement;
      }

      var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition);

      // In case of HTML, we need a different computation
      if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
        var _getWindowSizes = getWindowSizes(popper.ownerDocument),
            height = _getWindowSizes.height,
            width = _getWindowSizes.width;

        boundaries.top += offsets.top - offsets.marginTop;
        boundaries.bottom = height + offsets.top;
        boundaries.left += offsets.left - offsets.marginLeft;
        boundaries.right = width + offsets.left;
      } else {
        // for all the other DOM elements, this one is good
        boundaries = offsets;
      }
    }

    // Add paddings
    padding = padding || 0;
    var isPaddingNumber = typeof padding === 'number';
    boundaries.left += isPaddingNumber ? padding : padding.left || 0;
    boundaries.top += isPaddingNumber ? padding : padding.top || 0;
    boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
    boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;

    return boundaries;
  }

  function getArea(_ref) {
    var width = _ref.width,
        height = _ref.height;

    return width * height;
  }

  /**
   * Utility used to transform the `auto` placement to the placement with more
   * available space.
   * @method
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
    var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;

    if (placement.indexOf('auto') === -1) {
      return placement;
    }

    var boundaries = getBoundaries(popper, reference, padding, boundariesElement);

    var rects = {
      top: {
        width: boundaries.width,
        height: refRect.top - boundaries.top
      },
      right: {
        width: boundaries.right - refRect.right,
        height: boundaries.height
      },
      bottom: {
        width: boundaries.width,
        height: boundaries.bottom - refRect.bottom
      },
      left: {
        width: refRect.left - boundaries.left,
        height: boundaries.height
      }
    };

    var sortedAreas = Object.keys(rects).map(function (key) {
      return _extends$1({
        key: key
      }, rects[key], {
        area: getArea(rects[key])
      });
    }).sort(function (a, b) {
      return b.area - a.area;
    });

    var filteredAreas = sortedAreas.filter(function (_ref2) {
      var width = _ref2.width,
          height = _ref2.height;
      return width >= popper.clientWidth && height >= popper.clientHeight;
    });

    var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;

    var variation = placement.split('-')[1];

    return computedPlacement + (variation ? '-' + variation : '');
  }

  /**
   * Get offsets to the reference element
   * @method
   * @memberof Popper.Utils
   * @param {Object} state
   * @param {Element} popper - the popper element
   * @param {Element} reference - the reference element (the popper will be relative to this)
   * @param {Element} fixedPosition - is in fixed position mode
   * @returns {Object} An object containing the offsets which will be applied to the popper
   */
  function getReferenceOffsets(state, popper, reference) {
    var fixedPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

    var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference));
    return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
  }

  /**
   * Get the outer sizes of the given element (offset size + margins)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Object} object containing width and height properties
   */
  function getOuterSizes(element) {
    var window = element.ownerDocument.defaultView;
    var styles = window.getComputedStyle(element);
    var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
    var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
    var result = {
      width: element.offsetWidth + y,
      height: element.offsetHeight + x
    };
    return result;
  }

  /**
   * Get the opposite placement of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement
   * @returns {String} flipped placement
   */
  function getOppositePlacement(placement) {
    var hash = { left: 'right', right: 'left', bottom: 'top', top: 'bottom' };
    return placement.replace(/left|right|bottom|top/g, function (matched) {
      return hash[matched];
    });
  }

  /**
   * Get offsets to the popper
   * @method
   * @memberof Popper.Utils
   * @param {Object} position - CSS position the Popper will get applied
   * @param {HTMLElement} popper - the popper element
   * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
   * @param {String} placement - one of the valid placement options
   * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
   */
  function getPopperOffsets(popper, referenceOffsets, placement) {
    placement = placement.split('-')[0];

    // Get popper node sizes
    var popperRect = getOuterSizes(popper);

    // Add position, width and height to our offsets object
    var popperOffsets = {
      width: popperRect.width,
      height: popperRect.height
    };

    // depending by the popper placement we have to compute its offsets slightly differently
    var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
    var mainSide = isHoriz ? 'top' : 'left';
    var secondarySide = isHoriz ? 'left' : 'top';
    var measurement = isHoriz ? 'height' : 'width';
    var secondaryMeasurement = !isHoriz ? 'height' : 'width';

    popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;
    if (placement === secondarySide) {
      popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
    } else {
      popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
    }

    return popperOffsets;
  }

  /**
   * Mimics the `find` method of Array
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */
  function find(arr, check) {
    // use native find if supported
    if (Array.prototype.find) {
      return arr.find(check);
    }

    // use `filter` to obtain the same behavior of `find`
    return arr.filter(check)[0];
  }

  /**
   * Return the index of the matching object
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */
  function findIndex(arr, prop, value) {
    // use native findIndex if supported
    if (Array.prototype.findIndex) {
      return arr.findIndex(function (cur) {
        return cur[prop] === value;
      });
    }

    // use `find` + `indexOf` if `findIndex` isn't supported
    var match = find(arr, function (obj) {
      return obj[prop] === value;
    });
    return arr.indexOf(match);
  }

  /**
   * Loop trough the list of modifiers and run them in order,
   * each of them will then edit the data object.
   * @method
   * @memberof Popper.Utils
   * @param {dataObject} data
   * @param {Array} modifiers
   * @param {String} ends - Optional modifier name used as stopper
   * @returns {dataObject}
   */
  function runModifiers(modifiers, data, ends) {
    var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex(modifiers, 'name', ends));

    modifiersToRun.forEach(function (modifier) {
      if (modifier['function']) {
        // eslint-disable-line dot-notation
        console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
      }
      var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation
      if (modifier.enabled && isFunction(fn)) {
        // Add properties to offsets to make them a complete clientRect object
        // we do this before each modifier to make sure the previous one doesn't
        // mess with these values
        data.offsets.popper = getClientRect(data.offsets.popper);
        data.offsets.reference = getClientRect(data.offsets.reference);

        data = fn(data, modifier);
      }
    });

    return data;
  }

  /**
   * Updates the position of the popper, computing the new offsets and applying
   * the new style.<br />
   * Prefer `scheduleUpdate` over `update` because of performance reasons.
   * @method
   * @memberof Popper
   */
  function update$1() {
    // if popper is destroyed, don't perform any further update
    if (this.state.isDestroyed) {
      return;
    }

    var data = {
      instance: this,
      styles: {},
      arrowStyles: {},
      attributes: {},
      flipped: false,
      offsets: {}
    };

    // compute reference element offsets
    data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed);

    // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value
    data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding);

    // store the computed placement inside `originalPlacement`
    data.originalPlacement = data.placement;

    data.positionFixed = this.options.positionFixed;

    // compute the popper offsets
    data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);

    data.offsets.popper.position = this.options.positionFixed ? 'fixed' : 'absolute';

    // run the modifiers
    data = runModifiers(this.modifiers, data);

    // the first `update` will call `onCreate` callback
    // the other ones will call `onUpdate` callback
    if (!this.state.isCreated) {
      this.state.isCreated = true;
      this.options.onCreate(data);
    } else {
      this.options.onUpdate(data);
    }
  }

  /**
   * Helper used to know if the given modifier is enabled.
   * @method
   * @memberof Popper.Utils
   * @returns {Boolean}
   */
  function isModifierEnabled(modifiers, modifierName) {
    return modifiers.some(function (_ref) {
      var name = _ref.name,
          enabled = _ref.enabled;
      return enabled && name === modifierName;
    });
  }

  /**
   * Get the prefixed supported property name
   * @method
   * @memberof Popper.Utils
   * @argument {String} property (camelCase)
   * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
   */
  function getSupportedPropertyName(property) {
    var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
    var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

    for (var i = 0; i < prefixes.length; i++) {
      var prefix = prefixes[i];
      var toCheck = prefix ? '' + prefix + upperProp : property;
      if (typeof document.body.style[toCheck] !== 'undefined') {
        return toCheck;
      }
    }
    return null;
  }

  /**
   * Destroys the popper.
   * @method
   * @memberof Popper
   */
  function destroy() {
    this.state.isDestroyed = true;

    // touch DOM only if `applyStyle` modifier is enabled
    if (isModifierEnabled(this.modifiers, 'applyStyle')) {
      this.popper.removeAttribute('x-placement');
      this.popper.style.position = '';
      this.popper.style.top = '';
      this.popper.style.left = '';
      this.popper.style.right = '';
      this.popper.style.bottom = '';
      this.popper.style.willChange = '';
      this.popper.style[getSupportedPropertyName('transform')] = '';
    }

    this.disableEventListeners();

    // remove the popper if user explicitly asked for the deletion on destroy
    // do not use `remove` because IE11 doesn't support it
    if (this.options.removeOnDestroy) {
      this.popper.parentNode.removeChild(this.popper);
    }
    return this;
  }

  /**
   * Get the window associated with the element
   * @argument {Element} element
   * @returns {Window}
   */
  function getWindow(element) {
    var ownerDocument = element.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView : window;
  }

  function attachToScrollParents(scrollParent, event, callback, scrollParents) {
    var isBody = scrollParent.nodeName === 'BODY';
    var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
    target.addEventListener(event, callback, { passive: true });

    if (!isBody) {
      attachToScrollParents(getScrollParent$1(target.parentNode), event, callback, scrollParents);
    }
    scrollParents.push(target);
  }

  /**
   * Setup needed event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */
  function setupEventListeners(reference, options, state, updateBound) {
    // Resize event listener on window
    state.updateBound = updateBound;
    getWindow(reference).addEventListener('resize', state.updateBound, { passive: true });

    // Scroll event listener on scroll parents
    var scrollElement = getScrollParent$1(reference);
    attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
    state.scrollElement = scrollElement;
    state.eventsEnabled = true;

    return state;
  }

  /**
   * It will add resize/scroll events and start recalculating
   * position of the popper element when they are triggered.
   * @method
   * @memberof Popper
   */
  function enableEventListeners() {
    if (!this.state.eventsEnabled) {
      this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
    }
  }

  /**
   * Remove event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */
  function removeEventListeners(reference, state) {
    // Remove resize event listener on window
    getWindow(reference).removeEventListener('resize', state.updateBound);

    // Remove scroll event listener on scroll parents
    state.scrollParents.forEach(function (target) {
      target.removeEventListener('scroll', state.updateBound);
    });

    // Reset state
    state.updateBound = null;
    state.scrollParents = [];
    state.scrollElement = null;
    state.eventsEnabled = false;
    return state;
  }

  /**
   * It will remove resize/scroll events and won't recalculate popper position
   * when they are triggered. It also won't trigger `onUpdate` callback anymore,
   * unless you call `update` method manually.
   * @method
   * @memberof Popper
   */
  function disableEventListeners() {
    if (this.state.eventsEnabled) {
      cancelAnimationFrame(this.scheduleUpdate);
      this.state = removeEventListeners(this.reference, this.state);
    }
  }

  /**
   * Tells if a given input is a number
   * @method
   * @memberof Popper.Utils
   * @param {*} input to check
   * @return {Boolean}
   */
  function isNumeric(n) {
    return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
  }

  /**
   * Set the style to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the style to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */
  function setStyles(element, styles) {
    Object.keys(styles).forEach(function (prop) {
      var unit = '';
      // add unit if the value is numeric and is one of the following
      if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
        unit = 'px';
      }
      element.style[prop] = styles[prop] + unit;
    });
  }

  /**
   * Set the attributes to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the attributes to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */
  function setAttributes(element, attributes) {
    Object.keys(attributes).forEach(function (prop) {
      var value = attributes[prop];
      if (value !== false) {
        element.setAttribute(prop, attributes[prop]);
      } else {
        element.removeAttribute(prop);
      }
    });
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} data.styles - List of style properties - values to apply to popper element
   * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The same data object
   */
  function applyStyle(data) {
    // any property present in `data.styles` will be applied to the popper,
    // in this way we can make the 3rd party modifiers add custom styles to it
    // Be aware, modifiers could override the properties defined in the previous
    // lines of this modifier!
    setStyles(data.instance.popper, data.styles);

    // any property present in `data.attributes` will be applied to the popper,
    // they will be set as HTML attributes of the element
    setAttributes(data.instance.popper, data.attributes);

    // if arrowElement is defined and arrowStyles has some properties
    if (data.arrowElement && Object.keys(data.arrowStyles).length) {
      setStyles(data.arrowElement, data.arrowStyles);
    }

    return data;
  }

  /**
   * Set the x-placement attribute before everything else because it could be used
   * to add margins to the popper margins needs to be calculated to get the
   * correct popper offsets.
   * @method
   * @memberof Popper.modifiers
   * @param {HTMLElement} reference - The reference element used to position the popper
   * @param {HTMLElement} popper - The HTML element used as popper
   * @param {Object} options - Popper.js options
   */
  function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
    // compute reference element offsets
    var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed);

    // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value
    var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);

    popper.setAttribute('x-placement', placement);

    // Apply `position` to popper before anything else because
    // without the position applied we can't guarantee correct computations
    setStyles(popper, { position: options.positionFixed ? 'fixed' : 'absolute' });

    return options;
  }

  /**
   * @function
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Boolean} shouldRound - If the offsets should be rounded at all
   * @returns {Object} The popper's position offsets rounded
   *
   * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
   * good as it can be within reason.
   * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
   *
   * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
   * as well on High DPI screens).
   *
   * Firefox prefers no rounding for positioning and does not have blurriness on
   * high DPI screens.
   *
   * Only horizontal placement and left/right values need to be considered.
   */
  function getRoundedOffsets(data, shouldRound) {
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var round = Math.round,
        floor = Math.floor;

    var noRound = function noRound(v) {
      return v;
    };

    var referenceWidth = round(reference.width);
    var popperWidth = round(popper.width);

    var isVertical = ['left', 'right'].indexOf(data.placement) !== -1;
    var isVariation = data.placement.indexOf('-') !== -1;
    var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
    var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;

    var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
    var verticalToInteger = !shouldRound ? noRound : round;

    return {
      left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
      top: verticalToInteger(popper.top),
      bottom: verticalToInteger(popper.bottom),
      right: horizontalToInteger(popper.right)
    };
  }

  var isFirefox = isBrowser$1 && /Firefox/i.test(navigator.userAgent);

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function computeStyle(data, options) {
    var x = options.x,
        y = options.y;
    var popper = data.offsets.popper;

    // Remove this legacy support in Popper.js v2

    var legacyGpuAccelerationOption = find(data.instance.modifiers, function (modifier) {
      return modifier.name === 'applyStyle';
    }).gpuAcceleration;
    if (legacyGpuAccelerationOption !== undefined) {
      console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
    }
    var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;

    var offsetParent = getOffsetParent(data.instance.popper);
    var offsetParentRect = getBoundingClientRect(offsetParent);

    // Styles
    var styles = {
      position: popper.position
    };

    var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);

    var sideA = x === 'bottom' ? 'top' : 'bottom';
    var sideB = y === 'right' ? 'left' : 'right';

    // if gpuAcceleration is set to `true` and transform is supported,
    //  we use `translate3d` to apply the position to the popper we
    // automatically use the supported prefixed version if needed
    var prefixedProperty = getSupportedPropertyName('transform');

    // now, let's make a step back and look at this code closely (wtf?)
    // If the content of the popper grows once it's been positioned, it
    // may happen that the popper gets misplaced because of the new content
    // overflowing its reference element
    // To avoid this problem, we provide two options (x and y), which allow
    // the consumer to define the offset origin.
    // If we position a popper on top of a reference element, we can set
    // `x` to `top` to make the popper grow towards its top instead of
    // its bottom.
    var left = void 0,
        top = void 0;
    if (sideA === 'bottom') {
      // when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
      // and not the bottom of the html element
      if (offsetParent.nodeName === 'HTML') {
        top = -offsetParent.clientHeight + offsets.bottom;
      } else {
        top = -offsetParentRect.height + offsets.bottom;
      }
    } else {
      top = offsets.top;
    }
    if (sideB === 'right') {
      if (offsetParent.nodeName === 'HTML') {
        left = -offsetParent.clientWidth + offsets.right;
      } else {
        left = -offsetParentRect.width + offsets.right;
      }
    } else {
      left = offsets.left;
    }
    if (gpuAcceleration && prefixedProperty) {
      styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
      styles[sideA] = 0;
      styles[sideB] = 0;
      styles.willChange = 'transform';
    } else {
      // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
      var invertTop = sideA === 'bottom' ? -1 : 1;
      var invertLeft = sideB === 'right' ? -1 : 1;
      styles[sideA] = top * invertTop;
      styles[sideB] = left * invertLeft;
      styles.willChange = sideA + ', ' + sideB;
    }

    // Attributes
    var attributes = {
      'x-placement': data.placement
    };

    // Update `data` attributes, styles and arrowStyles
    data.attributes = _extends$1({}, attributes, data.attributes);
    data.styles = _extends$1({}, styles, data.styles);
    data.arrowStyles = _extends$1({}, data.offsets.arrow, data.arrowStyles);

    return data;
  }

  /**
   * Helper used to know if the given modifier depends from another one.<br />
   * It checks if the needed modifier is listed and enabled.
   * @method
   * @memberof Popper.Utils
   * @param {Array} modifiers - list of modifiers
   * @param {String} requestingName - name of requesting modifier
   * @param {String} requestedName - name of requested modifier
   * @returns {Boolean}
   */
  function isModifierRequired(modifiers, requestingName, requestedName) {
    var requesting = find(modifiers, function (_ref) {
      var name = _ref.name;
      return name === requestingName;
    });

    var isRequired = !!requesting && modifiers.some(function (modifier) {
      return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
    });

    if (!isRequired) {
      var _requesting = '`' + requestingName + '`';
      var requested = '`' + requestedName + '`';
      console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
    }
    return isRequired;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function arrow(data, options) {
    var _data$offsets$arrow;

    // arrow depends on keepTogether in order to work
    if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
      return data;
    }

    var arrowElement = options.element;

    // if arrowElement is a string, suppose it's a CSS selector
    if (typeof arrowElement === 'string') {
      arrowElement = data.instance.popper.querySelector(arrowElement);

      // if arrowElement is not found, don't run the modifier
      if (!arrowElement) {
        return data;
      }
    } else {
      // if the arrowElement isn't a query selector we must check that the
      // provided DOM node is child of its popper node
      if (!data.instance.popper.contains(arrowElement)) {
        console.warn('WARNING: `arrow.element` must be child of its popper element!');
        return data;
      }
    }

    var placement = data.placement.split('-')[0];
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var isVertical = ['left', 'right'].indexOf(placement) !== -1;

    var len = isVertical ? 'height' : 'width';
    var sideCapitalized = isVertical ? 'Top' : 'Left';
    var side = sideCapitalized.toLowerCase();
    var altSide = isVertical ? 'left' : 'top';
    var opSide = isVertical ? 'bottom' : 'right';
    var arrowElementSize = getOuterSizes(arrowElement)[len];

    //
    // extends keepTogether behavior making sure the popper and its
    // reference have enough pixels in conjunction
    //

    // top/left side
    if (reference[opSide] - arrowElementSize < popper[side]) {
      data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
    }
    // bottom/right side
    if (reference[side] + arrowElementSize > popper[opSide]) {
      data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
    }
    data.offsets.popper = getClientRect(data.offsets.popper);

    // compute center of the popper
    var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;

    // Compute the sideValue using the updated popper offsets
    // take popper margin in account because we don't have this info available
    var css = getStyleComputedProperty(data.instance.popper);
    var popperMarginSide = parseFloat(css['margin' + sideCapitalized], 10);
    var popperBorderSide = parseFloat(css['border' + sideCapitalized + 'Width'], 10);
    var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide;

    // prevent arrowElement from being placed not contiguously to its popper
    sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);

    data.arrowElement = arrowElement;
    data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty$1(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty$1(_data$offsets$arrow, altSide, ''), _data$offsets$arrow);

    return data;
  }

  /**
   * Get the opposite placement variation of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement variation
   * @returns {String} flipped placement variation
   */
  function getOppositeVariation(variation) {
    if (variation === 'end') {
      return 'start';
    } else if (variation === 'start') {
      return 'end';
    }
    return variation;
  }

  /**
   * List of accepted placements to use as values of the `placement` option.<br />
   * Valid placements are:
   * - `auto`
   * - `top`
   * - `right`
   * - `bottom`
   * - `left`
   *
   * Each placement can have a variation from this list:
   * - `-start`
   * - `-end`
   *
   * Variations are interpreted easily if you think of them as the left to right
   * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
   * is right.<br />
   * Vertically (`left` and `right`), `start` is top and `end` is bottom.
   *
   * Some valid examples are:
   * - `top-end` (on top of reference, right aligned)
   * - `right-start` (on right of reference, top aligned)
   * - `bottom` (on bottom, centered)
   * - `auto-end` (on the side with more space available, alignment depends by placement)
   *
   * @static
   * @type {Array}
   * @enum {String}
   * @readonly
   * @method placements
   * @memberof Popper
   */
  var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start'];

  // Get rid of `auto` `auto-start` and `auto-end`
  var validPlacements = placements.slice(3);

  /**
   * Given an initial placement, returns all the subsequent placements
   * clockwise (or counter-clockwise).
   *
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement - A valid placement (it accepts variations)
   * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
   * @returns {Array} placements including their variations
   */
  function clockwise(placement) {
    var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var index = validPlacements.indexOf(placement);
    var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
    return counter ? arr.reverse() : arr;
  }

  var BEHAVIORS = {
    FLIP: 'flip',
    CLOCKWISE: 'clockwise',
    COUNTERCLOCKWISE: 'counterclockwise'
  };

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function flip(data, options) {
    // if `inner` modifier is enabled, we can't use the `flip` modifier
    if (isModifierEnabled(data.instance.modifiers, 'inner')) {
      return data;
    }

    if (data.flipped && data.placement === data.originalPlacement) {
      // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
      return data;
    }

    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);

    var placement = data.placement.split('-')[0];
    var placementOpposite = getOppositePlacement(placement);
    var variation = data.placement.split('-')[1] || '';

    var flipOrder = [];

    switch (options.behavior) {
      case BEHAVIORS.FLIP:
        flipOrder = [placement, placementOpposite];
        break;
      case BEHAVIORS.CLOCKWISE:
        flipOrder = clockwise(placement);
        break;
      case BEHAVIORS.COUNTERCLOCKWISE:
        flipOrder = clockwise(placement, true);
        break;
      default:
        flipOrder = options.behavior;
    }

    flipOrder.forEach(function (step, index) {
      if (placement !== step || flipOrder.length === index + 1) {
        return data;
      }

      placement = data.placement.split('-')[0];
      placementOpposite = getOppositePlacement(placement);

      var popperOffsets = data.offsets.popper;
      var refOffsets = data.offsets.reference;

      // using floor because the reference offsets may contain decimals we are not going to consider here
      var floor = Math.floor;
      var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);

      var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
      var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
      var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
      var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);

      var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom;

      // flip the variation if required
      var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;

      // flips variation if reference element overflows boundaries
      var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom);

      // flips variation if popper content overflows boundaries
      var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === 'start' && overflowsRight || isVertical && variation === 'end' && overflowsLeft || !isVertical && variation === 'start' && overflowsBottom || !isVertical && variation === 'end' && overflowsTop);

      var flippedVariation = flippedVariationByRef || flippedVariationByContent;

      if (overlapsRef || overflowsBoundaries || flippedVariation) {
        // this boolean to detect any flip loop
        data.flipped = true;

        if (overlapsRef || overflowsBoundaries) {
          placement = flipOrder[index + 1];
        }

        if (flippedVariation) {
          variation = getOppositeVariation(variation);
        }

        data.placement = placement + (variation ? '-' + variation : '');

        // this object contains `position`, we want to preserve it along with
        // any additional property we may add in the future
        data.offsets.popper = _extends$1({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));

        data = runModifiers(data.instance.modifiers, data, 'flip');
      }
    });
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function keepTogether(data) {
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var placement = data.placement.split('-')[0];
    var floor = Math.floor;
    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
    var side = isVertical ? 'right' : 'bottom';
    var opSide = isVertical ? 'left' : 'top';
    var measurement = isVertical ? 'width' : 'height';

    if (popper[side] < floor(reference[opSide])) {
      data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
    }
    if (popper[opSide] > floor(reference[side])) {
      data.offsets.popper[opSide] = floor(reference[side]);
    }

    return data;
  }

  /**
   * Converts a string containing value + unit into a px value number
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} str - Value + unit string
   * @argument {String} measurement - `height` or `width`
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @returns {Number|String}
   * Value in pixels, or original string if no values were extracted
   */
  function toValue(str, measurement, popperOffsets, referenceOffsets) {
    // separate value from unit
    var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
    var value = +split[1];
    var unit = split[2];

    // If it's not a number it's an operator, I guess
    if (!value) {
      return str;
    }

    if (unit.indexOf('%') === 0) {
      var element = void 0;
      switch (unit) {
        case '%p':
          element = popperOffsets;
          break;
        case '%':
        case '%r':
        default:
          element = referenceOffsets;
      }

      var rect = getClientRect(element);
      return rect[measurement] / 100 * value;
    } else if (unit === 'vh' || unit === 'vw') {
      // if is a vh or vw, we calculate the size based on the viewport
      var size = void 0;
      if (unit === 'vh') {
        size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
      } else {
        size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
      }
      return size / 100 * value;
    } else {
      // if is an explicit pixel unit, we get rid of the unit and keep the value
      // if is an implicit unit, it's px, and we return just the value
      return value;
    }
  }

  /**
   * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} offset
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @argument {String} basePlacement
   * @returns {Array} a two cells array with x and y offsets in numbers
   */
  function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
    var offsets = [0, 0];

    // Use height if placement is left or right and index is 0 otherwise use width
    // in this way the first offset will use an axis and the second one
    // will use the other one
    var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1;

    // Split the offset string to obtain a list of values and operands
    // The regex addresses values with the plus or minus sign in front (+10, -20, etc)
    var fragments = offset.split(/(\+|\-)/).map(function (frag) {
      return frag.trim();
    });

    // Detect if the offset string contains a pair of values or a single one
    // they could be separated by comma or space
    var divider = fragments.indexOf(find(fragments, function (frag) {
      return frag.search(/,|\s/) !== -1;
    }));

    if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
      console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
    }

    // If divider is found, we divide the list of values and operands to divide
    // them by ofset X and Y.
    var splitRegex = /\s*,\s*|\s+/;
    var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];

    // Convert the values with units to absolute pixels to allow our computations
    ops = ops.map(function (op, index) {
      // Most of the units rely on the orientation of the popper
      var measurement = (index === 1 ? !useHeight : useHeight) ? 'height' : 'width';
      var mergeWithPrevious = false;
      return op
      // This aggregates any `+` or `-` sign that aren't considered operators
      // e.g.: 10 + +5 => [10, +, +5]
      .reduce(function (a, b) {
        if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
          a[a.length - 1] = b;
          mergeWithPrevious = true;
          return a;
        } else if (mergeWithPrevious) {
          a[a.length - 1] += b;
          mergeWithPrevious = false;
          return a;
        } else {
          return a.concat(b);
        }
      }, [])
      // Here we convert the string values into number values (in px)
      .map(function (str) {
        return toValue(str, measurement, popperOffsets, referenceOffsets);
      });
    });

    // Loop trough the offsets arrays and execute the operations
    ops.forEach(function (op, index) {
      op.forEach(function (frag, index2) {
        if (isNumeric(frag)) {
          offsets[index] += frag * (op[index2 - 1] === '-' ? -1 : 1);
        }
      });
    });
    return offsets;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @argument {Number|String} options.offset=0
   * The offset value as described in the modifier description
   * @returns {Object} The data object, properly modified
   */
  function offset(data, _ref) {
    var offset = _ref.offset;
    var placement = data.placement,
        _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var basePlacement = placement.split('-')[0];

    var offsets = void 0;
    if (isNumeric(+offset)) {
      offsets = [+offset, 0];
    } else {
      offsets = parseOffset(offset, popper, reference, basePlacement);
    }

    if (basePlacement === 'left') {
      popper.top += offsets[0];
      popper.left -= offsets[1];
    } else if (basePlacement === 'right') {
      popper.top += offsets[0];
      popper.left += offsets[1];
    } else if (basePlacement === 'top') {
      popper.left += offsets[0];
      popper.top -= offsets[1];
    } else if (basePlacement === 'bottom') {
      popper.left += offsets[0];
      popper.top += offsets[1];
    }

    data.popper = popper;
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function preventOverflow(data, options) {
    var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper);

    // If offsetParent is the reference element, we really want to
    // go one step up and use the next offsetParent as reference to
    // avoid to make this modifier completely useless and look like broken
    if (data.instance.reference === boundariesElement) {
      boundariesElement = getOffsetParent(boundariesElement);
    }

    // NOTE: DOM access here
    // resets the popper's position so that the document size can be calculated excluding
    // the size of the popper element itself
    var transformProp = getSupportedPropertyName('transform');
    var popperStyles = data.instance.popper.style; // assignment to help minification
    var top = popperStyles.top,
        left = popperStyles.left,
        transform = popperStyles[transformProp];

    popperStyles.top = '';
    popperStyles.left = '';
    popperStyles[transformProp] = '';

    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed);

    // NOTE: DOM access here
    // restores the original style properties after the offsets have been computed
    popperStyles.top = top;
    popperStyles.left = left;
    popperStyles[transformProp] = transform;

    options.boundaries = boundaries;

    var order = options.priority;
    var popper = data.offsets.popper;

    var check = {
      primary: function primary(placement) {
        var value = popper[placement];
        if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
          value = Math.max(popper[placement], boundaries[placement]);
        }
        return defineProperty$1({}, placement, value);
      },
      secondary: function secondary(placement) {
        var mainSide = placement === 'right' ? 'left' : 'top';
        var value = popper[mainSide];
        if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
          value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
        }
        return defineProperty$1({}, mainSide, value);
      }
    };

    order.forEach(function (placement) {
      var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
      popper = _extends$1({}, popper, check[side](placement));
    });

    data.offsets.popper = popper;

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function shift(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var shiftvariation = placement.split('-')[1];

    // if shift shiftvariation is specified, run the modifier
    if (shiftvariation) {
      var _data$offsets = data.offsets,
          reference = _data$offsets.reference,
          popper = _data$offsets.popper;

      var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
      var side = isVertical ? 'left' : 'top';
      var measurement = isVertical ? 'width' : 'height';

      var shiftOffsets = {
        start: defineProperty$1({}, side, reference[side]),
        end: defineProperty$1({}, side, reference[side] + reference[measurement] - popper[measurement])
      };

      data.offsets.popper = _extends$1({}, popper, shiftOffsets[shiftvariation]);
    }

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function hide(data) {
    if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
      return data;
    }

    var refRect = data.offsets.reference;
    var bound = find(data.instance.modifiers, function (modifier) {
      return modifier.name === 'preventOverflow';
    }).boundaries;

    if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === true) {
        return data;
      }

      data.hide = true;
      data.attributes['x-out-of-boundaries'] = '';
    } else {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === false) {
        return data;
      }

      data.hide = false;
      data.attributes['x-out-of-boundaries'] = false;
    }

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function inner(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;

    var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;

    popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);

    data.placement = getOppositePlacement(placement);
    data.offsets.popper = getClientRect(popper);

    return data;
  }

  /**
   * Modifier function, each modifier can have a function of this type assigned
   * to its `fn` property.<br />
   * These functions will be called on each update, this means that you must
   * make sure they are performant enough to avoid performance bottlenecks.
   *
   * @function ModifierFn
   * @argument {dataObject} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {dataObject} The data object, properly modified
   */

  /**
   * Modifiers are plugins used to alter the behavior of your poppers.<br />
   * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
   * needed by the library.
   *
   * Usually you don't want to override the `order`, `fn` and `onLoad` props.
   * All the other properties are configurations that could be tweaked.
   * @namespace modifiers
   */
  var modifiers = {
    /**
     * Modifier used to shift the popper on the start or end of its reference
     * element.<br />
     * It will read the variation of the `placement` property.<br />
     * It can be one either `-end` or `-start`.
     * @memberof modifiers
     * @inner
     */
    shift: {
      /** @prop {number} order=100 - Index used to define the order of execution */
      order: 100,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: shift
    },

    /**
     * The `offset` modifier can shift your popper on both its axis.
     *
     * It accepts the following units:
     * - `px` or unit-less, interpreted as pixels
     * - `%` or `%r`, percentage relative to the length of the reference element
     * - `%p`, percentage relative to the length of the popper element
     * - `vw`, CSS viewport width unit
     * - `vh`, CSS viewport height unit
     *
     * For length is intended the main axis relative to the placement of the popper.<br />
     * This means that if the placement is `top` or `bottom`, the length will be the
     * `width`. In case of `left` or `right`, it will be the `height`.
     *
     * You can provide a single value (as `Number` or `String`), or a pair of values
     * as `String` divided by a comma or one (or more) white spaces.<br />
     * The latter is a deprecated method because it leads to confusion and will be
     * removed in v2.<br />
     * Additionally, it accepts additions and subtractions between different units.
     * Note that multiplications and divisions aren't supported.
     *
     * Valid examples are:
     * ```
     * 10
     * '10%'
     * '10, 10'
     * '10%, 10'
     * '10 + 10%'
     * '10 - 5vh + 3%'
     * '-10px + 5vh, 5px - 6%'
     * ```
     * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
     * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
     * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
     *
     * @memberof modifiers
     * @inner
     */
    offset: {
      /** @prop {number} order=200 - Index used to define the order of execution */
      order: 200,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: offset,
      /** @prop {Number|String} offset=0
       * The offset value as described in the modifier description
       */
      offset: 0
    },

    /**
     * Modifier used to prevent the popper from being positioned outside the boundary.
     *
     * A scenario exists where the reference itself is not within the boundaries.<br />
     * We can say it has "escaped the boundaries" — or just "escaped".<br />
     * In this case we need to decide whether the popper should either:
     *
     * - detach from the reference and remain "trapped" in the boundaries, or
     * - if it should ignore the boundary and "escape with its reference"
     *
     * When `escapeWithReference` is set to`true` and reference is completely
     * outside its boundaries, the popper will overflow (or completely leave)
     * the boundaries in order to remain attached to the edge of the reference.
     *
     * @memberof modifiers
     * @inner
     */
    preventOverflow: {
      /** @prop {number} order=300 - Index used to define the order of execution */
      order: 300,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: preventOverflow,
      /**
       * @prop {Array} [priority=['left','right','top','bottom']]
       * Popper will try to prevent overflow following these priorities by default,
       * then, it could overflow on the left and on top of the `boundariesElement`
       */
      priority: ['left', 'right', 'top', 'bottom'],
      /**
       * @prop {number} padding=5
       * Amount of pixel used to define a minimum distance between the boundaries
       * and the popper. This makes sure the popper always has a little padding
       * between the edges of its container
       */
      padding: 5,
      /**
       * @prop {String|HTMLElement} boundariesElement='scrollParent'
       * Boundaries used by the modifier. Can be `scrollParent`, `window`,
       * `viewport` or any DOM element.
       */
      boundariesElement: 'scrollParent'
    },

    /**
     * Modifier used to make sure the reference and its popper stay near each other
     * without leaving any gap between the two. Especially useful when the arrow is
     * enabled and you want to ensure that it points to its reference element.
     * It cares only about the first axis. You can still have poppers with margin
     * between the popper and its reference element.
     * @memberof modifiers
     * @inner
     */
    keepTogether: {
      /** @prop {number} order=400 - Index used to define the order of execution */
      order: 400,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: keepTogether
    },

    /**
     * This modifier is used to move the `arrowElement` of the popper to make
     * sure it is positioned between the reference element and its popper element.
     * It will read the outer size of the `arrowElement` node to detect how many
     * pixels of conjunction are needed.
     *
     * It has no effect if no `arrowElement` is provided.
     * @memberof modifiers
     * @inner
     */
    arrow: {
      /** @prop {number} order=500 - Index used to define the order of execution */
      order: 500,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: arrow,
      /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
      element: '[x-arrow]'
    },

    /**
     * Modifier used to flip the popper's placement when it starts to overlap its
     * reference element.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     *
     * **NOTE:** this modifier will interrupt the current update cycle and will
     * restart it if it detects the need to flip the placement.
     * @memberof modifiers
     * @inner
     */
    flip: {
      /** @prop {number} order=600 - Index used to define the order of execution */
      order: 600,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: flip,
      /**
       * @prop {String|Array} behavior='flip'
       * The behavior used to change the popper's placement. It can be one of
       * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
       * placements (with optional variations)
       */
      behavior: 'flip',
      /**
       * @prop {number} padding=5
       * The popper will flip if it hits the edges of the `boundariesElement`
       */
      padding: 5,
      /**
       * @prop {String|HTMLElement} boundariesElement='viewport'
       * The element which will define the boundaries of the popper position.
       * The popper will never be placed outside of the defined boundaries
       * (except if `keepTogether` is enabled)
       */
      boundariesElement: 'viewport',
      /**
       * @prop {Boolean} flipVariations=false
       * The popper will switch placement variation between `-start` and `-end` when
       * the reference element overlaps its boundaries.
       *
       * The original placement should have a set variation.
       */
      flipVariations: false,
      /**
       * @prop {Boolean} flipVariationsByContent=false
       * The popper will switch placement variation between `-start` and `-end` when
       * the popper element overlaps its reference boundaries.
       *
       * The original placement should have a set variation.
       */
      flipVariationsByContent: false
    },

    /**
     * Modifier used to make the popper flow toward the inner of the reference element.
     * By default, when this modifier is disabled, the popper will be placed outside
     * the reference element.
     * @memberof modifiers
     * @inner
     */
    inner: {
      /** @prop {number} order=700 - Index used to define the order of execution */
      order: 700,
      /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
      enabled: false,
      /** @prop {ModifierFn} */
      fn: inner
    },

    /**
     * Modifier used to hide the popper when its reference element is outside of the
     * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
     * be used to hide with a CSS selector the popper when its reference is
     * out of boundaries.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     * @memberof modifiers
     * @inner
     */
    hide: {
      /** @prop {number} order=800 - Index used to define the order of execution */
      order: 800,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: hide
    },

    /**
     * Computes the style that will be applied to the popper element to gets
     * properly positioned.
     *
     * Note that this modifier will not touch the DOM, it just prepares the styles
     * so that `applyStyle` modifier can apply it. This separation is useful
     * in case you need to replace `applyStyle` with a custom implementation.
     *
     * This modifier has `850` as `order` value to maintain backward compatibility
     * with previous versions of Popper.js. Expect the modifiers ordering method
     * to change in future major versions of the library.
     *
     * @memberof modifiers
     * @inner
     */
    computeStyle: {
      /** @prop {number} order=850 - Index used to define the order of execution */
      order: 850,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: computeStyle,
      /**
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3D transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties
       */
      gpuAcceleration: true,
      /**
       * @prop {string} [x='bottom']
       * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
       * Change this if your popper should grow in a direction different from `bottom`
       */
      x: 'bottom',
      /**
       * @prop {string} [x='left']
       * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
       * Change this if your popper should grow in a direction different from `right`
       */
      y: 'right'
    },

    /**
     * Applies the computed styles to the popper element.
     *
     * All the DOM manipulations are limited to this modifier. This is useful in case
     * you want to integrate Popper.js inside a framework or view library and you
     * want to delegate all the DOM manipulations to it.
     *
     * Note that if you disable this modifier, you must make sure the popper element
     * has its position set to `absolute` before Popper.js can do its work!
     *
     * Just disable this modifier and define your own to achieve the desired effect.
     *
     * @memberof modifiers
     * @inner
     */
    applyStyle: {
      /** @prop {number} order=900 - Index used to define the order of execution */
      order: 900,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: applyStyle,
      /** @prop {Function} */
      onLoad: applyStyleOnLoad,
      /**
       * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3D transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties
       */
      gpuAcceleration: undefined
    }
  };

  /**
   * The `dataObject` is an object containing all the information used by Popper.js.
   * This object is passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
   * @name dataObject
   * @property {Object} data.instance The Popper.js instance
   * @property {String} data.placement Placement applied to popper
   * @property {String} data.originalPlacement Placement originally defined on init
   * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
   * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper
   * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
   * @property {Object} data.styles Any CSS property defined here will be applied to the popper. It expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow. It expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.boundaries Offsets of the popper boundaries
   * @property {Object} data.offsets The measurements of popper, reference and arrow elements
   * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
   */

  /**
   * Default options provided to Popper.js constructor.<br />
   * These can be overridden using the `options` argument of Popper.js.<br />
   * To override an option, simply pass an object with the same
   * structure of the `options` object, as the 3rd argument. For example:
   * ```
   * new Popper(ref, pop, {
   *   modifiers: {
   *     preventOverflow: { enabled: false }
   *   }
   * })
   * ```
   * @type {Object}
   * @static
   * @memberof Popper
   */
  var Defaults = {
    /**
     * Popper's placement.
     * @prop {Popper.placements} placement='bottom'
     */
    placement: 'bottom',

    /**
     * Set this to true if you want popper to position it self in 'fixed' mode
     * @prop {Boolean} positionFixed=false
     */
    positionFixed: false,

    /**
     * Whether events (resize, scroll) are initially enabled.
     * @prop {Boolean} eventsEnabled=true
     */
    eventsEnabled: true,

    /**
     * Set to true if you want to automatically remove the popper when
     * you call the `destroy` method.
     * @prop {Boolean} removeOnDestroy=false
     */
    removeOnDestroy: false,

    /**
     * Callback called when the popper is created.<br />
     * By default, it is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onCreate}
     */
    onCreate: function onCreate() {},

    /**
     * Callback called when the popper is updated. This callback is not called
     * on the initialization/creation of the popper, but only on subsequent
     * updates.<br />
     * By default, it is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onUpdate}
     */
    onUpdate: function onUpdate() {},

    /**
     * List of modifiers used to modify the offsets before they are applied to the popper.
     * They provide most of the functionalities of Popper.js.
     * @prop {modifiers}
     */
    modifiers: modifiers
  };

  /**
   * @callback onCreate
   * @param {dataObject} data
   */

  /**
   * @callback onUpdate
   * @param {dataObject} data
   */

  // Utils
  // Methods
  var Popper = function () {
    /**
     * Creates a new Popper.js instance.
     * @class Popper
     * @param {Element|referenceObject} reference - The reference element used to position the popper
     * @param {Element} popper - The HTML / XML element used as the popper
     * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
     * @return {Object} instance - The generated Popper.js instance
     */
    function Popper(reference, popper) {
      var _this = this;

      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      classCallCheck(this, Popper);

      this.scheduleUpdate = function () {
        return requestAnimationFrame(_this.update);
      };

      // make update() debounced, so that it only runs at most once-per-tick
      this.update = debounce$1(this.update.bind(this));

      // with {} we create a new object with the options inside it
      this.options = _extends$1({}, Popper.Defaults, options);

      // init state
      this.state = {
        isDestroyed: false,
        isCreated: false,
        scrollParents: []
      };

      // get reference and popper elements (allow jQuery wrappers)
      this.reference = reference && reference.jquery ? reference[0] : reference;
      this.popper = popper && popper.jquery ? popper[0] : popper;

      // Deep merge modifiers options
      this.options.modifiers = {};
      Object.keys(_extends$1({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
        _this.options.modifiers[name] = _extends$1({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
      });

      // Refactoring modifiers' list (Object => Array)
      this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
        return _extends$1({
          name: name
        }, _this.options.modifiers[name]);
      })
      // sort the modifiers by order
      .sort(function (a, b) {
        return a.order - b.order;
      });

      // modifiers have the ability to execute arbitrary code when Popper.js get inited
      // such code is executed in the same order of its modifier
      // they could add new properties to their options configuration
      // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!
      this.modifiers.forEach(function (modifierOptions) {
        if (modifierOptions.enabled && isFunction(modifierOptions.onLoad)) {
          modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
        }
      });

      // fire the first update to position the popper in the right place
      this.update();

      var eventsEnabled = this.options.eventsEnabled;
      if (eventsEnabled) {
        // setup event listeners, they will take care of update the position in specific situations
        this.enableEventListeners();
      }

      this.state.eventsEnabled = eventsEnabled;
    }

    // We can't use class properties because they don't get listed in the
    // class prototype and break stuff like Sinon stubs


    createClass(Popper, [{
      key: 'update',
      value: function update$$1() {
        return update$1.call(this);
      }
    }, {
      key: 'destroy',
      value: function destroy$$1() {
        return destroy.call(this);
      }
    }, {
      key: 'enableEventListeners',
      value: function enableEventListeners$$1() {
        return enableEventListeners.call(this);
      }
    }, {
      key: 'disableEventListeners',
      value: function disableEventListeners$$1() {
        return disableEventListeners.call(this);
      }

      /**
       * Schedules an update. It will run on the next UI update available.
       * @method scheduleUpdate
       * @memberof Popper
       */


      /**
       * Collection of utilities useful when writing custom modifiers.
       * Starting from version 1.7, this method is available only if you
       * include `popper-utils.js` before `popper.js`.
       *
       * **DEPRECATION**: This way to access PopperUtils is deprecated
       * and will be removed in v2! Use the PopperUtils module directly instead.
       * Due to the high instability of the methods contained in Utils, we can't
       * guarantee them to follow semver. Use them at your own risk!
       * @static
       * @private
       * @type {Object}
       * @deprecated since version 1.8
       * @member Utils
       * @memberof Popper
       */

    }]);
    return Popper;
  }();

  /**
   * The `referenceObject` is an object that provides an interface compatible with Popper.js
   * and lets you use it as replacement of a real DOM node.<br />
   * You can use this method to position a popper relatively to a set of coordinates
   * in case you don't have a DOM node to use as reference.
   *
   * ```
   * new Popper(referenceObject, popperNode);
   * ```
   *
   * NB: This feature isn't supported in Internet Explorer 10.
   * @name referenceObject
   * @property {Function} data.getBoundingClientRect
   * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
   * @property {number} data.clientWidth
   * An ES6 getter that will return the width of the virtual reference element.
   * @property {number} data.clientHeight
   * An ES6 getter that will return the height of the virtual reference element.
   */


  Popper.Utils = (typeof window !== 'undefined' ? window : global$1).PopperUtils;
  Popper.placements = placements;
  Popper.Defaults = Defaults;

  /**
   * Flips placement if in <body dir="rtl" />
   * @param {string} placement
   */

  function flipPlacement(placement) {
    var direction = typeof window !== 'undefined' && document.body.getAttribute('dir') || 'ltr';

    if (direction !== 'rtl') {
      return placement;
    }

    switch (placement) {
      case 'bottom-end':
        return 'bottom-start';

      case 'bottom-start':
        return 'bottom-end';

      case 'top-end':
        return 'top-start';

      case 'top-start':
        return 'top-end';

      default:
        return placement;
    }
  }

  function getAnchorEl$1(anchorEl) {
    return typeof anchorEl === 'function' ? anchorEl() : anchorEl;
  }

  var useEnhancedEffect$9 = typeof window !== 'undefined' ? React__default.useLayoutEffect : React__default.useEffect;
  var defaultPopperOptions = {};
  /**
   * Poppers rely on the 3rd party library [Popper.js](https://github.com/FezVrasta/popper.js) for positioning.
   */

  var Popper$1 = React__default.forwardRef(function Popper$1(props, ref) {
    var anchorEl = props.anchorEl,
        children = props.children,
        container = props.container,
        _props$disablePortal = props.disablePortal,
        disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal,
        _props$keepMounted = props.keepMounted,
        keepMounted = _props$keepMounted === void 0 ? false : _props$keepMounted,
        modifiers = props.modifiers,
        open = props.open,
        _props$placement = props.placement,
        initialPlacement = _props$placement === void 0 ? 'bottom' : _props$placement,
        _props$popperOptions = props.popperOptions,
        popperOptions = _props$popperOptions === void 0 ? defaultPopperOptions : _props$popperOptions,
        popperRefProp = props.popperRef,
        _props$transition = props.transition,
        transition = _props$transition === void 0 ? false : _props$transition,
        other = _objectWithoutProperties(props, ["anchorEl", "children", "container", "disablePortal", "keepMounted", "modifiers", "open", "placement", "popperOptions", "popperRef", "transition"]);

    var tooltipRef = React__default.useRef(null);
    var ownRef = useForkRef(tooltipRef, ref);
    var popperRef = React__default.useRef(null);
    var handlePopperRef = useForkRef(popperRef, popperRefProp);
    var handlePopperRefRef = React__default.useRef(handlePopperRef);
    useEnhancedEffect$9(function () {
      handlePopperRefRef.current = handlePopperRef;
    }, [handlePopperRef]);
    React__default.useImperativeHandle(popperRefProp, function () {
      return popperRef.current;
    }, []);

    var _React$useState = React__default.useState(true),
        exited = _React$useState[0],
        setExited = _React$useState[1];

    var rtlPlacement = flipPlacement(initialPlacement);
    /**
     * placement initialized from prop but can change during lifetime if modifiers.flip.
     * modifiers.flip is essentially a flip for controlled/uncontrolled behavior
     */

    var _React$useState2 = React__default.useState(rtlPlacement),
        placement = _React$useState2[0],
        setPlacement = _React$useState2[1];

    var handleOpen = React__default.useCallback(function () {
      if (!tooltipRef.current || !anchorEl || !open) {
        return;
      }

      if (popperRef.current) {
        popperRef.current.destroy();
        handlePopperRefRef.current(null);
      }

      var handlePopperUpdate = function handlePopperUpdate(data) {
        setPlacement(data.placement);
      };

      var resolvedAnchorEl = getAnchorEl$1(anchorEl);

      {
        var containerWindow = ownerWindow(resolvedAnchorEl);

        if (resolvedAnchorEl instanceof containerWindow.Element) {
          var box = resolvedAnchorEl.getBoundingClientRect();

          if ( box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
            console.warn(['Material-UI: the `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
          }
        }
      }

      var popper = new Popper(getAnchorEl$1(anchorEl), tooltipRef.current, _extends({
        placement: rtlPlacement
      }, popperOptions, {
        modifiers: _extends({}, disablePortal ? {} : {
          // It's using scrollParent by default, we can use the viewport when using a portal.
          preventOverflow: {
            boundariesElement: 'window'
          }
        }, {}, modifiers, {}, popperOptions.modifiers),
        // We could have been using a custom modifier like react-popper is doing.
        // But it seems this is the best public API for this use case.
        onCreate: createChainedFunction(handlePopperUpdate, popperOptions.onCreate),
        onUpdate: createChainedFunction(handlePopperUpdate, popperOptions.onUpdate)
      }));
      handlePopperRefRef.current(popper);
    }, [anchorEl, disablePortal, modifiers, open, rtlPlacement, popperOptions]);
    var handleRef = React__default.useCallback(function (node) {
      setRef(ownRef, node);
      handleOpen();
    }, [ownRef, handleOpen]);

    var handleEnter = function handleEnter() {
      setExited(false);
    };

    var handleClose = function handleClose() {
      if (!popperRef.current) {
        return;
      }

      popperRef.current.destroy();
      handlePopperRefRef.current(null);
    };

    var handleExited = function handleExited() {
      setExited(true);
      handleClose();
    };

    React__default.useEffect(function () {
      // Let's update the popper position.
      handleOpen();
    }, [handleOpen]);
    React__default.useEffect(function () {
      return function () {
        handleClose();
      };
    }, []);
    React__default.useEffect(function () {
      if (!open && !transition) {
        // Otherwise handleExited will call this.
        handleClose();
      }
    }, [open, transition]);

    if (!keepMounted && !open && (!transition || exited)) {
      return null;
    }

    var childProps = {
      placement: placement
    };

    if (transition) {
      childProps.TransitionProps = {
        in: open,
        onEnter: handleEnter,
        onExited: handleExited
      };
    }

    return React__default.createElement(Portal, {
      disablePortal: disablePortal,
      container: container
    }, React__default.createElement("div", _extends({
      ref: handleRef,
      role: "tooltip"
    }, other, {
      style: _extends({
        // Prevents scroll issue, waiting for Popper.js to add this style once initiated.
        position: 'fixed',
        // Fix Popper.js display issue
        top: 0,
        left: 0
      }, other.style)
    }), typeof children === 'function' ? children(childProps) : children));
  });
   Popper$1.propTypes = {
    /**
     * This is the reference element, or a function that returns the reference element,
     * that may be used to set the position of the popover.
     * The return value will passed as the reference object of the Popper
     * instance.
     *
     * The reference element should be an HTML Element instance or a referenceObject:
     * https://popper.js.org/popper-documentation.html#referenceObject.
     */
    anchorEl: chainPropTypes(propTypes.oneOfType([propTypes.object, propTypes.func]), function (props) {
      if (props.open) {
        var resolvedAnchorEl = getAnchorEl$1(props.anchorEl);
        var containerWindow = ownerWindow(resolvedAnchorEl);

        if (resolvedAnchorEl instanceof containerWindow.Element) {
          var box = resolvedAnchorEl.getBoundingClientRect();

          if ( box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
            return new Error(['Material-UI: the `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
          }
        } else if (!resolvedAnchorEl || typeof resolvedAnchorEl.clientWidth !== 'number' || typeof resolvedAnchorEl.clientHeight !== 'number' || typeof resolvedAnchorEl.getBoundingClientRect !== 'function') {
          return new Error(['Material-UI: the `anchorEl` prop provided to the component is invalid.', 'It should be an HTML Element instance or a referenceObject:', 'https://popper.js.org/popper-documentation.html#referenceObject.'].join('\n'));
        }
      }

      return null;
    }),

    /**
     * Popper render function or node.
     */
    children: propTypes.oneOfType([propTypes.node, propTypes.func]).isRequired,

    /**
     * A node, component instance, or function that returns either.
     * The `container` will passed to the Modal component.
     * By default, it uses the body of the anchorEl's top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * Disable the portal behavior.
     * The children stay within it's parent DOM hierarchy.
     */
    disablePortal: propTypes.bool,

    /**
     * Always keep the children in the DOM.
     * This prop can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Popper.
     */
    keepMounted: propTypes.bool,

    /**
     * Popper.js is based on a "plugin-like" architecture,
     * most of its features are fully encapsulated "modifiers".
     *
     * A modifier is a function that is called each time Popper.js needs to
     * compute the position of the popper.
     * For this reason, modifiers should be very performant to avoid bottlenecks.
     * To learn how to create a modifier, [read the modifiers documentation](https://github.com/FezVrasta/popper.js/blob/master/docs/_includes/popper-documentation.md#modifiers--object).
     */
    modifiers: propTypes.object,

    /**
     * If `true`, the popper is visible.
     */
    open: propTypes.bool.isRequired,

    /**
     * Popper placement.
     */
    placement: propTypes.oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),

    /**
     * Options provided to the [`popper.js`](https://github.com/FezVrasta/popper.js) instance.
     */
    popperOptions: propTypes.object,

    /**
     * A ref that points to the used popper instance.
     */
    popperRef: refType,

    /**
     * Help supporting a react-transition-group/Transition component.
     */
    transition: propTypes.bool
  } ;

  /**
   * @ignore - internal component.
   */

  var RadioButtonUncheckedIcon = createSvgIcon(React__default.createElement("path", {
    d: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"
  }), 'RadioButtonUnchecked');

  /**
   * @ignore - internal component.
   */

  var RadioButtonCheckedIcon = createSvgIcon(React__default.createElement("path", {
    d: "M8.465 8.465C9.37 7.56 10.62 7 12 7C14.76 7 17 9.24 17 12C17 13.38 16.44 14.63 15.535 15.535C14.63 16.44 13.38 17 12 17C9.24 17 7 14.76 7 12C7 10.62 7.56 9.37 8.465 8.465Z"
  }), 'RadioButtonChecked');

  var styles$1e = function styles(theme) {
    return {
      root: {
        position: 'relative',
        display: 'flex',
        '&$checked $layer': {
          transform: 'scale(1)',
          transition: theme.transitions.create('transform', {
            easing: theme.transitions.easing.easeOut,
            duration: theme.transitions.duration.shortest
          })
        }
      },
      layer: {
        left: 0,
        position: 'absolute',
        transform: 'scale(0)',
        transition: theme.transitions.create('transform', {
          easing: theme.transitions.easing.easeIn,
          duration: theme.transitions.duration.shortest
        })
      },
      checked: {}
    };
  };
  /**
   * @ignore - internal component.
   */

  var _ref = React__default.createElement(RadioButtonUncheckedIcon, null);

  function RadioButtonIcon(props) {
    var checked = props.checked,
        classes = props.classes;
    return React__default.createElement("div", {
      className: clsx(classes.root, checked && classes.checked)
    }, _ref, React__default.createElement(RadioButtonCheckedIcon, {
      className: classes.layer
    }));
  }

   RadioButtonIcon.propTypes = {
    /**
     * If `true`, the component is checked.
     */
    checked: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired
  } ;
  var RadioButtonIcon$1 = withStyles$1(styles$1e, {
    name: 'PrivateRadioButtonIcon'
  })(RadioButtonIcon);

  /**
   * @ignore - internal component.
   */

  var RadioGroupContext = React__default.createContext();

  var styles$1f = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        color: theme.palette.text.secondary
      },

      /* Pseudo-class applied to the root element if `checked={true}`. */
      checked: {},

      /* Pseudo-class applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        '&$checked': {
          color: theme.palette.primary.main,
          '&:hover': {
            backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity),
            // Reset on touch devices, it doesn't add specificity
            '@media (hover: none)': {
              backgroundColor: 'transparent'
            }
          }
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        '&$checked': {
          color: theme.palette.secondary.main,
          '&:hover': {
            backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
            // Reset on touch devices, it doesn't add specificity
            '@media (hover: none)': {
              backgroundColor: 'transparent'
            }
          }
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      }
    };
  };
  var defaultCheckedIcon$1 = React__default.createElement(RadioButtonIcon$1, {
    checked: true
  });
  var defaultIcon$1 = React__default.createElement(RadioButtonIcon$1, null);
  var Radio = React__default.forwardRef(function Radio(props, ref) {
    var checkedProp = props.checked,
        classes = props.classes,
        _props$color = props.color,
        color = _props$color === void 0 ? 'secondary' : _props$color,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        nameProp = props.name,
        onChangeProp = props.onChange,
        other = _objectWithoutProperties(props, ["checked", "classes", "color", "disabled", "name", "onChange"]);

    var radioGroup = React__default.useContext(RadioGroupContext);
    var checked = checkedProp;
    var onChange = createChainedFunction(onChangeProp, radioGroup && radioGroup.onChange);
    var name = nameProp;

    if (radioGroup) {
      if (typeof checked === 'undefined') {
        checked = radioGroup.value === props.value;
      }

      if (typeof name === 'undefined') {
        name = radioGroup.name;
      }
    }

    return React__default.createElement(SwitchBase$1, _extends({
      color: color,
      type: "radio",
      icon: defaultIcon$1,
      checkedIcon: defaultCheckedIcon$1,
      classes: {
        root: clsx(classes.root, classes["color".concat(capitalize(color))]),
        checked: classes.checked,
        disabled: classes.disabled
      },
      name: name,
      checked: checked,
      onChange: onChange,
      ref: ref,
      disabled: disabled
    }, other));
  });
   Radio.propTypes = {
    /**
     * If `true`, the component is checked.
     */
    checked: propTypes.bool,

    /**
     * The icon to display when the component is checked.
     */
    checkedIcon: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary', 'default']),

    /**
     * If `true`, the switch will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * The icon to display when the component is unchecked.
     */
    icon: propTypes.node,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     * You can pull out the new checked state by accessing `event.target.checked` (boolean).
     */
    onChange: propTypes.func,

    /**
     * If `true`, the `input` element will be required.
     */
    required: propTypes.bool,

    /**
     * The input component prop `type`.
     */
    type: propTypes.string,

    /**
     * The value of the component. The DOM API casts this to a string.
     */
    value: propTypes.any
  } ;
  var Radio$1 = withStyles$1(styles$1f, {
    name: 'MuiRadio'
  })(Radio);

  var RadioGroup = React__default.forwardRef(function RadioGroup(props, ref) {
    var actions = props.actions,
        children = props.children,
        name = props.name,
        valueProp = props.value,
        onChange = props.onChange,
        other = _objectWithoutProperties(props, ["actions", "children", "name", "value", "onChange"]);

    var rootRef = React__default.useRef(null);

    var _React$useRef = React__default.useRef(valueProp != null),
        isControlled = _React$useRef.current;

    var _React$useState = React__default.useState(props.defaultValue),
        valueState = _React$useState[0],
        setValue = _React$useState[1];

    var value = isControlled ? valueProp : valueState;

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__default.useEffect(function () {
        if (isControlled !== (valueProp != null)) {
          console.error(["Material-UI: A component is changing ".concat(isControlled ? 'a ' : 'an un', "controlled RadioGroup to be ").concat(isControlled ? 'un' : '', "controlled."), 'Elements should not switch from uncontrolled to controlled (or vice versa).', 'Decide between using a controlled or uncontrolled RadioGroup ' + 'element for the lifetime of the component.', 'More info: https://fb.me/react-controlled-components'].join('\n'));
        }
      }, [valueProp, isControlled]);
    }

    React__default.useImperativeHandle(actions, function () {
      return {
        focus: function focus() {
          var input = rootRef.current.querySelector('input:not(:disabled):checked');

          if (!input) {
            input = rootRef.current.querySelector('input:not(:disabled)');
          }

          if (input) {
            input.focus();
          }
        }
      };
    }, []);
    var handleRef = useForkRef(ref, rootRef);

    var handleChange = function handleChange(event) {
      if (!isControlled) {
        setValue(event.target.value);
      }

      if (onChange) {
        onChange(event, event.target.value);
      }
    };

    return React__default.createElement(RadioGroupContext.Provider, {
      value: {
        name: name,
        onChange: handleChange,
        value: value
      }
    }, React__default.createElement(FormGroup$1, _extends({
      role: "radiogroup",
      ref: handleRef
    }, other), children));
  });
   RadioGroup.propTypes = {
    /**
     * @ignore
     */
    actions: propTypes.shape({
      current: propTypes.object
    }),

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * The default `input` element value. Use when the component is not controlled.
     */
    defaultValue: propTypes.any,

    /**
     * The name used to reference the value of the control.
     */
    name: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * Callback fired when a radio button is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * Value of the selected radio button. The DOM API casts this to a string.
     */
    value: propTypes.any
  } ;

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  /**
   * ⚠️⚠️⚠️
   * If you want the DOM element of a Material-UI component check out
   * [FAQ: How can I access the DOM element?](/getting-started/faq/#how-can-i-access-the-dom-element)
   * first.
   *
   * This component uses `findDOMNode` which is deprecated in React.StrictMode.
   *
   * Helper component to allow attaching a ref to a
   * wrapped element to access the underlying DOM element.
   *
   * It's highly inspired by https://github.com/facebook/react/issues/11401#issuecomment-340543801.
   * For example:
   * ```jsx
   * import React from 'react';
   * import RootRef from '@material-ui/core/RootRef';
   *
   * function MyComponent() {
   *   const domRef = React.useRef();
   *
   *   React.useEffect(() => {
   *     console.log(domRef.current); // DOM node
   *   }, []);
   *
   *   return (
   *     <RootRef rootRef={domRef}>
   *       <SomeChildComponent />
   *     </RootRef>
   *   );
   * }
   * ```
   */

  var RootRef =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(RootRef, _React$Component);

    function RootRef() {
      _classCallCheck(this, RootRef);

      return _possibleConstructorReturn(this, _getPrototypeOf(RootRef).apply(this, arguments));
    }

    _createClass(RootRef, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.ref = ReactDOM.findDOMNode(this);
        setRef(this.props.rootRef, this.ref);
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        var ref = ReactDOM.findDOMNode(this);

        if (prevProps.rootRef !== this.props.rootRef || this.ref !== ref) {
          if (prevProps.rootRef !== this.props.rootRef) {
            setRef(prevProps.rootRef, null);
          }

          this.ref = ref;
          setRef(this.props.rootRef, this.ref);
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.ref = null;
        setRef(this.props.rootRef, null);
      }
    }, {
      key: "render",
      value: function render() {
        return this.props.children;
      }
    }]);

    return RootRef;
  }(React__default.Component);

   RootRef.propTypes = {
    /**
     * The wrapped element.
     */
    children: propTypes.element.isRequired,

    /**
     * A ref that points to the first DOM node of the wrapped element.
     */
    rootRef: refType.isRequired
  } ;

  {
     RootRef.propTypes = exactProp(RootRef.propTypes) ;
  }

  function areEqualValues(a, b) {
    if (_typeof(b) === 'object' && b !== null) {
      return a === b;
    }

    return String(a) === String(b);
  }

  function isEmpty(display) {
    return display == null || typeof display === 'string' && !display.trim();
  }
  /**
   * @ignore - internal component.
   */


  var SelectInput = React__default.forwardRef(function SelectInput(props, ref) {
    var autoFocus = props.autoFocus,
        autoWidth = props.autoWidth,
        children = props.children,
        classes = props.classes,
        className = props.className,
        defaultValue = props.defaultValue,
        disabled = props.disabled,
        displayEmpty = props.displayEmpty,
        labelId = props.labelId,
        IconComponent = props.IconComponent,
        inputRefProp = props.inputRef,
        _props$MenuProps = props.MenuProps,
        MenuProps = _props$MenuProps === void 0 ? {} : _props$MenuProps,
        multiple = props.multiple,
        name = props.name,
        onBlur = props.onBlur,
        onChange = props.onChange,
        onClose = props.onClose,
        onFocus = props.onFocus,
        onOpen = props.onOpen,
        openProp = props.open,
        readOnly = props.readOnly,
        renderValue = props.renderValue,
        required = props.required,
        _props$SelectDisplayP = props.SelectDisplayProps,
        SelectDisplayProps = _props$SelectDisplayP === void 0 ? {} : _props$SelectDisplayP,
        tabIndexProp = props.tabIndex,
        type = props.type,
        valueProp = props.value,
        _props$variant = props.variant,
        variant = _props$variant === void 0 ? 'standard' : _props$variant,
        other = _objectWithoutProperties(props, ["autoFocus", "autoWidth", "children", "classes", "className", "defaultValue", "disabled", "displayEmpty", "labelId", "IconComponent", "inputRef", "MenuProps", "multiple", "name", "onBlur", "onChange", "onClose", "onFocus", "onOpen", "open", "readOnly", "renderValue", "required", "SelectDisplayProps", "tabIndex", "type", "value", "variant"]);

    var _React$useRef = React__default.useRef(valueProp != null),
        isControlled = _React$useRef.current;

    var _React$useState = React__default.useState(defaultValue),
        valueState = _React$useState[0],
        setValueState = _React$useState[1];

    var value = isControlled ? valueProp : valueState;

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__default.useEffect(function () {
        if (isControlled !== (valueProp != null)) {
          console.error(["Material-UI: A component is changing ".concat(isControlled ? 'a ' : 'an un', "controlled Select to be ").concat(isControlled ? 'un' : '', "controlled."), 'Elements should not switch from uncontrolled to controlled (or vice versa).', 'Decide between using a controlled or uncontrolled Select ' + 'element for the lifetime of the component.', 'More info: https://fb.me/react-controlled-components'].join('\n'));
        }
      }, [valueProp, isControlled]);
    }

    var inputRef = React__default.useRef(null);

    var _React$useState2 = React__default.useState(null),
        displayNode = _React$useState2[0],
        setDisplayNode = _React$useState2[1];

    var _React$useRef2 = React__default.useRef(openProp != null),
        isOpenControlled = _React$useRef2.current;

    var _React$useState3 = React__default.useState(),
        menuMinWidthState = _React$useState3[0],
        setMenuMinWidthState = _React$useState3[1];

    var _React$useState4 = React__default.useState(false),
        openState = _React$useState4[0],
        setOpenState = _React$useState4[1];

    var handleRef = useForkRef(ref, inputRefProp);
    React__default.useImperativeHandle(handleRef, function () {
      return {
        focus: function focus() {
          displayNode.focus();
        },
        node: inputRef.current,
        value: value
      };
    }, [displayNode, value]);
    React__default.useEffect(function () {
      if (autoFocus && displayNode) {
        displayNode.focus();
      }
    }, [autoFocus, displayNode]);

    var update = function update(open, event) {
      if (open) {
        if (onOpen) {
          onOpen(event);
        }
      } else {
        displayNode.focus();

        if (onClose) {
          onClose(event);
        }
      }

      if (!isOpenControlled) {
        setMenuMinWidthState(autoWidth ? null : displayNode.clientWidth);
        setOpenState(open);
      }
    };

    var handleClick = function handleClick(event) {
      update(true, event);
    };

    var handleClose = function handleClose(event) {
      update(false, event);
    };

    var handleItemClick = function handleItemClick(child) {
      return function (event) {
        if (!multiple) {
          update(false, event);
        }

        var newValue;

        if (multiple) {
          newValue = Array.isArray(value) ? _toConsumableArray(value) : [];
          var itemIndex = value.indexOf(child.props.value);

          if (itemIndex === -1) {
            newValue.push(child.props.value);
          } else {
            newValue.splice(itemIndex, 1);
          }
        } else {
          newValue = child.props.value;
        }

        if (!isControlled) {
          setValueState(newValue);
        }

        if (onChange) {
          event.persist(); // Preact support, target is read only property on a native event.

          Object.defineProperty(event, 'target', {
            writable: true,
            value: {
              value: newValue,
              name: name
            }
          });
          onChange(event, child);
        }
      };
    };

    var handleKeyDown = function handleKeyDown(event) {
      if (!readOnly) {
        var validKeys = [' ', 'ArrowUp', 'ArrowDown', // The native select doesn't respond to enter on MacOS, but it's recommended by
        // https://www.w3.org/TR/wai-aria-practices/examples/listbox/listbox-collapsible.html
        'Enter'];

        if (validKeys.indexOf(event.key) !== -1) {
          event.preventDefault();
          update(true, event);
        }
      }
    };

    var open = displayNode !== null && (isOpenControlled ? openProp : openState);

    var handleBlur = function handleBlur(event) {
      // if open event.stopImmediatePropagation
      if (!open && onBlur) {
        event.persist(); // Preact support, target is read only property on a native event.

        Object.defineProperty(event, 'target', {
          writable: true,
          value: {
            value: value,
            name: name
          }
        });
        onBlur(event);
      }
    };

    delete other['aria-invalid'];
    var display;
    var displaySingle;
    var displayMultiple = [];
    var computeDisplay = false;
    var foundMatch = false; // No need to display any value if the field is empty.

    if (isFilled({
      value: value
    }) || displayEmpty) {
      if (renderValue) {
        display = renderValue(value);
      } else {
        computeDisplay = true;
      }
    }

    var items = React__default.Children.map(children, function (child) {
      if (!React__default.isValidElement(child)) {
        return null;
      }

      {
        if (child.type === React__default.Fragment) {
          console.error(["Material-UI: the Select component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      var selected;

      if (multiple) {
        if (!Array.isArray(value)) {
          throw new Error('Material-UI: the `value` prop must be an array ' + 'when using the `Select` component with `multiple`.');
        }

        selected = value.some(function (v) {
          return areEqualValues(v, child.props.value);
        });

        if (selected && computeDisplay) {
          displayMultiple.push(child.props.children);
        }
      } else {
        selected = areEqualValues(value, child.props.value);

        if (selected && computeDisplay) {
          displaySingle = child.props.children;
        }
      }

      if (selected) {
        foundMatch = true;
      }

      return React__default.cloneElement(child, {
        'aria-selected': selected ? 'true' : undefined,
        onClick: handleItemClick(child),
        role: 'option',
        selected: selected,
        value: undefined,
        // The value is most likely not a valid HTML attribute.
        'data-value': child.props.value // Instead, we provide it as a data attribute.

      });
    });

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__default.useEffect(function () {
        if (!foundMatch && !multiple && value !== '') {
          var values = React__default.Children.toArray(children).map(function (child) {
            return child.props.value;
          });
          console.warn(["Material-UI: you have provided an out-of-range value `".concat(value, "` for the select ").concat(name ? "(name=\"".concat(name, "\") ") : '', "component."), "Consider providing a value that matches one of the available options or ''.", "The available values are ".concat(values.filter(function (x) {
            return x != null;
          }).map(function (x) {
            return "`".concat(x, "`");
          }).join(', ') || '""', ".")].join('\n'));
        }
      }, [foundMatch, children, multiple, name, value]);
    }

    if (computeDisplay) {
      display = multiple ? displayMultiple.join(', ') : displaySingle;
    } // Avoid performing a layout computation in the render method.


    var menuMinWidth = menuMinWidthState;

    if (!autoWidth && isOpenControlled && displayNode) {
      menuMinWidth = displayNode.clientWidth;
    }

    var tabIndex;

    if (typeof tabIndexProp !== 'undefined') {
      tabIndex = tabIndexProp;
    } else {
      tabIndex = disabled ? null : 0;
    }

    var buttonId = SelectDisplayProps.id || (name ? "mui-component-select-".concat(name) : undefined);
    return React__default.createElement(React__default.Fragment, null, React__default.createElement("div", _extends({
      className: clsx(classes.root, // TODO v5: merge root and select
      classes.select, classes.selectMenu, classes[variant], className, disabled && classes.disabled),
      ref: setDisplayNode,
      tabIndex: tabIndex,
      role: "button",
      "aria-expanded": open ? 'true' : undefined,
      "aria-labelledby": "".concat(labelId || '', " ").concat(buttonId || ''),
      "aria-haspopup": "listbox",
      onKeyDown: handleKeyDown,
      onClick: disabled || readOnly ? null : handleClick,
      onBlur: handleBlur,
      onFocus: onFocus
    }, SelectDisplayProps, {
      // The id is required for proper a11y
      id: buttonId
    }), isEmpty(display) ? // eslint-disable-next-line react/no-danger
    React__default.createElement("span", {
      dangerouslySetInnerHTML: {
        __html: '&#8203;'
      }
    }) : display), React__default.createElement("input", _extends({
      value: Array.isArray(value) ? value.join(',') : value,
      name: name,
      ref: inputRef,
      type: "hidden",
      autoFocus: autoFocus
    }, other)), React__default.createElement(IconComponent, {
      className: clsx(classes.icon, classes["icon".concat(capitalize(variant))], open && classes.iconOpen)
    }), React__default.createElement(Menu$1, _extends({
      id: "menu-".concat(name || ''),
      anchorEl: displayNode,
      open: open,
      onClose: handleClose
    }, MenuProps, {
      MenuListProps: _extends({
        'aria-labelledby': labelId,
        role: 'listbox',
        disableListWrap: true
      }, MenuProps.MenuListProps),
      PaperProps: _extends({}, MenuProps.PaperProps, {
        style: _extends({
          minWidth: menuMinWidth
        }, MenuProps.PaperProps != null ? MenuProps.PaperProps.style : null)
      })
    }), items));
  });
   SelectInput.propTypes = {
    /**
     * @ignore
     */
    autoFocus: propTypes.bool,

    /**
     * If true, the width of the popover will automatically be set according to the items inside the
     * menu, otherwise it will be at least the width of the select input.
     */
    autoWidth: propTypes.bool,

    /**
     * The option elements to populate the select with.
     * Can be some `<MenuItem>` elements.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the select element.
     */
    className: propTypes.string,

    /**
     * The default element value. Use when the component is not controlled.
     */
    defaultValue: propTypes.any,

    /**
     * If `true`, the select will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the selected item is displayed even if its value is empty.
     */
    displayEmpty: propTypes.bool,

    /**
     * The icon that displays the arrow.
     */
    IconComponent: propTypes.elementType.isRequired,

    /**
     * Imperative handle implementing `{ value: T, node: HTMLElement, focus(): void }`
     * Equivalent to `ref`
     */
    inputRef: refType,

    /**
     * The idea of an element that acts as an additional label. The Select will
     * be labelled by the additional label and the selected value.
     */
    labelId: propTypes.string,

    /**
     * Props applied to the [`Menu`](/api/menu/) element.
     */
    MenuProps: propTypes.object,

    /**
     * If true, `value` must be an array and the menu will support multiple selections.
     */
    multiple: propTypes.bool,

    /**
     * Name attribute of the `select` or hidden `input` element.
     */
    name: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * Callback function fired when a menu item is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (any).
     * @param {object} [child] The react element that was selected.
     */
    onChange: propTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     * Use in controlled mode (see open).
     *
     * @param {object} event The event source of the callback.
     */
    onClose: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * Callback fired when the component requests to be opened.
     * Use in controlled mode (see open).
     *
     * @param {object} event The event source of the callback.
     */
    onOpen: propTypes.func,

    /**
     * Control `select` open state.
     */
    open: propTypes.bool,

    /**
     * @ignore
     */
    readOnly: propTypes.bool,

    /**
     * Render the selected value.
     *
     * @param {any} value The `value` provided to the component.
     * @returns {ReactNode}
     */
    renderValue: propTypes.func,

    /**
     * @ignore
     */
    required: propTypes.bool,

    /**
     * Props applied to the clickable div element.
     */
    SelectDisplayProps: propTypes.object,

    /**
     * @ignore
     */
    tabIndex: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * @ignore
     */
    type: propTypes.any,

    /**
     * The input value.
     */
    value: propTypes.any,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  } ;

  var styles$1g = styles$1b;

  var _ref$1 = React__default.createElement(Input$1, null);

  var _ref2 = React__default.createElement(FilledInput$1, null);

  var Select = React__default.forwardRef(function Select(props, ref) {
    var _props$autoWidth = props.autoWidth,
        autoWidth = _props$autoWidth === void 0 ? false : _props$autoWidth,
        children = props.children,
        classes = props.classes,
        _props$displayEmpty = props.displayEmpty,
        displayEmpty = _props$displayEmpty === void 0 ? false : _props$displayEmpty,
        _props$IconComponent = props.IconComponent,
        IconComponent = _props$IconComponent === void 0 ? ArrowDropDownIcon : _props$IconComponent,
        id = props.id,
        input = props.input,
        inputProps = props.inputProps,
        labelId = props.labelId,
        MenuProps = props.MenuProps,
        _props$multiple = props.multiple,
        multiple = _props$multiple === void 0 ? false : _props$multiple,
        _props$native = props.native,
        native = _props$native === void 0 ? false : _props$native,
        onClose = props.onClose,
        onOpen = props.onOpen,
        open = props.open,
        renderValue = props.renderValue,
        SelectDisplayProps = props.SelectDisplayProps,
        _props$variant = props.variant,
        variantProps = _props$variant === void 0 ? 'standard' : _props$variant,
        _props$labelWidth = props.labelWidth,
        labelWidth = _props$labelWidth === void 0 ? 0 : _props$labelWidth,
        other = _objectWithoutProperties(props, ["autoWidth", "children", "classes", "displayEmpty", "IconComponent", "id", "input", "inputProps", "labelId", "MenuProps", "multiple", "native", "onClose", "onOpen", "open", "renderValue", "SelectDisplayProps", "variant", "labelWidth"]);

    var inputComponent = native ? NativeSelectInput : SelectInput;
    var muiFormControl = useFormControl$1();
    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['variant']
    });
    var variant = fcs.variant || variantProps;
    var InputComponent = input || {
      standard: _ref$1,
      outlined: React__default.createElement(OutlinedInput$1, {
        labelWidth: labelWidth
      }),
      filled: _ref2
    }[variant];
    return React__default.cloneElement(InputComponent, _extends({
      // Most of the logic is implemented in `SelectInput`.
      // The `Select` component is a simple API wrapper to expose something better to play with.
      inputComponent: inputComponent,
      select: true,
      inputProps: _extends({
        children: children,
        IconComponent: IconComponent,
        variant: variant,
        type: undefined,
        // We render a select. We can ignore the type provided by the `Input`.
        multiple: multiple
      }, native ? {
        id: id
      } : {
        autoWidth: autoWidth,
        displayEmpty: displayEmpty,
        labelId: labelId,
        MenuProps: MenuProps,
        onClose: onClose,
        onOpen: onOpen,
        open: open,
        renderValue: renderValue,
        SelectDisplayProps: _extends({
          id: id
        }, SelectDisplayProps)
      }, {}, inputProps, {
        classes: inputProps ? mergeClasses({
          baseClasses: classes,
          newClasses: inputProps.classes,
          Component: Select
        }) : classes
      }, input ? input.props.inputProps : {}),
      ref: ref
    }, other));
  });
   Select.propTypes = {
    /**
     * If true, the width of the popover will automatically be set according to the items inside the
     * menu, otherwise it will be at least the width of the select input.
     */
    autoWidth: propTypes.bool,

    /**
     * The option elements to populate the select with.
     * Can be some `MenuItem` when `native` is false and `option` when `native` is true.
     *
     * ⚠️The `MenuItem` elements **must** be direct descendants when `native` is false.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The default element value. Use when the component is not controlled.
     */
    defaultValue: propTypes.any,

    /**
     * If `true`, a value is displayed even if no items are selected.
     *
     * In order to display a meaningful value, a function should be passed to the `renderValue` prop which returns the value to be displayed when no items are selected.
     * You can only use it when the `native` prop is `false` (default).
     */
    displayEmpty: propTypes.bool,

    /**
     * The icon that displays the arrow.
     */
    IconComponent: propTypes.elementType,

    /**
     * @ignore
     */
    id: propTypes.string,

    /**
     * An `Input` element; does not have to be a material-ui specific `Input`.
     */
    input: propTypes.element,

    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     * When `native` is `true`, the attributes are applied on the `select` element.
     */
    inputProps: propTypes.object,

    /**
     * The idea of an element that acts as an additional label. The Select will
     * be labelled by the additional label and the selected value.
     */
    labelId: propTypes.string,

    /**
     * The label width to be used on OutlinedInput.
     * This prop is required when the `variant` prop is `outlined`.
     */
    labelWidth: propTypes.number,

    /**
     * Props applied to the [`Menu`](/api/menu/) element.
     */
    MenuProps: propTypes.object,

    /**
     * If true, `value` must be an array and the menu will support multiple selections.
     */
    multiple: propTypes.bool,

    /**
     * If `true`, the component will be using a native `select` element.
     */
    native: propTypes.bool,

    /**
     * Callback function fired when a menu item is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (any).
     * @param {object} [child] The react element that was selected when `native` is `false` (default).
     */
    onChange: propTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     * Use in controlled mode (see open).
     *
     * @param {object} event The event source of the callback.
     */
    onClose: propTypes.func,

    /**
     * Callback fired when the component requests to be opened.
     * Use in controlled mode (see open).
     *
     * @param {object} event The event source of the callback.
     */
    onOpen: propTypes.func,

    /**
     * Control `select` open state.
     * You can only use it when the `native` prop is `false` (default).
     */
    open: propTypes.bool,

    /**
     * Render the selected value.
     * You can only use it when the `native` prop is `false` (default).
     *
     * @param {any} value The `value` provided to the component.
     * @returns {ReactNode}
     */
    renderValue: propTypes.func,

    /**
     * Props applied to the clickable div element.
     */
    SelectDisplayProps: propTypes.object,

    /**
     * The input value. Providing an empty string will select no options.
     * This prop is required when the `native` prop is `false` (default).
     * Set to an empty string `''` if you don't want any of the available options to be selected.
     *
     * If the value is an object it must have reference equality with the option in order to be selected.
     * If the value is not an object, the string representation must match with the string representation of the option in order to be selected.
     */
    value: propTypes.any,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  } ;
  Select.muiName = 'Select';
  var Select$1 = withStyles$1(styles$1g, {
    name: 'MuiSelect'
  })(Select);

  var styles$1h = function styles(theme) {
    return {
      thumb: {
        '&$open': {
          '& $offset': {
            transform: 'scale(1) translateY(-10px)'
          }
        }
      },
      open: {},
      offset: _extends({
        zIndex: 1
      }, theme.typography.body2, {
        fontSize: theme.typography.pxToRem(12),
        lineHeight: 1.2,
        transition: theme.transitions.create(['transform'], {
          duration: theme.transitions.duration.shortest
        }),
        top: -34,
        left: 'calc(-50% + -4px)',
        transformOrigin: 'bottom center',
        transform: 'scale(0)',
        position: 'absolute'
      }),
      circle: {
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
        width: 32,
        height: 32,
        borderRadius: '50% 50% 50% 0',
        backgroundColor: 'currentColor',
        transform: 'rotate(-45deg)'
      },
      label: {
        color: theme.palette.primary.contrastText,
        transform: 'rotate(45deg)'
      }
    };
  };
  /**
   * @ignore - internal component.
   */


  function ValueLabel(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        open = props.open,
        value = props.value,
        valueLabelDisplay = props.valueLabelDisplay;

    if (valueLabelDisplay === 'off') {
      return children;
    }

    return React__default.cloneElement(children, {
      className: clsx(children.props.className, (open || valueLabelDisplay === 'on') && classes.open, classes.thumb)
    }, React__default.createElement("span", {
      className: clsx(classes.offset, className)
    }, React__default.createElement("span", {
      className: classes.circle
    }, React__default.createElement("span", {
      className: classes.label
    }, value))));
  }

  var ValueLabel$1 = withStyles$1(styles$1h, {
    name: 'PrivateValueLabel'
  })(ValueLabel);

  function asc(a, b) {
    return a - b;
  }

  function clamp$1(value, min, max) {
    if (value < min) {
      return min;
    }

    if (value > max) {
      return max;
    }

    return value;
  }

  function findClosest(values, currentValue) {
    var _values$reduce = values.reduce(function (acc, value, index) {
      var distance = Math.abs(currentValue - value);

      if (acc === null || distance < acc.distance || distance === acc.distance) {
        return {
          distance: distance,
          index: index
        };
      }

      return acc;
    }, null),
        closestIndex = _values$reduce.index;

    return closestIndex;
  }

  function trackFinger(event, touchId) {
    if (touchId.current !== undefined && event.changedTouches) {
      for (var i = 0; i < event.changedTouches.length; i += 1) {
        var touch = event.changedTouches[i];

        if (touch.identifier === touchId.current) {
          return {
            x: touch.clientX,
            y: touch.clientY
          };
        }
      }

      return false;
    }

    return {
      x: event.clientX,
      y: event.clientY
    };
  }

  function valueToPercent(value, min, max) {
    return (value - min) * 100 / (max - min);
  }

  function percentToValue(percent, min, max) {
    return (max - min) * percent + min;
  }

  function getDecimalPrecision(num) {
    // This handles the case when num is very small (0.00000001), js will turn this into 1e-8.
    // When num is bigger than 1 or less than -1 it won't get converted to this notation so it's fine.
    if (Math.abs(num) < 1) {
      var parts = num.toExponential().split('e-');
      var matissaDecimalPart = parts[0].split('.')[1];
      return (matissaDecimalPart ? matissaDecimalPart.length : 0) + parseInt(parts[1], 10);
    }

    var decimalPart = num.toString().split('.')[1];
    return decimalPart ? decimalPart.length : 0;
  }

  function roundValueToStep(value, step) {
    var nearest = Math.round(value / step) * step;
    return Number(nearest.toFixed(getDecimalPrecision(step)));
  }

  function setValueIndex(_ref) {
    var values = _ref.values,
        source = _ref.source,
        newValue = _ref.newValue,
        index = _ref.index;

    // Performance shortcut
    if (values[index] === newValue) {
      return source;
    }

    var output = _toConsumableArray(values);

    output[index] = newValue;
    return output;
  }

  function focusThumb(_ref2) {
    var sliderRef = _ref2.sliderRef,
        activeIndex = _ref2.activeIndex,
        setActive = _ref2.setActive;

    if (!sliderRef.current.contains(document.activeElement) || Number(document.activeElement.getAttribute('data-index')) !== activeIndex) {
      sliderRef.current.querySelector("[data-index=\"".concat(activeIndex, "\"]")).focus();
    }

    if (setActive) {
      setActive(activeIndex);
    }
  }

  var axisProps = {
    horizontal: {
      offset: function offset(percent) {
        return {
          left: "".concat(percent, "%")
        };
      },
      leap: function leap(percent) {
        return {
          width: "".concat(percent, "%")
        };
      }
    },
    'horizontal-reverse': {
      offset: function offset(percent) {
        return {
          right: "".concat(percent, "%")
        };
      },
      leap: function leap(percent) {
        return {
          width: "".concat(percent, "%")
        };
      }
    },
    vertical: {
      offset: function offset(percent) {
        return {
          bottom: "".concat(percent, "%")
        };
      },
      leap: function leap(percent) {
        return {
          height: "".concat(percent, "%")
        };
      }
    }
  };
  var defaultMarks = [];

  var Identity = function Identity(x) {
    return x;
  };

  var styles$1i = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        height: 2,
        width: '100%',
        boxSizing: 'content-box',
        padding: '11px 0',
        display: 'inline-block',
        position: 'relative',
        cursor: 'pointer',
        touchAction: 'none',
        color: theme.palette.primary.main,
        // Remove grey highlight
        WebkitTapHighlightColor: 'transparent',
        '&$disabled': {
          pointerEvents: 'none',
          cursor: 'default',
          color: theme.palette.grey[400]
        },
        '&$vertical': {
          width: 2,
          height: '100%',
          padding: '0 11px'
        },
        // The primary input mechanism of the device includes a pointing device of limited accuracy.
        '@media (pointer: coarse)': {
          // Reach 42px touch target, about ~8mm on screen.
          padding: '20px 0',
          '&$vertical': {
            padding: '0 20px'
          }
        }
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {// TODO v5, move the style here
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the root element if `marks` is provided with at least one label. */
      marked: {
        marginBottom: 20,
        '&$vertical': {
          marginBottom: 'auto',
          marginRight: 20
        }
      },

      /* Pseudo-class applied to the root element if `orientation="vertical"`. */
      vertical: {},

      /* Pseudo-class applied to the root and thumb element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the rail element. */
      rail: {
        display: 'block',
        position: 'absolute',
        width: '100%',
        height: 2,
        borderRadius: 1,
        backgroundColor: 'currentColor',
        opacity: 0.38,
        '$vertical &': {
          height: '100%',
          width: 2
        }
      },

      /* Styles applied to the track element. */
      track: {
        display: 'block',
        position: 'absolute',
        height: 2,
        borderRadius: 1,
        backgroundColor: 'currentColor',
        '$vertical &': {
          width: 2
        }
      },

      /* Styles applied to the track element if `track={false}`. */
      trackFalse: {
        '& $track': {
          display: 'none'
        }
      },

      /* Styles applied to the track element if `track="inverted"`. */
      trackInverted: {
        '& $track': {
          backgroundColor: // Same logic as the LinearProgress track color
          theme.palette.type === 'light' ? lighten(theme.palette.primary.main, 0.62) : darken(theme.palette.primary.main, 0.5)
        },
        '& $rail': {
          opacity: 1
        }
      },

      /* Styles applied to the thumb element. */
      thumb: {
        position: 'absolute',
        width: 12,
        height: 12,
        marginLeft: -6,
        marginTop: -5,
        boxSizing: 'border-box',
        borderRadius: '50%',
        outline: 0,
        backgroundColor: 'currentColor',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
        transition: theme.transitions.create(['box-shadow'], {
          duration: theme.transitions.duration.shortest
        }),
        '&::after': {
          position: 'absolute',
          content: '""',
          // reach 48px touch target (2 * 18 + thumb circumference)
          left: -18,
          top: -18,
          right: -18,
          bottom: -18
        },
        '&$focusVisible,&:hover': {
          boxShadow: "0px 0px 0px 8px ".concat(fade(theme.palette.primary.main, 0.16)),
          '@media (hover: none)': {
            boxShadow: 'none'
          }
        },
        '&$active': {
          boxShadow: "0px 0px 0px 14px ".concat(fade(theme.palette.primary.main, 0.16))
        },
        '&$disabled': {
          width: 8,
          height: 8,
          marginLeft: -4,
          marginTop: -3,
          '&:hover': {
            boxShadow: 'none'
          }
        },
        '$vertical &': {
          marginLeft: -5,
          marginBottom: -6
        },
        '$vertical &$disabled': {
          marginLeft: -3,
          marginBottom: -4
        }
      },

      /* Styles applied to the thumb element if `color="primary"`. */
      thumbColorPrimary: {// TODO v5, move the style here
      },

      /* Styles applied to the thumb element if `color="secondary"`. */
      thumbColorSecondary: {
        '&$focusVisible,&:hover': {
          boxShadow: "0px 0px 0px 8px ".concat(fade(theme.palette.secondary.main, 0.16))
        },
        '&$active': {
          boxShadow: "0px 0px 0px 14px ".concat(fade(theme.palette.secondary.main, 0.16))
        }
      },

      /* Pseudo-class applied to the thumb element if it's active. */
      active: {},

      /* Pseudo-class applied to the thumb element if keyboard focused. */
      focusVisible: {},

      /* Styles applied to the thumb label element. */
      valueLabel: {},

      /* Styles applied to the mark element. */
      mark: {
        position: 'absolute',
        width: 2,
        height: 2,
        borderRadius: 1,
        backgroundColor: 'currentColor'
      },

      /* Styles applied to the mark element if active (depending on the value). */
      markActive: {
        backgroundColor: theme.palette.background.paper,
        opacity: 0.8
      },

      /* Styles applied to the mark label element. */
      markLabel: _extends({}, theme.typography.body2, {
        color: theme.palette.text.secondary,
        position: 'absolute',
        top: 22,
        transform: 'translateX(-50%)',
        whiteSpace: 'nowrap',
        '$vertical &': {
          top: 'auto',
          left: 22,
          transform: 'translateY(50%)'
        },
        '@media (pointer: coarse)': {
          top: 40,
          '$vertical &': {
            left: 31
          }
        }
      }),

      /* Styles applied to the mark label element if active (depending on the value). */
      markLabelActive: {
        color: theme.palette.text.primary
      }
    };
  };
  var Slider = React__default.forwardRef(function Slider(props, ref) {
    var ariaLabel = props['aria-label'],
        ariaLabelledby = props['aria-labelledby'],
        ariaValuetext = props['aria-valuetext'],
        classes = props.classes,
        className = props.className,
        _props$color = props.color,
        color = _props$color === void 0 ? 'primary' : _props$color,
        _props$component = props.component,
        Component = _props$component === void 0 ? 'span' : _props$component,
        defaultValue = props.defaultValue,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        getAriaLabel = props.getAriaLabel,
        getAriaValueText = props.getAriaValueText,
        _props$marks = props.marks,
        marksProp = _props$marks === void 0 ? defaultMarks : _props$marks,
        _props$max = props.max,
        max = _props$max === void 0 ? 100 : _props$max,
        _props$min = props.min,
        min = _props$min === void 0 ? 0 : _props$min,
        name = props.name,
        onChange = props.onChange,
        onChangeCommitted = props.onChangeCommitted,
        onMouseDown = props.onMouseDown,
        _props$orientation = props.orientation,
        orientation = _props$orientation === void 0 ? 'horizontal' : _props$orientation,
        _props$step = props.step,
        step = _props$step === void 0 ? 1 : _props$step,
        _props$ThumbComponent = props.ThumbComponent,
        ThumbComponent = _props$ThumbComponent === void 0 ? 'span' : _props$ThumbComponent,
        _props$track = props.track,
        track = _props$track === void 0 ? 'normal' : _props$track,
        valueProp = props.value,
        _props$ValueLabelComp = props.ValueLabelComponent,
        ValueLabelComponent = _props$ValueLabelComp === void 0 ? ValueLabel$1 : _props$ValueLabelComp,
        _props$valueLabelDisp = props.valueLabelDisplay,
        valueLabelDisplay = _props$valueLabelDisp === void 0 ? 'off' : _props$valueLabelDisp,
        _props$valueLabelForm = props.valueLabelFormat,
        valueLabelFormat = _props$valueLabelForm === void 0 ? Identity : _props$valueLabelForm,
        other = _objectWithoutProperties(props, ["aria-label", "aria-labelledby", "aria-valuetext", "classes", "className", "color", "component", "defaultValue", "disabled", "getAriaLabel", "getAriaValueText", "marks", "max", "min", "name", "onChange", "onChangeCommitted", "onMouseDown", "orientation", "step", "ThumbComponent", "track", "value", "ValueLabelComponent", "valueLabelDisplay", "valueLabelFormat"]);

    var theme = useTheme$1();
    var touchId = React__default.useRef(); // We can't use the :active browser pseudo-classes.
    // - The active state isn't triggered when clicking on the rail.
    // - The active state isn't transfered when inversing a range slider.

    var _React$useState = React__default.useState(-1),
        active = _React$useState[0],
        setActive = _React$useState[1];

    var _React$useState2 = React__default.useState(-1),
        open = _React$useState2[0],
        setOpen = _React$useState2[1];

    var _React$useRef = React__default.useRef(valueProp != null),
        isControlled = _React$useRef.current;

    var _React$useState3 = React__default.useState(defaultValue),
        valueState = _React$useState3[0],
        setValueState = _React$useState3[1];

    var valueDerived = isControlled ? valueProp : valueState;

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__default.useEffect(function () {
        if (isControlled !== (valueProp != null)) {
          console.error(["Material-UI: A component is changing ".concat(isControlled ? 'a ' : 'an un', "controlled Slider to be ").concat(isControlled ? 'un' : '', "controlled."), 'Elements should not switch from uncontrolled to controlled (or vice versa).', 'Decide between using a controlled or uncontrolled Slider ' + 'element for the lifetime of the component.', 'More info: https://fb.me/react-controlled-components'].join('\n'));
        }
      }, [valueProp, isControlled]);
    }

    var range = Array.isArray(valueDerived);
    var instanceRef = React__default.useRef();
    var values = range ? _toConsumableArray(valueDerived).sort(asc) : [valueDerived];
    values = values.map(function (value) {
      return clamp$1(value, min, max);
    });
    var marks = marksProp === true && step !== null ? _toConsumableArray(Array(Math.floor((max - min) / step) + 1)).map(function (_, index) {
      return {
        value: min + step * index
      };
    }) : marksProp;
    instanceRef.current = {
      source: valueDerived // Keep track of the input value to leverage immutable state comparison.

    };

    var _useIsFocusVisible = useIsFocusVisible(),
        isFocusVisible = _useIsFocusVisible.isFocusVisible,
        onBlurVisible = _useIsFocusVisible.onBlurVisible,
        focusVisibleRef = _useIsFocusVisible.ref;

    var _React$useState4 = React__default.useState(-1),
        focusVisible = _React$useState4[0],
        setFocusVisible = _React$useState4[1];

    var sliderRef = React__default.useRef();
    var handleFocusRef = useForkRef(focusVisibleRef, sliderRef);
    var handleRef = useForkRef(ref, handleFocusRef);
    var handleFocus = useEventCallback(function (event) {
      var index = Number(event.currentTarget.getAttribute('data-index'));

      if (isFocusVisible(event)) {
        setFocusVisible(index);
      }

      setOpen(index);
    });
    var handleBlur = useEventCallback(function () {
      if (focusVisible !== -1) {
        setFocusVisible(-1);
        onBlurVisible();
      }

      setOpen(-1);
    });
    var handleMouseOver = useEventCallback(function (event) {
      var index = Number(event.currentTarget.getAttribute('data-index'));
      setOpen(index);
    });
    var handleMouseLeave = useEventCallback(function () {
      setOpen(-1);
    });
    var handleKeyDown = useEventCallback(function (event) {
      var index = Number(event.currentTarget.getAttribute('data-index'));
      var value = values[index];
      var tenPercents = (max - min) / 10;
      var marksValues = marks.map(function (mark) {
        return mark.value;
      });
      var marksIndex = marksValues.indexOf(value);
      var newValue;

      switch (event.key) {
        case 'Home':
          newValue = min;
          break;

        case 'End':
          newValue = max;
          break;

        case 'PageUp':
          if (step) {
            newValue = value + tenPercents;
          }

          break;

        case 'PageDown':
          if (step) {
            newValue = value - tenPercents;
          }

          break;

        case 'ArrowRight':
        case 'ArrowUp':
          if (step) {
            newValue = value + step;
          } else {
            newValue = marksValues[marksIndex + 1] || marksValues[marksValues.length - 1];
          }

          break;

        case 'ArrowLeft':
        case 'ArrowDown':
          if (step) {
            newValue = value - step;
          } else {
            newValue = marksValues[marksIndex - 1] || marksValues[0];
          }

          break;

        default:
          return;
      } // Prevent scroll of the page


      event.preventDefault();

      if (step) {
        newValue = roundValueToStep(newValue, step);
      }

      newValue = clamp$1(newValue, min, max);

      if (range) {
        var previousValue = newValue;
        newValue = setValueIndex({
          values: values,
          source: valueDerived,
          newValue: newValue,
          index: index
        }).sort(asc);
        focusThumb({
          sliderRef: sliderRef,
          activeIndex: newValue.indexOf(previousValue)
        });
      }

      if (!isControlled) {
        setValueState(newValue);
      }

      setFocusVisible(index);

      if (onChange) {
        onChange(event, newValue);
      }

      if (onChangeCommitted) {
        onChangeCommitted(event, newValue);
      }
    });
    var previousIndex = React__default.useRef();
    var axis = orientation;

    if (theme.direction === 'rtl' && orientation !== "vertical") {
      axis += '-reverse';
    }

    var getFingerNewValue = React__default.useCallback(function (_ref3) {
      var finger = _ref3.finger,
          _ref3$move = _ref3.move,
          move = _ref3$move === void 0 ? false : _ref3$move,
          values2 = _ref3.values,
          source = _ref3.source;
      var slider = sliderRef.current;

      var _slider$getBoundingCl = slider.getBoundingClientRect(),
          width = _slider$getBoundingCl.width,
          height = _slider$getBoundingCl.height,
          bottom = _slider$getBoundingCl.bottom,
          left = _slider$getBoundingCl.left;

      var percent;

      if (axis.indexOf('vertical') === 0) {
        percent = (bottom - finger.y) / height;
      } else {
        percent = (finger.x - left) / width;
      }

      if (axis.indexOf('-reverse') !== -1) {
        percent = 1 - percent;
      }

      var newValue;
      newValue = percentToValue(percent, min, max);

      if (step) {
        newValue = roundValueToStep(newValue, step);
      } else {
        var marksValues = marks.map(function (mark) {
          return mark.value;
        });
        var closestIndex = findClosest(marksValues, newValue);
        newValue = marksValues[closestIndex];
      }

      newValue = clamp$1(newValue, min, max);
      var activeIndex = 0;

      if (range) {
        if (!move) {
          activeIndex = findClosest(values2, newValue);
        } else {
          activeIndex = previousIndex.current;
        }

        var previousValue = newValue;
        newValue = setValueIndex({
          values: values2,
          source: source,
          newValue: newValue,
          index: activeIndex
        }).sort(asc);
        activeIndex = newValue.indexOf(previousValue);
        previousIndex.current = activeIndex;
      }

      return {
        newValue: newValue,
        activeIndex: activeIndex
      };
    }, [max, min, axis, range, step, marks]);
    var handleTouchMove = useEventCallback(function (event) {
      var finger = trackFinger(event, touchId);

      if (!finger) {
        return;
      }

      var _getFingerNewValue = getFingerNewValue({
        finger: finger,
        move: true,
        values: values,
        source: valueDerived
      }),
          newValue = _getFingerNewValue.newValue,
          activeIndex = _getFingerNewValue.activeIndex;

      focusThumb({
        sliderRef: sliderRef,
        activeIndex: activeIndex,
        setActive: setActive
      });

      if (!isControlled) {
        setValueState(newValue);
      }

      if (onChange) {
        onChange(event, newValue);
      }
    });
    var handleTouchEnd = useEventCallback(function (event) {
      var finger = trackFinger(event, touchId);

      if (!finger) {
        return;
      }

      var _getFingerNewValue2 = getFingerNewValue({
        finger: finger,
        values: values,
        source: valueDerived
      }),
          newValue = _getFingerNewValue2.newValue;

      setActive(-1);

      if (event.type === 'touchend') {
        setOpen(-1);
      }

      if (onChangeCommitted) {
        onChangeCommitted(event, newValue);
      }

      touchId.current = undefined;
      document.body.removeEventListener('mousemove', handleTouchMove);
      document.body.removeEventListener('mouseup', handleTouchEnd); // eslint-disable-next-line no-use-before-define

      document.body.removeEventListener('mouseenter', handleMouseEnter);
      document.body.removeEventListener('touchmove', handleTouchMove);
      document.body.removeEventListener('touchend', handleTouchEnd);
    });
    var handleMouseEnter = useEventCallback(function (event) {
      // If the slider was being interacted with but the mouse went off the window
      // and then re-entered while unclicked then end the interaction.
      if (event.buttons === 0) {
        handleTouchEnd(event);
      }
    });
    var handleTouchStart = useEventCallback(function (event) {
      // Workaround as Safari has partial support for touchAction: 'none'.
      event.preventDefault();
      var touch = event.changedTouches[0];

      if (touch != null) {
        // A number that uniquely identifies the current finger in the touch session.
        touchId.current = touch.identifier;
      }

      var finger = trackFinger(event, touchId);

      var _getFingerNewValue3 = getFingerNewValue({
        finger: finger,
        values: values,
        source: valueDerived
      }),
          newValue = _getFingerNewValue3.newValue,
          activeIndex = _getFingerNewValue3.activeIndex;

      focusThumb({
        sliderRef: sliderRef,
        activeIndex: activeIndex,
        setActive: setActive
      });

      if (!isControlled) {
        setValueState(newValue);
      }

      if (onChange) {
        onChange(event, newValue);
      }

      document.body.addEventListener('touchmove', handleTouchMove);
      document.body.addEventListener('touchend', handleTouchEnd);
    });
    React__default.useEffect(function () {
      var slider = sliderRef.current;
      slider.addEventListener('touchstart', handleTouchStart);
      return function () {
        slider.removeEventListener('touchstart', handleTouchStart);
        document.body.removeEventListener('mousemove', handleTouchMove);
        document.body.removeEventListener('mouseup', handleTouchEnd);
        document.body.removeEventListener('mouseenter', handleMouseEnter);
        document.body.removeEventListener('touchmove', handleTouchMove);
        document.body.removeEventListener('touchend', handleTouchEnd);
      };
    }, [handleMouseEnter, handleTouchEnd, handleTouchMove, handleTouchStart]);

    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__default.useEffect(function () {
        if (isControlled !== (valueProp != null)) {
          console.error(["Material-UI: A component is changing ".concat(isControlled ? 'a ' : 'an un', "controlled Slider to be ").concat(isControlled ? 'un' : '', "controlled."), 'Elements should not switch from uncontrolled to controlled (or vice versa).', 'Decide between using a controlled or uncontrolled Slider ' + 'element for the lifetime of the component.', 'More info: https://fb.me/react-controlled-components'].join('\n'));
        }
      }, [valueProp, isControlled]);
    }

    var handleMouseDown = useEventCallback(function (event) {
      if (onMouseDown) {
        onMouseDown(event);
      }

      event.preventDefault();
      var finger = trackFinger(event, touchId);

      var _getFingerNewValue4 = getFingerNewValue({
        finger: finger,
        values: values,
        source: valueDerived
      }),
          newValue = _getFingerNewValue4.newValue,
          activeIndex = _getFingerNewValue4.activeIndex;

      focusThumb({
        sliderRef: sliderRef,
        activeIndex: activeIndex,
        setActive: setActive
      });

      if (!isControlled) {
        setValueState(newValue);
      }

      if (onChange) {
        onChange(event, newValue);
      }

      document.body.addEventListener('mousemove', handleTouchMove);
      document.body.addEventListener('mouseenter', handleMouseEnter);
      document.body.addEventListener('mouseup', handleTouchEnd);
    });
    var trackOffset = valueToPercent(range ? values[0] : min, min, max);
    var trackLeap = valueToPercent(values[values.length - 1], min, max) - trackOffset;

    var trackStyle = _extends({}, axisProps[axis].offset(trackOffset), {}, axisProps[axis].leap(trackLeap));

    return React__default.createElement(Component, _extends({
      ref: handleRef,
      className: clsx(classes.root, classes["color".concat(capitalize(color))], className, disabled && classes.disabled, marks.length > 0 && marks.some(function (mark) {
        return mark.label;
      }) && classes.marked, track === false && classes.trackFalse, {
        vertical: classes.vertical
      }[orientation], {
        inverted: classes.trackInverted
      }[track]),
      onMouseDown: handleMouseDown
    }, other), React__default.createElement("span", {
      className: classes.rail
    }), React__default.createElement("span", {
      className: classes.track,
      style: trackStyle
    }), React__default.createElement("input", {
      value: values.join(','),
      name: name,
      type: "hidden"
    }), marks.map(function (mark) {
      var percent = valueToPercent(mark.value, min, max);
      var style = axisProps[axis].offset(percent);
      var markActive;

      if (track === false) {
        markActive = values.indexOf(mark.value) !== -1;
      } else {
        var isMarkActive = range ? mark.value >= values[0] && mark.value <= values[values.length - 1] : mark.value <= values[0];
        markActive = isMarkActive && track === 'normal' || !isMarkActive && track === 'inverted';
      }

      return React__default.createElement(React__default.Fragment, {
        key: mark.value
      }, React__default.createElement("span", {
        style: style,
        className: clsx(classes.mark, markActive && classes.markActive)
      }), React__default.createElement("span", {
        "aria-hidden": true,
        style: style,
        className: clsx(classes.markLabel, markActive && classes.markLabelActive)
      }, mark.label));
    }), values.map(function (value, index) {
      var percent = valueToPercent(value, min, max);
      var style = axisProps[axis].offset(percent);
      return React__default.createElement(ValueLabelComponent, {
        key: index,
        valueLabelFormat: valueLabelFormat,
        valueLabelDisplay: valueLabelDisplay,
        className: classes.valueLabel,
        value: typeof valueLabelFormat === 'function' ? valueLabelFormat(value, index) : valueLabelFormat,
        index: index,
        open: open === index || active === index || valueLabelDisplay === 'on',
        disabled: disabled
      }, React__default.createElement(ThumbComponent, {
        className: clsx(classes.thumb, classes["thumbColor".concat(capitalize(color))], active === index && classes.active, disabled && classes.disabled, focusVisible === index && classes.focusVisible),
        tabIndex: disabled ? null : 0,
        role: "slider",
        style: style,
        "data-index": index,
        "aria-label": getAriaLabel ? getAriaLabel(index) : ariaLabel,
        "aria-labelledby": ariaLabelledby,
        "aria-orientation": orientation,
        "aria-valuemax": max,
        "aria-valuemin": min,
        "aria-valuenow": value,
        "aria-valuetext": getAriaValueText ? getAriaValueText(value, index) : ariaValuetext,
        onKeyDown: handleKeyDown,
        onFocus: handleFocus,
        onBlur: handleBlur,
        onMouseOver: handleMouseOver,
        onMouseLeave: handleMouseLeave
      }));
    }));
  });
   Slider.propTypes = {
    /**
     * The label of the slider.
     */
    'aria-label': chainPropTypes(propTypes.string, function (props) {
      var range = Array.isArray(props.value || props.defaultValue);

      if (range && props['aria-label'] != null) {
        return new Error('Material-UI: you need to use the `getAriaLabel` prop instead of `aria-label` when using a range slider.');
      }

      return null;
    }),

    /**
     * The id of the element containing a label for the slider.
     */
    'aria-labelledby': propTypes.string,

    /**
     * A string value that provides a user-friendly name for the current value of the slider.
     */
    'aria-valuetext': chainPropTypes(propTypes.string, function (props) {
      var range = Array.isArray(props.value || props.defaultValue);

      if (range && props['aria-valuetext'] != null) {
        return new Error('Material-UI: you need to use the `getAriaValueText` prop instead of `aria-valuetext` when using a range slider.');
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: propTypes.elementType,

    /**
     * The default element value. Use when the component is not controlled.
     */
    defaultValue: propTypes.oneOfType([propTypes.number, propTypes.arrayOf(propTypes.number)]),

    /**
     * If `true`, the slider will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * Accepts a function which returns a string value that provides a user-friendly name for the thumb labels of the slider.
     *
     * @param {number} index The thumb label's index to format.
     * @returns {string}
     */
    getAriaLabel: propTypes.func,

    /**
     * Accepts a function which returns a string value that provides a user-friendly name for the current value of the slider.
     *
     * @param {number} value The thumb label's value to format.
     * @param {number} index The thumb label's index to format.
     * @returns {string}
     */
    getAriaValueText: propTypes.func,

    /**
     * Marks indicate predetermined values to which the user can move the slider.
     * If `true` the marks will be spaced according the value of the `step` prop.
     * If an array, it should contain objects with `value` and an optional `label` keys.
     */
    marks: propTypes.oneOfType([propTypes.bool, propTypes.array]),

    /**
     * The maximum allowed value of the slider.
     * Should not be equal to min.
     */
    max: propTypes.number,

    /**
     * The minimum allowed value of the slider.
     * Should not be equal to max.
     */
    min: propTypes.number,

    /**
     * Name attribute of the hidden `input` element.
     */
    name: propTypes.string,

    /**
     * Callback function that is fired when the slider's value changed.
     *
     * @param {object} event The event source of the callback.
     * @param {any} value The new value.
     */
    onChange: propTypes.func,

    /**
     * Callback function that is fired when the `mouseup` is triggered.
     *
     * @param {object} event The event source of the callback.
     * @param {any} value The new value.
     */
    onChangeCommitted: propTypes.func,

    /**
     * @ignore
     */
    onMouseDown: propTypes.func,

    /**
     * The slider orientation.
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical']),

    /**
     * The granularity with which the slider can step through values. (A "discrete" slider.)
     * When step is `null`, the thumb can only be slid onto marks provided with the `marks` prop.
     */
    step: propTypes.number,

    /**
     * The component used to display the value label.
     */
    ThumbComponent: propTypes.elementType,

    /**
     * The track presentation:
     *
     * - `normal` the track will render a bar representing the slider value.
     * - `inverted` the track will render a bar representing the remaining slider value.
     * - `false` the track will render without a bar.
     */
    track: propTypes.oneOf(['normal', false, 'inverted']),

    /**
     * The value of the slider.
     * For ranged sliders, provide an array with two values.
     */
    value: propTypes.oneOfType([propTypes.number, propTypes.arrayOf(propTypes.number)]),

    /**
     * The value label component.
     */
    ValueLabelComponent: propTypes.elementType,

    /**
     * Controls when the value label is displayed:
     *
     * - `auto` the value label will display when the thumb is hovered or focused.
     * - `on` will display persistently.
     * - `off` will never display.
     */
    valueLabelDisplay: propTypes.oneOf(['on', 'auto', 'off']),

    /**
     * The format function the value label's value.
     *
     * When a function is provided, it should have the following signature:
     *
     * - {number} value The value label's value to format
     * - {number} index The value label's index to format
     */
    valueLabelFormat: propTypes.oneOfType([propTypes.string, propTypes.func])
  } ;
  var Slider$1 = withStyles$1(styles$1i, {
    name: 'MuiSlider'
  })(Slider);

  var styles$1j = function styles(theme) {
    var emphasis = theme.palette.type === 'light' ? 0.8 : 0.98;
    var backgroundColor = emphasize(theme.palette.background.default, emphasis);
    return {
      /* Styles applied to the root element. */
      root: _defineProperty({
        color: theme.palette.getContrastText(backgroundColor),
        backgroundColor: backgroundColor,
        display: 'flex',
        alignItems: 'center',
        flexWrap: 'wrap',
        padding: '6px 16px',
        borderRadius: theme.shape.borderRadius,
        flexGrow: 1
      }, theme.breakpoints.up('sm'), {
        flexGrow: 'initial',
        minWidth: 288
      }),

      /* Styles applied to the message wrapper element. */
      message: {
        padding: '8px 0'
      },

      /* Styles applied to the action wrapper element if `action` is provided. */
      action: {
        display: 'flex',
        alignItems: 'center',
        marginLeft: 'auto',
        paddingLeft: 16,
        marginRight: -8
      }
    };
  };
  var SnackbarContent = React__default.forwardRef(function SnackbarContent(props, ref) {
    var action = props.action,
        classes = props.classes,
        className = props.className,
        message = props.message,
        _props$role = props.role,
        role = _props$role === void 0 ? 'alert' : _props$role,
        other = _objectWithoutProperties(props, ["action", "classes", "className", "message", "role"]);

    return React__default.createElement(Paper$1, _extends({
      component: Typography$1,
      variant: "body2",
      variantMapping: {
        body1: 'div',
        body2: 'div'
      },
      role: role,
      square: true,
      elevation: 6,
      className: clsx(classes.root, className),
      ref: ref
    }, other), React__default.createElement("div", {
      className: classes.message
    }, message), action ? React__default.createElement("div", {
      className: classes.action
    }, action) : null);
  });
   SnackbarContent.propTypes = {
    /**
     * The action to display.
     */
    action: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The message to display.
     */
    message: propTypes.node,

    /**
     * The role of the SnackbarContent. If the Snackbar requires focus
     * to be closed, the `alertdialog` role should be used instead.
     */
    role: propTypes.oneOf(['alert', 'alertdialog'])
  } ;
  var SnackbarContent$1 = withStyles$1(styles$1j, {
    name: 'MuiSnackbarContent'
  })(SnackbarContent);

  var styles$1k = function styles(theme) {
    var top1 = {
      top: 8
    };
    var bottom1 = {
      bottom: 8
    };
    var right = {
      justifyContent: 'flex-end'
    };
    var left = {
      justifyContent: 'flex-start'
    };
    var top3 = {
      top: 24
    };
    var bottom3 = {
      bottom: 24
    };
    var right3 = {
      right: 24
    };
    var left3 = {
      left: 24
    };
    var center = {
      left: '50%',
      right: 'auto',
      transform: 'translateX(-50%)'
    };
    return {
      /* Styles applied to the root element. */
      root: {
        zIndex: theme.zIndex.snackbar,
        position: 'fixed',
        display: 'flex',
        left: 8,
        right: 8,
        justifyContent: 'center',
        alignItems: 'center'
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'center' }}`. */
      anchorOriginTopCenter: _extends({}, top1, _defineProperty({}, theme.breakpoints.up('sm'), _extends({}, top3, {}, center))),

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'center' }}`. */
      anchorOriginBottomCenter: _extends({}, bottom1, _defineProperty({}, theme.breakpoints.up('sm'), _extends({}, bottom3, {}, center))),

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'right' }}`. */
      anchorOriginTopRight: _extends({}, top1, {}, right, _defineProperty({}, theme.breakpoints.up('sm'), _extends({
        left: 'auto'
      }, top3, {}, right3))),

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'right' }}`. */
      anchorOriginBottomRight: _extends({}, bottom1, {}, right, _defineProperty({}, theme.breakpoints.up('sm'), _extends({
        left: 'auto'
      }, bottom3, {}, right3))),

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'left' }}`. */
      anchorOriginTopLeft: _extends({}, top1, {}, left, _defineProperty({}, theme.breakpoints.up('sm'), _extends({
        right: 'auto'
      }, top3, {}, left3))),

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'left' }}`. */
      anchorOriginBottomLeft: _extends({}, bottom1, {}, left, _defineProperty({}, theme.breakpoints.up('sm'), _extends({
        right: 'auto'
      }, bottom3, {}, left3)))
    };
  };
  var Snackbar = React__default.forwardRef(function Snackbar(props, ref) {
    var action = props.action,
        _props$anchorOrigin = props.anchorOrigin;
    _props$anchorOrigin = _props$anchorOrigin === void 0 ? {
      vertical: 'bottom',
      horizontal: 'center'
    } : _props$anchorOrigin;

    var vertical = _props$anchorOrigin.vertical,
        horizontal = _props$anchorOrigin.horizontal,
        autoHideDuration = props.autoHideDuration,
        children = props.children,
        classes = props.classes,
        className = props.className,
        ClickAwayListenerProps = props.ClickAwayListenerProps,
        ContentProps = props.ContentProps,
        _props$disableWindowB = props.disableWindowBlurListener,
        disableWindowBlurListener = _props$disableWindowB === void 0 ? false : _props$disableWindowB,
        message = props.message,
        onClose = props.onClose,
        onEnter = props.onEnter,
        onEntered = props.onEntered,
        onEntering = props.onEntering,
        onExit = props.onExit,
        onExited = props.onExited,
        onExiting = props.onExiting,
        onMouseEnter = props.onMouseEnter,
        onMouseLeave = props.onMouseLeave,
        open = props.open,
        resumeHideDuration = props.resumeHideDuration,
        _props$TransitionComp = props.TransitionComponent,
        TransitionComponent = _props$TransitionComp === void 0 ? Grow : _props$TransitionComp,
        _props$transitionDura = props.transitionDuration,
        transitionDuration = _props$transitionDura === void 0 ? {
      enter: duration.enteringScreen,
      exit: duration.leavingScreen
    } : _props$transitionDura,
        TransitionProps = props.TransitionProps,
        other = _objectWithoutProperties(props, ["action", "anchorOrigin", "autoHideDuration", "children", "classes", "className", "ClickAwayListenerProps", "ContentProps", "disableWindowBlurListener", "message", "onClose", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "onMouseEnter", "onMouseLeave", "open", "resumeHideDuration", "TransitionComponent", "transitionDuration", "TransitionProps"]);

    var timerAutoHide = React__default.useRef();

    var _React$useState = React__default.useState(true),
        exited = _React$useState[0],
        setExited = _React$useState[1]; // Timer that controls delay before snackbar auto hides


    var setAutoHideTimer = React__default.useCallback(function (autoHideDurationParam) {
      var autoHideDurationBefore = autoHideDurationParam != null ? autoHideDurationParam : autoHideDuration;

      if (!onClose || autoHideDurationBefore == null) {
        return;
      }

      clearTimeout(timerAutoHide.current);
      timerAutoHide.current = setTimeout(function () {
        var autoHideDurationAfter = autoHideDurationParam != null ? autoHideDurationParam : autoHideDuration;

        if (!onClose || autoHideDurationAfter == null) {
          return;
        }

        onClose(null, 'timeout');
      }, autoHideDurationBefore);
    }, [autoHideDuration, onClose]);
    React__default.useEffect(function () {
      if (open) {
        setAutoHideTimer();
      }

      return function () {
        clearTimeout(timerAutoHide.current);
      };
    }, [open, setAutoHideTimer]); // Pause the timer when the user is interacting with the Snackbar
    // or when the user hide the window.

    var handlePause = function handlePause() {
      clearTimeout(timerAutoHide.current);
    }; // Restart the timer when the user is no longer interacting with the Snackbar
    // or when the window is shown back.


    var handleResume = React__default.useCallback(function () {
      if (autoHideDuration != null) {
        if (resumeHideDuration != null) {
          setAutoHideTimer(resumeHideDuration);
          return;
        }

        setAutoHideTimer(autoHideDuration * 0.5);
      }
    }, [autoHideDuration, resumeHideDuration, setAutoHideTimer]);

    var handleMouseEnter = function handleMouseEnter(event) {
      if (onMouseEnter) {
        onMouseEnter(event);
      }

      handlePause();
    };

    var handleMouseLeave = function handleMouseLeave(event) {
      if (onMouseLeave) {
        onMouseLeave(event);
      }

      handleResume();
    };

    var handleClickAway = function handleClickAway(event) {
      if (onClose) {
        onClose(event, 'clickaway');
      }
    };

    var handleExited = function handleExited() {
      setExited(true);
    };

    var handleEnter = function handleEnter() {
      setExited(false);
    };

    React__default.useEffect(function () {
      if (!disableWindowBlurListener && open) {
        window.addEventListener('focus', handleResume);
        window.addEventListener('blur', handlePause);
        return function () {
          window.removeEventListener('focus', handleResume);
          window.removeEventListener('blur', handlePause);
        };
      }

      return undefined;
    }, [disableWindowBlurListener, handleResume, open]); // So we only render active snackbars.

    if (!open && exited) {
      return null;
    }

    return React__default.createElement(ClickAwayListener, _extends({
      onClickAway: handleClickAway
    }, ClickAwayListenerProps), React__default.createElement("div", _extends({
      className: clsx(classes.root, classes["anchorOrigin".concat(capitalize(vertical)).concat(capitalize(horizontal))], className),
      onMouseEnter: handleMouseEnter,
      onMouseLeave: handleMouseLeave,
      ref: ref
    }, other), React__default.createElement(TransitionComponent, _extends({
      appear: true,
      in: open,
      onEnter: createChainedFunction(handleEnter, onEnter),
      onEntered: onEntered,
      onEntering: onEntering,
      onExit: onExit,
      onExited: createChainedFunction(handleExited, onExited),
      onExiting: onExiting,
      timeout: transitionDuration,
      direction: vertical === 'top' ? 'down' : 'up'
    }, TransitionProps), children || React__default.createElement(SnackbarContent$1, _extends({
      message: message,
      action: action
    }, ContentProps)))));
  });
   Snackbar.propTypes = {
    /**
     * The action to display.
     */
    action: propTypes.node,

    /**
     * The anchor of the `Snackbar`.
     */
    anchorOrigin: propTypes.shape({
      horizontal: propTypes.oneOf(['left', 'center', 'right']).isRequired,
      vertical: propTypes.oneOf(['top', 'bottom']).isRequired
    }),

    /**
     * The number of milliseconds to wait before automatically calling the
     * `onClose` function. `onClose` should then set the state of the `open`
     * prop to hide the Snackbar. This behavior is disabled by default with
     * the `null` value.
     */
    autoHideDuration: propTypes.number,

    /**
     * Replace the `SnackbarContent` component.
     */
    children: propTypes.element,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Props applied to the `ClickAwayListener` element.
     */
    ClickAwayListenerProps: propTypes.object,

    /**
     * Props applied to the [`SnackbarContent`](/api/snackbar-content/) element.
     */
    ContentProps: propTypes.object,

    /**
     * If `true`, the `autoHideDuration` timer will expire even if the window is not focused.
     */
    disableWindowBlurListener: propTypes.bool,

    /**
     * When displaying multiple consecutive Snackbars from a parent rendering a single
     * <Snackbar/>, add the key prop to ensure independent treatment of each message.
     * e.g. <Snackbar key={message} />, otherwise, the message may update-in-place and
     * features such as autoHideDuration may be canceled.
     */
    key: propTypes.any,

    /**
     * The message to display.
     */
    message: propTypes.node,

    /**
     * Callback fired when the component requests to be closed.
     * Typically `onClose` is used to set state in the parent component,
     * which is used to control the `Snackbar` `open` prop.
     * The `reason` parameter can optionally be used to control the response to `onClose`,
     * for example ignoring `clickaway`.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be:`"timeout"` (`autoHideDuration` expired) or: `"clickaway"`.
     */
    onClose: propTypes.func,

    /**
     * Callback fired before the transition is entering.
     */
    onEnter: propTypes.func,

    /**
     * Callback fired when the transition has entered.
     */
    onEntered: propTypes.func,

    /**
     * Callback fired when the transition is entering.
     */
    onEntering: propTypes.func,

    /**
     * Callback fired before the transition is exiting.
     */
    onExit: propTypes.func,

    /**
     * Callback fired when the transition has exited.
     */
    onExited: propTypes.func,

    /**
     * Callback fired when the transition is exiting.
     */
    onExiting: propTypes.func,

    /**
     * @ignore
     */
    onMouseEnter: propTypes.func,

    /**
     * @ignore
     */
    onMouseLeave: propTypes.func,

    /**
     * If true, `Snackbar` is open.
     */
    open: propTypes.bool,

    /**
     * The number of milliseconds to wait before dismissing after user interaction.
     * If `autoHideDuration` prop isn't specified, it does nothing.
     * If `autoHideDuration` prop is specified but `resumeHideDuration` isn't,
     * we default to `autoHideDuration / 2` ms.
     */
    resumeHideDuration: propTypes.number,

    /**
     * The component used for the transition.
     */
    TransitionComponent: propTypes.elementType,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })]),

    /**
     * Props applied to the `Transition` element.
     */
    TransitionProps: propTypes.object
  } ;
  var Snackbar$1 = withStyles$1(styles$1k, {
    flip: false,
    name: 'MuiSnackbar'
  })(Snackbar);

  var styles$1l = {
    /* Styles applied to the root element. */
    root: {},

    /* Styles applied to the root element if `orientation="horizontal"`. */
    horizontal: {
      paddingLeft: 8,
      paddingRight: 8
    },

    /* Styles applied to the root element if `orientation="vertical"`. */
    vertical: {},

    /* Styles applied to the root element if `alternativeLabel={true}`. */
    alternativeLabel: {
      flex: 1,
      position: 'relative'
    },

    /* Pseudo-class applied to the root element if `completed={true}`. */
    completed: {}
  };
  var Step = React__default.forwardRef(function Step(props, ref) {
    var _props$active = props.active,
        active = _props$active === void 0 ? false : _props$active,
        alternativeLabel = props.alternativeLabel,
        children = props.children,
        classes = props.classes,
        className = props.className,
        _props$completed = props.completed,
        completed = _props$completed === void 0 ? false : _props$completed,
        connector = props.connector,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        index = props.index,
        last = props.last,
        orientation = props.orientation,
        other = _objectWithoutProperties(props, ["active", "alternativeLabel", "children", "classes", "className", "completed", "connector", "disabled", "index", "last", "orientation"]);

    return React__default.createElement("div", _extends({
      className: clsx(classes.root, classes[orientation], className, alternativeLabel && classes.alternativeLabel, completed && classes.completed),
      ref: ref
    }, other), connector && alternativeLabel && index !== 0 && React__default.cloneElement(connector, {
      orientation: orientation,
      alternativeLabel: alternativeLabel,
      index: index,
      active: active,
      completed: completed,
      disabled: disabled
    }), React__default.Children.map(children, function (child) {
      if (!React__default.isValidElement(child)) {
        return null;
      }

      {
        if (child.type === React__default.Fragment) {
          console.error(["Material-UI: the Step component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }

      return React__default.cloneElement(child, _extends({
        active: active,
        alternativeLabel: alternativeLabel,
        completed: completed,
        disabled: disabled,
        last: last,
        icon: index + 1,
        orientation: orientation
      }, child.props));
    }));
  });
   Step.propTypes = {
    /**
     * Sets the step as active. Is passed to child components.
     */
    active: propTypes.bool,

    /**
     * @ignore
     * Set internally by Stepper when it's supplied with the alternativeLabel property.
     */
    alternativeLabel: propTypes.bool,

    /**
     * Should be `Step` sub-components such as `StepLabel`, `StepContent`.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Mark the step as completed. Is passed to child components.
     */
    completed: propTypes.bool,

    /**
     * @ignore
     * Passed down from Stepper if alternativeLabel is also set.
     */
    connector: propTypes.element,

    /**
     * Mark the step as disabled, will also disable the button if
     * `StepButton` is a child of `Step`. Is passed to child components.
     */
    disabled: propTypes.bool,

    /**
     * @ignore
     * Used internally for numbering.
     */
    index: propTypes.number,

    /**
     * @ignore
     */
    last: propTypes.bool,

    /**
     * @ignore
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical'])
  } ;
  var Step$1 = withStyles$1(styles$1l, {
    name: 'MuiStep'
  })(Step);

  /**
   * @ignore - internal component.
   */

  var CheckCircle = createSvgIcon(React__default.createElement("path", {
    d: "M12 0a12 12 0 1 0 0 24 12 12 0 0 0 0-24zm-2 17l-5-5 1.4-1.4 3.6 3.6 7.6-7.6L19 8l-9 9z"
  }), 'CheckCircle');

  /**
   * @ignore - internal component.
   */

  var Warning = createSvgIcon(React__default.createElement("path", {
    d: "M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"
  }), 'Warning');

  var styles$1m = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'block',
        color: theme.palette.text.disabled,
        '&$active': {
          color: theme.palette.primary.main
        },
        '&$completed': {
          color: theme.palette.primary.main
        },
        '&$error': {
          color: theme.palette.error.main
        }
      },

      /* Styles applied to the SVG text element. */
      text: {
        fill: theme.palette.primary.contrastText,
        fontSize: theme.typography.caption.fontSize,
        fontFamily: theme.typography.fontFamily
      },

      /* Pseudo-class applied to the root element if `active={true}`. */
      active: {},

      /* Pseudo-class applied to the root element if `completed={true}`. */
      completed: {},

      /* Pseudo-class applied to the root element if `error={true}`. */
      error: {}
    };
  };

  var _ref$2 = React__default.createElement("circle", {
    cx: "12",
    cy: "12",
    r: "12"
  });

  var StepIcon = React__default.forwardRef(function StepIcon(props, ref) {
    var _props$completed = props.completed,
        completed = _props$completed === void 0 ? false : _props$completed,
        icon = props.icon,
        _props$active = props.active,
        active = _props$active === void 0 ? false : _props$active,
        _props$error = props.error,
        error = _props$error === void 0 ? false : _props$error,
        classes = props.classes;

    if (typeof icon === 'number' || typeof icon === 'string') {
      if (error) {
        return React__default.createElement(Warning, {
          className: clsx(classes.root, classes.error),
          ref: ref
        });
      }

      if (completed) {
        return React__default.createElement(CheckCircle, {
          className: clsx(classes.root, classes.completed),
          ref: ref
        });
      }

      return React__default.createElement(SvgIcon$1, {
        className: clsx(classes.root, active && classes.active),
        ref: ref
      }, _ref$2, React__default.createElement("text", {
        className: classes.text,
        x: "12",
        y: "16",
        textAnchor: "middle"
      }, icon));
    }

    return icon;
  });
   StepIcon.propTypes = {
    /**
     * Whether this step is active.
     */
    active: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * Mark the step as completed. Is passed to child components.
     */
    completed: propTypes.bool,

    /**
     * Mark the step as failed.
     */
    error: propTypes.bool,

    /**
     * The label displayed in the step icon.
     */
    icon: propTypes.node.isRequired
  } ;
  var StepIcon$1 = withStyles$1(styles$1m, {
    name: 'MuiStepIcon'
  })(StepIcon);

  var styles$1n = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        alignItems: 'center',
        '&$alternativeLabel': {
          flexDirection: 'column'
        },
        '&$disabled': {
          cursor: 'default'
        }
      },

      /* Styles applied to the root element if `orientation="horizontal". */
      horizontal: {},

      /* Styles applied to the root element if `orientation="vertical". */
      vertical: {},

      /* Styles applied to the `Typography` component which wraps `children`. */
      label: {
        color: theme.palette.text.secondary,
        '&$active': {
          color: theme.palette.text.primary,
          fontWeight: 500
        },
        '&$completed': {
          color: theme.palette.text.primary,
          fontWeight: 500
        },
        '&$alternativeLabel': {
          textAlign: 'center',
          marginTop: 16
        },
        '&$error': {
          color: theme.palette.error.main
        }
      },

      /* Pseudo-class applied to the `Typography` component if `active={true}`. */
      active: {},

      /* Pseudo-class applied to the `Typography` component if `completed={true}`. */
      completed: {},

      /* Pseudo-class applied to the root element and `Typography` component if `error={true}`. */
      error: {},

      /* Pseudo-class applied to the root element and `Typography` component if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the `icon` container element. */
      iconContainer: {
        flexShrink: 0,
        // Fix IE 11 issue
        display: 'flex',
        paddingRight: 8,
        '&$alternativeLabel': {
          paddingRight: 0
        }
      },

      /* Pseudo-class applied to the root and icon container and `Typography` if `alternativeLabel={true}`. */
      alternativeLabel: {},

      /* Styles applied to the container element which wraps `Typography` and `optional`. */
      labelContainer: {
        width: '100%'
      }
    };
  };
  var StepLabel = React__default.forwardRef(function StepLabel(props, ref) {
    var _props$active = props.active,
        active = _props$active === void 0 ? false : _props$active,
        _props$alternativeLab = props.alternativeLabel,
        alternativeLabel = _props$alternativeLab === void 0 ? false : _props$alternativeLab,
        children = props.children,
        classes = props.classes,
        className = props.className,
        _props$completed = props.completed,
        completed = _props$completed === void 0 ? false : _props$completed,
        _props$disabled = props.disabled,
        disabled = _props$disabled === void 0 ? false : _props$disabled,
        _props$error = props.error,
        error = _props$error === void 0 ? false : _props$error,
        icon = props.icon,
        last = props.last,
        optional = props.optional,
        _props$orientation = props.orientation,
        orientation = _props$orientation === void 0 ? 'horizontal' : _props$orientation,
        StepIconComponentProp = props.StepIconComponent,
        StepIconProps = props.StepIconProps,
        other = _objectWithoutProperties(props, ["active", "alternativeLabel", "children", "classes", "className", "completed", "disabled", "error", "icon", "last", "optional", "orientation", "StepIconComponent", "StepIconProps"]);

    var StepIconComponent = StepIconComponentProp;

    if (icon && !StepIconComponent) {
      StepIconComponent = StepIcon$1;
    }

    return React__default.createElement("span", _extends({
      className: clsx(classes.root, classes[orientation], className, disabled && classes.disabled, alternativeLabel && classes.alternativeLabel, error && classes.error),
      ref: ref
    }, other), icon || StepIconComponent ? React__default.createElement("span", {
      className: clsx(classes.iconContainer, alternativeLabel && classes.alternativeLabel)
    }, React__default.createElement(StepIconComponent, _extends({
      completed: completed,
      active: active,
      error: error,
      icon: icon
    }, StepIconProps))) : null, React__default.createElement("span", {
      className: classes.labelContainer
    }, React__default.createElement(Typography$1, {
      variant: "body2",
      component: "span",
      className: clsx(classes.label, alternativeLabel && classes.alternativeLabel, completed && classes.completed, active && classes.active, error && classes.error),
      display: "block"
    }, children), optional));
  });
   StepLabel.propTypes = {
    /**
     * @ignore
     * Sets the step as active. Is passed to child components.
     */
    active: propTypes.bool,

    /**
     * @ignore
     * Set internally by Stepper when it's supplied with the alternativeLabel prop.
     */
    alternativeLabel: propTypes.bool,

    /**
     * In most cases will simply be a string containing a title for the label.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     * Mark the step as completed. Is passed to child components.
     */
    completed: propTypes.bool,

    /**
     * Mark the step as disabled, will also disable the button if
     * `StepLabelButton` is a child of `StepLabel`. Is passed to child components.
     */
    disabled: propTypes.bool,

    /**
     * Mark the step as failed.
     */
    error: propTypes.bool,

    /**
     * Override the default label of the step icon.
     */
    icon: propTypes.node,

    /**
     * @ignore
     */
    last: propTypes.bool,

    /**
     * The optional node t