import { DerEncodedPublicKey, PublicKey, Signature, SignIdentity } from '@dfinity/agent';
export declare class CosePublicKey implements PublicKey {
    protected _cose: ArrayBuffer;
    protected _encodedKey: DerEncodedPublicKey;
    constructor(_cose: ArrayBuffer);
    toDer(): DerEncodedPublicKey;
    getCose(): ArrayBuffer;
}
/**
 * A SignIdentity that uses `navigator.credentials`. See https://webauthn.guide/ for
 * more information about WebAuthentication.
 */
export declare class WebAuthnIdentity extends SignIdentity {
    readonly rawId: ArrayBuffer;
    /**
     * Create an identity from a JSON serialization.
     * @param json - json to parse
     */
    static fromJSON(json: string): WebAuthnIdentity;
    /**
     * Create an identity.
     * @param credentialCreationOptions an optional CredentialCreationOptions Challenge
     */
    static create(credentialCreationOptions?: CredentialCreationOptions): Promise<WebAuthnIdentity>;
    protected _publicKey: CosePublicKey;
    protected constructor(rawId: ArrayBuffer, cose: ArrayBuffer);
    getPublicKey(): PublicKey;
    sign(blob: ArrayBuffer): Promise<Signature>;
    /**
     * Allow for JSON serialization of all information needed to reuse this identity.
     */
    toJSON(): JsonnableWebAuthnIdentitiy;
}
/**
 * ReturnType<WebAuthnIdentity.toJSON>
 */
export interface JsonnableWebAuthnIdentitiy {
    publicKey: string;
    rawId: string;
}
