import './_version.js';
export interface InstallResult {
    updatedURLs: string[];
    notUpdatedURLs: string[];
}
export interface CleanupResult {
    deletedCacheRequests: string[];
}
export declare interface PrecacheEntry {
    integrity?: string;
    url: string;
    revision?: string | null;
}
export interface PrecacheRouteOptions {
    directoryIndex?: string;
    ignoreURLParametersMatching?: RegExp[];
    cleanURLs?: boolean;
    urlManipulation?: urlManipulation;
}
export declare type urlManipulation = ({ url }: {
    url: URL;
}) => URL[];
/**
 * @typedef {Object} InstallResult
 * @property {Array<string>} updatedURLs List of URLs that were updated during
 * installation.
 * @property {Array<string>} notUpdatedURLs List of URLs that were already up to
 * date.
 *
 * @memberof module:workbox-precaching
 */
/**
 * @typedef {Object} CleanupResult
 * @property {Array<string>} deletedCacheRequests List of URLs that were deleted
 * while cleaning up the cache.
 *
 * @memberof module:workbox-precaching
 */
/**
 * @typedef {Object} PrecacheEntry
 * @property {string} url URL to precache.
 * @property {string} [revision] Revision information for the URL.
 * @property {string} [integrity] Integrity metadata that will be used when
 * making the network request for the URL.
 *
 * @memberof module:workbox-precaching
 */
/**
 * The "urlManipulation" callback can be used to determine if there are any
 * additional permutations of a URL that should be used to check against
 * the available precached files.
 *
 * For example, Workbox supports checking for '/index.html' when the URL
 * '/' is provided. This callback allows additional, custom checks.
 *
 * @callback ~urlManipulation
 * @param {Object} context
 * @param {URL} context.url The request's URL.
 * @return {Array<URL>} To add additional urls to test, return an Array of
 * URLs. Please note that these **should not be strings**, but URL objects.
 *
 * @memberof module:workbox-precaching
 */
